/*
 *   @(#) MP3 Player 1.0 Demicron (demicron@demicron.com)
 *
 *   MP3Properties.java   2002-09-17
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import java.awt.event.*;
import java.util.*;
import java.applet.*;
import java.net.*;
import javax.swing.border.*;

public class MP3Properties extends WobProperties implements Externalizable {
  static final long serialVersionUID = 921367935677174125L;
  private String fileName = "dummyFileName";
  private int startupMode = 0; // 0==NOTHING, 1==PLAY 2==LOOP
  private boolean streamed = true;

  public WobPropertiesPanel createWobPropertiesPanel() {
    return new MP3PropertiesPanel();
  }

  public void writeExternal(ObjectOutput out) {
    try {
        ObjectOutputStream oos = (ObjectOutputStream)out;
        super.writeExternal(oos);
        oos.writeObject(fileName);
        oos.writeShort(startupMode);
        oos.writeBoolean(streamed);
    } catch (Exception e) {System.out.println("SoundDialog: "+e);}
  }

  public void readExternal(ObjectInput in) {
    try {
      ObjectInputStream ois = (ObjectInputStream)in;
      super.readExternal(ois);
      fileName = (String)ois.readObject();
      startupMode = ois.readShort();
      streamed = ois.readBoolean();
    } catch (Exception e) {System.out.println("SoundDialog: "+e);if (!e.getMessage().equals("progress")) e.printStackTrace();}
  }

  public void setSound(File soundFile) {
    File mp3File = createFileDep(soundFile, 1, true, FileDependency.NON_RESOURCE_MANAGED_DEPENDENCY);
    fileName = mp3File.getName();
    File auFile = createAuFile(mp3File); // Same name as mp3-file, only ends with .mp3.au
    createFileDep(auFile, 2, false, FileDependency.NON_RESOURCE_MANAGED_DEPENDENCY);
  }

  private File createAuFile(File mp3File) {
    File auFile = new File(mp3File.getAbsolutePath()+".au");
    try {
      File wavFile = new File("tmpfiles", "converting_temp.wav");
      Conv_Converter conv = new Conv_Converter();
      conv.convert(mp3File.getAbsolutePath(),wavFile.getAbsolutePath(), null);
      //AudioFormat(AudioFormat.ULAW,8000,8,1)
      String[] args = new String[] {"-o", auFile.toURL().toExternalForm(),"-a","ulaw:8000:8:1", wavFile.toURL().toExternalForm()};
      //URL jmfURL = (new File("wobs"+File.separator+"wob64"+File.separator+"jmf.jar")).toURL();
      /*URL transcodeURL = (new File("wobs"+File.separator+"wob64"+File.separator+"transcode.jar")).toURL();
      URL[] urlArray = new URL[] {jmfURL, transcodeURL};
      ClassLoader cl = new URLClassLoader(urlArray);
      Object transcodeObject = cl.loadClass("Transcode").newInstance();
      transcodeObject.equals(args);*/
      WFUtils.transcode(args);
      //Transcode trans = new Transcode();
      //trans.convert(args);
      wavFile.delete();
    } catch (Exception e) {e.printStackTrace();}
    return auFile;
  }

  public MP3Properties() {
    super();
  }

  public void writeData(DataOutputStream dos) {
    try {
      dos.writeShort(startupMode);
      dos.writeUTF(fileName);
      dos.writeBoolean(streamed);
    } catch (IOException e) {System.out.println(e);}
  }


class MP3PropertiesPanel extends WobPropertiesPanel implements ActionListener {
  private JButton changeButton;
  private JButton testButton;
  private JButton stopButton;
  private JLabel fileLabel;
  private JLabel sizeLabel;
  private Play_jlp player = null;
  private File soundFile;
  private JComboBox startupModeComboBox;
  private JCheckBox streamedCheckBox;

  public MP3PropertiesPanel() {
    if (fileName.equals("dummyFileName")) {
      soundFile = new File(WF.installFolder, "wobs"+File.separator+"wob64"+File.separator+"default.mp3");
    } else {
      soundFile = new File("tmpfiles"+File.separator+fileName);
    }

    try {
      player = new Play_jlp(soundFile);//Applet.newAudioClip(soundFile.toURL());
    } catch (Exception e) {e.printStackTrace();}

    JPanel panel = new JPanel();
    setLayout(new FlowLayout());
    add(panel);

//        lastFileName = fileName;
    GridBagLayout gbl = new GridBagLayout();
    GridBagConstraints gbc = new GridBagConstraints();
    panel.setLayout(gbl);

    gbc.weightx = 1;
    gbc.weighty = 1;
    gbc.insets = new Insets(5,5,5,5);


    JPanel testPanel = new JPanel();

    testButton = new JButton("Play", new ImageIcon("wobs"+File.separator+"wob64"+File.separator+"play.gif"));
    testButton.addActionListener(this);
    /*gbc.anchor = gbc.EAST;
    gbc.gridy = 0;
    gbc.gridx = 0;*/
    testPanel.add(testButton);

    stopButton = new JButton("Stop", new ImageIcon("wobs"+File.separator+"wob64"+File.separator+"stop.gif"));
    stopButton.addActionListener(this);
    //gbc.anchor = gbc.EAST;
    //gbc.gridx = 1;

    testPanel.add(stopButton);


    gbc.gridwidth = 2;
    panel.add(testPanel, gbc);


   // gbc.insets = new Insets(30,5,5,5);
    JLabel mp3FileLabel = new JLabel("Sound:");
    gbc.anchor = gbc.EAST;
    gbc.gridy = 1;
    gbc.gridx = 0;
    gbc.gridwidth = 1;
    panel.add(mp3FileLabel, gbc);
    gbc.gridwidth = 1;

    fileLabel = new JLabel(removeCheckSum(soundFile.getName()));
    gbc.anchor = gbc.WEST;
    gbc.gridy = 1;
    gbc.gridx = 1;
    panel.add(fileLabel, gbc);
    gbc.gridwidth = 1;


    JLabel sizeNameLabel = new JLabel("File size:");
    gbc.anchor = gbc.EAST;
    gbc.gridy = 2;
    gbc.gridx = 0;
    panel.add(sizeNameLabel,gbc);

    sizeLabel = new JLabel("");
    gbc.anchor = gbc.WEST;
    gbc.gridx = 1;
    gbc.fill = gbc.HORIZONTAL;
    panel.add(sizeLabel, gbc);
    gbc.gridwidth = 1;
    gbc.fill = gbc.NONE;

    gbc.gridx = 0;
    gbc.gridy = 3;
    gbc.anchor = gbc.EAST;
    panel.add(new JLabel("At startup:"), gbc);

    Object[] items = {"Do nothing", "Play", "Loop"};
    startupModeComboBox = new JComboBox(items);
    startupModeComboBox.setSelectedIndex(startupMode);
    gbc.gridx = 1;
    gbc.weightx = 10000;
    gbc.fill = gbc.HORIZONTAL;
    gbc.anchor = gbc.WEST;
    panel.add(startupModeComboBox, gbc);

    streamedCheckBox = new JCheckBox("Streaming                                   ", streamed);
    streamedCheckBox.setActionCommand("stream");
    streamedCheckBox.addActionListener(this);
    gbc.gridx = 1;
    gbc.gridy = 4;
    gbc.anchor = gbc.WEST;
    gbc.gridwidth = 1;
    panel.add(streamedCheckBox, gbc);

    gbc.insets = new Insets(30,5,5,5);
    gbc.fill = gbc.NONE;
    changeButton = new JButton("Change Sound...");
    changeButton.addActionListener(this);
    gbc.gridwidth = 2;
    gbc.anchor = gbc.CENTER;
    gbc.gridx = 0;
    gbc.gridy = 5;
    panel.add(changeButton,gbc);

    updateFileLabel();
  }

  private void updateFileLabel() {
    String fileName = soundFile.getName();
    fileLabel.setText(removeCheckSum(soundFile.getName()));
    sizeLabel.setText(soundFile.length()/1024+" kb");
  }



  public void actionPerformed(ActionEvent e) {
    if (e.getSource()==changeButton) {
      player.stop();
      File selectedFile = null;
      File defaultFolder = WFUtils.getDefaultFolder("mp3sound", new File(WF.installFolder, "resources"+File.separator+"sound"));
      JFileChooser chooser = new JFileChooser(defaultFolder);//new File());
      MyFileFilter filter = new MyFileFilter("mp3","MP3 Sound");
      chooser.setFileFilter(filter);
      int returnVal = chooser.showOpenDialog(getPropertiesDialog());
      if (returnVal == JFileChooser.APPROVE_OPTION) {
        WFUtils.saveDefaultFolder("mp3sound", chooser.getSelectedFile());
        selectedFile = chooser.getSelectedFile();
        soundFile = selectedFile;
        updateFileLabel();
        try {
          player = new Play_jlp(soundFile);//Applet.newAudioClip(soundFile.toURL());
        } catch (Exception ex) {ex.printStackTrace();}
      } else {
        return;
      }
    } else if (e.getSource()==testButton) {
      try {
        //if (sound!=null) sound.stop();
        player.play();
      } catch (Exception ex) {System.out.println("Sound: "+ex);}
    } else if (e.getSource()==stopButton) {
      player.stop();
    }
  }

  public void setSoundFile(final File soundFile) {
      final JDialog dialog = new JDialog(this.propertiesDialog, "Processing", true);
      dialog.setCursor(new Cursor(Cursor.WAIT_CURSOR));
      dialog.getContentPane().setLayout(new FlowLayout());
      JLabel label = new JLabel("Processing. This may take a while, please wait...");
      label.setBorder(new EmptyBorder(20,20,20,20));
      dialog.getContentPane().add(label);

      Runnable runnable = new Runnable() {
        public void run() {
          setSound(soundFile);
          dialog.dispose();
        }
      };
      (new Thread(runnable)).start();
      WF.showCenteredWindow(dialog);
  }

  public synchronized void apply() { // Synchronize...if apply is clicked twice in a row
    if (!soundFile.getName().equals(fileName)) { // Only set sound if new file choosen
      setSoundFile(soundFile);
    }
    startupMode = startupModeComboBox.getSelectedIndex();
    streamed = streamedCheckBox.isSelected();
  }

  public void cancel() {
    if (MP3Properties.this.fileName.equals("dummyFileName"))
      setSoundFile(new File(WF.installFolder, "wobs"+File.separator+"wob64"+File.separator+"default.mp3"));
  }

  public void closed() {
    player.stop(); // p.g.av bug i AudioClip
  }
}

}
