/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AD_LayerIIDecoder.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;

/**
 * Implements decoding of MPEG Audio Layer II frames.
 */

class AD_LayerIIDecoder extends AD_LayerIDecoder implements AD_FrameDecoder
{

	public AD_LayerIIDecoder() {
	}

	protected void createSubbands() {

  		int i;
		if (mode == AD_Header.SINGLE_CHANNEL) {
			for (i = 0; i < num_subbands; ++i) {
				subbands[i] = new SubbandLayer2(i);
			}
		} else if (mode == AD_Header.JOINT_STEREO) {
			System.out.println("creating Joint Stereo subbands " + header.intensity_stereo_bound() + " " + num_subbands);
			for (i = 0; i < header.intensity_stereo_bound(); ++i) {
				subbands[i] = new SubbandLayer2Stereo(i);
			}
			for (; i < num_subbands; ++i) {
  		      subbands[i] = new SubbandLayer2IntensityStereo(i);
			}
  		} else {
			for (i = 0; i < num_subbands; ++i) {
				subbands[i] = new SubbandLayer2Stereo(i);
			}
        }
	}

	protected void readScaleFactorSelection() throws InterruptedException {
  		for (int i = 0; i < num_subbands; ++i)
			((SubbandLayer2)subbands[i]).read_scalefactor_selection(stream, crc[0]);
	}



	/**
	 * Class for layer II subbands in single channel mode.
	 */
	static class SubbandLayer2 extends Subband {

		// this table contains 3 requantized samples for each legal codeword
		// when grouped in 5 bits, i.e. 3 quantizationsteps per sample

		public static final float grouping_5bits[] = new float[] {
			-2.0f/3.0f, -2.0f/3.0f, -2.0f/3.0f,
			      0.0f, -2.0f/3.0f, -2.0f/3.0f,
			 2.0f/3.0f, -2.0f/3.0f, -2.0f/3.0f,
			-2.0f/3.0f,       0.0f, -2.0f/3.0f,
			      0.0f,       0.0f, -2.0f/3.0f,
			 2.0f/3.0f,       0.0f, -2.0f/3.0f,
			-2.0f/3.0f,  2.0f/3.0f, -2.0f/3.0f,
			      0.0f,  2.0f/3.0f, -2.0f/3.0f,
			 2.0f/3.0f,  2.0f/3.0f, -2.0f/3.0f,
			-2.0f/3.0f, -2.0f/3.0f,       0.0f,
			      0.0f, -2.0f/3.0f,       0.0f,
			 2.0f/3.0f, -2.0f/3.0f,       0.0f,
			-2.0f/3.0f,       0.0f,       0.0f,
			      0.0f,       0.0f,       0.0f,
			 2.0f/3.0f,       0.0f,       0.0f,
			-2.0f/3.0f,  2.0f/3.0f,       0.0f,
			      0.0f,  2.0f/3.0f,       0.0f,
			 2.0f/3.0f,  2.0f/3.0f,       0.0f,
			-2.0f/3.0f, -2.0f/3.0f,  2.0f/3.0f,
			      0.0f, -2.0f/3.0f,  2.0f/3.0f,
			 2.0f/3.0f, -2.0f/3.0f,  2.0f/3.0f,
			-2.0f/3.0f,       0.0f,  2.0f/3.0f,
			      0.0f,       0.0f,  2.0f/3.0f,
			 2.0f/3.0f,       0.0f,  2.0f/3.0f,
			-2.0f/3.0f,  2.0f/3.0f,  2.0f/3.0f,
			      0.0f,  2.0f/3.0f,  2.0f/3.0f,
			 2.0f/3.0f,  2.0f/3.0f,  2.0f/3.0f
		};

		// this table contains 3 requantized samples for each legal codeword
		// when grouped in 7 bits, i.e. 5 quantizationsteps per sample
		public final static float grouping_7bits[] = new float[] {
			-0.8f, -0.8f, -0.8f,   -0.4f, -0.8f, -0.8f,    0.0f, -0.8f, -0.8f,    0.4f, -0.8f, -0.8f,    0.8f, -0.8f, -0.8f,
			-0.8f, -0.4f, -0.8f,   -0.4f, -0.4f, -0.8f,    0.0f, -0.4f, -0.8f,    0.4f, -0.4f, -0.8f,    0.8f, -0.4f, -0.8f,
			-0.8f,  0.0f, -0.8f,   -0.4f,  0.0f, -0.8f,    0.0f,  0.0f, -0.8f,    0.4f,  0.0f, -0.8f,    0.8f,  0.0f, -0.8f,
			-0.8f,  0.4f, -0.8f,   -0.4f,  0.4f, -0.8f,    0.0f,  0.4f, -0.8f,    0.4f,  0.4f, -0.8f,    0.8f,  0.4f, -0.8f,
			-0.8f,  0.8f, -0.8f,   -0.4f,  0.8f, -0.8f,    0.0f,  0.8f, -0.8f,    0.4f,  0.8f, -0.8f,    0.8f,  0.8f, -0.8f,
			-0.8f, -0.8f, -0.4f,   -0.4f, -0.8f, -0.4f,    0.0f, -0.8f, -0.4f,    0.4f, -0.8f, -0.4f,    0.8f, -0.8f, -0.4f,
			-0.8f, -0.4f, -0.4f,   -0.4f, -0.4f, -0.4f,    0.0f, -0.4f, -0.4f,    0.4f, -0.4f, -0.4f,    0.8f, -0.4f, -0.4f,
			-0.8f,  0.0f, -0.4f,   -0.4f,  0.0f, -0.4f,    0.0f,  0.0f, -0.4f,    0.4f,  0.0f, -0.4f,    0.8f,  0.0f, -0.4f,
			-0.8f,  0.4f, -0.4f,   -0.4f,  0.4f, -0.4f,    0.0f,  0.4f, -0.4f,    0.4f,  0.4f, -0.4f,    0.8f,  0.4f, -0.4f,
			-0.8f,  0.8f, -0.4f,   -0.4f,  0.8f, -0.4f,    0.0f,  0.8f, -0.4f,    0.4f,  0.8f, -0.4f,    0.8f,  0.8f, -0.4f,
			-0.8f, -0.8f,  0.0f,   -0.4f, -0.8f,  0.0f,    0.0f, -0.8f,  0.0f,    0.4f, -0.8f,  0.0f,    0.8f, -0.8f,  0.0f,
			-0.8f, -0.4f,  0.0f,   -0.4f, -0.4f,  0.0f,    0.0f, -0.4f,  0.0f,    0.4f, -0.4f,  0.0f,    0.8f, -0.4f,  0.0f,
			-0.8f,  0.0f,  0.0f,   -0.4f,  0.0f,  0.0f,    0.0f,  0.0f,  0.0f,    0.4f,  0.0f,  0.0f,    0.8f,  0.0f,  0.0f,
			-0.8f,  0.4f,  0.0f,   -0.4f,  0.4f,  0.0f,    0.0f,  0.4f,  0.0f,    0.4f,  0.4f,  0.0f,    0.8f,  0.4f,  0.0f,
			-0.8f,  0.8f,  0.0f,   -0.4f,  0.8f,  0.0f,    0.0f,  0.8f,  0.0f,    0.4f,  0.8f,  0.0f,    0.8f,  0.8f,  0.0f,
			-0.8f, -0.8f,  0.4f,   -0.4f, -0.8f,  0.4f,    0.0f, -0.8f,  0.4f,    0.4f, -0.8f,  0.4f,    0.8f, -0.8f,  0.4f,
			-0.8f, -0.4f,  0.4f,   -0.4f, -0.4f,  0.4f,    0.0f, -0.4f,  0.4f,    0.4f, -0.4f,  0.4f,    0.8f, -0.4f,  0.4f,
			-0.8f,  0.0f,  0.4f,   -0.4f,  0.0f,  0.4f,    0.0f,  0.0f,  0.4f,    0.4f,  0.0f,  0.4f,    0.8f,  0.0f,  0.4f,
			-0.8f,  0.4f,  0.4f,   -0.4f,  0.4f,  0.4f,    0.0f,  0.4f,  0.4f,    0.4f,  0.4f,  0.4f,    0.8f,  0.4f,  0.4f,
			-0.8f,  0.8f,  0.4f,   -0.4f,  0.8f,  0.4f,    0.0f,  0.8f,  0.4f,    0.4f,  0.8f,  0.4f,    0.8f,  0.8f,  0.4f,
			-0.8f, -0.8f,  0.8f,   -0.4f, -0.8f,  0.8f,    0.0f, -0.8f,  0.8f,    0.4f, -0.8f,  0.8f,    0.8f, -0.8f,  0.8f,
			-0.8f, -0.4f,  0.8f,   -0.4f, -0.4f,  0.8f,    0.0f, -0.4f,  0.8f,    0.4f, -0.4f,  0.8f,    0.8f, -0.4f,  0.8f,
			-0.8f,  0.0f,  0.8f,   -0.4f,  0.0f,  0.8f,    0.0f,  0.0f,  0.8f,    0.4f,  0.0f,  0.8f,    0.8f,  0.0f,  0.8f,
			-0.8f,  0.4f,  0.8f,   -0.4f,  0.4f,  0.8f,    0.0f,  0.4f,  0.8f,    0.4f,  0.4f,  0.8f,    0.8f,  0.4f,  0.8f,
			-0.8f,  0.8f,  0.8f,   -0.4f,  0.8f,  0.8f,    0.0f,  0.8f,  0.8f,    0.4f,  0.8f,  0.8f,    0.8f,  0.8f,  0.8f
			};

		// this table contains 3 requantized samples for each legal codeword
		// when grouped in 10 bits, i.e. 9 quantizationsteps per sample
		public final static float grouping_10bits[] = new float[] {
			-8.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,			0.0f, -8.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,			0.0f, -6.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,			0.0f, -4.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,			0.0f, -2.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f,		  0.0f, -8.0f/9.0f,	  -6.0f/9.0f,		0.0f, -8.0f/9.0f,	-4.0f/9.0f,		  0.0f, -8.0f/9.0f,
			-2.0f/9.0f,		  0.0f, -8.0f/9.0f,			0.0f,		0.0f, -8.0f/9.0f,	 2.0f/9.0f,		  0.0f, -8.0f/9.0f,
			 4.0f/9.0f,		  0.0f, -8.0f/9.0f,	   6.0f/9.0f,		0.0f, -8.0f/9.0f,	 8.0f/9.0f,		  0.0f, -8.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,			0.0f,  2.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,			0.0f,  4.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,			0.0f,  6.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f, -8.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,			0.0f,  8.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,			0.0f, -8.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,			0.0f, -6.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,			0.0f, -4.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,			0.0f, -2.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f,		  0.0f, -6.0f/9.0f,	  -6.0f/9.0f,		0.0f, -6.0f/9.0f,	-4.0f/9.0f,		  0.0f, -6.0f/9.0f,
			-2.0f/9.0f,		  0.0f, -6.0f/9.0f,			0.0f,		0.0f, -6.0f/9.0f,	 2.0f/9.0f,		  0.0f, -6.0f/9.0f,
			 4.0f/9.0f,		  0.0f, -6.0f/9.0f,	   6.0f/9.0f,		0.0f, -6.0f/9.0f,	 8.0f/9.0f,		  0.0f, -6.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,			0.0f,  2.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,			0.0f,  4.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,			0.0f,  6.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f, -6.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,			0.0f,  8.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,			0.0f, -8.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,			0.0f, -6.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,			0.0f, -4.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,			0.0f, -2.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f,		  0.0f, -4.0f/9.0f,	  -6.0f/9.0f,		0.0f, -4.0f/9.0f,	-4.0f/9.0f,		  0.0f, -4.0f/9.0f,
			-2.0f/9.0f,		  0.0f, -4.0f/9.0f,			0.0f,		0.0f, -4.0f/9.0f,	 2.0f/9.0f,		  0.0f, -4.0f/9.0f,
			 4.0f/9.0f,		  0.0f, -4.0f/9.0f,	   6.0f/9.0f,		0.0f, -4.0f/9.0f,	 8.0f/9.0f,		  0.0f, -4.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,			0.0f,  2.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,			0.0f,  4.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,			0.0f,  6.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f, -4.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,			0.0f,  8.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,			0.0f, -8.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,			0.0f, -6.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,			0.0f, -4.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,			0.0f, -2.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f,		  0.0f, -2.0f/9.0f,	  -6.0f/9.0f,		0.0f, -2.0f/9.0f,	-4.0f/9.0f,		  0.0f, -2.0f/9.0f,
			-2.0f/9.0f,		  0.0f, -2.0f/9.0f,			0.0f,		0.0f, -2.0f/9.0f,	 2.0f/9.0f,		  0.0f, -2.0f/9.0f,
			 4.0f/9.0f,		  0.0f, -2.0f/9.0f,	   6.0f/9.0f,		0.0f, -2.0f/9.0f,	 8.0f/9.0f,		  0.0f, -2.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,			0.0f,  2.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,			0.0f,  4.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,			0.0f,  6.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f, -2.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,			0.0f,  8.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f,		  0.0f,	  -6.0f/9.0f, -8.0f/9.0f,	    0.0f,	-4.0f/9.0f, -8.0f/9.0f,		  0.0f,
			-2.0f/9.0f, -8.0f/9.0f,		  0.0f,			0.0f, -8.0f/9.0f,	    0.0f,	 2.0f/9.0f, -8.0f/9.0f,		  0.0f,
			 4.0f/9.0f, -8.0f/9.0f,		  0.0f,	   6.0f/9.0f, -8.0f/9.0f,	    0.0f,	 8.0f/9.0f, -8.0f/9.0f,		  0.0f,
			-8.0f/9.0f, -6.0f/9.0f,		  0.0f,	  -6.0f/9.0f, -6.0f/9.0f,	    0.0f,	-4.0f/9.0f, -6.0f/9.0f,		  0.0f,
			-2.0f/9.0f, -6.0f/9.0f,		  0.0f,			0.0f, -6.0f/9.0f,	    0.0f,	 2.0f/9.0f, -6.0f/9.0f,		  0.0f,
			 4.0f/9.0f, -6.0f/9.0f,		  0.0f,	   6.0f/9.0f, -6.0f/9.0f,	    0.0f,	 8.0f/9.0f, -6.0f/9.0f,		  0.0f,
			-8.0f/9.0f, -4.0f/9.0f,		  0.0f,	  -6.0f/9.0f, -4.0f/9.0f,	    0.0f,	-4.0f/9.0f, -4.0f/9.0f,		  0.0f,
			-2.0f/9.0f, -4.0f/9.0f,		  0.0f,			0.0f, -4.0f/9.0f,	    0.0f,	 2.0f/9.0f, -4.0f/9.0f,		  0.0f,
			 4.0f/9.0f, -4.0f/9.0f,		  0.0f,	   6.0f/9.0f, -4.0f/9.0f,	    0.0f,	 8.0f/9.0f, -4.0f/9.0f,		  0.0f,
			-8.0f/9.0f, -2.0f/9.0f,		  0.0f,	  -6.0f/9.0f, -2.0f/9.0f,	    0.0f,	-4.0f/9.0f, -2.0f/9.0f,		  0.0f,
			-2.0f/9.0f, -2.0f/9.0f,		  0.0f,			0.0f, -2.0f/9.0f,	    0.0f,	 2.0f/9.0f, -2.0f/9.0f,		  0.0f,
			 4.0f/9.0f, -2.0f/9.0f,		  0.0f,	   6.0f/9.0f, -2.0f/9.0f,	    0.0f,	 8.0f/9.0f, -2.0f/9.0f,		  0.0f,
			-8.0f/9.0f ,	  0.0f,		  0.0f,	  -6.0f/9.0f,		0.0f,	    0.0f,	-4.0f/9.0f,		  0.0f,		  0.0f,
			-2.0f/9.0f,		  0.0f,		  0.0f,			0.0f,		0.0f,	    0.0f,	 2.0f/9.0f,		  0.0f,		  0.0f,
			 4.0f/9.0f,		  0.0f,		  0.0f,	   6.0f/9.0f,		0.0f,	    0.0f,	 8.0f/9.0f,		  0.0f,		  0.0f,
			-8.0f/9.0f,	 2.0f/9.0f,		  0.0f,	  -6.0f/9.0f,  2.0f/9.0f,	    0.0f,	-4.0f/9.0f,	 2.0f/9.0f,		  0.0f,
			-2.0f/9.0f,	 2.0f/9.0f,		  0.0f,			0.0f,  2.0f/9.0f,	    0.0f,	 2.0f/9.0f,	 2.0f/9.0f,		  0.0f,
			 4.0f/9.0f,	 2.0f/9.0f,		  0.0f,	   6.0f/9.0f,  2.0f/9.0f,	    0.0f,	 8.0f/9.0f,	 2.0f/9.0f,		  0.0f,
			-8.0f/9.0f,	 4.0f/9.0f,		  0.0f,	  -6.0f/9.0f,  4.0f/9.0f,	    0.0f,	-4.0f/9.0f,	 4.0f/9.0f,		  0.0f,
			-2.0f/9.0f,	 4.0f/9.0f,		  0.0f,			0.0f,  4.0f/9.0f,	    0.0f,	 2.0f/9.0f,	 4.0f/9.0f,		  0.0f,
			 4.0f/9.0f,	 4.0f/9.0f,		  0.0f,	   6.0f/9.0f,  4.0f/9.0f,	    0.0f,	 8.0f/9.0f,	 4.0f/9.0f,		  0.0f,
			-8.0f/9.0f,	 6.0f/9.0f,		  0.0f,	  -6.0f/9.0f,  6.0f/9.0f,	    0.0f,	-4.0f/9.0f,	 6.0f/9.0f,		  0.0f,
			-2.0f/9.0f,	 6.0f/9.0f,		  0.0f,			0.0f,  6.0f/9.0f,	    0.0f,	 2.0f/9.0f,	 6.0f/9.0f,		  0.0f,
			 4.0f/9.0f,	 6.0f/9.0f,		  0.0f,	   6.0f/9.0f,  6.0f/9.0f,	    0.0f,	 8.0f/9.0f,	 6.0f/9.0f,		  0.0f,
			-8.0f/9.0f,	 8.0f/9.0f,		  0.0f,	  -6.0f/9.0f,  8.0f/9.0f,	    0.0f,	-4.0f/9.0f,	 8.0f/9.0f,		  0.0f,
			-2.0f/9.0f,	 8.0f/9.0f,		  0.0f,			0.0f,  8.0f/9.0f,	    0.0f,	 2.0f/9.0f,	 8.0f/9.0f,		  0.0f,
			 4.0f/9.0f,	 8.0f/9.0f,		  0.0f,	   6.0f/9.0f,  8.0f/9.0f,	    0.0f,	 8.0f/9.0f,	 8.0f/9.0f,		  0.0f,
			-8.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,			0.0f, -8.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,			0.0f, -6.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,			0.0f, -4.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,			0.0f, -2.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f,		  0.0f,	 2.0f/9.0f,	  -6.0f/9.0f,		0.0f,  2.0f/9.0f,	-4.0f/9.0f,		  0.0f,	 2.0f/9.0f,
			-2.0f/9.0f,		  0.0f,	 2.0f/9.0f,			0.0f,		0.0f,  2.0f/9.0f,	 2.0f/9.0f,		  0.0f,	 2.0f/9.0f,
			 4.0f/9.0f,		  0.0f,	 2.0f/9.0f,	   6.0f/9.0f,		0.0f,  2.0f/9.0f,	 8.0f/9.0f,		  0.0f,	 2.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,			0.0f,  2.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,			0.0f,  4.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,			0.0f,  6.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f,  2.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,			0.0f,  8.0f/9.0f,  2.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f,  2.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,			0.0f, -8.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,			0.0f, -6.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,			0.0f, -4.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,			0.0f, -2.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f,		  0.0f,	 4.0f/9.0f,	  -6.0f/9.0f,		0.0f,  4.0f/9.0f,	-4.0f/9.0f,		  0.0f,	 4.0f/9.0f,
			-2.0f/9.0f,		  0.0f,	 4.0f/9.0f,			0.0f,		0.0f,  4.0f/9.0f,	 2.0f/9.0f,		  0.0f,	 4.0f/9.0f,
			 4.0f/9.0f,		  0.0f,	 4.0f/9.0f,	   6.0f/9.0f,		0.0f,  4.0f/9.0f,	 8.0f/9.0f,		  0.0f,	 4.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,			0.0f,  2.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,			0.0f,  4.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,			0.0f,  6.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f,  4.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,			0.0f,  8.0f/9.0f,  4.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f,  4.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,			0.0f, -8.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,			0.0f, -6.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,			0.0f, -4.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,			0.0f, -2.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f,		  0.0f,	 6.0f/9.0f,	  -6.0f/9.0f,		0.0f,  6.0f/9.0f,	-4.0f/9.0f,		  0.0f,	 6.0f/9.0f,
			-2.0f/9.0f,		  0.0f,	 6.0f/9.0f,			0.0f,		0.0f,  6.0f/9.0f,	 2.0f/9.0f,		  0.0f,	 6.0f/9.0f,
			 4.0f/9.0f,		  0.0f,	 6.0f/9.0f,	   6.0f/9.0f,		0.0f,  6.0f/9.0f,	 8.0f/9.0f,		  0.0f,	 6.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,			0.0f,  2.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,			0.0f,  4.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,			0.0f,  6.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f,  6.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,			0.0f,  8.0f/9.0f,  6.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f,  6.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,
			-8.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f, -8.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,			0.0f, -8.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f, -8.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f, -8.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f, -6.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,			0.0f, -6.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f, -6.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f, -6.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f, -4.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,			0.0f, -4.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f, -4.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f, -4.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f, -2.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,			0.0f, -2.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f, -2.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f, -2.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f,		  0.0f,	 8.0f/9.0f,	  -6.0f/9.0f,		0.0f,  8.0f/9.0f,	-4.0f/9.0f,		  0.0f,	 8.0f/9.0f,
			-2.0f/9.0f,		  0.0f,	 8.0f/9.0f,			0.0f,		0.0f,  8.0f/9.0f,	 2.0f/9.0f,		  0.0f,	 8.0f/9.0f,
			 4.0f/9.0f,		  0.0f,	 8.0f/9.0f,	   6.0f/9.0f,		0.0f,  8.0f/9.0f,	 8.0f/9.0f,		  0.0f,	 8.0f/9.0f,
			-8.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f,  2.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,			0.0f,  2.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f,  2.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f,  4.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,			0.0f,  4.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f,  4.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f,	 4.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f,  6.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,			0.0f,  6.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f,  6.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f,	 6.0f/9.0f,	 8.0f/9.0f,
			-8.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	  -6.0f/9.0f,  8.0f/9.0f,  8.0f/9.0f,	-4.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,
			-2.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,			0.0f,  8.0f/9.0f,  8.0f/9.0f,	 2.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,
			 4.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	   6.0f/9.0f,  8.0f/9.0f,  8.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f,	 8.0f/9.0f
			 };

		// data taken from ISO/IEC DIS 11172, Annexes 3-B.2[abcd] and 3-B.4:

		// subbands 0-2 in tables 3-B.2a and 2b: (index is allocation)
		public static final int table_ab1_codelength[] =
			// bits per codeword
		{ 0, 5, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16 };

		public static final float table_ab1_groupingtables[][] =
			// pointer to sample grouping table, or NULL-pointer if ungrouped
		{ null, grouping_5bits, null, null, null, null, null, null, null, null, null, null, null, null, null, null };

		public static final float table_ab1_factor[] =
			// factor for requantization: (real)sample * factor - 1.0 gives requantized sample
		{ 0.0f, 1.0f/2.0f, 1.0f/4.0f, 1.0f/8.0f, 1.0f/16.0f, 1.0f/32.0f, 1.0f/64.0f,
		  1.0f/128.0f, 1.0f/256.0f, 1.0f/512.0f, 1.0f/1024.0f, 1.0f/2048.0f,
		  1.0f/4096.0f, 1.0f/8192.0f, 1.0f/16384.0f, 1.0f/32768.0f };

		public static final float table_ab1_c[] =
			// factor c for requantization from table 3-B.4
		{ 0.0f,           1.33333333333f, 1.14285714286f, 1.06666666666f, 1.03225806452f,
		  1.01587301587f, 1.00787401575f, 1.00392156863f, 1.00195694716f, 1.00097751711f,
		  1.00048851979f, 1.00024420024f, 1.00012208522f, 1.00006103888f, 1.00003051851f,
		  1.00001525902f };

		public static final float table_ab1_d[] =
			// addend d for requantization from table 3-B.4
		{ 0.0f,           0.50000000000f, 0.25000000000f, 0.12500000000f, 0.06250000000f,
		  0.03125000000f, 0.01562500000f, 0.00781250000f, 0.00390625000f, 0.00195312500f,
		  0.00097656250f, 0.00048828125f, 0.00024414063f, 0.00012207031f, 0.00006103516f,
		  0.00003051758f };

		// subbands 3-... tables 3-B.2a and 2b:
		public static final float[] table_ab234_groupingtables[] =
		{ null, grouping_5bits, grouping_7bits, null, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null };

		// subbands 3-10 in tables 3-B.2a and 2b:
		public static final int table_ab2_codelength[] =
		{ 0, 5, 7, 3, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16 };
		public static final float table_ab2_factor[] =
		{ 0.0f, 1.0f/2.0f, 1.0f/4.0f, 1.0f/4.0f, 1.0f/8.0f, 1.0f/8.0f, 1.0f/16.0f,
		  1.0f/32.0f, 1.0f/64.0f, 1.0f/128.0f, 1.0f/256.0f, 1.0f/512.0f,
		  1.0f/1024.0f, 1.0f/2048.0f, 1.0f/4096.0f, 1.0f/32768.0f };
		public static final float table_ab2_c[] =
		{ 0.0f,           1.33333333333f, 1.60000000000f, 1.14285714286f, 1.77777777777f,
		  1.06666666666f, 1.03225806452f, 1.01587301587f, 1.00787401575f, 1.00392156863f,
		  1.00195694716f, 1.00097751711f, 1.00048851979f, 1.00024420024f, 1.00012208522f,
		  1.00001525902f };
		public static final float table_ab2_d[] =
		{ 0.0f,           0.50000000000f, 0.50000000000f, 0.25000000000f, 0.50000000000f,
		  0.12500000000f, 0.06250000000f, 0.03125000000f, 0.01562500000f, 0.00781250000f,
		  0.00390625000f, 0.00195312500f, 0.00097656250f, 0.00048828125f, 0.00024414063f,
		  0.00003051758f };

		// subbands 11-22 in tables 3-B.2a and 2b:
		public static final int table_ab3_codelength[] = { 0, 5, 7, 3, 10, 4, 5, 16 };
		public static final float table_ab3_factor[] =
		{ 0.0f, 1.0f/2.0f, 1.0f/4.0f, 1.0f/4.0f, 1.0f/8.0f, 1.0f/8.0f, 1.0f/16.0f, 1.0f/32768.0f };
		public static final float table_ab3_c[] =
		{ 0.0f,           1.33333333333f, 1.60000000000f, 1.14285714286f, 1.77777777777f,
		  1.06666666666f, 1.03225806452f, 1.00001525902f };
		public static final float table_ab3_d[] =
		{ 0.0f,           0.50000000000f, 0.50000000000f, 0.25000000000f, 0.50000000000f,
		  0.12500000000f, 0.06250000000f, 0.00003051758f };

		// subbands 23-... in tables 3-B.2a and 2b:
		public static final int table_ab4_codelength[] = { 0, 5, 7, 16 };
		public static final float table_ab4_factor[] = { 0.0f, 1.0f/2.0f, 1.0f/4.0f, 1.0f/32768.0f };
		public static final float table_ab4_c[] = { 0.0f, 1.33333333333f, 1.60000000000f, 1.00001525902f };
		public static final float table_ab4_d[] = { 0.0f, 0.50000000000f, 0.50000000000f, 0.00003051758f };

		// subbands in tables 3-B.2c and 2d:
		public static final int table_cd_codelength[] =
		{ 0, 5, 7, 10, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 };
		public static final float table_cd_groupingtables[][] =
		{ null, grouping_5bits, grouping_7bits, grouping_10bits, null, null, null, null, null, null, null, null, null, null, null, null };
		public static final float table_cd_factor[] =
		{ 0.0f, 1.0f/2.0f, 1.0f/4.0f, 1.0f/8.0f, 1.0f/8.0f, 1.0f/16.0f, 1.0f/32.0f, 1.0f/64.0f,
		  1.0f/128.0f, 1.0f/256.0f, 1.0f/512.0f, 1.0f/1024.0f, 1.0f/2048.0f, 1.0f/4096.0f,
		  1.0f/8192.0f, 1.0f/16384.0f };
		public static final float table_cd_c[] =
		{ 0.0f,           1.33333333333f, 1.60000000000f, 1.77777777777f, 1.06666666666f,
		  1.03225806452f, 1.01587301587f, 1.00787401575f, 1.00392156863f, 1.00195694716f,
		  1.00097751711f, 1.00048851979f, 1.00024420024f, 1.00012208522f, 1.00006103888f,
		  1.00003051851f };
		public static final float table_cd_d[] =
		{ 0.0f,           0.50000000000f, 0.50000000000f, 0.50000000000f, 0.12500000000f,
		  0.06250000000f, 0.03125000000f, 0.01562500000f, 0.00781250000f, 0.00390625000f,
		  0.00195312500f, 0.00097656250f, 0.00048828125f, 0.00024414063f, 0.00012207031f,
		  0.00006103516f };

		protected int 			subbandnumber;
		protected int			allocation;
		protected int			scfsi;
		protected float			scalefactor1, scalefactor2, scalefactor3;
		protected int[] 		codelength = {0};
		protected float[][] 	groupingtable = { null };
		protected float[]		factor = {0.0f};
		protected int			groupnumber = 0;
		protected int			samplenumber = 0;
		protected float[]		samples = new float[3];
		protected float[]		c = {0};
		protected float[]		d = {0};

		public SubbandLayer2(int subbandnumber) {
			this.subbandnumber = subbandnumber;

			/*
			if (grouping_10bits == null) {
				grouping_10bits = loadTable("g10b.ser", 2187);
				grouping_7bits = loadTable("g7b.ser", 375);
			}
			*/

			/*
			AD_JavaLayerUtils jlu = new AD_JavaLayerUtils();
			try {
				FileOutputStream out = new FileOutputStream("g10b.ser");
				jlu.serialize(out, grouping_10bits);
				out.close();
			} catch (Exception ex) { }
			*/

		}


		static private float[] loadTable(String filename, int size) {
			try {
				Class elemType = Float.TYPE;
				Object o = AD_JavaLayerUtils.deserializeArrayResource(filename, elemType, size);
				return (float[])o;
			}
			catch (IOException ex) {
				throw new ExceptionInInitializerError(ex);
			}
		}


		// FIXME: reset state to initial values
		public void reset() {
			allocation = 0;
			scfsi = 0;
			scalefactor1 = 0; scalefactor2 = 0; scalefactor3 = 0;
			codelength[0] = 0;
			groupingtable[0] = null;
			factor[0] = 0f;
			groupnumber = 0;
			samplenumber = 0;
			samples[0] = 0f;
			samples[1] = 0f;
			samples[2] = 0f;
			c[0] = 0f;
			d[0] = 0f;
		}

		/**
		 *
		 */
		protected int get_allocationlength (AD_Header header) {
			if (header.version() == AD_Header.MPEG1) {
				int channel_bitrate = header.bitrate_index();

				// calculate bitrate per channel:
				if (header.mode() != AD_Header.SINGLE_CHANNEL)
					if (channel_bitrate == 4)
						channel_bitrate = 1;
					else
						channel_bitrate -= 4;

				if (channel_bitrate == 1 || channel_bitrate == 2)
					// table 3-B.2c or 3-B.2d
					if (subbandnumber <= 1)
						return 4;
					else
						return 3;
				else
					// tables 3-B.2a or 3-B.2b
					if (subbandnumber <= 10)
						return 4;
					else if (subbandnumber <= 22)
						return 3;
					else
						return 2;
			} else { // MPEG-2 LSF -- Jeff

				// table B.1 of ISO/IEC 13818-3
				if (subbandnumber <= 3)
					return 4;
				else if (subbandnumber <= 10)
					return 3;
				else
					return 2;
			}
		}

		/**
		 *
		 */
		protected void prepare_sample_reading(AD_Header header, int allocation,
											  float[][] gt,
											  float[] factor, int[] codelength,
											  float[] c, float[] d) {

	 	 	int channel_bitrate = header.bitrate_index();

	  		// calculate bitrate per channel:
		  	if (header.mode() != AD_Header.SINGLE_CHANNEL)
		 		if (channel_bitrate == 4)
					channel_bitrate = 1;
		 		else
					channel_bitrate -= 4;

			if (channel_bitrate == 1 || channel_bitrate == 2) {
				// table 3-B.2c or 3-B.2d
				gt[0] = table_cd_groupingtables[allocation];
				factor[0] = table_cd_factor[allocation];
				codelength[0] = table_cd_codelength[allocation];
				c[0] = table_cd_c[allocation];
				d[0] = table_cd_d[allocation];
			} else {
				// tables 3-B.2a or 3-B.2b
				if (subbandnumber <= 2) {
					gt[0] = table_ab1_groupingtables[allocation];
					factor[0] = table_ab1_factor[allocation];
					codelength[0] = table_ab1_codelength[allocation];
					c[0] = table_ab1_c[allocation];
					d[0] = table_ab1_d[allocation];
				} else {
					gt[0] = table_ab234_groupingtables[allocation];
					if (subbandnumber <= 10) {
						factor[0] = table_ab2_factor[allocation];
						codelength[0] = table_ab2_codelength[allocation];
						c[0] = table_ab2_c[allocation];
						d[0] = table_ab2_d[allocation];
					} else if (subbandnumber <= 22) {
						factor[0] = table_ab3_factor[allocation];
						codelength[0] = table_ab3_codelength[allocation];
						c[0] = table_ab3_c[allocation];
						d[0] = table_ab3_d[allocation];
					} else {
						factor[0] = table_ab4_factor[allocation];
						codelength[0] = table_ab4_codelength[allocation];
						c[0] = table_ab4_c[allocation];
						d[0] = table_ab4_d[allocation];
					}
				}
			}
		}

		/**
		 *
		 */
		public void read_allocation(BufferedBitStream stream, AD_Header header, AD_Crc16 crc) throws InterruptedException {
			int length = get_allocationlength(header);
			allocation = stream.getBits(length);
			if (crc != null)
				crc.add_bits(allocation, length);
		}

		/**
		 *
		 */
		public void read_scalefactor_selection (BufferedBitStream stream, AD_Crc16 crc) throws InterruptedException {
			if (allocation != 0) {
				scfsi = stream.getBits(2);
				if (crc != null) crc.add_bits(scfsi, 2);
			}
		}

		/**
		 *
		 */
		public void read_scalefactor (BufferedBitStream stream, AD_Header header) throws InterruptedException {
			if (allocation != 0) {
				switch (scfsi) {
				case 0:
					scalefactor1 = scalefactors[stream.getBits(6)];
					scalefactor2 = scalefactors[stream.getBits(6)];
					scalefactor3 = scalefactors[stream.getBits(6)];
					break;
				case 1:
					scalefactor1 = scalefactor2 = scalefactors[stream.getBits(6)];
					scalefactor3 = scalefactors[stream.getBits(6)];
					break;
				case 2:
					scalefactor1 = scalefactor2 = scalefactor3 = scalefactors[stream.getBits(6)];
					break;
				case 3:
					scalefactor1 = scalefactors[stream.getBits(6)];
					scalefactor2 = scalefactor3 = scalefactors[stream.getBits(6)];
					break;
				}
				prepare_sample_reading(header, allocation, groupingtable,
									   factor, codelength, c, d);
			}
		}

		// static int count = 0;
		public boolean read_sampledata (BufferedBitStream stream) throws InterruptedException {
			if (allocation != 0) {
				if (groupingtable[0] != null) {

					int samplecode = stream.getBits(codelength[0]);
					samplecode += samplecode << 1;
					float[] source = groupingtable[0];

					// if (count > 1300) System.out.print(count + ":" + samplecode + " ");
					// if (count > 1300 && count % 20 == 0) System.out.println();
					// count++;

					samples[0] = source[samplecode];
					samples[1] = source[samplecode + 1];
					samples[2] = source[samplecode + 2];
				} else {
					final float fct = factor[0];
					final int cl = codelength[0];

					samples[0] = (float) (stream.getBits(cl) * fct - 1.0);
					samples[1] = (float) (stream.getBits(cl) * fct - 1.0);
					samples[2] = (float) (stream.getBits(cl) * fct - 1.0);
				}
			}

			samplenumber = 0;
			if (++groupnumber == 12)
				return true;
			else
				return false;
		}

		/**
		 *
		 */
		public boolean put_next_sample(int channels, AD_SynthesisFilter filter1, AD_SynthesisFilter filter2) {
			if ((allocation != 0) && (channels != AD_OutputChannels.RIGHT_CHANNEL)) {
				float sample = samples[samplenumber];

				if (groupingtable[0] == null)
					sample = (sample + d[0]) * c[0];
				// System.out.println(" c: " + c[0] + " d: " + d[0] + " samp: " + sample + " gt: " + groupingtable[0]);
				if (groupnumber <= 4)
					sample *= scalefactor1;
				else if (groupnumber <= 8)
					sample *= scalefactor2;
				else
					sample *= scalefactor3;

				filter1.input_sample(sample, subbandnumber);
			}

			if (++samplenumber == 3)
				return true;
			else
				return false;
		}
	};

	/**
	 * Class for layer II subbands in joint stereo mode.
	 */
	static class SubbandLayer2IntensityStereo extends SubbandLayer2 {
		protected int		 channel2_scfsi;
		protected float 	 channel2_scalefactor1, channel2_scalefactor2, channel2_scalefactor3;

		public SubbandLayer2IntensityStereo(int subbandnumber) {
			super(subbandnumber);
		}

		public void reset() {
			super.reset();
			channel2_scfsi = 0;
			channel2_scalefactor1= 0f; channel2_scalefactor2 = 0f; channel2_scalefactor3 = 0f;
		}

		/**
		 * joint stereo
		 */
		public void read_allocation(BufferedBitStream stream, AD_Header header, AD_Crc16 crc) throws InterruptedException {
			super.read_allocation(stream, header, crc);
		}

		/**
		 * joint stereo
		 */
		public void read_scalefactor_selection(BufferedBitStream stream, AD_Crc16 crc) throws InterruptedException {
			if (allocation != 0) {
				scfsi = stream.getBits(2);
				channel2_scfsi = stream.getBits(2);
				if (crc != null) {
					crc.add_bits(scfsi, 2);
					crc.add_bits(channel2_scfsi, 2);
				}
			}
		}

		/**
		 * joint stereo
		 */
		public void read_scalefactor(BufferedBitStream stream, AD_Header header) throws InterruptedException {
			if (allocation != 0) {
				super.read_scalefactor(stream, header);
				switch (channel2_scfsi) {
				case 0:
					channel2_scalefactor1 = scalefactors[stream.getBits(6)];
					channel2_scalefactor2 = scalefactors[stream.getBits(6)];
					channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 1:
					channel2_scalefactor1 = channel2_scalefactor2 = scalefactors[stream.getBits(6)];
					channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 2:
					channel2_scalefactor1 = channel2_scalefactor2 =
						channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 3:
					channel2_scalefactor1 = scalefactors[stream.getBits(6)];
					channel2_scalefactor2 = channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;
				}
			}
		}

		/**
		 * joint stereo
		 */
		public boolean read_sampledata(BufferedBitStream stream) throws InterruptedException {
			return super.read_sampledata(stream);
		}

		/**
		 * joint stereo
		 */
		public boolean put_next_sample(int channels, AD_SynthesisFilter filter1, AD_SynthesisFilter filter2) {
			if (allocation != 0){
				float sample = samples[samplenumber];

				if (groupingtable[0] == null)
					sample = (sample + d[0]) * c[0];
				if (channels == AD_OutputChannels.BOTH_CHANNELS) {
					float sample2 = sample;
					if (groupnumber <= 4) {
						sample *= scalefactor1;
						sample2 *= channel2_scalefactor1;
					}
					else if (groupnumber <= 8) {
						sample *= scalefactor2;
						sample2 *= channel2_scalefactor2;
					} else {
						sample *= scalefactor3;
						sample2 *= channel2_scalefactor3;
					}
					filter1.input_sample(sample, subbandnumber);
					filter2.input_sample(sample2, subbandnumber);
			    }
		 	   	else if (channels == AD_OutputChannels.LEFT_CHANNEL) {
					if (groupnumber <= 4)
						sample *= scalefactor1;
		 	     	else if (groupnumber <= 8)
						sample *= scalefactor2;
					else
						sample *= scalefactor3;
					filter1.input_sample(sample, subbandnumber);
				 } else {
					 if (groupnumber <= 4)
						 sample *= channel2_scalefactor1;
					 else if (groupnumber <= 8)
						 sample *= channel2_scalefactor2;
					 else
						 sample *= channel2_scalefactor3;
					 filter1.input_sample(sample, subbandnumber);
				 }
		  	}

			if (++samplenumber == 3)
				return true;
			else
				return false;
		}
	};

	/**
	 * Class for layer II subbands in stereo mode.
	 */
	static class SubbandLayer2Stereo extends SubbandLayer2 {
		protected int		channel2_allocation;
		protected int 		channel2_scfsi;
		protected float	 	channel2_scalefactor1, channel2_scalefactor2, channel2_scalefactor3;
		protected boolean	channel2_grouping;
		protected int[] 	channel2_codelength = {0};
		protected float[][] channel2_groupingtable = { null };
		protected float[]	channel2_factor = {0};
		protected float[] 	channel2_samples = new float[3];
		protected float[]	channel2_c = {0};
		protected float[]	channel2_d = {0};

		public SubbandLayer2Stereo(int subbandnumber) {
			super(subbandnumber);
		}

		public void reset() {
			super.reset();
			channel2_allocation = 0;
			channel2_scfsi = 0;
			channel2_scalefactor1 = 0; channel2_scalefactor2 = 0; channel2_scalefactor3 = 0;
			channel2_grouping = false;
			channel2_codelength[0] = 0;
			channel2_groupingtable[0] = null;
			channel2_factor[0] = 0f;
			channel2_samples[0] = 0f;
			channel2_samples[1] = 0f;
			channel2_samples[2] = 0f;
			channel2_c[0] = 0f;
			channel2_d[0] = 0f;
		}


		/**
		 * stereo
		 */
		public void read_allocation (BufferedBitStream stream, AD_Header header, AD_Crc16 crc) throws InterruptedException {
			int length = get_allocationlength(header);
			allocation = stream.getBits(length);
			channel2_allocation = stream.getBits(length);
			if (crc != null) {
				crc.add_bits(allocation, length);
				crc.add_bits(channel2_allocation, length);
			}
		}

		/**
		 * stereo
		 */
		public void read_scalefactor_selection(BufferedBitStream stream, AD_Crc16 crc) throws InterruptedException {
			if (allocation != 0) {
				scfsi = stream.getBits(2);
				if (crc != null)
					crc.add_bits(scfsi, 2);
			}
			if (channel2_allocation != 0) {
				channel2_scfsi = stream.getBits(2);
				if (crc != null)
					crc.add_bits(channel2_scfsi, 2);
			}
		}

		/**
		 * stereo
		 */
		public void read_scalefactor(BufferedBitStream stream, AD_Header header) throws InterruptedException {
			super.read_scalefactor(stream, header);
			if (channel2_allocation != 0) {
				switch (channel2_scfsi) {
				case 0:
					channel2_scalefactor1 = scalefactors[stream.getBits(6)];
					channel2_scalefactor2 = scalefactors[stream.getBits(6)];
					channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 1:
					channel2_scalefactor1 = channel2_scalefactor2 =
						scalefactors[stream.getBits(6)];
					channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 2:
					channel2_scalefactor1 = channel2_scalefactor2 =
						channel2_scalefactor3 = scalefactors[stream.getBits(6)];
					break;

				case 3:
					channel2_scalefactor1 = scalefactors[stream.getBits(6)];
					channel2_scalefactor2 = channel2_scalefactor3 =
						scalefactors[stream.getBits(6)];
					break;
				}
				prepare_sample_reading(header, channel2_allocation, channel2_groupingtable,
									   channel2_factor, channel2_codelength, channel2_c,
									   channel2_d);
			}
		}

		/**
		 * stereo
		 */
		public boolean read_sampledata(BufferedBitStream stream) throws InterruptedException {
			boolean returnvalue = super.read_sampledata(stream);

			if (channel2_allocation != 0)
				if (channel2_groupingtable[0] != null) {
					int samplecode = stream.getBits(channel2_codelength[0]);

					// create requantized samples:
					samplecode += samplecode << 1;
					float[] source = channel2_groupingtable[0];

					channel2_samples[0] = source[samplecode];
					channel2_samples[1] = source[samplecode + 1];
					channel2_samples[2] = source[samplecode + 2];
				} else {
					final float c2f = channel2_factor[0];
					final int c2cl = channel2_codelength[0];
					channel2_samples[0] = (float) (stream.getBits(c2cl) * c2f - 1.0);
					channel2_samples[1] = (float) (stream.getBits(c2cl) * c2f - 1.0);
					channel2_samples[2] = (float) (stream.getBits(c2cl) * c2f - 1.0);
				}

			return returnvalue;
		}


		/**
		 * stereo
		 */
		public boolean put_next_sample(int channels, AD_SynthesisFilter filter1, AD_SynthesisFilter filter2) {
			boolean returnvalue = super.put_next_sample(channels, filter1, filter2);
			if ((channel2_allocation != 0) && (channels != AD_OutputChannels.LEFT_CHANNEL)) {
				float sample = channel2_samples[samplenumber - 1];

				// FIX 4/24/01: check 0th element of groupingtable for
				// null, not groupingtable itself! (fixes ringing bug)
				if (channel2_groupingtable[0] == null)
					sample = (sample + channel2_d[0]) * channel2_c[0];

				if (groupnumber <= 4)
					sample *= channel2_scalefactor1;
				else if (groupnumber <= 8)
					sample *= channel2_scalefactor2;
				else
					sample *= channel2_scalefactor3;
				if (channels == AD_OutputChannels.BOTH_CHANNELS)
					filter2.input_sample(sample, subbandnumber);
				else
					filter1.input_sample(sample, subbandnumber);
			}
			return returnvalue;
		}
	}
}
