/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AD_Obuffer.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */




/**
 * Audio output buffer.
 */
public class AD_Obuffer
{
    public static final int OBUFFERSIZE = 2 * 1152;	// max. 2 * 1152 samples per frame
    public static final int MAXCHANNELS = 2;		// max. number of channels

	private short[] 	buffer;
	private int[] 		bufferp;
	private int 		channels;
	private int			frequency;

	/**
	 * Constructor
	 */
	public AD_Obuffer(int sample_frequency, int number_of_channels) {
		buffer = new short[OBUFFERSIZE];
		bufferp = new int[MAXCHANNELS];
		channels = number_of_channels;
		frequency = sample_frequency;

		for (int i = 0; i < number_of_channels; ++i)
			bufferp[i] = (short)i;

	}

	public int getChannelCount() {
		return this.channels;
	}

	public int getSampleFrequency() {
		return this.frequency;
	}

	public short[] getBuffer() {
		return this.buffer;
	}

	public int getBufferLength() {
		return bufferp[0];
	}

 	/**
	 * Takes a 16 Bit PCM sample.
	 */
	public void append(int channel, short value) {
		buffer[bufferp[channel]] = value;
		bufferp[channel] += channels;
	}

    /**
     * Accepts 32 new PCM samples.
     */
	public void appendSamples(int channel, float[] f, int len) {

	    int pos = bufferp[channel];
		short s;
		float fs;

	    for (int i = 0; i < len;) {
		  	fs = f[i++];
			fs = (fs>32767.0f ? 32767.0f
				  : (fs < -32767.0f ? -32767.0f : fs));

			s = (short)fs;
			buffer[pos] = s;
			pos += channels;
	    }
		bufferp[channel] = pos;
	}

    /**
     * Write the samples to the file or directly to the audio hardware.
     */
    public void write_buffer(int val) {}
    public void close() {}

    /**
     * Clears all data in the buffer (for seeking).
     */
	public void clear_buffer() {
		for (int i = 0; i < channels; ++i)
			bufferp[i] = (short)i;
	}
}
