/*
 *   @(#) MPEG-I Video Decoder 1.0 Demicron (demicron@demicron.com)
 *
 *   AudioDecoder.java   2002-08-20
 *
 *   Copyright (C) 2002  Demicron
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

import java.io.*;

/**
 *   MPEG-I Audio Stream Decoder
 * Note: This class is for future extension, now it just kick the buffer back to system queue
 */
public class AudioDecoder implements Runnable
{

  private boolean stopped;
// Needed for the subclass to be possible
/*public AudioDecoder() {

}*/
	/**
	 *   The Buffered bit stream where all the audio data comes
	 */
	private BufferedBitStream audioStream;

	/**
	 *   Constructor
	 */
	public AudioDecoder() {
          //audioStream = stream;
	}

        public void init(BufferedBitStream stream) {
          audioStream = stream;
        }

	private volatile Thread audio_thread;		// The audio decoder runs as thread

	/**
	 *   Reset the audio stream decoder
	 */
	void reset() {
		audioStream.reset();
	}

	public void start() {
		audio_thread = new Thread(this);
		audio_thread.start();
	}

	public void play() {

	}

	public boolean isStoked() {
          return true; // Always ok to "turn on audio", since this is dummy
        }

        public void stop()
        {
          stopped = true;

               /* if (state != RESETED) {
                        if (state == PAUSED)
                          play();
                        loop = false;
                        systemDecoder.stop();
                }*/
        }

        public Thread getThread() {
          return audio_thread;
        }

	/**
	 *   The main Audio decoding process ( just kicking back the buffer )
	 */
	public void run()
	{
		try {
			int code = audioStream.showBits(32);
			//while ( code != VideoDecoder.SEQUENCE_END_CODE) {
			// Note: Change to ISO_11172_END_CODE to force the system decoder die first

			while ( code != BitStream.ISO_11172_END_CODE && !stopped) {
				audioStream.nextBuffer();
				code = audioStream.showBits(32);
			}
		} catch (InterruptedException e) {
			//System.out.println(" InterruptedException in AudioDecoder Thread: " + e);
		}
	}
}
