/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.formats;

import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import photoorganizer.Controller;
import photoorganizer.formats.AbstractImageInfo;
import photoorganizer.formats.BasicJpeg;
import photoorganizer.formats.FileFormatException;
import photoorganizer.formats.Naming;
import photoorganizer.formats.Rational;
import photoorganizer.formats.Record;

public class CIFF
extends AbstractImageInfo {
    static final String FORMAT = "HEAP";
    static final String JPGM = "JPGM";
    static final String II = "II";
    static final String MM = "MM";
    public static final int KSTG_FORMATMASK = 49152;
    public static final int K_DATATYPEMASK = 14336;
    public static final int K_IDCODEMASK = 2047;
    public static final int K_TYPEIDCODEMASK = 16383;
    public static final int KSTG_INHEAPSPACE = 49152;
    public static final int KSTG_INRECORDENTRY = 16384;
    public static final int K_DT_BYTE = 0;
    public static final int K_DT_ASCII = 2048;
    public static final int K_DT_WORD = 4096;
    public static final int K_DT_DWORD = 6144;
    public static final int K_DT_BYTE2 = 8192;
    public static final int K_DT_HEAPTYPEPROPERTY1 = 10240;
    public static final int K_DT_HEAPTYPEPROPERTY2 = 12288;
    public static final int K_TC_WILDCARD = 65535;
    public static final int K_TC_NULL = 0;
    public static final int K_TC_FREE = 1;
    public static final int K_TC_EXUSED = 2;
    public static final int K_TC_DESCRIPTION = 2053;
    public static final int K_TC_MODELNAME = 2058;
    public static final int K_TC_FIRMWAREVERSION = 2059;
    public static final int K_TC_COMPONENTVESRION = 2060;
    public static final int K_TC_ROMOPERATIONMODE = 2061;
    public static final int K_TC_OWNERNAME = 2064;
    public static final int K_TC_IMAGEFILENAME = 2070;
    public static final int K_TC_THUMBNAILFILENAME = 2071;
    public static final int K_TC_TARGETIMAGETYPE = 4106;
    public static final int K_TC_SR_RELEASEMETHOD = 4112;
    public static final int K_TC_SR_RELEASETIMING = 4113;
    public static final int K_TC_RELEASESETTING = 4118;
    public static final int K_TC_BODYSENSITIVITY = 4124;
    public static final int K_TC_IMAGEFORMAT = 6147;
    public static final int K_TC_RECORDID = 6148;
    public static final int K_TC_SELFTIMERTIME = 6150;
    public static final int K_TC_SR_TARGETDISTANCESETTING = 6151;
    public static final int K_TC_BODYID = 6155;
    public static final int K_TC_CAPTURETIME = 6158;
    public static final int K_TC_IMAGESPEC = 6160;
    public static final int K_TC_SR_EF = 6163;
    public static final int K_TC_MI_EV = 6164;
    public static final int K_TC_SERIALNUMBER = 6167;
    public static final int K_TC_SR_EXPOSURE = 6168;
    public static final int K_TC_CAMERAOBJECT = 10247;
    public static final int K_TC_SHOOTINGRECORD = 12290;
    public static final int K_TC_MEASUREDINFO = 12291;
    public static final int K_TC_CAMERASPECIFICATION = 12292;
    Hashtable heapcontent;

    public CIFF(InputStream inputStream, byte[] byArray, int n, String string, String string2) throws FileFormatException {
        super(inputStream, byArray, n, string, string2);
    }

    public String getFormat() {
        return FORMAT;
    }

    public void readInfo() {
        this.readHeapFileHeader();
        this.data = null;
    }

    void readHeapFileHeader() {
        this.motorola = this.data[0] == 77;
        boolean bl = this.intel = this.data[0] == 73;
        if (!this.isSignature(10, JPGM)) {
            return;
        }
        this.heapcontent = new Hashtable();
        int n = this.s2n(2, 4);
        this.processHeap(n, this.data.length - n);
    }

    void processHeap(int n, int n2) {
        int n3 = this.s2n(n + n2 - 4, 4) + n;
        int n4 = this.s2n(n3, 2);
        int n5 = n3 + 2;
        int n6 = 0;
        while (n6 < n4) {
            n5 = this.processRecord(n5, n);
            ++n6;
        }
    }

    int processRecord(int n, int n2) {
        int n3 = this.s2n(n, 2);
        int n4 = n3 & 0x3FFF;
        if ((n3 & 0xC000) == 0) {
            int n5 = this.s2n(n + 2, 4);
            int n6 = this.s2n(n + 6, 4) + n2;
            if (n4 == 6160) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n6, 4), this.s2n(n6 + 4, 4), Float.intBitsToFloat(this.s2n(n6 + 8, 4)), this.s2n(n6 + 12, 4), this.s2n(n6 + 16, 4), this.s2n(n6 + 20, 4), this.s2n(n6 + 24, 4)));
            } else if (n4 == 2058) {
                String string = this.s2a(n6, n5);
                string.replace('\u0000', ' ');
                this.heapcontent.put(new Integer(n4), new Record(n4, string));
            } else if (n4 == 2070 || n4 == 2071 || n4 == 2053 || n4 == 2064 || n4 == 2059) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2a(n6, n5)));
            } else if (n4 == 6168) {
                this.heapcontent.put(new Integer(n4), new Record(n4, Float.intBitsToFloat(this.s2n(n6, 4)), Float.intBitsToFloat(this.s2n(n6 + 4, 4)), Float.intBitsToFloat(this.s2n(n6 + 8, 4))));
            } else if (n4 == 6158) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n6, 4), this.s2n(n6 + 4, 4), this.s2n(n6 + 8, 4)));
            } else if (n4 == 12292) {
                this.processHeap(n6, n5);
            } else if (n4 == 10247) {
                this.processHeap(n6, n5);
            } else if (n4 == 12291) {
                this.processHeap(n6, n5);
            } else if (n4 == 12290) {
                this.processHeap(n6, n5);
            } else if ((n4 & 0x3800) == 10240 || (n4 & 0x3800) == 12288) {
                this.processHeap(n6, n5);
            } else {
                this.heapcontent.put(new Integer(n4), new Record(n4, (n4 & 0x3800) == 2048 ? this.s2a(n6, n5) : "Unknown " + Naming.getCIFFTypeName(n4) + " in-heap property"));
            }
        } else if ((n3 & 0x4000) != 0) {
            if (n4 == 6147) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n + 2, 4), Float.intBitsToFloat(this.s2n(n + 6, 4))));
            } else if (n4 == 4106) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n + 2, 2)));
            } else if (n4 == 6148 || n4 == 6167 || n4 == 6150 || n4 == 6155) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n + 2, 4)));
            } else if (n4 == 4112 || n4 == 4113 || n4 == 4124) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2n(n + 2, 2)));
            } else if (n4 == 6163) {
                this.heapcontent.put(new Integer(n4), new Record(n4, Float.intBitsToFloat(this.s2n(n + 2, 4)), Float.intBitsToFloat(this.s2n(n + 6, 4))));
            } else if (n4 == 6151 || n4 == 6164) {
                this.heapcontent.put(new Integer(n4), new Record(n4, Float.intBitsToFloat(this.s2n(n + 2, 4))));
            } else if (n4 == 2061) {
                this.heapcontent.put(new Integer(n4), new Record(n4, this.s2a(n + 2, 8)));
            } else {
                String string;
                if ((n4 & 0x3800) == 2048) {
                    string = this.s2a(n + 2, 8);
                } else {
                    string = "Unknown " + Naming.getCIFFTypeName(n4) + " in-record property";
                    if ((n4 & 0x3800) == 4096) {
                        string = string + "(" + this.s2n(n + 2, 2) + ")";
                    } else if ((n4 & 0x3800) == 6144) {
                        string = string + "(" + this.s2n(n + 2, 4) + ")";
                    } else if ((n4 & 0x3800) == 0) {
                        string = string + "(" + this.s2n(n + 2, 1) + ")";
                    }
                }
                this.heapcontent.put(new Integer(n4), new Record(n4, string));
            }
        }
        return n + 2 + 4 + 4;
    }

    public int getResolutionX() {
        Record record = (Record)this.heapcontent.get(new Integer(6160));
        if (record != null) {
            return record.getWidth();
        }
        return -1;
    }

    public int getResolutionY() {
        Record record = (Record)this.heapcontent.get(new Integer(6160));
        if (record != null) {
            return record.getHeight();
        }
        return -1;
    }

    public int getMetering() {
        return 0;
    }

    public int getExpoProgram() {
        return 0;
    }

    public String getMake() {
        return this.heapcontent.get(new Integer(2058)).toString();
    }

    public String getModel() {
        return this.heapcontent.get(new Integer(2058)).toString();
    }

    public String getDataTimeOriginalString() {
        return this.heapcontent.get(new Integer(6158)).toString();
    }

    public float getFNumber() {
        try {
            return this.apertureToFnumber(((Record)this.heapcontent.get(new Integer(6168))).getFloatValue(2));
        }
        catch (NullPointerException nullPointerException) {
            return -1.0f;
        }
    }

    public Rational getShutter() {
        try {
            int n = (int)((Record)this.heapcontent.get(new Integer(6168))).getFloatValue(1);
            return AbstractImageInfo.TV_TO_SEC[n];
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return new Rational(0, 1);
    }

    public boolean isFlash() {
        try {
            return ((Record)this.heapcontent.get(new Integer(6163))).getFloatValue() > 0.0f;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public float getFocalLength() {
        return 0.0f;
    }

    public String getQuality() {
        return "BEST";
    }

    public String getReport() {
        return this.heapcontent.get(new Integer(6168)).toString();
    }

    public void saveThumbnailImage(BasicJpeg basicJpeg, OutputStream outputStream) throws IOException {
        try {
            String string = this.heapcontent.get(new Integer(2071)).toString();
            if (string != null) {
                int n;
                FileInputStream fileInputStream = new FileInputStream(new File(new File(basicJpeg.getLocationName()).getParent(), string));
                byte[] byArray = new byte[1024];
                while ((n = ((InputStream)fileInputStream).read(byArray)) > 0) {
                    outputStream.write(byArray, 0, n);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (outputStream != null) {
            outputStream.close();
        }
    }

    public Icon getThumbnailIcon(BasicJpeg basicJpeg, Dimension dimension) {
        try {
            File file = new File(new File(basicJpeg.getLocationName()).getParent(), this.heapcontent.get(new Integer(2071)).toString());
            if (file.exists()) {
                return new ImageIcon(file.getAbsolutePath());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (Controller.getAdvancedImage() != null) {
            try {
                return Controller.getAdvancedImage().createThumbnailIcon(basicJpeg.getLocationName(), null);
            }
            catch (Throwable throwable) {
                System.err.println(throwable);
            }
        }
        return null;
    }

    public Hashtable getProperties() {
        return this.heapcontent;
    }
}

