/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.jai;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.swing.Icon;

public class IconJAI
implements Icon {
    protected RenderedImage im;
    protected SampleModel sampleModel;
    protected ColorModel colorModel;
    protected int minX;
    protected int minY;
    protected int width;
    protected int height;
    protected Rectangle imageBounds;
    protected int minTileX;
    protected int maxTileX;
    protected int minTileY;
    protected int maxTileY;
    protected int tileWidth;
    protected int tileHeight;
    protected int tileGridXOffset;
    protected int tileGridYOffset;
    protected int originX;
    protected int originY;
    private Color grayColor = new Color(192, 192, 192);
    private Color backgroundColor = null;
    private static final Dimension DEFAULT_THUMB_SIZE = new Dimension(120, 96);

    public static RenderedImage createThumbnailImage(RenderedImage renderedImage, Dimension dimension) {
        float f;
        float f2;
        if (dimension == null) {
            dimension = DEFAULT_THUMB_SIZE;
        }
        if ((f2 = (float)dimension.width / (float)Math.abs(renderedImage.getWidth())) < (f = (float)dimension.height / (float)Math.abs(renderedImage.getHeight()))) {
            f = f2;
        } else {
            f2 = f;
        }
        ParameterBlock parameterBlock = new ParameterBlock();
        parameterBlock.addSource(renderedImage);
        parameterBlock.add(f2);
        parameterBlock.add(f);
        parameterBlock.add(0.0f);
        parameterBlock.add(0.0f);
        parameterBlock.add(Interpolation.getInstance((int)0));
        ImageLayout imageLayout = new ImageLayout().setTileWidth((int)((float)renderedImage.getTileWidth() * f2)).setTileWidth((int)((float)renderedImage.getTileHeight() * f));
        return JAI.create((String)"scale", (ParameterBlock)parameterBlock, (RenderingHints)new RenderingHints(JAI.KEY_IMAGE_LAYOUT, imageLayout));
    }

    public IconJAI(RenderedImage renderedImage) {
        Object object;
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        if (n < 0 || n2 < 0) {
            object = new ParameterBlock();
            ((ParameterBlock)object).addSource(renderedImage);
            ((ParameterBlock)object).add((float)Math.max(-n, 0));
            ((ParameterBlock)object).add((float)Math.max(-n2, 0));
            ((ParameterBlock)object).add(new InterpolationNearest());
            renderedImage = JAI.create((String)"translate", (ParameterBlock)object, null);
        }
        this.im = renderedImage;
        this.sampleModel = renderedImage.getSampleModel();
        this.colorModel = renderedImage.getColorModel();
        if (this.colorModel == null) {
            this.colorModel = PlanarImage.createColorModel((SampleModel)renderedImage.getSampleModel());
        }
        if (this.colorModel == null) {
            throw new IllegalArgumentException("IconJAI is unable to display supplied RenderedImage.");
        }
        if (this.colorModel.getTransparency() != 1) {
            object = renderedImage.getProperty("background_color");
            this.backgroundColor = object != null ? (Color)object : null;
        }
        this.minX = renderedImage.getMinX();
        this.minY = renderedImage.getMinY();
        this.width = renderedImage.getWidth();
        this.height = renderedImage.getHeight();
        this.imageBounds = new Rectangle(this.minX, this.minY, this.width, this.height);
        this.minTileX = renderedImage.getMinTileX();
        this.maxTileX = renderedImage.getMinTileX() + renderedImage.getNumXTiles() - 1;
        this.minTileY = renderedImage.getMinTileY();
        this.maxTileY = renderedImage.getMinTileY() + renderedImage.getNumYTiles() - 1;
        this.tileWidth = renderedImage.getTileWidth();
        this.tileHeight = renderedImage.getTileHeight();
        this.tileGridXOffset = renderedImage.getTileGridXOffset();
        this.tileGridYOffset = renderedImage.getTileGridYOffset();
        this.originY = 0;
        this.originX = 0;
    }

    public int getIconWidth() {
        return this.im.getWidth();
    }

    public int getIconHeight() {
        return this.im.getHeight();
    }

    private int XtoTileX(int n) {
        return (int)Math.floor((double)(n - this.tileGridXOffset) / (double)this.tileWidth);
    }

    private int YtoTileY(int n) {
        return (int)Math.floor((double)(n - this.tileGridYOffset) / (double)this.tileHeight);
    }

    private int TileXtoX(int n) {
        return n * this.tileWidth + this.tileGridXOffset;
    }

    private int TileYtoY(int n) {
        return n * this.tileHeight + this.tileGridYOffset;
    }

    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        Graphics2D graphics2D = null;
        if (!(graphics instanceof Graphics2D)) {
            System.err.println("IconJAI: not a Graphics2D.");
            return;
        }
        graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics.getClipBounds();
        int n7 = n;
        int n8 = n2;
        Rectangle rectangle2 = new Rectangle(this.minX + n7, this.minY + n8, this.width, this.height);
        if (rectangle != null) {
            n6 = this.XtoTileX(rectangle.x);
            n6 = Math.max(n6, this.minTileX);
            n6 = Math.min(n6, this.maxTileX);
            n5 = this.XtoTileX(rectangle.x + rectangle.width - 1);
            n5 = Math.max(n5, this.minTileX);
            n5 = Math.min(n5, this.maxTileX);
            n4 = this.YtoTileY(rectangle.y);
            n4 = Math.max(n4, this.minTileY);
            n4 = Math.min(n4, this.maxTileY);
            n3 = this.YtoTileY(rectangle.y + rectangle.height - 1);
            n3 = Math.max(n3, this.minTileY);
            n3 = Math.min(n3, this.maxTileY);
            graphics2D.clip(rectangle2);
        } else {
            n6 = this.minTileX;
            n5 = this.maxTileX;
            n4 = this.minTileY;
            n3 = this.maxTileY;
            graphics2D.setClip(rectangle2);
        }
        if (this.backgroundColor != null) {
            graphics2D.setColor(this.backgroundColor);
        }
        int n9 = n4;
        while (n9 <= n3) {
            int n10 = n6;
            while (n10 <= n5) {
                try {
                    int n11 = this.TileXtoX(n10);
                    int n12 = this.TileYtoY(n9);
                    Raster raster = this.im.getTile(n10, n9);
                    DataBuffer dataBuffer = raster.getDataBuffer();
                    Point point = new Point(0, 0);
                    WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, dataBuffer, point);
                    BufferedImage bufferedImage = new BufferedImage(this.colorModel, writableRaster, false, null);
                    AffineTransform affineTransform = AffineTransform.getTranslateInstance(n11 + n7, n12 + n8);
                    if (this.backgroundColor != null) {
                        graphics2D.fillRect(n11 + n7, n12 + n8, this.tileWidth, this.tileHeight);
                    }
                    graphics2D.drawImage(bufferedImage, affineTransform, null);
                }
                catch (Throwable throwable) {
                    System.err.println("IconJAI: Exception " + throwable + " in drawing tiles");
                    return;
                }
                ++n10;
            }
            ++n9;
        }
        if (rectangle != null) {
            graphics2D.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }
}

