/*
 * Decompiled with CFR 0.152.
 */
package photoorganizer.renderer;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import photoorganizer.Controller;
import photoorganizer.Resources;
import photoorganizer.directory.JDirectoryChooser;
import photoorganizer.formats.AbstractFormat;
import photoorganizer.formats.FileNameFormat;
import photoorganizer.renderer.PopupCombo;
import rogatkin.GranulatedLayout;
import rogatkin.Helpable;
import rogatkin.Persistable;
import rogatkin.Serializer;

public final class RenameOptionsTab
extends JPanel
implements ActionListener,
FocusListener,
Persistable,
Helpable {
    public static final String SECNAME = "RenameOptions";
    public static final String MASK = "Mask";
    public static final String ASKEDIT = "AskEdit";
    public static final String REMOVEAFTER = "RemoveAfterRename";
    public static final String COUNTER = "Counter";
    static final String DESTFOLDER = "DestinationFolder";
    Controller controller;
    private JTextField tf_counter;
    private JTextField tf_destdir;
    private JButton bt_brws_dstdir;
    private JCheckBox cb_editnewname;
    private JCheckBox cb_remafter;
    private JComboBox cb_masks;
    private DefaultComboBoxModel maskItems;

    public RenameOptionsTab(final Controller controller) {
        this.controller = controller;
        this.setLayout((LayoutManager)new GranulatedLayout(5, 5, 20, 4, 8, 8));
        this.add((Component)new JLabel("Target name generation mask"), "0,0,4,1");
        this.maskItems = new DefaultComboBoxModel();
        this.cb_masks = new JComboBox(this.maskItems);
        this.add(this.cb_masks, "0,1,2");
        this.cb_masks.setEditable(true);
        this.add((Component)new PopupCombo(Resources.MASKS[1], "<", this, "2,1", this.cb_masks), "2,1,2");
        this.cb_masks.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Object object = RenameOptionsTab.this.cb_masks.getEditor().getItem();
                if (object != null && object.toString().trim().length() > 0) {
                    if (RenameOptionsTab.this.maskItems.getIndexOf(object) < 0) {
                        RenameOptionsTab.this.cb_masks.addItem(object);
                    }
                    RenameOptionsTab.this.cb_masks.setToolTipText(FileNameFormat.makeValidPathName(new FileNameFormat(object.toString()).format(controller.sampleJpeg)));
                }
            }
        });
        this.cb_editnewname = new JCheckBox("Edit name before");
        this.add((Component)this.cb_editnewname, "0,2,2,1,12");
        this.cb_remafter = new JCheckBox("Remove from selection");
        this.add((Component)this.cb_remafter, "0,3,2,1,12");
        this.add((Component)new JLabel("Initial counter", 2), "2,2,2,1");
        this.tf_counter = new JTextField();
        this.add((Component)this.tf_counter, "2,3,1,1");
        this.tf_counter.setHorizontalAlignment(4);
        this.add((Component)new JLabel("Destination folder for renaming and transformation"), "0,4,4,1");
        this.tf_destdir = new JTextField();
        this.add((Component)this.tf_destdir, "0,5,4,1");
        this.bt_brws_dstdir = new JButton("Browse");
        this.add((Component)this.bt_brws_dstdir, "4,5,1,1");
        this.bt_brws_dstdir.addActionListener(this);
        this.tf_counter.addFocusListener(this);
    }

    public String getHelp() {
        return "<html>\n<h2>Format escape sequences for pictures and music</h2>\n<pre>\n %D - date/time stamp in current locale,\n %d - date stamp,\n %t - time stamp,\n %s - shutter speed/bitrate,\n %a - aperture value/sample rate,\n %f - flash/protected (yes, no),\n %q - quality/mode\n %c - counter, can be specified as %0..0c, if leading zeros have to be present,\n %o - original file name,\n %r - transformation code expanded to: r90, r270, r180, TrPose, TrVerse, HMirr, VMirr\n %S - file size (undocumented),\n %z - focal length (zoom)/year,\n %M - make/artist\n %m - model/title\n %x - metering mode,\n %X - exposure program\n %n - type extension\n Format escape sequences for music\n %A - album,\n %b - band,\n %C - comment,\n %L - language,\n %g - genre,\n %l - length,\n %T - track,\n %e - composer,\n %E - conductor\n </pre>";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JDirectoryChooser jDirectoryChooser;
        if (actionEvent.getSource() == this.bt_brws_dstdir && (jDirectoryChooser = new JDirectoryChooser(new JFrame(), this.tf_destdir.getText(), null)).getDirectory() != null) {
            this.tf_destdir.setText(jDirectoryChooser.getDirectory());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.tf_counter.setText("" + FileNameFormat.counter);
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public void load() {
        Object object;
        Serializer serializer = this.controller.getSerializer();
        Object object2 = serializer.getProperty((Object)SECNAME, (Object)MASK);
        if (object2 != null) {
            if (object2 instanceof Object[]) {
                object = (Object[])object2;
                int n = 0;
                while (n < ((Object[])object).length) {
                    this.maskItems.addElement(object[n]);
                    ++n;
                }
            } else {
                this.maskItems.addElement(object2);
            }
        }
        this.cb_editnewname.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)ASKEDIT), (int)0) == 1);
        this.cb_remafter.setSelected(Serializer.getInt((Object)serializer.getProperty((Object)SECNAME, (Object)REMOVEAFTER), (int)0) == 1);
        this.tf_counter.setText("" + FileNameFormat.counter);
        object = (String)serializer.getProperty((Object)SECNAME, (Object)DESTFOLDER);
        if (object != null) {
            this.tf_destdir.setText((String)object);
        }
    }

    public void save() {
        Object object;
        Serializer serializer = this.controller.getSerializer();
        this.cb_masks.setSelectedIndex(-1);
        if (this.maskItems.getSize() == 1) {
            serializer.setProperty((Object)SECNAME, (Object)MASK, (Object)this.maskItems.getElementAt(0).toString());
        } else if (this.maskItems.getSize() > 1) {
            object = new String[this.maskItems.getSize()];
            int n = 0;
            while (n < this.maskItems.getSize()) {
                object[n] = this.maskItems.getElementAt(n).toString();
                ++n;
            }
            serializer.setProperty((Object)SECNAME, (Object)MASK, object);
        }
        serializer.setProperty((Object)SECNAME, (Object)ASKEDIT, (Object)(this.cb_editnewname.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)REMOVEAFTER, (Object)(this.cb_remafter.isSelected() ? Resources.I_YES : Resources.I_NO));
        serializer.setProperty((Object)SECNAME, (Object)DESTFOLDER, (Object)this.tf_destdir.getText());
        object = Resources.I_NO;
        try {
            object = new Integer(this.tf_counter.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        serializer.setProperty((Object)SECNAME, (Object)COUNTER, object);
        FileNameFormat.counter = (Integer)object;
    }

    public static String getNewName(AbstractFormat abstractFormat, Controller controller) {
        return new FileNameFormat((String)controller.getSerializer().getProperty((Object)SECNAME, (Object)MASK), true).format(abstractFormat);
    }
}

