/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class CDMPanel
extends JPanel
implements VectorEditor {
    VectorPanel panelDevices;
    Vector deviceVector;
    Vector deviceArray;
    JTextArea jta;
    int type;
    JScrollPane scrollPane;

    public CDMPanel() {
        this.setLayout(new BorderLayout());
        this.panelDevices = new VectorPanel("Capture Devices", this, 0);
        this.add("West", this.panelDevices);
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add("North", new JLabel("Capture Device  Details"));
        this.jta = new JTextArea();
        this.jta.setEnabled(false);
        this.scrollPane = new JScrollPane(this.jta);
        panel.add("Center", this.scrollPane);
        this.add("Center", panel);
    }

    public Vector stringArrayToVector(String[] array) {
        Vector<String> v = new Vector<String>();
        if (array != null) {
            int i2 = 0;
            while (i2 < array.length) {
                v.addElement(array[i2]);
                ++i2;
            }
        }
        return v;
    }

    public String[] vectorToStringArray(Vector v) {
        String[] sa = new String[v.size()];
        Enumeration e2 = v.elements();
        int i2 = 0;
        while (e2.hasMoreElements()) {
            sa[i2++] = (String)e2.nextElement();
        }
        return sa;
    }

    public Vector getList(int code) {
        Vector devices = CaptureDeviceManager.getDeviceList(null);
        this.deviceVector = new Vector(10);
        Enumeration enumeration = devices.elements();
        while (enumeration.hasMoreElements()) {
            CaptureDeviceInfo cdi = (CaptureDeviceInfo)enumeration.nextElement();
            this.deviceVector.addElement(cdi.getName());
        }
        return this.deviceVector;
    }

    public void setList(int code, Vector v) {
        this.deviceVector = v;
    }

    public void commit(int code) {
        try {
            CaptureDeviceManager.commit();
        }
        catch (IOException ioe) {
            System.err.println("CaptureDeviceManager.commit() - " + ioe);
        }
    }

    public boolean addToList(int code, String value) {
        try {
            CaptureDeviceInfo cdi;
            String className = value;
            Class<?> pic = Class.forName(className);
            Object instance = pic.newInstance();
            if (instance instanceof CaptureDeviceInfo && ((cdi = (CaptureDeviceInfo)instance).getName() != null || cdi.getLocator() != null) && CaptureDeviceManager.addDevice(cdi)) {
                return true;
            }
        }
        catch (Exception e2) {
            System.err.println(e2);
        }
        catch (Error er) {
            System.err.println(er);
        }
        return false;
    }

    public void selectedIndex(int code, int index) {
        String name = (String)this.deviceVector.elementAt(index);
        String text = "";
        CaptureDeviceInfo cdi = CaptureDeviceManager.getDevice(name);
        if (cdi != null) {
            text = String.valueOf(text) + "Name = " + cdi.getName() + "\n\n";
            text = String.valueOf(text) + "Locator = " + cdi.getLocator() + "\n\n";
            text = String.valueOf(text) + "Output Formats---->\n\n" + this.printFormats(cdi.getFormats()) + "\n\n";
        }
        this.jta.setText(text);
        this.scrollPane.invalidate();
        this.scrollPane.validate();
        this.scrollPane.repaint();
    }

    private String printFormats(Object fa) {
        if (!(fa instanceof Format[])) {
            return "null";
        }
        Format[] formats = (Format[])fa;
        String text = "";
        int i2 = 0;
        while (i2 < formats.length) {
            text = String.valueOf(text) + i2 + ". " + formats[i2].getClass().getName() + "\n  " + formats[i2] + "\n";
            ++i2;
        }
        return text;
    }
}

