/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.AudioFormatChooser;
import com.sun.media.ui.TabControl;
import com.sun.media.ui.VideoFormatChooser;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.control.FormatControl;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.DataSource;

public class CaptureDialog
extends Dialog
implements WindowListener,
ActionListener,
ItemListener {
    private Vector vectorDevices;
    private MediaLocator locatorMedia;
    private List listDevices;
    private Panel panelDevices;
    private Panel panelParams;
    private AudioFormatChooser chooserAudio;
    private VideoFormatChooser chooserVideo;
    private Button buttonOK;
    private Button buttonCancel;

    public CaptureDialog(Frame parentFrame) {
        super(parentFrame, true);
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public MediaLocator getLocator() {
        return this.locatorMedia;
    }

    public VideoFormat getVideoFormat() {
        VideoFormat format = null;
        if (this.chooserVideo != null && this.chooserVideo.isTrackEnabled()) {
            format = (VideoFormat)this.chooserVideo.getFormat();
        }
        return format;
    }

    public AudioFormat getAudioFormat() {
        AudioFormat format = null;
        if (this.chooserAudio != null && this.chooserAudio.isTrackEnabled()) {
            format = (AudioFormat)this.chooserAudio.getFormat();
        }
        return format;
    }

    public DataSource createCaptureDataSource() {
        DataSource dataSource;
        block9: {
            MediaLocator locatorMedia = this.getLocator();
            VideoFormat formatVideo = this.getVideoFormat();
            AudioFormat formatAudio = this.getAudioFormat();
            if (locatorMedia == null) {
                return null;
            }
            try {
                dataSource = Manager.createDataSource(locatorMedia);
            }
            catch (Exception exception) {
                MessageDialog.createErrorDialog(this.getFrame(), "Failed to create Data Source for '" + locatorMedia.toString() + "'. " + exception.getMessage());
                return null;
            }
            if (!(dataSource instanceof CaptureDevice)) break block9;
            CaptureDevice deviceCapture = (CaptureDevice)((Object)dataSource);
            FormatControl[] arrFormatControls = deviceCapture.getFormatControls();
            int nCount = arrFormatControls.length;
            int i2 = 0;
            while (i2 < nCount) {
                block12: {
                    Format formatCompare;
                    block11: {
                        Format format;
                        block10: {
                            format = arrFormatControls[i2].getFormat();
                            if (!(format instanceof VideoFormat) || formatVideo == null) break block10;
                            formatCompare = formatVideo;
                            break block11;
                        }
                        if (!(format instanceof AudioFormat) || formatAudio == null) break block12;
                        formatCompare = formatAudio;
                    }
                    Format[] arrSupportedFormats = arrFormatControls[i2].getSupportedFormats();
                    int j2 = 0;
                    while (j2 < arrSupportedFormats.length) {
                        if (arrSupportedFormats[j2].matches(formatCompare)) {
                            arrFormatControls[i2].setFormat(arrSupportedFormats[j2].intersects(formatCompare));
                            break;
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        return dataSource;
    }

    private void init() throws Exception {
        Panel panel;
        this.setTitle("Select Capture Device");
        this.setLayout(new BorderLayout());
        ((Component)this).setBackground(Color.lightGray);
        BorderedPanel panelContent = new BorderedPanel(new BorderLayout());
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        this.vectorDevices = CaptureDeviceManager.getDeviceList(null);
        if (this.vectorDevices == null || this.vectorDevices.size() < 1) {
            Label label = new Label("No capture devices found in JMF registry!");
            panelContent.add((Component)label, "Center");
        } else {
            this.panelDevices = new Panel(new BorderLayout(6, 6));
            panelContent.add((Component)this.panelDevices, "Center");
            panel = this.createPanelList();
            this.panelDevices.add((Component)panel, "North");
            this.createPanelParams();
        }
        panel = this.createPanelButtons();
        panelContent.add((Component)panel, "South");
        ((Component)this).setSize(360, 360);
        this.addWindowListener(this);
        this.setResizable(false);
    }

    private Panel createPanelList() throws Exception {
        int nCount = this.vectorDevices.size();
        Panel panel = new Panel(new BorderLayout(6, 6));
        this.listDevices = new List(Math.min(6, nCount));
        panel.add((Component)this.listDevices, "Center");
        int i2 = 0;
        while (i2 < nCount) {
            CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)this.vectorDevices.elementAt(i2);
            this.listDevices.addItem(infoCaptureDevice.getName());
            ++i2;
        }
        this.listDevices.select(0);
        this.listDevices.addItemListener(this);
        return panel;
    }

    private Panel createPanelButtons() throws Exception {
        Panel panelButtons = new Panel(new FlowLayout(1));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonOK = new Button("OK");
        this.buttonOK.addActionListener(this);
        panel.add(this.buttonOK);
        if (this.vectorDevices != null && this.vectorDevices.size() > 0) {
            this.buttonCancel = new Button("Cancel");
            this.buttonCancel.addActionListener(this);
            panel.add(this.buttonCancel);
        }
        return panelButtons;
    }

    private void createPanelParams() {
        if (this.panelParams != null) {
            this.panelDevices.remove(this.panelParams);
        }
        this.panelParams = new Panel(new BorderLayout(6, 6));
        this.panelDevices.add((Component)this.panelParams, "Center");
        int nIndex = this.listDevices.getSelectedIndex();
        if (nIndex < 0) {
            return;
        }
        CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)this.vectorDevices.elementAt(nIndex);
        Panel panel = this.createPanelFormats(infoCaptureDevice);
        this.panelParams.add((Component)panel, "North");
    }

    private Panel createPanelFormats(CaptureDeviceInfo infoCaptureDevice) {
        TabControl tabControl = null;
        AudioFormat formatAudio = null;
        VideoFormat formatVideo = null;
        this.chooserAudio = null;
        this.chooserVideo = null;
        Format[] arrFormats = infoCaptureDevice.getFormats();
        int nCount = arrFormats.length;
        int nAudioCount = 0;
        int nVideoCount = 0;
        int i2 = 0;
        while (i2 < nCount) {
            if (arrFormats[i2] instanceof AudioFormat) {
                ++nAudioCount;
                if (formatAudio == null) {
                    formatAudio = (AudioFormat)arrFormats[i2];
                }
            } else if (arrFormats[i2] instanceof VideoFormat) {
                ++nVideoCount;
                if (formatVideo == null) {
                    formatVideo = (VideoFormat)arrFormats[i2];
                }
            }
            ++i2;
        }
        Panel panel = new Panel(new BorderLayout());
        if (nAudioCount > 0) {
            this.chooserAudio = new AudioFormatChooser(arrFormats, formatAudio, true, null);
        }
        if (nVideoCount > 0) {
            this.chooserVideo = new VideoFormatChooser(arrFormats, formatVideo, true, null);
        }
        if (this.chooserAudio != null && this.chooserVideo != null) {
            tabControl = new TabControl(0);
            tabControl.addPage(this.chooserAudio, "Audio");
            tabControl.addPage(this.chooserVideo, "Video");
            panel.add((Component)tabControl, "Center");
        } else if (this.chooserAudio != null) {
            panel.add((Component)this.chooserAudio, "Center");
        } else if (this.chooserVideo != null) {
            panel.add((Component)this.chooserVideo, "Center");
        }
        return panel;
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(this.buttonOK.getLabel()) && this.vectorDevices != null && this.vectorDevices.size() > 0) {
            int nIndex = this.listDevices.getSelectedIndex();
            CaptureDeviceInfo infoCaptureDevice = (CaptureDeviceInfo)this.vectorDevices.elementAt(nIndex);
            this.locatorMedia = infoCaptureDevice.getLocator();
        } else {
            this.locatorMedia = null;
        }
        this.dispose();
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.listDevices) {
            this.createPanelParams();
            this.panelDevices.doLayout();
            this.panelDevices.validate();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.locatorMedia = null;
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    private Frame getFrame() {
        Frame frame = null;
        Container comp = this;
        while (comp != null) {
            if (comp instanceof Frame) {
                frame = (Frame)comp;
                break;
            }
            comp = comp.getParent();
        }
        return frame;
    }
}

