/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.ui.TabControl;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoPlayerException;
import javax.media.Processor;
import javax.media.Time;
import javax.media.control.FormatControl;
import javax.media.control.TrackControl;
import javax.media.datasink.EndOfFileEvent;
import javax.media.datasink.FileSizeLimitReachedEvent;
import javax.media.datasink.FileWriterControl;
import javax.media.datasink.FileWriterEvent;
import javax.media.datasink.FileWriterListener;
import javax.media.datasink.FileWritingErrorEvent;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.CaptureDevice;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class SaveAsDialog
extends Dialog
implements WindowListener,
ActionListener,
ControllerListener,
FileWriterListener,
ItemListener {
    public static final String ACTION_TRACK_ENABLED = "ACTION_TRACK_ENABLED";
    public static final String ACTION_TRACK_DISABLED = "ACTION_TRACK_DISABLED";
    private String inputURL;
    private Processor processor;
    private DataSink dataSink;
    private TrackControl[] arrTrackControls;
    private int nAudioTrackCount;
    private int nVideoTrackCount;
    private String strContentType;
    private String strContentTypeExt;
    private boolean boolSaving = false;
    private Frame frameOwner;
    private ProgressDialog dlgProgress;
    private ProgressThread threadProgress;
    private Format captureFormat;
    private TabControl tabControl;
    private Hashtable hashtablePanelsAudio = new Hashtable();
    private Hashtable hashtablePanelsVideo = new Hashtable();
    private Button buttonSave;
    private Button buttonCancel;
    private Choice comboContentType;
    private Image imageAudioEn;
    private Image imageAudioDis;
    private Image imageVideoEn;
    private Image imageVideoDis;
    private String strFailMessage;
    private ContentDescriptor[] supportedCDs;
    private static final String STR_MSVIDEO = "MSVideo (avi)";
    private static final String STR_QUICKTIME = "QuickTime (mov)";
    private static final String STR_AIFF = "AIFF (aif)";
    private static final String STR_GSM = "GSM (gsm)";
    private static final String STR_WAVE = "Wave (wav)";
    private static final String STR_BASIC_AUDIO = "Basic Audio (au)";
    private static final String STR_MPEG = "MPEG Audio (mp2/mp3)";
    Object stateLock = new Object();
    boolean stateFailed = false;

    public SaveAsDialog(Frame frame, String inputURL, Format format) {
        super(frame, "Save As...", false);
        this.inputURL = inputURL;
        this.frameOwner = frame;
        this.captureFormat = format;
        try {
            this.init();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void init() throws Exception {
        DataSource dataSource;
        ((Component)this).setBackground(Color.lightGray);
        this.imageAudioEn = MessageDialog.loadImage("/images/audio.gif", this, true);
        this.imageAudioDis = MessageDialog.loadImage("/images/audio-disabled.gif", this, true);
        this.imageVideoEn = MessageDialog.loadImage("/images/video.gif", this, true);
        this.imageVideoDis = MessageDialog.loadImage("/images/video-disabled.gif", this, true);
        Frame frame = this.getFrame();
        Point point = frame == null ? new Point(0, 0) : frame.getLocationOnScreen();
        point.x += 100;
        point.y += 100;
        ((Component)this).setLocation(point);
        this.frameOwner.setCursor(new Cursor(3));
        try {
            FormatControl[] fcs;
            MediaLocator mediaSource = new MediaLocator(this.inputURL);
            dataSource = Manager.createDataSource(mediaSource);
            if (this.captureFormat != null && dataSource instanceof CaptureDevice && (fcs = ((CaptureDevice)((Object)dataSource)).getFormatControls()) != null && fcs.length > 0) {
                fcs[0].setFormat(this.captureFormat);
            }
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to create Data Source for file '" + this.inputURL + "'. " + exception.getMessage());
            throw exception;
        }
        this.strContentType = dataSource.getContentType();
        try {
            this.processor = Manager.createProcessor(dataSource);
        }
        catch (NoPlayerException exception) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to create Processor. " + exception.getMessage());
            throw exception;
        }
        this.processor.addControllerListener(this);
        boolean boolResult = this.waitForState(this.processor, 180);
        if (!boolResult) {
            MessageDialog.createErrorDialog(this.getFrame(), "Failed to configure Processor. " + this.strFailMessage);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        this.supportedCDs = this.processor.getSupportedContentDescriptors();
        this.arrTrackControls = this.processor.getTrackControls();
        int i2 = 0;
        while (i2 < this.arrTrackControls.length) {
            Format format = this.arrTrackControls[i2].getFormat();
            if (format instanceof VideoFormat) {
                ++this.nVideoTrackCount;
            }
            if (format instanceof AudioFormat) {
                ++this.nAudioTrackCount;
            }
            ++i2;
        }
        this.setLayout(new BorderLayout());
        BorderedPanel panelBorder = new BorderedPanel(new BorderLayout(6, 6));
        panelBorder.setEmptyBorder(6, 6, 6, 6);
        panelBorder.setBackground(Color.lightGray);
        this.add((Component)panelBorder, "Center");
        Panel panel = this.createPanelGeneral();
        panelBorder.add((Component)panel, "North");
        panel = this.createPanelProperties();
        panelBorder.add((Component)panel, "Center");
        panel = this.createPanelButtons();
        panelBorder.add((Component)panel, "South");
        this.changeContentType();
        ((Component)this).setSize(320, 380);
        this.addWindowListener(this);
        this.setResizable(false);
        ((Component)this).setVisible(true);
        this.frameOwner.setCursor(Cursor.getDefaultCursor());
    }

    private Panel createPanelProperties() throws Exception {
        this.tabControl = new TabControl(0);
        int nIndexAudio = 0;
        int nIndexVideo = 0;
        int nCount = this.arrTrackControls.length;
        int i2 = 0;
        while (i2 < nCount) {
            Panel panel;
            String strTitle;
            Format format = this.arrTrackControls[i2].getFormat();
            if (format instanceof AudioFormat) {
                strTitle = this.nAudioTrackCount < 2 ? new String("Audio") : new String("Audio " + ++nIndexAudio);
                panel = new SaveAsAudioPanel(this.arrTrackControls[i2], this);
                this.tabControl.addPage(panel, strTitle, this.imageAudioEn);
                this.hashtablePanelsAudio.put(strTitle, panel);
            } else if (format instanceof VideoFormat) {
                strTitle = this.nVideoTrackCount < 2 ? new String("Video") : new String("Video " + ++nIndexVideo);
                panel = new SaveAsVideoPanel(this.arrTrackControls[i2], this);
                this.tabControl.addPage(panel, strTitle, this.imageVideoEn);
                this.hashtablePanelsVideo.put(strTitle, panel);
            }
            ++i2;
        }
        return this.tabControl;
    }

    private Panel createPanelButtons() throws Exception {
        Panel panelButtons = new Panel(new FlowLayout(2));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonSave = new Button("Save...");
        this.buttonSave.addActionListener(this);
        panel.add(this.buttonSave);
        this.buttonCancel = new Button("Cancel");
        this.buttonCancel.addActionListener(this);
        panel.add(this.buttonCancel);
        return panelButtons;
    }

    private Panel createPanelGeneral() throws Exception {
        Panel panelGeneral = new Panel(new GridLayout(0, 1, 4, 4));
        Panel panelFormat = new Panel(new BorderLayout());
        panelGeneral.add(panelFormat);
        Label label = new Label("Format:");
        panelFormat.add((Component)label, "West");
        this.comboContentType = new Choice();
        this.comboContentType.addItemListener(this);
        int i2 = 0;
        while (i2 < this.supportedCDs.length) {
            String ct = this.supportedCDs[i2].getContentType();
            if (!ct.equalsIgnoreCase("raw") && !ct.equalsIgnoreCase("raw.rtp")) {
                this.comboContentType.addItem(this.transCDToDesc(ct));
            }
            ++i2;
        }
        this.comboContentType.select(this.transCDToDesc(ContentDescriptor.mimeTypeToPackageName(this.strContentType)));
        panelFormat.add((Component)this.comboContentType, "Center");
        return panelGeneral;
    }

    private String transCDToDesc(String strContentType) {
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("video.x_msvideo"))) {
            return STR_MSVIDEO;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("video.quicktime"))) {
            return STR_QUICKTIME;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_aiff"))) {
            return STR_AIFF;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_gsm"))) {
            return STR_GSM;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_wav"))) {
            return STR_WAVE;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.basic"))) {
            return STR_BASIC_AUDIO;
        }
        if (strContentType.equals(ContentDescriptor.mimeTypeToPackageName("audio.x_mpegaudio"))) {
            return STR_MPEG;
        }
        return strContentType;
    }

    private Frame getFrame() {
        Frame frame = null;
        Container component = this;
        while (component != null) {
            if (component instanceof Frame) {
                frame = (Frame)component;
                break;
            }
            component = component.getParent();
        }
        return frame;
    }

    private void doSave() {
        String strDirName;
        String strFileContentType = null;
        String strFileName = null;
        Component monitor = null;
        FileDialog dlgFile = new FileDialog(this.getFrame(), "Save As File ...", 1);
        int i2 = this.inputURL.indexOf(58);
        strFileName = i2 > 2 ? this.inputURL.substring(i2 + 1) : new String(this.inputURL);
        if (strFileName.indexOf(47) == 0 && strFileName.indexOf(58) == 2) {
            strFileName = strFileName.substring(1);
        }
        if ((i2 = strFileName.lastIndexOf(46)) >= 0 && this.strContentTypeExt != null) {
            strFileName = String.valueOf(strFileName.substring(0, i2 + 1)) + this.strContentTypeExt;
        } else if (i2 < 0 && this.strContentTypeExt != null) {
            strFileName = "Unknown." + this.strContentTypeExt;
        }
        i2 = Math.max(strFileName.lastIndexOf(47), strFileName.lastIndexOf(92));
        if (i2 > -1) {
            strDirName = strFileName.substring(0, i2);
            strFileName = strFileName.substring(i2 + 1);
            dlgFile.setDirectory(strDirName);
        }
        dlgFile.setFile(strFileName);
        ((Component)dlgFile).setVisible(true);
        strFileName = dlgFile.getFile();
        if (strFileName == null || strFileName.length() == 0) {
            return;
        }
        strDirName = dlgFile.getDirectory();
        strFileName = strDirName != null ? String.valueOf(strDirName.trim()) + strFileName.trim() : strFileName.trim();
        this.setCursor(new Cursor(3));
        try {
            this.processor.setContentDescriptor(new ContentDescriptor(this.strContentType));
            Enumeration enumPanels = this.hashtablePanelsVideo.elements();
            while (enumPanels.hasMoreElements()) {
                SaveAsVideoPanel panelVideo = (SaveAsVideoPanel)enumPanels.nextElement();
                panelVideo.updateTrack();
            }
            enumPanels = this.hashtablePanelsAudio.elements();
            while (enumPanels.hasMoreElements()) {
                SaveAsAudioPanel panelAudio = (SaveAsAudioPanel)enumPanels.nextElement();
                panelAudio.updateTrack();
            }
            boolean boolResult = this.waitForState(this.processor, 300);
            if (!boolResult) {
                MessageDialog.createErrorDialogModeless(this.getFrame(), "Failed to realize Processor. " + this.strFailMessage);
                this.setCursor(Cursor.getDefaultCursor());
                this.dispose();
                return;
            }
            strFileContentType = "file:";
            DataSource dataSource = this.processor.getDataOutput();
            MediaLocator mediaDest = new MediaLocator(String.valueOf(strFileContentType) + strFileName);
            this.dataSink = Manager.createDataSink(dataSource, mediaDest);
            this.boolSaving = true;
            Control monitorControl = this.processor.getControl("javax.media.control.MonitorControl");
            if (monitorControl != null) {
                monitor = monitorControl.getControlComponent();
            }
            Object[] arrControls = this.dataSink.getControls();
            i2 = 0;
            while (i2 < arrControls.length) {
                if (arrControls[i2] instanceof FileWriterControl) {
                    FileWriterControl fileWriter = (FileWriterControl)arrControls[i2];
                    fileWriter.addFileWriterListener(this);
                    break;
                }
                ++i2;
            }
            this.dataSink.open();
            this.dataSink.start();
            this.processor.start();
            Time duration = this.processor.getDuration();
            int nMediaDuration = (int)duration.getSeconds();
            this.dlgProgress = nMediaDuration > 0 && duration != Duration.DURATION_UNBOUNDED && duration != Duration.DURATION_UNKNOWN ? new ProgressDialog(this.frameOwner, "Saving File ...", 0, nMediaDuration, (ActionListener)this) : new ProgressDialog(this.frameOwner, "Saving File ...", "Saving File, please wait ...", monitor, (ActionListener)this);
            ((Component)this.dlgProgress).setVisible(true);
            this.threadProgress = new ProgressThread(this.processor, this.dlgProgress);
            this.threadProgress.start();
        }
        catch (Exception exception) {
            this.boolSaving = false;
            MessageDialog.createErrorDialogModeless(this.getFrame(), exception.toString());
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.dispose();
    }

    public void actionPerformed(ActionEvent event) {
        Object objectSource;
        String strCmd = event.getActionCommand();
        if (strCmd.equals(this.buttonCancel.getLabel())) {
            this.stopSaving();
            this.dispose();
        } else if (strCmd.equals(this.buttonSave.getLabel())) {
            this.doSave();
        } else if ((strCmd.equals(" Abort ") || strCmd.equals(" Stop ")) && this.boolSaving) {
            this.stopSaving();
        } else if (strCmd.equals(" Pause ") && this.boolSaving) {
            this.processor.stop();
            this.dlgProgress.setPauseButtonText("Resume");
        } else if (strCmd.equals("Resume") && this.boolSaving) {
            this.processor.start();
            this.dlgProgress.setPauseButtonText(" Pause ");
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_ENABLED")) {
            Object objectSource2 = event.getSource();
            if (objectSource2 instanceof SaveAsAudioPanel) {
                this.tabControl.setPageImage((Panel)objectSource2, this.imageAudioEn);
            }
        } else if (strCmd.equals("ACTION_AUDIO_TRACK_DISABLED")) {
            Object objectSource3 = event.getSource();
            if (objectSource3 instanceof SaveAsAudioPanel) {
                this.tabControl.setPageImage((Panel)objectSource3, this.imageAudioDis);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_ENABLED")) {
            Object objectSource4 = event.getSource();
            if (objectSource4 instanceof SaveAsVideoPanel) {
                this.tabControl.setPageImage((Panel)objectSource4, this.imageVideoEn);
            }
        } else if (strCmd.equals("ACTION_VIDEO_TRACK_DISABLED") && (objectSource = event.getSource()) instanceof SaveAsVideoPanel) {
            this.tabControl.setPageImage((Panel)objectSource, this.imageVideoDis);
        }
    }

    public void itemStateChanged(ItemEvent event) {
        Object objectSource = event.getSource();
        if (objectSource == this.comboContentType) {
            this.changeContentType();
        }
    }

    public void windowOpened(WindowEvent event) {
    }

    public void windowClosing(WindowEvent event) {
        this.stopSaving();
        this.dispose();
    }

    public void windowClosed(WindowEvent event) {
    }

    public void windowIconified(WindowEvent event) {
    }

    public void windowDeiconified(WindowEvent event) {
    }

    public void windowActivated(WindowEvent event) {
    }

    public void windowDeactivated(WindowEvent event) {
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.strFailMessage = ((ControllerErrorEvent)event).getMessage();
            if (this.boolSaving) {
                this.stopSaving();
                MessageDialog.createErrorDialogModeless(this.getFrame(), "Failed to save file. Controller Error: " + this.strFailMessage);
            } else {
                MessageDialog.createErrorDialogModeless(this.getFrame(), "Controller Error: " + this.strFailMessage);
            }
        }
    }

    public void fileWriterUpdate(FileWriterEvent event) {
        if (event instanceof EndOfFileEvent) {
            this.stopSaving();
        } else if (event instanceof FileSizeLimitReachedEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialogModeless(this.getFrame(), "Reached file size limit.");
        } else if (event instanceof FileWritingErrorEvent) {
            this.stopSaving();
            MessageDialog.createErrorDialogModeless(this.getFrame(), "Error writing the file.");
        }
    }

    private void stopSaving() {
        this.boolSaving = false;
        if (this.threadProgress != null) {
            this.threadProgress.stop();
            this.threadProgress = null;
        }
        if (this.dlgProgress != null) {
            this.dlgProgress.dispose();
            this.dlgProgress = null;
        }
        if (this.processor != null) {
            this.processor.stop();
            this.processor.close();
        }
        if (this.dataSink != null) {
            this.dataSink.close();
        }
    }

    private synchronized boolean waitForState(Processor p2, int state) {
        p2.addControllerListener(new StateListener());
        this.stateFailed = false;
        if (state == 180) {
            p2.configure();
        } else if (state == 300) {
            p2.realize();
        }
        while (p2.getState() < state && !this.stateFailed) {
            Object object = this.stateLock;
            synchronized (object) {
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    boolean bl = false;
                    Object var5_5 = null;
                    return bl;
                }
            }
        }
        return !this.stateFailed;
    }

    private void changeContentType() {
        String strValue = this.comboContentType.getSelectedItem();
        if (strValue.equals(STR_MSVIDEO)) {
            this.strContentType = "video.x_msvideo";
            this.strContentTypeExt = "avi";
        } else if (strValue.equals(STR_QUICKTIME)) {
            this.strContentType = "video.quicktime";
            this.strContentTypeExt = "mov";
        } else if (strValue.equals(STR_AIFF)) {
            this.strContentType = "audio.x_aiff";
            this.strContentTypeExt = "aif";
        } else if (strValue.equals(STR_GSM)) {
            this.strContentType = "audio.x_gsm";
            this.strContentTypeExt = "gsm";
        } else if (strValue.equals(STR_WAVE)) {
            this.strContentType = "audio.x_wav";
            this.strContentTypeExt = "wav";
        } else if (strValue.equals(STR_BASIC_AUDIO)) {
            this.strContentType = "audio.basic";
            this.strContentTypeExt = "au";
        } else if (strValue.equals(STR_MPEG)) {
            this.strContentType = "audio.x_mpegaudio";
            this.strContentTypeExt = "mp3";
        } else {
            this.strContentType = strValue;
            this.strContentTypeExt = "movie";
        }
        if (this.processor.setContentDescriptor(new ContentDescriptor(this.strContentType)) == null) {
            System.err.println("Error setting content descriptor on processor");
        }
        Enumeration enumPanels = this.hashtablePanelsVideo.elements();
        while (enumPanels.hasMoreElements()) {
            SaveAsVideoPanel panelVideo = (SaveAsVideoPanel)enumPanels.nextElement();
            panelVideo.setContentType(this.strContentType);
        }
        enumPanels = this.hashtablePanelsAudio.elements();
        while (enumPanels.hasMoreElements()) {
            SaveAsAudioPanel panelAudio = (SaveAsAudioPanel)enumPanels.nextElement();
            panelAudio.setContentType(this.strContentType);
        }
    }

    class StateListener
    implements ControllerListener {
        public void controllerUpdate(ControllerEvent ce) {
            if (ce instanceof ControllerClosedEvent) {
                SaveAsDialog.this.stateFailed = true;
            }
            if (ce instanceof ControllerEvent) {
                Object object = SaveAsDialog.this.stateLock;
                synchronized (object) {
                    SaveAsDialog.this.stateLock.notifyAll();
                }
            }
        }

        StateListener() {
            SaveAsDialog.this = SaveAsDialog.this;
        }
    }
}

