/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.codec.audio.mpegenc;

import com.ibm.media.codec.audio.mpegenc.NativeEncoder;
import com.sun.media.controls.VFlowLayout;
import java.awt.BorderLayout;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.media.Owned;
import javax.media.control.BitRateControl;
import javax.media.control.MpegAudioControl;

public class MpegAudioControlAdapter
implements MpegAudioControl,
BitRateControl,
Owned {
    Component component;
    NativeEncoder owner;
    int layer;
    int bitrate;
    int error_protection;
    int nChannels;
    int joint_stereo;
    int original;
    int copyright;
    int layout;
    int samplingFrequency;
    int[] availableRates;
    public static final int LAYER_1 = 1;
    public static final int LAYER_2 = 2;
    public static final int LAYER_3 = 4;
    public static final int SAMPLING_RATE_16 = 1;
    public static final int SAMPLING_RATE_22_05 = 2;
    public static final int SAMPLING_RATE_24 = 4;
    public static final int SAMPLING_RATE_32 = 8;
    public static final int SAMPLING_RATE_44_1 = 16;
    public static final int SAMPLING_RATE_48 = 32;
    public static final int SINGLE_CHANNEL = 1;
    public static final int TWO_CHANNELS_STEREO = 2;
    public static final int TWO_CHANNELS_DUAL = 4;
    public static final int THREE_CHANNELS_2_1 = 4;
    public static final int THREE_CHANNELS_3_0 = 8;
    public static final int FOUR_CHANNELS_2_0_2_0 = 16;
    public static final int FOUR_CHANNELS_2_2 = 32;
    public static final int FOUR_CHANNELS_3_1 = 64;
    public static final int FIVE_CHANNELS_3_0_2_0 = 128;
    public static final int FIVE_CHANNELS_3_2 = 256;
    String SAMPLING_FREQUENCY_STRING = " Sampling Frequency ";
    String ERROR_PROTECTION_STRING = " Error Protection ";
    String ORIGINAL_STRING = " Original ";
    String COPYRIGHT_STRING = " Copyright ";
    String LAYER_STRING = " Layer ";
    String LAYER_1_STRING = " Layer 1 ";
    String LAYER_2_STRING = " Layer 2 ";
    String MODE_STRING = " Mode ";
    String MONO_STRING = " Mono ";
    String STEREO_STRING = " Stereo ";
    String JOINT_STEREO_STRING = " Joint Stereo ";
    String BITRATE_STRING = " Bitrate ";
    Choice ratesComp;

    public int getSupportedAudioLayers() {
        return 3;
    }

    public int getSupportedSamplingRates() {
        return 56;
    }

    public int getSupportedChannelLayouts() {
        return 3;
    }

    public boolean isLowFrequencyChannelSupported() {
        return false;
    }

    public boolean isMultilingualModeSupported() {
        return false;
    }

    public int setAudioLayer(int audioLayer) {
        return this.layer;
    }

    public int getAudioLayer() {
        return this.layer;
    }

    public int setChannelLayout(int channelLayout) {
        return this.layout;
    }

    public int getChannelLayout() {
        return this.layout;
    }

    public boolean setLowFrequencyChannel(boolean on) {
        return false;
    }

    public boolean getLowFrequencyChannel() {
        return false;
    }

    public boolean setMultilingualMode(boolean on) {
        return false;
    }

    public boolean getMultilingualMode() {
        return false;
    }

    public Object getOwner() {
        return this.owner;
    }

    public int getBitRate() {
        return this.bitrate;
    }

    public int setBitRate(int bitrate) {
        return bitrate;
    }

    public int getMinSupportedBitRate() {
        return 32000;
    }

    public int getMaxSupportedBitRate() {
        return 448000;
    }

    public Component getControlComponent() {
        if (this.component == null) {
            Panel componentPanel = new Panel();
            componentPanel.setLayout(new VFlowLayout(0));
            Panel freqPanel = new Panel();
            freqPanel.setLayout(new BorderLayout());
            freqPanel.add("West", new Label(this.SAMPLING_FREQUENCY_STRING, 1));
            freqPanel.add("East", new Label(String.valueOf(this.samplingFrequency), 1));
            componentPanel.add(freqPanel);
            Panel errPanel = new Panel();
            errPanel.setLayout(new BorderLayout());
            errPanel.add("West", new Label(this.ERROR_PROTECTION_STRING, 1));
            Checkbox err_cb = new Checkbox(null, null, this.error_protection != 0);
            err_cb.addItemListener(new 1());
            errPanel.add("East", err_cb);
            Panel orgPanel = new Panel();
            orgPanel.setLayout(new BorderLayout());
            orgPanel.add("West", new Label(this.ORIGINAL_STRING, 1));
            Checkbox org_cb = new Checkbox(null, null, this.original != 0);
            org_cb.addItemListener(new 2());
            orgPanel.add("East", org_cb);
            Panel cpyPanel = new Panel();
            cpyPanel.setLayout(new BorderLayout());
            cpyPanel.add("West", new Label(this.COPYRIGHT_STRING, 1));
            Checkbox cpy_cb = new Checkbox(null, null, this.copyright != 0);
            cpy_cb.addItemListener(new 3());
            cpyPanel.add("East", cpy_cb);
            Panel layerPanel = new Panel();
            layerPanel.setLayout(new BorderLayout());
            layerPanel.add("West", new Label(this.LAYER_STRING, 1));
            Choice layer_choice = new Choice();
            layer_choice.add(this.LAYER_1_STRING);
            layer_choice.add(this.LAYER_2_STRING);
            layer_choice.select(this.LAYER_2_STRING);
            layer_choice.addItemListener(new 4());
            layerPanel.add("East", layer_choice);
            Panel cnlPanel = new Panel();
            cnlPanel.setLayout(new BorderLayout());
            cnlPanel.add("West", new Label(this.MODE_STRING, 1));
            Choice mode_choice = new Choice();
            if (this.nChannels == 1) {
                mode_choice.add(this.MONO_STRING);
            } else {
                mode_choice.add(this.STEREO_STRING);
                mode_choice.add(this.JOINT_STEREO_STRING);
                mode_choice.select(this.joint_stereo != 0 ? this.JOINT_STEREO_STRING : this.STEREO_STRING);
                mode_choice.addItemListener(new 5());
            }
            cnlPanel.add("East", mode_choice);
            Panel ratePanel = new Panel();
            ratePanel.setLayout(new BorderLayout());
            ratePanel.add("West", new Label(this.BITRATE_STRING, 1));
            this.ratesComp = new Choice();
            this.setAvailableRates();
            this.ratesComp.addItemListener(new 6());
            ratePanel.add("East", this.ratesComp);
            componentPanel.add(ratePanel);
            componentPanel.add(layerPanel);
            componentPanel.add(cnlPanel);
            componentPanel.add(errPanel);
            componentPanel.add(orgPanel);
            componentPanel.add(cpyPanel);
            this.component = componentPanel;
        }
        return this.component;
    }

    void setAvailableRates() {
        this.availableRates = this.layer == 1 ? (this.nChannels == 1 ? NativeEncoder.layer1BitRate_mono : NativeEncoder.layer1BitRate_stereo) : (this.nChannels == 1 ? NativeEncoder.layer2BitRate_mono : NativeEncoder.layer2BitRate_stereo);
        if (this.ratesComp != null) {
            this.bitrate = 128 * this.nChannels;
            this.owner.setBitrate(this.bitrate);
            this.ratesComp.removeAll();
            int i2 = 0;
            while (i2 < this.availableRates.length) {
                this.ratesComp.add(String.valueOf(this.availableRates[i2]) + " Kbits/sec ");
                ++i2;
            }
            this.ratesComp.select(String.valueOf(this.bitrate) + " Kbits/sec ");
        }
    }

    public MpegAudioControlAdapter(NativeEncoder new_Owner, int new_Layer, int new_samplingFrequency, int new_nChannels, int new_bitrate, int new_copyright, int new_original, int new_error_protect, int new_joint_stereo) {
        this.owner = new_Owner;
        this.layer = new_Layer;
        this.samplingFrequency = new_samplingFrequency;
        this.nChannels = new_nChannels;
        this.bitrate = new_bitrate;
        this.copyright = new_copyright;
        this.original = new_original;
        this.error_protection = new_error_protect;
        this.joint_stereo = new_joint_stereo;
    }

    private final class 1
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            int new_error_protection = e2.getStateChange();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.error_protection = new_error_protection == 1 ? 1 : 0;
                MpegAudioControlAdapter.this.owner.setErrorProtect(MpegAudioControlAdapter.this.error_protection);
            } else {
                Checkbox in_cb = (Checkbox)e2.getItemSelectable();
                in_cb.setState(MpegAudioControlAdapter.this.error_protection != 0);
            }
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            int new_original = e2.getStateChange();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.original = new_original == 1 ? 1 : 0;
                MpegAudioControlAdapter.this.owner.setOriginal(MpegAudioControlAdapter.this.original);
            } else {
                Checkbox in_cb = (Checkbox)e2.getItemSelectable();
                in_cb.setState(MpegAudioControlAdapter.this.original != 0);
            }
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            int new_copyright = e2.getStateChange();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.copyright = new_copyright == 1 ? 1 : 0;
                MpegAudioControlAdapter.this.owner.setOriginal(MpegAudioControlAdapter.this.copyright);
            } else {
                Checkbox in_cb = (Checkbox)e2.getItemSelectable();
                in_cb.setState(MpegAudioControlAdapter.this.copyright != 0);
            }
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            String s = (String)e2.getItem();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.layer = s.equals(MpegAudioControlAdapter.this.LAYER_1_STRING) ? 1 : 2;
                MpegAudioControlAdapter.this.setAvailableRates();
                MpegAudioControlAdapter.this.owner.setLayer(MpegAudioControlAdapter.this.layer);
            } else {
                Choice in_choice = (Choice)e2.getItemSelectable();
                in_choice.select(MpegAudioControlAdapter.this.layer == 1 ? MpegAudioControlAdapter.this.LAYER_1_STRING : MpegAudioControlAdapter.this.LAYER_2_STRING);
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            String s = (String)e2.getItem();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.joint_stereo = s.equals(MpegAudioControlAdapter.this.STEREO_STRING) ? 0 : 1;
                int mode = MpegAudioControlAdapter.this.joint_stereo == 0 ? 0 : 1;
                MpegAudioControlAdapter.this.owner.SetEncodingType(mode);
            } else {
                Choice in_choice = (Choice)e2.getItemSelectable();
                in_choice.select(MpegAudioControlAdapter.this.joint_stereo != 0 ? MpegAudioControlAdapter.this.JOINT_STEREO_STRING : MpegAudioControlAdapter.this.STEREO_STRING);
            }
        }

        /* synthetic */ 5() {
        }
    }

    private final class 6
    implements ItemListener {
        public void itemStateChanged(ItemEvent e2) {
            String s = (String)e2.getItem();
            if (!MpegAudioControlAdapter.this.owner.isStarted) {
                MpegAudioControlAdapter.this.bitrate = Integer.parseInt(s.substring(0, 3).trim());
                MpegAudioControlAdapter.this.owner.setBitrate(MpegAudioControlAdapter.this.bitrate);
            } else {
                Choice in_choice = (Choice)e2.getItemSelectable();
                in_choice.select(String.valueOf(MpegAudioControlAdapter.this.bitrate) + " Kbits/sec ");
            }
        }

        /* synthetic */ 6() {
        }
    }
}

