/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.sun.media.BasicConnector;
import com.sun.media.CircularBuffer;
import com.sun.media.InputConnector;
import com.sun.media.OutputConnector;
import javax.media.Buffer;

public class BasicInputConnector
extends BasicConnector
implements InputConnector {
    protected OutputConnector outputConnector;
    private boolean reset = false;

    public OutputConnector getOutputConnector() {
        return this.outputConnector;
    }

    public void reset() {
        CircularBuffer circularBuffer = this.circularBuffer;
        synchronized (circularBuffer) {
            this.reset = true;
            super.reset();
            this.circularBuffer.notifyAll();
        }
    }

    public boolean isValidBufferAvailable() {
        return this.circularBuffer.canRead();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Buffer getValidBuffer() {
        switch (this.protocol) {
            case 0: 
            case 1: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (!this.isValidBufferAvailable() && this.reset) {
                        return null;
                    }
                    this.reset = false;
                    return this.circularBuffer.read();
                }
            }
            case 2: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.isValidBufferAvailable()) {
                        if (!this.reset) return this.circularBuffer.read();
                        return null;
                    }
                    this.reset = false;
                }
                this.getOutputConnector().getModule().connectorPulled(this.getOutputConnector());
                return this.circularBuffer.read();
            }
            case 3: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    this.reset = false;
                    while (!this.reset && !this.isValidBufferAvailable()) {
                        try {
                            this.circularBuffer.wait();
                        }
                        catch (Exception exception) {}
                    }
                    if (this.reset) {
                        return null;
                    }
                    Buffer buffer = this.circularBuffer.read();
                    this.circularBuffer.notifyAll();
                    return buffer;
                }
            }
        }
        throw new RuntimeException();
    }

    public void setOutputConnector(OutputConnector outputConnector) {
        this.outputConnector = outputConnector;
    }

    public void readReport() {
        switch (this.protocol) {
            case 0: 
            case 1: 
            case 2: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        Object var2_3 = null;
                        return;
                    }
                    this.circularBuffer.readReport();
                    Object var2_4 = null;
                    return;
                }
            }
            case 3: {
                CircularBuffer circularBuffer = this.circularBuffer;
                synchronized (circularBuffer) {
                    if (this.reset) {
                        Object var2_5 = null;
                        return;
                    }
                    this.circularBuffer.readReport();
                    this.circularBuffer.notifyAll();
                    Object var2_6 = null;
                    return;
                }
            }
        }
        throw new RuntimeException();
    }
}

