/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicController;
import com.sun.media.CreateWorkThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.PlayThread;
import com.sun.media.SeekFailedEvent;
import com.sun.media.StatsThread;
import com.sun.media.controls.ActionControl;
import com.sun.media.controls.AtomicControlAdapter;
import com.sun.media.controls.BooleanControl;
import com.sun.media.controls.BooleanControlAdapter;
import com.sun.media.controls.NumericControl;
import com.sun.media.controls.NumericControlAdapter;
import com.sun.media.controls.PlaybackControl;
import com.sun.media.controls.SliderRegionControl;
import com.sun.media.controls.SliderRegionControlAdapter;
import com.sun.media.controls.StringControl;
import com.sun.media.controls.StringControlAdapter;
import com.sun.media.ui.DefaultControlPanel2;
import com.sun.media.util.JMFI18N;
import com.sun.media.util.jdk12;
import java.awt.Component;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.AudioDeviceUnavailableEvent;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Clock;
import javax.media.ClockStartedError;
import javax.media.Control;
import javax.media.Controller;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DownloadProgressListener;
import javax.media.Duration;
import javax.media.DurationUpdateEvent;
import javax.media.EndOfMediaEvent;
import javax.media.ExtendedCachingControl;
import javax.media.GainControl;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.MediaLocator;
import javax.media.NotPrefetchedError;
import javax.media.NotRealizedError;
import javax.media.Player;
import javax.media.Processor;
import javax.media.ResourceUnavailableEvent;
import javax.media.RestartingEvent;
import javax.media.SizeChangeEvent;
import javax.media.StartEvent;
import javax.media.StopAtTimeEvent;
import javax.media.StopByRequestEvent;
import javax.media.Time;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;

public abstract class BasicPlayer
extends BasicController
implements Player,
ControllerListener,
DownloadProgressListener {
    public static String VERSION = JMFI18N.getResource("mediaplayer.version");
    protected DataSource source;
    private Time duration = Duration.DURATION_UNKNOWN;
    private Vector controllerList = new Vector();
    private Vector optionalControllerList = new Vector();
    private Vector removedControllerList = new Vector();
    private Vector currentControllerList = new Vector();
    private Vector potentialEventsList;
    private Vector receivedEventList = new Vector();
    private boolean receivedAllEvents = false;
    private Vector configureEventList = new Vector();
    private Vector realizeEventList = new Vector();
    private Vector prefetchEventList = new Vector();
    private Vector stopEventList = new Vector();
    private ControllerEvent CachingControlEvent;
    private Controller restartFrom;
    private Vector eomEventsReceivedFrom = new Vector();
    private PlayThread playThread;
    private StatsThread statsThread;
    private Time startTime;
    private Time mediaTimeAtStart;
    private boolean aboutToRestart = false;
    protected boolean framePositioning = true;
    protected PlayBCA playControl;
    protected StopBCA stopControl;
    protected NumericControl seekControl;
    protected RateNCA rateControl;
    protected StringControl urlControl;
    protected PlaybackControl playbackControl;
    protected Control[] controls;
    protected Component controlComp;
    public SliderRegionControl regionControl;
    protected StringControl frameRate;
    protected StringControl bitRate;
    protected StringControl videoProps;
    protected StringControl audioProps;
    protected StringControl videoCodec;
    protected StringControl audioCodec;
    private CachingControl cachingControl;
    private ExtendedCachingControl extendedCachingControl;
    protected StringControl urlName;
    private Object mediaTimeSync = new Object();
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    long lastTime;
    static /* synthetic */ Class class$com$sun$media$PlayThread;
    static /* synthetic */ Class class$com$sun$media$BasicPlayer;
    static /* synthetic */ Class class$com$sun$media$StatsThread;

    public BasicPlayer() {
        this.configureEventList.addElement("javax.media.ConfigureCompleteEvent");
        this.configureEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.realizeEventList.addElement("javax.media.RealizeCompleteEvent");
        this.realizeEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.prefetchEventList.addElement("javax.media.PrefetchCompleteEvent");
        this.prefetchEventList.addElement("javax.media.ResourceUnavailableEvent");
        this.stopEventList.addElement("javax.media.StopEvent");
        this.stopEventList.addElement("javax.media.StopByRequestEvent");
        this.stopEventList.addElement("javax.media.StopAtTimeEvent");
    }

    public boolean isFramePositionable() {
        return this.framePositioning;
    }

    protected boolean isConfigurable() {
        return false;
    }

    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        this.source = source;
        if (this.urlName == null) {
            this.urlName = new StringControlAdapter();
            MediaLocator ml = source.getLocator();
            if (ml != null) {
                this.urlName.setValue("URL=" + ml.toString());
                this.urlControl = this.urlName;
            }
        }
        try {
            this.cachingControl = (CachingControl)source.getControl("javax.media.CachingControl");
            if (this.cachingControl != null && this.cachingControl instanceof ExtendedCachingControl) {
                this.extendedCachingControl = (ExtendedCachingControl)this.cachingControl;
                if (this.extendedCachingControl != null) {
                    this.regionControl = new SliderRegionControlAdapter();
                    this.extendedCachingControl.addDownloadProgressListener(this, 100);
                }
            }
        }
        catch (ClassCastException classCastException) {}
    }

    public void downloadUpdate() {
        int maxValuePercent;
        if (this.extendedCachingControl == null) {
            return;
        }
        this.sendEvent(new CachingControlEvent(this, this.cachingControl, this.cachingControl.getContentProgress()));
        if (this.regionControl == null) {
            return;
        }
        long contentLength = this.cachingControl.getContentLength();
        if (contentLength == -1L || contentLength <= 0L) {
            maxValuePercent = 0;
        } else {
            long endOffset = this.extendedCachingControl.getEndOffset();
            maxValuePercent = (int)(100.0 * (double)endOffset / (double)contentLength);
            if (maxValuePercent < 0) {
                maxValuePercent = 0;
            } else if (maxValuePercent > 100) {
                maxValuePercent = 100;
            }
        }
        this.regionControl.setMinValue(0L);
        this.regionControl.setMaxValue(maxValuePercent);
    }

    public MediaLocator getMediaLocator() {
        if (this.source != null) {
            return this.source.getLocator();
        }
        return null;
    }

    public String getContentType() {
        if (this.source != null) {
            return this.source.getContentType();
        }
        return null;
    }

    protected DataSource getSource() {
        return this.source;
    }

    protected void doClose() {
        this.stop();
        if (this.controllerList != null) {
            while (!this.controllerList.isEmpty()) {
                Controller c2 = (Controller)this.controllerList.firstElement();
                c2.close();
                this.controllerList.removeElement(c2);
            }
        }
        if (this.controlComp != null) {
            ((DefaultControlPanel2)this.controlComp).dispose();
        }
        this.controlComp = null;
        if (this.statsThread != null) {
            this.statsThread.kill();
        }
        this.sendEvent(new ControllerClosedEvent(this));
    }

    public void setTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        if (tb == null) {
            tb = this.getMasterTimeBase();
        }
        super.setTimeBase(tb);
        if (this.controllerList == null) {
            return;
        }
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            ((Controller)this.controllerList.elementAt(i2)).setTimeBase(tb);
        }
    }

    protected void setMediaLength(long t) {
        this.duration = new Time(t);
        super.setMediaLength(t);
    }

    public Time getDuration() {
        long t = this.getMediaNanoseconds();
        if (t > this.lastTime) {
            this.lastTime = t;
            this.updateDuration();
        }
        return this.duration;
    }

    protected synchronized void updateDuration() {
        Time oldDuration = this.duration;
        this.duration = Duration.DURATION_UNKNOWN;
        int i2 = 0;
        while (i2 < this.controllerList.size()) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            Time dur = c2.getDuration();
            if (dur.equals(Duration.DURATION_UNKNOWN)) {
                if (!(c2 instanceof BasicController)) {
                    this.duration = Duration.DURATION_UNKNOWN;
                    break;
                }
            } else {
                if (dur.equals(Duration.DURATION_UNBOUNDED)) {
                    this.duration = Duration.DURATION_UNBOUNDED;
                    break;
                }
                if (this.duration.equals(Duration.DURATION_UNKNOWN)) {
                    this.duration = dur;
                } else if (this.duration.getNanoseconds() < dur.getNanoseconds()) {
                    this.duration = dur;
                }
            }
            ++i2;
        }
        if (this.duration.getNanoseconds() != oldDuration.getNanoseconds()) {
            this.setMediaLength(this.duration.getNanoseconds());
            this.sendEvent(new DurationUpdateEvent(this, this.duration));
        }
    }

    public void setStopTime(Time t) {
        if (this.state < 300) {
            throw new NotRealizedError("Cannot set stop time on an unrealized controller.");
        }
        Vector list = this.controllerList;
        int i2 = list.size();
        while (--i2 >= 0) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            c2.setStopTime(t);
        }
        super.setStopTime(t);
    }

    public final void setMediaTime(Time now) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            if (this.getState() == 600) {
                this.aboutToRestart = true;
                this.stop();
            }
            super.setMediaTime(now);
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                ((Controller)this.controllerList.elementAt(i2)).setMediaTime(now);
            }
            this.doSetMediaTime(now);
            if (this.aboutToRestart) {
                this.syncStart(this.getTimeBase().getTime());
                this.aboutToRestart = false;
            }
        }
    }

    public boolean isAboutToRestart() {
        return this.aboutToRestart;
    }

    protected void doSetMediaTime(Time now) {
        if (this.seekControl instanceof SeekNCA) {
            ((SeekNCA)this.seekControl).progSetValue(now.getNanoseconds());
        }
    }

    public Component getVisualComponent() {
        int state = this.getState();
        if (state < 300) {
            throw new NotRealizedError("Cannot get visual component on an unrealized player");
        }
        return null;
    }

    public Component getControlPanelComponent() {
        int state = this.getState();
        if (state < 300) {
            throw new NotRealizedError("Cannot get control panel component on an unrealized player");
        }
        if (this.controlComp == null) {
            this.controlComp = new DefaultControlPanel2(this);
        }
        return this.controlComp;
    }

    public GainControl getGainControl() {
        int state = this.getState();
        if (state < 300) {
            throw new NotRealizedError("Cannot get gain control on an unrealized player");
        }
        return (GainControl)this.getControl("javax.media.GainControl");
    }

    protected NumericControlAdapter getSeekNCA() {
        return new SeekNCA();
    }

    public Control[] getControls() {
        if (this.controls != null) {
            return this.controls;
        }
        Vector<Control> cv = new Vector<Control>();
        int size = this.controllerList.size();
        int i2 = 0;
        while (i2 < size) {
            Controller ctrller = (Controller)this.controllerList.elementAt(i2);
            Control[] cs = ctrller.getControls();
            if (cs != null) {
                int j2 = 0;
                while (j2 < cs.length) {
                    cv.addElement(cs[j2]);
                    ++j2;
                }
            }
            ++i2;
        }
        if (this.cachingControl != null) {
            cv.addElement(this.cachingControl);
        }
        size = cv.size();
        Control[] ctrls = new Control[size];
        i2 = 0;
        while (i2 < size) {
            ctrls[i2] = (Control)cv.elementAt(i2);
            ++i2;
        }
        if (this.getState() >= 300) {
            this.controls = ctrls;
        }
        return ctrls;
    }

    public final void controllerUpdate(ControllerEvent evt) {
        this.processEvent(evt);
    }

    public final Vector getControllerList() {
        return this.controllerList;
    }

    private Vector getPotentialEventsList() {
        return this.potentialEventsList;
    }

    private void resetReceivedEventList() {
        if (this.receivedEventList != null) {
            this.receivedEventList.removeAllElements();
        }
    }

    private Vector getReceivedEventsList() {
        return this.receivedEventList;
    }

    private void updateReceivedEventsList(ControllerEvent event) {
        if (this.receivedEventList != null) {
            Controller source = event.getSourceController();
            if (this.receivedEventList.contains(source)) {
                return;
            }
            this.receivedEventList.addElement(source);
        }
    }

    public final void start() {
        if (this.restartFrom != null) {
            return;
        }
        if (this.getState() == 600) {
            this.sendEvent(new StartEvent(this, 600, 600, 600, this.mediaTimeAtStart, this.startTime));
            return;
        }
        if (this.playThread == null || !this.playThread.isAlive()) {
            this.setTargetState(600);
            if (jmfSecurity != null) {
                String permission = null;
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        permission = "thread";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                        permission = "thread group";
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                    }
                }
                catch (Throwable e2) {
                    securityPrivelege = false;
                }
            }
            if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
                try {
                    Constructor cons = CreateWorkThreadAction.cons;
                    this.playThread = (PlayThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$PlayThread != null ? class$com$sun$media$PlayThread : (class$com$sun$media$PlayThread = BasicController.class$("com.sun.media.PlayThread")), class$com$sun$media$BasicPlayer != null ? class$com$sun$media$BasicPlayer : (class$com$sun$media$BasicPlayer = BasicController.class$("com.sun.media.BasicPlayer")), this));
                    this.playThread.start();
                }
                catch (Exception exception) {}
            } else {
                this.playThread = new PlayThread(this);
                this.playThread.start();
            }
        }
    }

    public final void syncStart(Time tbt) {
        Object object = this.mediaTimeSync;
        synchronized (object) {
            int state = this.getState();
            if (state == 600) {
                throw new ClockStartedError("syncStart() cannot be used on an already started player");
            }
            if (state != 500) {
                throw new NotPrefetchedError("Cannot start player before it has been prefetched");
            }
            this.setTargetState(600);
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                if (this.getTargetState() != 600) continue;
                ((Controller)this.controllerList.elementAt(i2)).syncStart(tbt);
            }
            if (this.getTargetState() == 600) {
                this.startTime = tbt;
                this.mediaTimeAtStart = this.getMediaTime();
                super.syncStart(tbt);
            }
        }
    }

    protected void doStart() {
        if (this.playControl != null) {
            this.playControl.progSetValue(true);
        }
    }

    final synchronized void play() {
        if (this.getTargetState() != 600) {
            return;
        }
        int state = this.getState();
        if (state == 100 || state == 180 || state == 300) {
            this.prefetch();
        }
        while (this.getState() == 140 || this.getState() == 200 || this.getState() == 300 || this.getState() == 400) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.getTargetState() == 600 && this.getState() == 500) {
            this.syncStart(this.getTimeBase().getTime());
        }
    }

    protected void doStop() {
        if (this.stopControl != null) {
            this.stopControl.progSetValue(true);
        }
    }

    public final void stop() {
        this.stop("StopByRequest");
    }

    protected void stopAtTime() {
        this.stop("StopAtTime");
        super.setStopTime(Clock.RESET);
    }

    private void stop(String request) {
        int state = this.getState();
        switch (state) {
            case 100: 
            case 300: 
            case 500: {
                this.setTargetState(state);
                break;
            }
            case 200: {
                this.setTargetState(300);
                break;
            }
            case 400: 
            case 600: {
                this.setTargetState(500);
                break;
            }
        }
        if (this.getState() != 600 && request.equals("StopByRequest")) {
            this.sendEvent(new StopByRequestEvent(this, this.getState(), this.getState(), this.getTargetState(), this.getMediaTime()));
        }
        if (this.getState() == 600) {
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.potentialEventsList = this.stopEventList;
                this.resetReceivedEventList();
                this.receivedAllEvents = false;
                this.currentControllerList.removeAllElements();
                int i2 = this.controllerList.size();
                while (--i2 >= 0) {
                    Controller c2 = (Controller)this.controllerList.elementAt(i2);
                    this.currentControllerList.addElement(c2);
                    c2.stop();
                }
                if (this.currentControllerList == null) {
                    Object var4_6 = null;
                    return;
                }
                if (!this.currentControllerList.isEmpty()) {
                    try {
                        while (!this.receivedAllEvents) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    this.currentControllerList.removeAllElements();
                }
                this.eomEventsReceivedFrom.removeAllElements();
                super.stop();
                if (request.equals("StopByRequest")) {
                    this.sendEvent(new StopByRequestEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                } else if (request.equals("StopAtTime")) {
                    this.sendEvent(new StopAtTimeEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                }
            }
        }
    }

    protected final void processEndOfMedia() {
        super.stop();
        this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
        if (this.stopControl != null) {
            this.stopControl.progSetValue(true);
        }
    }

    protected final void manageController(Controller controller) {
        this.manageController(controller, false);
    }

    protected final void manageController(Controller controller, boolean optional) {
        if (controller != null && !this.controllerList.contains(controller)) {
            this.controllerList.addElement(controller);
            if (optional) {
                this.optionalControllerList.addElement(controller);
            }
            controller.addControllerListener(this);
        }
        this.updateDuration();
    }

    protected final void unmanageController(Controller controller) {
        if (controller != null && this.controllerList.contains(controller)) {
            this.controllerList.removeElement(controller);
            controller.removeControllerListener(this);
        }
    }

    public final synchronized void addController(Controller newController) throws IncompatibleTimeBaseException {
        int playerState = this.getState();
        if (playerState == 600) {
            throw new ClockStartedError("Cannot add controller to a started player");
        }
        if (playerState == 100 || playerState == 200) {
            throw new NotRealizedError("A Controller cannot be added to an Unrealized Player");
        }
        if (newController == null) {
            return;
        }
        int controllerState = newController.getState();
        if (controllerState == 100 || controllerState == 200) {
            throw new NotRealizedError("An Unrealized Controller cannot be added to a Player");
        }
        if (this.controllerList.contains(newController)) {
            return;
        }
        if (playerState == 500 && (controllerState == 300 || controllerState == 400)) {
            this.deallocate();
        }
        this.manageController(newController);
        newController.setTimeBase(this.getTimeBase());
    }

    public final synchronized void removeController(Controller oldController) {
        block5: {
            int state = this.getState();
            if (state == 100 || state == 200) {
                throw new NotRealizedError("Cannot remove controller from a unrealized player");
            }
            if (state == 600) {
                throw new ClockStartedError("Cannot remove controller from a started player");
            }
            if (oldController == null) {
                return;
            }
            if (!this.controllerList.contains(oldController)) break block5;
            this.controllerList.removeElement(oldController);
            oldController.removeControllerListener(this);
            this.updateDuration();
            try {
                oldController.setTimeBase(null);
            }
            catch (IncompatibleTimeBaseException incompatibleTimeBaseException) {}
        }
    }

    protected abstract boolean audioEnabled();

    protected abstract boolean videoEnabled();

    protected abstract TimeBase getMasterTimeBase();

    protected synchronized boolean doConfigure() {
        Controller c2;
        this.potentialEventsList = this.configureEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() != 100 || !(c2 instanceof Processor) && !(c2 instanceof BasicController)) continue;
            this.currentControllerList.addElement(c2);
        }
        i2 = this.currentControllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.currentControllerList.elementAt(i2);
            if (c2 instanceof Processor) {
                ((Processor)c2).configure();
                continue;
            }
            if (!(c2 instanceof BasicController)) continue;
            ((BasicController)c2).configure();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.currentControllerList.removeAllElements();
        }
        i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (!(c2 instanceof Processor) && !(c2 instanceof BasicController) || c2.getState() >= 180) continue;
            System.err.println("Error: Unable to configure " + c2);
            this.source.disconnect();
            return false;
        }
        return true;
    }

    protected void completeConfigure() {
        super.completeConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedConfigure() {
        super.doFailedConfigure();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected synchronized boolean doRealize() {
        Controller c2;
        this.potentialEventsList = this.realizeEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() != 100 && c2.getState() != 180) continue;
            this.currentControllerList.addElement(c2);
        }
        i2 = this.currentControllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.currentControllerList.elementAt(i2);
            c2.realize();
        }
        if (!this.currentControllerList.isEmpty()) {
            try {
                while (!this.receivedAllEvents) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {}
            this.currentControllerList.removeAllElements();
        }
        i2 = this.controllerList.size();
        while (--i2 >= 0) {
            c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.getState() >= 300) continue;
            System.err.println("Error: Unable to realize " + c2);
            this.source.disconnect();
            return false;
        }
        this.playbackControl = new PBC();
        this.updateDuration();
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateWorkThreadAction.cons;
                this.statsThread = (StatsThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$StatsThread != null ? class$com$sun$media$StatsThread : (class$com$sun$media$StatsThread = BasicController.class$("com.sun.media.StatsThread")), class$com$sun$media$BasicPlayer != null ? class$com$sun$media$BasicPlayer : (class$com$sun$media$BasicPlayer = BasicController.class$("com.sun.media.BasicPlayer")), this));
                this.statsThread.start();
            }
            catch (Exception exception) {}
        } else {
            this.statsThread = new StatsThread(this);
            this.statsThread.start();
        }
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        try {
            this.slaveToMasterTimeBase(this.getMasterTimeBase());
        }
        catch (IncompatibleTimeBaseException e2) {
            System.out.println(e2);
        }
        super.completeRealize();
        BasicPlayer e2 = this;
        synchronized (e2) {
            this.notify();
        }
    }

    protected void doFailedRealize() {
        super.doFailedRealize();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void completePrefetch() {
        super.completePrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected void doFailedPrefetch() {
        super.doFailedPrefetch();
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected final void abortRealize() {
        if (this.controllerList != null) {
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                Controller c2 = (Controller)this.controllerList.elementAt(i2);
                c2.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected boolean doPrefetch() {
        Controller c2;
        this.potentialEventsList = this.prefetchEventList;
        this.resetReceivedEventList();
        this.receivedAllEvents = false;
        this.currentControllerList.removeAllElements();
        Vector list = this.controllerList;
        if (list == null) {
            return false;
        }
        int i2 = list.size();
        while (--i2 >= 0) {
            c2 = (Controller)list.elementAt(i2);
            if (c2.getState() != 300) continue;
            this.currentControllerList.addElement(c2);
            c2.prefetch();
        }
        if (!this.currentControllerList.isEmpty()) {
            c2 = this;
            synchronized (c2) {
                try {
                    while (!this.receivedAllEvents) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {}
                this.currentControllerList.removeAllElements();
            }
        }
        i2 = list.size();
        while (--i2 >= 0) {
            c2 = (Controller)list.elementAt(i2);
            if (c2.getState() >= 500) continue;
            System.err.println("Error: Unable to prefetch " + c2);
            if (this.optionalControllerList.contains(c2)) {
                this.removedControllerList.addElement(c2);
                continue;
            }
            return false;
        }
        if (this.removedControllerList != null) {
            i2 = this.removedControllerList.size();
            while (--i2 >= 0) {
                Object o2 = this.removedControllerList.elementAt(i2);
                this.controllerList.removeElement(o2);
                ((BasicController)o2).close();
                if (this.deviceBusy((BasicController)o2)) continue;
                return false;
            }
            this.removedControllerList.removeAllElements();
        }
        return true;
    }

    protected final void abortPrefetch() {
        if (this.controllerList != null) {
            int i2 = this.controllerList.size();
            while (--i2 >= 0) {
                Controller c2 = (Controller)this.controllerList.elementAt(i2);
                c2.deallocate();
            }
        }
        BasicPlayer basicPlayer = this;
        synchronized (basicPlayer) {
            this.notify();
        }
    }

    protected boolean deviceBusy(BasicController mc) {
        return true;
    }

    protected void slaveToMasterTimeBase(TimeBase tb) throws IncompatibleTimeBaseException {
        this.setTimeBase(tb);
    }

    private void notifyIfAllEventsArrived(Vector controllerList, Vector receivedEventList) {
        if (receivedEventList != null && receivedEventList.size() == this.currentControllerList.size()) {
            this.receivedAllEvents = true;
            this.resetReceivedEventList();
            BasicPlayer basicPlayer = this;
            synchronized (basicPlayer) {
                this.notifyAll();
            }
        }
    }

    protected void processEvent(ControllerEvent evt) {
        Controller c2;
        int i2;
        Controller source = evt.getSourceController();
        if (evt instanceof AudioDeviceUnavailableEvent) {
            this.sendEvent(new AudioDeviceUnavailableEvent(this));
            return;
        }
        if (evt instanceof ControllerErrorEvent && this.controllerList.contains(source) && !(evt instanceof ResourceUnavailableEvent)) {
            i2 = this.controllerList.size();
            while (--i2 >= 0) {
                Controller c3 = (Controller)this.controllerList.elementAt(i2);
                if (c3 == source) continue;
                c3.close();
            }
            this.sendEvent(new ControllerErrorEvent(this, ((ControllerErrorEvent)evt).getMessage()));
        }
        if (evt instanceof SizeChangeEvent && this.controllerList.contains(source)) {
            this.sendEvent(new SizeChangeEvent(this, ((SizeChangeEvent)evt).getWidth(), ((SizeChangeEvent)evt).getHeight(), ((SizeChangeEvent)evt).getScale()));
            return;
        }
        if (evt instanceof DurationUpdateEvent && this.controllerList.contains(source)) {
            this.updateDuration();
            return;
        }
        if (evt instanceof RestartingEvent && this.controllerList.contains(source)) {
            this.restartFrom = source;
            i2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            this.playControl.setEnabled(false);
            int ii = 0;
            while (ii < i2) {
                c2 = (Controller)this.controllerList.elementAt(ii);
                if (c2 != source) {
                    c2.stop();
                }
                ++ii;
            }
            super.stop();
            this.sendEvent(new RestartingEvent(this, 600, 400, 600, this.getMediaTime()));
        }
        if (evt instanceof StartEvent && source == this.restartFrom) {
            this.restartFrom = null;
            this.start();
            this.playControl.setEnabled(true);
        }
        if (evt instanceof EndOfMediaEvent && this.controllerList.contains(source)) {
            this.getState();
        }
        if (evt instanceof SeekFailedEvent && this.controllerList.contains(source)) {
            i2 = this.controllerList.size();
            super.stop();
            this.setTargetState(500);
            int ii = 0;
            while (ii < i2) {
                c2 = (Controller)this.controllerList.elementAt(ii);
                if (c2 != source) {
                    c2.stop();
                }
                ++ii;
            }
            this.sendEvent(new SeekFailedEvent(this, 600, 500, 500, this.getMediaTime()));
        }
        if (evt instanceof EndOfMediaEvent && this.controllerList.contains(source) && this.getState() == 600) {
            if (this.eomEventsReceivedFrom.contains(source)) {
                return;
            }
            this.eomEventsReceivedFrom.addElement(source);
            if (this.eomEventsReceivedFrom.size() == this.controllerList.size()) {
                this.eomEventsReceivedFrom.removeAllElements();
                super.stop();
                this.sendEvent(new EndOfMediaEvent(this, 600, 500, this.getTargetState(), this.getMediaTime()));
                this.playControl.progSetValue(false);
            }
            return;
        }
        if (evt instanceof CachingControlEvent && this.controllerList.contains(source)) {
            CachingControl mcc = ((CachingControlEvent)evt).getCachingControl();
            this.sendEvent(new CachingControlEvent(this, mcc, mcc.getContentProgress()));
            return;
        }
        Vector eventList = this.potentialEventsList;
        if (this.controllerList != null && this.controllerList.contains(source) && eventList != null && eventList.contains(evt.getClass().getName())) {
            this.updateReceivedEventsList(evt);
            this.notifyIfAllEventsArrived(this.controllerList, this.getReceivedEventsList());
        }
    }

    private boolean trySetRate(float rate) {
        int i2 = this.controllerList.size();
        while (--i2 >= 0) {
            Controller c2 = (Controller)this.controllerList.elementAt(i2);
            if (c2.setRate(rate) == rate) continue;
            return false;
        }
        return true;
    }

    protected float doSetRate(float factor) {
        return factor;
    }

    public float setRate(float rate) {
        float rateSet;
        if (this.state < 300) {
            throw new NotRealizedError("Cannot set rate on an unrealized Player.");
        }
        float oldRate = this.getRate();
        if (this.getState() == 600) {
            this.aboutToRestart = true;
            this.stop();
        }
        if (!this.trySetRate(rate)) {
            if (!this.trySetRate(oldRate)) {
                this.trySetRate(1.0f);
                rateSet = 1.0f;
            } else {
                rateSet = oldRate;
            }
        } else {
            rateSet = rate;
        }
        super.setRate(rateSet);
        if (this.rateControl != null) {
            this.rateControl.progSetValue(rateSet);
        }
        if (this.aboutToRestart) {
            this.syncStart(this.getTimeBase().getTime());
            this.aboutToRestart = false;
        }
        return rateSet;
    }

    public abstract void updateStats();

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }

    public class PlayBCA
    extends BooleanControlAdapter {
        public boolean value = false;

        public boolean setValue(boolean value) {
            int targetState = BasicPlayer.this.getTargetState();
            if (value) {
                if (targetState != 600) {
                    BasicPlayer.this.start();
                }
            } else if (targetState == 600) {
                BasicPlayer.this.stop();
            }
            this.progSetValue(value);
            return this.getValue();
        }

        public boolean progSetValue(boolean value) {
            if (this.value != value) {
                this.value = value;
                this.informListeners();
                BasicPlayer.this.stopControl.progSetValue(!value);
            }
            return this.value;
        }

        public boolean getValue() {
            return this.value;
        }

        public PlayBCA() {
            BasicPlayer.this = BasicPlayer.this;
        }
    }

    public class StopBCA
    extends BooleanControlAdapter {
        public boolean value = true;

        public boolean setValue(boolean value) {
            BasicPlayer.this.playControl.setValue(!value);
            return this.getValue();
        }

        public boolean progSetValue(boolean value) {
            if (this.value != value) {
                this.value = value;
                this.informListeners();
                BasicPlayer.this.playControl.progSetValue(!value);
            }
            return this.value;
        }

        public boolean getValue() {
            return this.value;
        }

        public StopBCA() {
            BasicPlayer.this = BasicPlayer.this;
        }
    }

    public class SeekNCA
    extends NumericControlAdapter {
        public float value;

        public float setValue(float value) {
            long t = (long)((double)value * 1000000.0);
            this.value = value;
            BasicPlayer.this.setMediaTime(new Time(t));
            this.informListeners();
            return this.getValue();
        }

        public float progSetValue(long value) {
            this.value = (float)value / 1000000.0f;
            this.informListeners();
            return this.value;
        }

        public float getValue() {
            long t = BasicPlayer.this.getMediaNanoseconds() / 1000000L;
            return t;
        }

        public float getUpperLimit() {
            Time duration = BasicPlayer.this.getDuration();
            long t = duration.getNanoseconds();
            if (t >= 0x7FFFFFFFFFFFFFFEL || duration == Duration.DURATION_UNKNOWN) {
                return 0.0f;
            }
            return t /= 1000000L;
        }

        public SeekNCA() {
            BasicPlayer.this = BasicPlayer.this;
        }
    }

    public class RateNCA
    extends NumericControlAdapter {
        public float value = 1.0f;

        public float setValue(float value) {
            if (value != this.value) {
                this.value = value;
                if (BasicPlayer.this.getTargetState() == 600) {
                    BasicPlayer.this.stop();
                    this.value = BasicPlayer.this.setRate(value);
                    BasicPlayer.this.start();
                } else {
                    this.value = BasicPlayer.this.setRate(value);
                }
                this.informListeners();
            }
            return this.value;
        }

        public float progSetValue(float value) {
            if (this.value != value) {
                this.value = value;
                this.informListeners();
            }
            return this.value;
        }

        public float getValue() {
            this.value = BasicPlayer.this.getRate();
            return this.value;
        }

        public float getLowerLimit() {
            return -4.0f;
        }

        public float getUpperLimit() {
            return 4.0f;
        }

        public float getGranularity() {
            return 0.1f;
        }

        public RateNCA() {
            BasicPlayer.this = BasicPlayer.this;
        }
    }

    public class PBC
    extends AtomicControlAdapter
    implements PlaybackControl {
        public PBC() {
            super(null, true, null);
            BasicPlayer.this = BasicPlayer.this;
            BasicPlayer.this.playControl = new PlayBCA();
            BasicPlayer.this.stopControl = new StopBCA();
            BasicPlayer.this.seekControl = BasicPlayer.this.getSeekNCA();
            BasicPlayer.this.rateControl = new RateNCA();
        }

        public BooleanControl getPlay() {
            return BasicPlayer.this.playControl;
        }

        public BooleanControl getStop() {
            return BasicPlayer.this.stopControl;
        }

        public ActionControl getStepForward() {
            return null;
        }

        public ActionControl getStepBackward() {
            return null;
        }

        public NumericControl getPlayRate() {
            return BasicPlayer.this.rateControl;
        }

        public NumericControl getSeek() {
            return BasicPlayer.this.seekControl;
        }

        public Control[] getControls() {
            return new Control[0];
        }
    }
}

