/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.BasicModule;
import com.sun.media.BasicOutputConnector;
import com.sun.media.BasicPlugIn;
import com.sun.media.Connector;
import com.sun.media.CreateSourceThreadAction;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.MyOutputConnector;
import com.sun.media.SourceThread;
import com.sun.media.util.MediaThread;
import com.sun.media.util.jdk12;
import com.sun.media.util.jdk12PriorityAction;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.media.BadHeaderException;
import javax.media.Demultiplexer;
import javax.media.Duration;
import javax.media.Format;
import javax.media.IncompatibleSourceException;
import javax.media.PlugInManager;
import javax.media.ResourceUnavailableException;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.format.VideoFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;
import javax.media.protocol.Positionable;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PushDataSource;
import javax.media.protocol.SourceStream;

public class BasicSourceModule
extends BasicModule
implements Duration,
Positionable {
    protected DataSource source;
    protected Demultiplexer parser;
    protected Track[] tracks = new Track[0];
    protected SourceThread[] loops;
    protected String[] connectorNames;
    protected long bitsRead;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];
    Object resetSync = new Object();
    int latencyTrack = -1;
    static /* synthetic */ Class class$com$sun$media$SourceThread;

    protected BasicSourceModule(DataSource ds) throws IOException, IncompatibleSourceException {
        this.parser = this.createDemultiplexer(ds);
        this.source = ds;
        SourceStream stream = null;
        if (this.source instanceof PullDataSource) {
            stream = ((PullDataSource)this.source).getStreams()[0];
        } else if (this.source instanceof PushDataSource) {
            stream = ((PushDataSource)this.source).getStreams()[0];
        }
    }

    protected Demultiplexer createDemultiplexer(DataSource ds) throws IOException, IncompatibleSourceException {
        ContentDescriptor cd = new ContentDescriptor(ds.getContentType());
        Vector cnames = PlugInManager.getPlugInList(cd, null, 1);
        Demultiplexer parser = null;
        int i2 = 0;
        while (i2 < cnames.size()) {
            try {
                Class cls = BasicPlugIn.getClassForName((String)cnames.elementAt(i2));
                Object p2 = cls.newInstance();
                if (p2 instanceof Demultiplexer) {
                    parser = (Demultiplexer)p2;
                    try {
                        parser.setSource(ds);
                        break;
                    }
                    catch (IOException e2) {
                        parser = null;
                        throw new IOException("Paser.setSource(): " + e2);
                    }
                    catch (IncompatibleSourceException incompatibleSourceException) {
                        parser = null;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {}
            ++i2;
        }
        if (parser == null) {
            throw new IncompatibleSourceException();
        }
        return parser;
    }

    public boolean doRealize() {
        try {
            this.parser.open();
            this.parser.start();
            this.tracks = this.parser.getTracks();
        }
        catch (ResourceUnavailableException resourceUnavailableException) {
            return false;
        }
        catch (BadHeaderException badHeaderException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
        if (this.tracks == null || this.tracks.length == 0) {
            return false;
        }
        if (jmfSecurity != null) {
            String permission = null;
            try {
                if (jmfSecurity.getName().startsWith("jmf-security")) {
                    permission = "thread";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 16);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    permission = "thread group";
                    jmfSecurity.requestPermission(this.m, this.cl, this.args, 32);
                    this.m[0].invoke((Object)this.cl[0], this.args[0]);
                } else if (jmfSecurity.getName().startsWith("internet")) {
                    PolicyEngine.checkPermission((PermissionID)PermissionID.THREAD);
                    PolicyEngine.assertPermission((PermissionID)PermissionID.THREAD);
                }
            }
            catch (Exception e2) {
                securityPrivelege = false;
            }
        }
        if (jmfSecurity != null && jmfSecurity.getName().startsWith("jdk12")) {
            try {
                Constructor cons = CreateSourceThreadAction.cons;
                Constructor pcons = jdk12PriorityAction.cons;
                this.loops = new SourceThread[this.tracks.length];
                this.connectorNames = new String[this.tracks.length];
                int i2 = 0;
                while (i2 < this.tracks.length) {
                    MyOutputConnector oc = new MyOutputConnector(this.tracks[i2]);
                    oc.setProtocol(1);
                    oc.setSize(1);
                    this.connectorNames[i2] = this.tracks[i2].toString();
                    this.registerOutputConnector(this.tracks[i2].toString(), oc);
                    this.loops[i2] = (SourceThread)jdk12.doPrivM.invoke((Object)jdk12.ac, cons.newInstance(class$com$sun$media$SourceThread != null ? class$com$sun$media$SourceThread : BasicSourceModule.class$("com.sun.media.SourceThread"), this, oc, new Integer(i2)));
                    int index = i2;
                    int priority = this.tracks[i2].getFormat() instanceof AudioFormat ? MediaThread.getAudioPriority() : MediaThread.getVideoPriority();
                    this.loops[i2].useVideoPriority();
                    jdk12.doPrivM.invoke((Object)jdk12.ac, pcons.newInstance(this.loops[i2], new Integer(priority)));
                    ++i2;
                }
            }
            catch (Exception exception) {}
        } else {
            this.loops = new SourceThread[this.tracks.length];
            this.connectorNames = new String[this.tracks.length];
            int i3 = 0;
            while (i3 < this.tracks.length) {
                MyOutputConnector oc = new MyOutputConnector(this.tracks[i3]);
                oc.setProtocol(1);
                oc.setSize(1);
                this.connectorNames[i3] = this.tracks[i3].toString();
                this.registerOutputConnector(this.tracks[i3].toString(), oc);
                this.loops[i3] = new SourceThread(this, oc, i3);
                if (this.tracks[i3].getFormat() instanceof AudioFormat) {
                    this.loops[i3].useAudioPriority();
                } else {
                    this.loops[i3].useVideoPriority();
                }
                ++i3;
            }
        }
        return true;
    }

    public void doFailedRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public void abortRealize() {
        this.parser.stop();
        this.parser.close();
    }

    public boolean doPrefetch() {
        super.doPrefetch();
        return true;
    }

    public void doFailedPrefetch() {
    }

    public void abortPrefetch() {
        this.doStop();
    }

    public void doStart() {
        super.doStart();
        try {
            this.parser.start();
        }
        catch (IOException iOException) {}
        int i2 = 0;
        while (i2 < this.loops.length) {
            BasicOutputConnector oc = (BasicOutputConnector)this.getOutputConnector(this.connectorNames[i2]);
            if (this.tracks[i2].isEnabled() && oc.getInputConnector() != null) {
                this.loops[i2].start();
            }
            ++i2;
        }
    }

    public void doStop() {
    }

    public void pause() {
        Object object = this.resetSync;
        synchronized (object) {
            int i2 = 0;
            while (i2 < this.loops.length) {
                if (this.tracks[i2].isEnabled() && !this.loops[i2].resetted) {
                    this.loops[i2].pause();
                }
                ++i2;
            }
            this.parser.stop();
        }
    }

    public void doDealloc() {
    }

    public void doClose() {
        this.parser.close();
        if (this.tracks == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.tracks.length) {
            this.loops[i2].kill();
            this.loops[i2].cleanUp();
            ++i2;
        }
    }

    public void reset() {
        Object object = this.resetSync;
        synchronized (object) {
            super.reset();
            int i2 = 0;
            while (i2 < this.loops.length) {
                if (this.tracks[i2].isEnabled()) {
                    this.loops[i2].resetted = true;
                    this.loops[i2].start();
                }
                ++i2;
            }
        }
    }

    public String[] getOutputConnectorNames() {
        return this.connectorNames;
    }

    public Time getDuration() {
        return this.parser.getDuration();
    }

    public Time setPosition(Time when, int rounding) {
        return this.parser.setPosition(when, rounding);
    }

    public boolean isPositionable() {
        return this.parser.isPositionable();
    }

    public boolean isRandomAccess() {
        return this.parser.isRandomAccess();
    }

    public Object[] getControls() {
        return this.parser.getControls();
    }

    public Object getControl(String s) {
        return this.parser.getControl(s);
    }

    public Demultiplexer getDemultiplexer() {
        return this.parser;
    }

    public Format[] listFormats(Connector connector) {
        if (!(connector instanceof MyOutputConnector)) {
            return null;
        }
        Format[] fmts = new Format[]{((MyOutputConnector)connector).track.getFormat()};
        return fmts;
    }

    public void setFormat(Connector connector, Format format) {
    }

    public void process() {
    }

    public long getBitsRead() {
        return this.bitsRead;
    }

    public void resetBitsRead() {
        this.bitsRead = 0L;
    }

    boolean readHasBlocked() {
        if (this.loops == null) {
            return false;
        }
        int i2 = 0;
        while (i2 < this.loops.length) {
            if (this.loops[i2].readBlocked) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void checkLatency() {
        if (this.latencyTrack > -1) {
            if (this.tracks[this.latencyTrack].isEnabled()) {
                this.loops[this.latencyTrack].checkLatency = true;
                return;
            }
            this.latencyTrack = -1;
        }
        int i2 = 0;
        while (i2 < this.loops.length) {
            if (this.tracks[i2].isEnabled()) {
                this.latencyTrack = i2;
                if (this.loops[i2].oc.getFormat() instanceof VideoFormat) break;
            }
            ++i2;
        }
        if (this.latencyTrack > -1) {
            this.loops[this.latencyTrack].checkLatency = true;
        }
    }

    protected boolean checkAllPaused() {
        int i2 = 0;
        while (i2 < this.loops.length) {
            if (this.tracks[i2].isEnabled() && !this.loops[i2].isPaused()) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

