/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.video.h261;

import com.ibm.media.codec.video.VideoCodec;
import com.sun.media.JMFSecurityManager;
import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;

public class NativeDecoder
extends VideoCodec {
    public static final int[] widths = new int[]{176, 352};
    public static final int[] heights = new int[]{144, 288};
    private int nativeData;
    int h261Flags;
    int syncBit;
    int skipBytes;
    int nframes;
    int sizeChanged;
    private int width = 352;
    private int height = 288;
    private boolean formatSizeInitFlag = false;
    private byte[] frameBuffer;

    private native boolean initNativeDecoder();

    private native boolean freeNativeDecoder();

    private native boolean decodeNative(Buffer var1, Buffer var2);

    public NativeDecoder() {
        this.supportedInputFormats = new VideoFormat[]{new VideoFormat("h261"), new VideoFormat("h261/rtp")};
        this.defaultOutputFormats = new VideoFormat[]{new YUVFormat()};
        this.PLUGIN_NAME = "H.261 Decoder";
    }

    protected Format[] getMatchingOutputFormats(Format in) {
        VideoFormat ivf = (VideoFormat)in;
        Dimension inSize = ivf.getSize();
        int inMaxDataLength = ivf.getMaxDataLength();
        if (ivf.getEncoding().equals("h261/rtp")) {
            if (inSize != null) {
                this.width = inSize.width;
                this.height = inSize.height;
            }
            int outNumOfPixels = this.width * this.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(new Dimension(this.width, this.height), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.width, this.width >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        } else {
            Dimension outSize = this.movieSizeTo261Size(inSize);
            this.width = outSize.width;
            this.height = outSize.height;
            int outNumOfPixels = outSize.width * outSize.height;
            this.supportedOutputFormats = new VideoFormat[]{new YUVFormat(inSize, outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, outSize.width, outSize.width >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2))};
        }
        return this.supportedOutputFormats;
    }

    public void open() throws ResourceUnavailableException {
        try {
            JMFSecurityManager.loadLibrary("jmh261");
            this.initDecoder();
            return;
        }
        catch (Throwable e2) {
            System.err.println("could not open " + this.PLUGIN_NAME + ". reason:");
            System.err.println(e2);
            throw new ResourceUnavailableException("Could not open " + this.PLUGIN_NAME);
        }
    }

    public void close() {
        this.frameBuffer = null;
        this.freeNativeDecoder();
    }

    public void reset() {
    }

    protected void videoResized() {
        this.initDecoder();
    }

    protected void initDecoder() {
        this.frameBuffer = new byte[2 * this.outputFormat.getMaxDataLength()];
        int i2 = 0;
        while (i2 < this.frameBuffer.length) {
            this.frameBuffer[i2] = -128;
            ++i2;
        }
        this.initNativeDecoder();
    }

    public void findStartCode(Buffer inputBuffer) {
        byte[] data = (byte[])inputBuffer.getData();
        int i2 = 1;
        while (data[i2] == 0) {
            ++i2;
        }
        this.skipBytes = i2 - 1;
        if (data[i2] != 1) {
            --this.skipBytes;
            if ((data[i2] & 0x80) != 0) {
                this.h261Flags |= 0x20000000;
            } else if ((data[i2] & 0x40) != 0) {
                this.h261Flags |= 0x40000000;
            } else if ((data[i2] & 0x20) != 0) {
                this.h261Flags |= 0x60000000;
            } else if ((data[i2] & 0x10) != 0) {
                this.h261Flags |= Integer.MIN_VALUE;
            } else if ((data[i2] & 8) != 0) {
                this.h261Flags |= 0xA0000000;
            } else if ((data[i2] & 4) != 0) {
                this.h261Flags |= 0xC0000000;
            } else if ((data[i2] & 2) != 0) {
                this.h261Flags |= 0xE0000000;
            }
        }
        i2 = inputBuffer.getLength() - 1;
        while (data[i2] == 0) {
            --i2;
        }
        if (i2 == 1) {
            inputBuffer.setLength(i2 - 1);
        } else {
            switch (data[i2] & 0xFF) {
                case 2: {
                    this.h261Flags |= 0x4000000;
                    break;
                }
                case 4: {
                    this.h261Flags |= 0x8000000;
                    break;
                }
                case 8: {
                    this.h261Flags |= 0xC000000;
                    break;
                }
                case 16: {
                    this.h261Flags |= 0x10000000;
                    break;
                }
                case 32: {
                    this.h261Flags |= 0x14000000;
                    break;
                }
                case 64: {
                    this.h261Flags |= 0x18000000;
                    break;
                }
                case 128: {
                    this.h261Flags |= 0x1C000000;
                    break;
                }
            }
            inputBuffer.setLength(i2 - 1);
        }
    }

    public int process(Buffer inputBuffer, Buffer outputBuffer) {
        boolean ret;
        boolean rtpData = false;
        if (!this.checkInputBuffer(inputBuffer)) {
            return 1;
        }
        if (this.isEOM(inputBuffer)) {
            this.propagateEOM(outputBuffer);
            return 0;
        }
        VideoFormat ivf = (VideoFormat)inputBuffer.getFormat();
        int inLength = inputBuffer.getLength();
        int inMaxLength = ivf.getMaxDataLength();
        int outMaxLength = this.outputFormat.getMaxDataLength();
        byte[] inData = (byte[])inputBuffer.getData();
        byte[] outData = this.validateByteArraySize(outputBuffer, outMaxLength * 2);
        if (ivf.getEncoding().equals("h261/rtp")) {
            rtpData = true;
            int inputOffset = inputBuffer.getOffset();
            this.h261Flags = (inData[inputOffset] << 24) + ((inData[inputOffset + 1] & 0xFF) << 16) + ((inData[inputOffset + 2] & 0xFF) << 8) + (inData[inputOffset + 3] & 0xFF);
            this.syncBit = (inputBuffer.getFlags() & 0x400) != 0 ? 1 : 0;
            this.skipBytes = 4;
            if (inData[inputOffset + this.skipBytes] == 0 && inData[inputOffset + this.skipBytes + 1] == 1 && (inData[inputOffset + this.skipBytes + 2] & 0xFC) == 0) {
                int pictureFormat = inData[inputOffset + this.skipBytes + 3] >> 3 & 1;
                if (this.width != widths[pictureFormat] || this.height != heights[pictureFormat]) {
                    this.width = widths[pictureFormat];
                    this.height = heights[pictureFormat];
                    int outNumOfPixels = this.width * this.height;
                    this.outputFormat = new YUVFormat(new Dimension(this.width, this.height), outNumOfPixels + (outNumOfPixels >> 1), Format.byteArray, ivf.getFrameRate(), 2, this.width, this.width >> 1, 0, outNumOfPixels, outNumOfPixels + (outNumOfPixels >> 2));
                }
                this.formatSizeInitFlag = true;
            }
            if (!this.formatSizeInitFlag) {
                return 1;
            }
        } else {
            this.h261Flags = 0x1000000;
            this.syncBit = 1;
            this.findStartCode(inputBuffer);
        }
        if ((ret = this.decodeNative(inputBuffer, outputBuffer)) && this.syncBit == 1) {
            if (rtpData) {
                outputBuffer.setTimeStamp(0L);
            }
            this.updateOutput(outputBuffer, this.outputFormat, outMaxLength, 0);
            return 0;
        }
        return 4;
    }

    private Dimension movieSizeTo261Size(Dimension movieSize) {
        int width = movieSize.width + 15 & 0xFFFFFFF0;
        int height = movieSize.height + 15 & 0xFFFFFFF0;
        int formatCap = width * height >> 8;
        if (formatCap <= 99) {
            return new Dimension(176, 144);
        }
        if (formatCap <= 396) {
            return new Dimension(352, 288);
        }
        return new Dimension(0, 0);
    }

    public boolean checkFormat(Format format) {
        if (format.getEncoding().equals("h261/rtp")) {
            return true;
        }
        return super.checkFormat(format);
    }
}

