/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_shockwave_flash;

import com.sun.media.content.application.x_shockwave_flash.Bitmap;
import com.sun.media.content.application.x_shockwave_flash.ColorTransform;
import com.sun.media.content.application.x_shockwave_flash.Curve;
import com.sun.media.content.application.x_shockwave_flash.DisplayList;
import com.sun.media.content.application.x_shockwave_flash.Matrix;
import com.sun.media.content.application.x_shockwave_flash.RColor;
import com.sun.media.content.application.x_shockwave_flash.REdge;
import com.sun.media.content.application.x_shockwave_flash.SCharacter;
import com.sun.media.content.application.x_shockwave_flash.SObject;
import com.sun.media.content.application.x_shockwave_flash.SParser;
import com.sun.media.content.application.x_shockwave_flash.ScriptPlayer;
import java.awt.Point;

final class SCharacterParser
extends SParser {
    static final int fillSolid = 0;
    static final int fillGradient = 16;
    static final int fillLinearGradient = 16;
    static final int fillRadialGradient = 18;
    static final int fillMaxGradientColors = 8;
    static final int fillBits = 64;
    static final int fillBitsClip = 65;
    static final int fillBitsNoSmooth = 66;
    DisplayList display;
    ScriptPlayer player;
    ColorTransform cx;
    Matrix mat;
    int layer;
    int nLines;
    int nFills;
    RColor[] fillIndex;
    RColor[] lineIndexColor;
    int[] lineIndexThick;
    int nFillBits;
    int nLineBits;
    int line;
    int fill0;
    int fill1;
    Point curPt = new Point(0, 0);
    Point curPtX = new Point(0, 0);
    Point curPtXc = new Point(0, 0);
    Point curPtX2 = new Point(0, 0);
    public final int eflagsMoveTo = 1;
    public final int eflagsFill0 = 2;
    public final int eflagsFill1 = 4;
    public final int eflagsLine = 8;
    public final int eflagsNewStyles = 16;
    public final int eflagsEnd = 128;
    boolean useWinding = false;
    int depth;
    SObject obj;
    int fillRule;
    RColor color1;
    RColor color2;
    RColor strokeColor;
    boolean isThick;
    int lineThickness;
    boolean strokeInited;
    int strokeDepth;
    Point lStartPt = new Point(0, 0);
    Point startOrigin = new Point(0, 0);
    Point rStartPt = new Point(0, 0);
    Point lCurPt = new Point(0, 0);
    Point curOrigin = new Point(0, 0);
    Point rCurPt = new Point(0, 0);
    Point sCurPt = new Point(0, 0);

    SCharacterParser(ScriptPlayer p2, int start, Matrix m2, ColorTransform cx) {
        this.mat = m2;
        this.cx = cx;
        this.layer = 0;
        this.nFills = 0;
        this.nLines = 0;
        this.fill1 = 0;
        this.fill0 = 0;
        this.line = 0;
        this.curPt.y = 0;
        this.curPt.x = 0;
        this.mat.transform(this.curPt, this.curPtX);
        this.player = p2;
        this.display = p2.display;
        this.Attach(this.player.script, start);
    }

    private void buildCache(RColor color) {
        if (color.cacheValid) {
            return;
        }
        switch (color.fillType) {
            case 64: 
            case 65: 
            case 66: {
                if (color.bitmap == null) {
                    color.fillType = 0;
                    break;
                }
                color.bmFast = true;
                color.bmDx = color.bmInvMat.a;
                color.bmDy = color.bmInvMat.b;
                if (this.cx == null) break;
                this.cx.BuildMapChannels();
                color.cx = this.cx;
                color.bmFast = false;
                break;
            }
        }
    }

    boolean GetStyles() {
        this.nFills = this.GetByte();
        if (this.nFills == 255) {
            this.nFills = this.GetWord();
        }
        if ((this.fillIndex = new RColor[this.nFills + 1]) == null) {
            return false;
        }
        int i2 = 1;
        while (i2 <= this.nFills) {
            RColor color = null;
            int fillStyle = this.GetByte();
            if ((fillStyle & 0x10) != 0) {
                Matrix gmat = this.GetMatrix();
                int nColors = this.GetByte();
                int[] colors = new int[nColors];
                int[] colorRatios = new int[nColors];
                int j2 = 0;
                while (j2 < nColors) {
                    colorRatios[j2] = this.GetByte();
                    colors[j2] = this.GetColor();
                    ++j2;
                }
                color = new RColor(this.display, fillStyle, nColors, colors, colorRatios, gmat, this.mat);
                if (this.cx != null) {
                    this.cx.ApplyGradient(color);
                }
            } else if ((fillStyle & 0x40) != 0) {
                int tag = this.GetWord();
                Matrix bitsMat = this.GetMatrix();
                color = new RColor(this.display, -65281);
                SCharacter ch = this.player.FindCharacter(tag);
                if (ch != null && ch.type == 1) {
                    if (ch.object != null && ch.object instanceof Bitmap) {
                        color.bitmap = (Bitmap)ch.object;
                        color.fillType = fillStyle;
                        if (this.display.model != null) {
                            Matrix devMat;
                            if (this.display.antialias) {
                                Matrix aaToDev = new Matrix();
                                aaToDev.scale(16384, 16384);
                                devMat = Matrix.concat(this.mat, aaToDev);
                            } else {
                                devMat = new Matrix(this.mat);
                            }
                            bitsMat.tx <<= 16;
                            bitsMat.ty <<= 16;
                            devMat.tx <<= 16;
                            devMat.ty <<= 16;
                            bitsMat = Matrix.concat(bitsMat, devMat);
                            color.bmInvMat = bitsMat.invert();
                            this.buildCache(color);
                        }
                    }
                } else {
                    color = new RColor(this.display, -65536);
                }
            } else {
                color = new RColor(this.display, this.GetColor());
                if (this.cx != null) {
                    this.cx.Apply(color);
                }
            }
            this.fillIndex[i2] = color;
            color.order = this.layer + i2;
            ++i2;
        }
        this.nLines = this.GetByte();
        if (this.nLines == 255) {
            this.nLines = this.GetWord();
        }
        this.lineIndexColor = new RColor[this.nLines + 1];
        this.lineIndexThick = new int[this.nLines + 1];
        if (this.lineIndexColor == null || this.lineIndexThick == null) {
            this.lineIndexColor = null;
            this.lineIndexThick = null;
            return false;
        }
        int i3 = 1;
        while (i3 <= this.nLines) {
            this.lineIndexThick[i3] = this.mat.transform(this.GetWord());
            RColor color = new RColor(this.display, this.GetColor());
            if (this.cx != null) {
                this.cx.Apply(color);
            }
            this.lineIndexColor[i3] = color;
            color.order = this.layer | i3 + this.nFills;
            ++i3;
        }
        this.InitBits();
        this.nFillBits = this.GetBits(4);
        this.nLineBits = this.GetBits(4);
        return true;
    }

    int GetEdge(Curve c2) {
        boolean isEdge;
        boolean bl = isEdge = this.GetBits(1) != 0;
        if (!isEdge) {
            int flags = this.GetBits(5);
            if (flags == 0) {
                return 128;
            }
            if ((flags & 1) != 0) {
                int nBits = this.GetBits(5);
                this.curPt.x = this.GetSBits(nBits);
                this.curPt.y = this.GetSBits(nBits);
                this.mat.transform(this.curPt, this.curPtX);
            }
            if ((flags & 2) != 0) {
                this.fill0 = this.GetBits(this.nFillBits);
            }
            if ((flags & 4) != 0) {
                this.fill1 = this.GetBits(this.nFillBits);
            }
            if ((flags & 8) != 0) {
                this.line = this.GetBits(this.nLineBits);
            }
            if ((flags & 0x10) != 0) {
                this.layer += this.nFills + this.nLines;
                this.GetStyles();
            }
            return flags;
        }
        boolean bl2 = c2.isLine = this.GetBits(1) != 0;
        if (c2.isLine) {
            boolean generalLine;
            int nBits = this.GetBits(4) + 2;
            boolean bl3 = generalLine = this.GetBits(1) != 0;
            if (generalLine) {
                this.curPt.x += this.GetSBits(nBits);
                this.curPt.y += this.GetSBits(nBits);
            } else {
                boolean vertical;
                boolean bl4 = vertical = this.GetBits(1) != 0;
                if (vertical) {
                    this.curPt.y += this.GetSBits(nBits);
                } else {
                    this.curPt.x += this.GetSBits(nBits);
                }
            }
            this.mat.transform(this.curPt, this.curPtX2);
            c2.set(this.curPtX, this.curPtX2);
        } else {
            int nBits = this.GetBits(4) + 2;
            this.curPt.x += this.GetSBits(nBits);
            this.curPt.y += this.GetSBits(nBits);
            this.mat.transform(this.curPt, this.curPtXc);
            this.curPt.x += this.GetSBits(nBits);
            this.curPt.y += this.GetSBits(nBits);
            this.mat.transform(this.curPt, this.curPtX2);
            c2.set(this.curPtX, this.curPtXc, this.curPtX2);
        }
        this.curPtX.x = this.curPtX2.x;
        this.curPtX.y = this.curPtX2.y;
        return 0;
    }

    void AddCurve(Curve c2, boolean stroke) {
        REdge edge = new REdge();
        if (c2.anchor1y <= c2.anchor2y) {
            edge.anchor1x = c2.anchor1x;
            edge.anchor1y = c2.anchor1y;
            edge.anchor2x = c2.anchor2x;
            edge.anchor2y = c2.anchor2y;
            edge.dir = 1;
        } else {
            edge.anchor1x = c2.anchor2x;
            edge.anchor1y = c2.anchor2y;
            edge.anchor2x = c2.anchor1x;
            edge.anchor2y = c2.anchor1y;
            edge.dir = -1;
        }
        edge.isLine = c2.isLine;
        edge.controlx = c2.controlx;
        edge.controly = c2.controly;
        if (!edge.isLine) {
            if (edge.controly < edge.anchor1y || edge.controly > edge.anchor2y) {
                if (edge.controly < edge.anchor1y && edge.anchor1y - edge.controly < 3) {
                    edge.controly = edge.anchor1y;
                } else if (c2.controly > edge.anchor2y && c2.controly - edge.anchor2y < 3) {
                    edge.controly = edge.anchor2y;
                } else {
                    int a2 = c2.anchor1y - 2 * c2.controly + c2.anchor2y;
                    int b2 = c2.anchor1y - c2.controly;
                    if (++this.depth > 16) {
                        return;
                    }
                    Curve c1 = new Curve(c2);
                    Curve c22 = c1.divide(Matrix.div(b2, a2));
                    this.AddCurve(c1, stroke);
                    this.AddCurve(c22, stroke);
                    --this.depth;
                    return;
                }
            }
            if (edge.anchor2y - edge.anchor1y > 256) {
                if (++this.depth > 16) {
                    return;
                }
                Curve c1 = new Curve(c2);
                Curve c23 = c1.divide(32768);
                this.AddCurve(c1, stroke);
                this.AddCurve(c23, stroke);
                --this.depth;
                return;
            }
        }
        if (edge.anchor1y == edge.anchor2y) {
            return;
        }
        if (stroke) {
            edge.fillRule = 2;
            edge.color1 = this.strokeColor;
        } else {
            edge.fillRule = this.fillRule;
            edge.color1 = this.color1;
            edge.color2 = this.color2;
        }
        edge.nextObj = this.obj.edges;
        this.obj.edges = edge;
    }

    void BuildEdges(boolean getStyles) {
        this.depth = 0;
        this.layer = this.obj.id << 16;
        if (getStyles) {
            if (!this.GetStyles()) {
                return;
            }
        } else {
            this.InitBits();
            this.nFillBits = this.GetBits(4);
            this.nLineBits = this.GetBits(4);
        }
        boolean hasFill = false;
        boolean hasLine = false;
        Curve c2 = new Curve();
        this.color2 = null;
        this.color1 = null;
        while (true) {
            int flags;
            if ((flags = this.GetEdge(c2)) != 0) {
                if (flags == 128) {
                    if (!hasLine) break;
                    this.EndStroke();
                    break;
                }
                if ((flags & 6) != 0) {
                    this.color1 = this.fillIndex[this.fill0];
                    this.color2 = this.fillIndex[this.fill1];
                    if (this.color1 == null && this.color2 != null) {
                        this.color1 = this.color2;
                        this.color2 = null;
                    }
                    this.fillRule = this.color2 != null ? 0 : (this.useWinding ? 2 : 1);
                    boolean bl = hasFill = this.color1 != null;
                }
                if ((flags & 9) == 0) continue;
                if (hasLine) {
                    this.EndStroke();
                }
                if (this.line != 0) {
                    this.BeginStroke(this.lineIndexThick[this.line], this.lineIndexColor[this.line]);
                    hasLine = true;
                    continue;
                }
                hasLine = false;
                continue;
            }
            if (hasLine) {
                this.AddStrokeCurve(c2);
            }
            if (!hasFill) continue;
            this.AddCurve(c2, false);
        }
    }

    final void AddEdge(Point pt1, Point pt2) {
        if (pt1.y == pt2.y) {
            return;
        }
        REdge edge = new REdge();
        if (pt1.y > pt2.y) {
            edge.dir = -1;
            edge.set(pt2, pt1);
        } else {
            edge.dir = 1;
            edge.set(pt1, pt2);
        }
        edge.fillRule = 2;
        edge.color1 = this.strokeColor;
        edge.nextObj = this.obj.edges;
        this.obj.edges = edge;
    }

    /*
     * Unable to fully structure code
     */
    final void StrokeJoin(Point pt1, Point pt2, Point origin) {
        block3: {
            block4: {
                d = Matrix.fastLength(pt1.x - pt2.x, pt1.y - pt2.y);
                if (d <= 3) break block3;
                perpAng1 = Math.atan2(pt1.y - origin.y, pt1.x - origin.x);
                perpAng2 = Math.atan2(pt2.y - origin.y, pt2.x - origin.x);
                while (perpAng1 < perpAng2) {
                    perpAng1 += 6.283185307179586;
                }
                deltaAng = perpAng1 - perpAng2;
                if (!(deltaAng > 0.1) || !(deltaAng <= 3.141592653589793)) break block3;
                radius = this.lineThickness / 2;
                nSegs = (int)(radius * deltaAng) / 3;
                p1 = new Point(pt1.x, pt1.y);
                p2 = new Point(0, 0);
                if (nSegs <= 1) break block4;
                if (nSegs > 16) {
                    nSegs = 16;
                }
                stepAng = -deltaAng / (double)nSegs;
                ang = perpAng1 + stepAng;
                if (true) ** GOTO lbl27
                do {
                    p2.x = (int)(radius * Math.cos(ang)) + origin.x;
                    p2.y = (int)(radius * Math.sin(ang)) + origin.y;
                    this.AddEdge(p1, p2);
                    p1.x = p2.x;
                    p1.y = p2.y;
                    ang += stepAng;
lbl27:
                    // 2 sources

                    v0 = --nSegs;
                    --nSegs;
                } while (v0 > 0);
            }
            this.AddEdge(p1, pt2);
            return;
        }
        this.AddEdge(pt1, pt2);
    }

    static final Curve CurveAdjust(Curve src, Point pt1, Point pt2) {
        int srcDist = Matrix.length(src.anchor1x - src.anchor2x, src.anchor1y - src.anchor2y);
        int ratio = srcDist > 0 ? Matrix.div(Matrix.length(pt1.x - pt2.x, pt1.y - pt2.y), srcDist) : 65536;
        int v1x = src.controlx - src.anchor1x;
        int v1y = src.controly - src.anchor1y;
        int v2x = src.controlx - src.anchor2x;
        int v2y = src.controly - src.anchor2y;
        Curve dst = new Curve();
        dst.anchor1x = pt1.x;
        dst.anchor1y = pt1.y;
        dst.anchor2x = pt2.x;
        dst.anchor2y = pt2.y;
        if (Matrix.fastLength(v1x, v1y) > Matrix.fastLength(v2x, v2y)) {
            dst.controlx = Matrix.mul(ratio, v1x) + pt1.x;
            dst.controly = Matrix.mul(ratio, v1y) + pt1.y;
        } else {
            dst.controlx = Matrix.mul(ratio, v2x) + pt2.x;
            dst.controly = Matrix.mul(ratio, v2y) + pt2.y;
        }
        return dst;
    }

    static final Curve CurveReverse(Curve src) {
        Curve dst = new Curve();
        dst.isLine = src.isLine;
        dst.anchor1x = src.anchor2x;
        dst.anchor1y = src.anchor2y;
        dst.controlx = src.controlx;
        dst.controly = src.controly;
        dst.anchor2x = src.anchor1x;
        dst.anchor2y = src.anchor1y;
        return dst;
    }

    final void StrokeThickCurve(Curve c2) {
        int perp2y;
        int perp2x;
        int invD;
        int da;
        int dc;
        if (!c2.isLine && this.strokeDepth < 5 && (dc = c2.flatness()) > 6 && 2 * dc > (da = Matrix.fastLength(c2.anchor1x - c2.anchor2x, c2.anchor1y - c2.anchor2y))) {
            Curve a2 = new Curve(c2);
            Curve b2 = a2.divide(32768);
            ++this.strokeDepth;
            this.StrokeThickCurve(a2);
            this.StrokeThickCurve(b2);
            --this.strokeDepth;
            return;
        }
        int t = this.lineThickness / 2;
        int perp1x = c2.controly - c2.anchor1y;
        int perp1y = c2.anchor1x - c2.controlx;
        if (perp1x == 0 && perp1y == 0) {
            perp1x = c2.anchor2y - c2.anchor1y;
            perp1y = c2.anchor1x - c2.anchor2x;
        }
        if ((invD = Matrix.length(perp1x, perp1y)) > 0) {
            invD = Matrix.div(t, invD);
            perp1x = Matrix.mul(invD, perp1x);
            perp1y = Matrix.mul(invD, perp1y);
        }
        if (c2.isLine) {
            perp2x = perp1x;
            perp2y = perp1y;
        } else {
            perp2x = c2.anchor2y - c2.controly;
            perp2y = c2.controlx - c2.anchor2x;
            if (perp2x == 0 && perp2y == 0) {
                perp2x = c2.anchor2y - c2.anchor1y;
                perp2y = c2.anchor1x - c2.anchor2x;
            }
            if ((invD = Matrix.length(perp2x, perp2y)) > 0) {
                invD = Matrix.div(t, invD);
                perp2x = Matrix.mul(invD, perp2x);
                perp2y = Matrix.mul(invD, perp2y);
            }
        }
        Point l1 = new Point(c2.anchor1x + perp1x, c2.anchor1y + perp1y);
        Point l2 = new Point(c2.anchor2x + perp2x, c2.anchor2y + perp2y);
        Point r1 = new Point(c2.anchor1x - perp1x, c2.anchor1y - perp1y);
        Point r2 = new Point(c2.anchor2x - perp2x, c2.anchor2y - perp2y);
        if (c2.isLine) {
            this.AddEdge(l2, l1);
            this.AddEdge(r1, r2);
        } else {
            this.AddCurve(SCharacterParser.CurveReverse(SCharacterParser.CurveAdjust(c2, l1, l2)), true);
            this.AddCurve(SCharacterParser.CurveAdjust(c2, r1, r2), true);
        }
        if (!this.strokeInited) {
            this.lStartPt.x = l1.x;
            this.lStartPt.y = l1.y;
            this.startOrigin.x = c2.anchor1x;
            this.startOrigin.y = c2.anchor1y;
            this.rStartPt.x = r1.x;
            this.rStartPt.y = r1.y;
            this.strokeInited = true;
        } else {
            this.StrokeJoin(l1, this.lCurPt, this.curOrigin);
            this.StrokeJoin(this.rCurPt, r1, this.curOrigin);
        }
        this.lCurPt.x = l2.x;
        this.lCurPt.y = l2.y;
        this.curOrigin.x = c2.anchor2x;
        this.curOrigin.y = c2.anchor2y;
        this.rCurPt.x = r2.x;
        this.rCurPt.y = r2.y;
    }

    static final int Sign(int i2) {
        if (i2 < 0) {
            return -1;
        }
        return i2 > 0 ? 1 : 0;
    }

    final void StrokeThinLine(Curve c2) {
        int perpx = c2.anchor2y - c2.anchor1y;
        int perpy = c2.anchor1x - c2.anchor2x;
        Point l1 = new Point(c2.anchor1x, c2.anchor1y);
        Point r1 = new Point(c2.anchor1x, c2.anchor1y);
        Point l2 = new Point(c2.anchor2x, c2.anchor2y);
        Point r2 = new Point(c2.anchor2x, c2.anchor2y);
        boolean mostlyV = Matrix.abs(perpx) > Matrix.abs(perpy);
        switch (this.lineThickness) {
            case 1: {
                if (mostlyV) {
                    int d2 = SCharacterParser.Sign(perpx);
                    if (d2 > 0) {
                        l1.x += d2;
                        l2.x += d2;
                        break;
                    }
                    r1.x -= d2;
                    r2.x -= d2;
                    break;
                }
                int d3 = SCharacterParser.Sign(perpy);
                if (d3 > 0) {
                    l1.y += d3;
                    l2.y += d3;
                    break;
                }
                r1.y -= d3;
                r2.y -= d3;
                break;
            }
            case 2: {
                if (mostlyV) {
                    int d4 = SCharacterParser.Sign(perpx);
                    l1.x += d4;
                    l2.x += d4;
                    r1.x -= d4;
                    r2.x -= d4;
                    break;
                }
                int d5 = SCharacterParser.Sign(perpy);
                l1.y += d5;
                l2.y += d5;
                r1.y -= d5;
                r2.y -= d5;
                break;
            }
            case 3: {
                if (mostlyV) {
                    int d6 = SCharacterParser.Sign(perpx);
                    l1.x += d6;
                    l2.x += d6;
                    r1.x -= (d6 *= 2);
                    r2.x -= d6;
                    break;
                }
                int d7 = SCharacterParser.Sign(perpy);
                l1.y += d7;
                l2.y += d7;
                r1.y -= (d7 *= 2);
                r2.y -= d7;
                break;
            }
        }
        this.AddEdge(l2, l1);
        this.AddEdge(r1, r2);
        if (!this.strokeInited) {
            this.lStartPt.x = l1.x;
            this.lStartPt.y = l1.y;
            this.startOrigin.x = c2.anchor1x;
            this.startOrigin.y = c2.anchor1y;
            this.rStartPt.x = r1.x;
            this.rStartPt.y = r1.y;
            this.strokeInited = true;
        } else {
            this.AddEdge(l1, this.lCurPt);
            this.AddEdge(this.rCurPt, r1);
        }
        this.lCurPt.x = l2.x;
        this.lCurPt.y = l2.y;
        this.curOrigin.x = c2.anchor2x;
        this.curOrigin.y = c2.anchor2y;
        this.rCurPt.x = r2.x;
        this.rCurPt.y = r2.y;
    }

    private static final void CurveOffsetX(Curve c2, int d2) {
        c2.anchor1x += d2;
        c2.controlx += d2;
        c2.anchor2x += d2;
    }

    private static final void CurveOffsetY(Curve c2, int d2) {
        c2.anchor1y += d2;
        c2.controly += d2;
        c2.anchor2y += d2;
    }

    private static final boolean SameSign(int a2, int b2) {
        if (a2 == 0) {
            return true;
        }
        if (a2 > 0) {
            return b2 >= 0;
        }
        return b2 <= 0;
    }

    final void StrokeThinCurve(Curve c2) {
        if (!c2.isLine && c2.flatness() > 2) {
            boolean mostlyV2;
            int perp1x = c2.controly - c2.anchor1y;
            int perp1y = c2.anchor1x - c2.controlx;
            int perp2x = c2.anchor2y - c2.controly;
            int perp2y = c2.controlx - c2.anchor2x;
            boolean mostlyV1 = Matrix.abs(perp1x) > Matrix.abs(perp1y);
            boolean bl = mostlyV2 = Matrix.abs(perp2x) > Matrix.abs(perp2y);
            if (mostlyV1 != mostlyV2 || !SCharacterParser.SameSign(perp1x, perp2x) || !SCharacterParser.SameSign(perp1y, perp2y)) {
                Curve a2 = new Curve(c2);
                Curve b2 = a2.divide(32768);
                this.StrokeThinCurve(a2);
                this.StrokeThinCurve(b2);
                return;
            }
        }
        int perpx = c2.anchor2y - c2.anchor1y;
        int perpy = c2.anchor1x - c2.anchor2x;
        Curve cl = new Curve(c2);
        Curve cr = new Curve(c2);
        boolean mostlyV = Matrix.abs(perpx) > Matrix.abs(perpy);
        switch (this.lineThickness) {
            case 1: {
                int d2;
                if (mostlyV) {
                    d2 = SCharacterParser.Sign(perpx);
                    if (d2 > 0) {
                        SCharacterParser.CurveOffsetX(cl, d2);
                        break;
                    }
                    SCharacterParser.CurveOffsetX(cr, -d2);
                    break;
                }
                d2 = SCharacterParser.Sign(perpy);
                if (d2 > 0) {
                    SCharacterParser.CurveOffsetY(cl, d2);
                    break;
                }
                SCharacterParser.CurveOffsetY(cr, -d2);
                break;
            }
            case 2: {
                int d2;
                if (mostlyV) {
                    d2 = SCharacterParser.Sign(perpx);
                    SCharacterParser.CurveOffsetX(cl, d2);
                    SCharacterParser.CurveOffsetX(cr, -d2);
                    break;
                }
                d2 = SCharacterParser.Sign(perpy);
                SCharacterParser.CurveOffsetY(cl, d2);
                SCharacterParser.CurveOffsetY(cr, -d2);
                break;
            }
            case 3: {
                int d2;
                if (mostlyV) {
                    d2 = SCharacterParser.Sign(perpx);
                    SCharacterParser.CurveOffsetX(cl, d2);
                    SCharacterParser.CurveOffsetX(cr, -2 * d2);
                    break;
                }
                d2 = SCharacterParser.Sign(perpy);
                SCharacterParser.CurveOffsetY(cl, d2);
                SCharacterParser.CurveOffsetY(cr, -2 * d2);
                break;
            }
        }
        this.AddCurve(SCharacterParser.CurveReverse(cl), true);
        this.AddCurve(cr, true);
        if (!this.strokeInited) {
            this.lStartPt.x = cl.anchor1x;
            this.lStartPt.y = cl.anchor1y;
            this.startOrigin.x = c2.anchor1x;
            this.startOrigin.y = c2.anchor1y;
            this.rStartPt.x = cr.anchor1x;
            this.rStartPt.y = cr.anchor1y;
            this.strokeInited = true;
        } else {
            this.AddEdge(new Point(cl.anchor1x, cl.anchor1y), this.lCurPt);
            this.AddEdge(this.rCurPt, new Point(cr.anchor1x, cr.anchor1y));
        }
        this.lCurPt.x = cl.anchor2x;
        this.lCurPt.y = cl.anchor2y;
        this.curOrigin.x = c2.anchor2x;
        this.curOrigin.y = c2.anchor2y;
        this.rCurPt.x = cr.anchor2x;
        this.rCurPt.y = cr.anchor2y;
    }

    final void BeginStroke(int thickness, RColor c2) {
        this.strokeInited = false;
        this.lineThickness = Math.max(this.display.antialias ? 4 : 1, thickness);
        this.isThick = this.lineThickness > 3;
        this.strokeColor = c2;
        this.sCurPt.y = Integer.MIN_VALUE;
        this.sCurPt.x = Integer.MIN_VALUE;
    }

    final void AddStrokeCurve(Curve c2) {
        this.sCurPt.x = c2.anchor2x;
        this.sCurPt.y = c2.anchor2y;
        if (c2.anchor1x == c2.anchor2x && c2.anchor1y == c2.anchor2y && c2.anchor1x == c2.controlx && c2.anchor1y == c2.controly) {
            return;
        }
        if (!this.isThick) {
            if (c2.isLine) {
                this.StrokeThinLine(c2);
            } else {
                this.StrokeThinCurve(c2);
            }
        } else if (this.display.antialias && c2.isLine) {
            if (this.lineThickness == 4 || this.lineThickness == 12) {
                Curve c22 = new Curve(c2);
                if (c22.anchor1x == c22.anchor2x && Matrix.abs(c22.anchor1y - c22.anchor2y) > 12) {
                    c22.anchor1x = c22.anchor2x = (c22.anchor1x & 0xFFFFFFFC) + 2;
                } else if (c22.anchor1y == c22.anchor2y && Matrix.abs(c22.anchor1x - c22.anchor2x) > 12) {
                    c22.anchor1y = c22.anchor2y = (c22.anchor1y & 0xFFFFFFFC) + 2;
                }
                this.StrokeThickCurve(c22);
            } else if (this.lineThickness == 8) {
                Curve c23 = new Curve(c2);
                if (c23.anchor1x == c23.anchor2x && Matrix.abs(c23.anchor1y - c23.anchor2y) > 12) {
                    c23.anchor1x = c23.anchor2x = c23.anchor1x + 2 & 0xFFFFFFFC;
                } else if (c23.anchor1y == c23.anchor2y && Matrix.abs(c23.anchor1x - c23.anchor2x) > 12) {
                    c23.anchor1y = c23.anchor2y = c23.anchor1y + 2 & 0xFFFFFFFC;
                }
                this.StrokeThickCurve(c23);
            } else {
                this.StrokeThickCurve(c2);
            }
        } else {
            this.StrokeThickCurve(c2);
        }
    }

    final void EndStroke() {
        if (this.strokeInited) {
            if (this.startOrigin.x == this.curOrigin.x && this.startOrigin.y == this.curOrigin.y) {
                if (!this.isThick) {
                    this.AddEdge(this.lStartPt, this.lCurPt);
                    this.AddEdge(this.rCurPt, this.rStartPt);
                } else {
                    this.StrokeJoin(this.lStartPt, this.lCurPt, this.curOrigin);
                    this.StrokeJoin(this.rCurPt, this.rStartPt, this.curOrigin);
                }
            } else if (!this.isThick) {
                this.AddEdge(this.lStartPt, this.rStartPt);
                this.AddEdge(this.rCurPt, this.lCurPt);
            } else {
                this.StrokeJoin(this.lStartPt, this.rStartPt, this.startOrigin);
                this.StrokeJoin(this.rCurPt, this.lCurPt, this.curOrigin);
            }
        } else if (this.sCurPt.x != Integer.MIN_VALUE) {
            int t = this.lineThickness / 2;
            Point pt1 = new Point(this.sCurPt.x, this.sCurPt.y);
            Point pt2 = new Point(this.sCurPt.x, this.sCurPt.y);
            pt1.y -= t;
            pt2.y += this.lineThickness - t;
            if (!this.isThick) {
                pt1.x -= t;
                pt2.x -= t;
                this.AddEdge(pt1, pt2);
                pt1.x += this.lineThickness - t;
                pt2.x += this.lineThickness - t;
                this.AddEdge(pt2, pt1);
            } else {
                this.StrokeJoin(pt1, pt2, this.sCurPt);
                this.StrokeJoin(pt2, pt1, this.sCurPt);
            }
        }
    }
}

