/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.controls;

import com.sun.media.ui.TextComp;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.media.control.KeyFrameControl;

public class KeyFrameAdapter
implements KeyFrameControl,
ActionListener {
    int preferred;
    int value;
    boolean settable;
    TextComp textComp;

    public KeyFrameAdapter(int preferredInterval, boolean settable) {
        this.preferred = preferredInterval;
        this.settable = settable;
        this.value = this.preferred;
    }

    public int getKeyFrameInterval() {
        return this.value;
    }

    public int setKeyFrameInterval(int newValue) {
        if (this.settable) {
            if (newValue < 1) {
                newValue = 1;
            }
            this.value = newValue;
            if (this.textComp != null) {
                this.textComp.setValue(Integer.toString(this.value));
            }
            return this.value;
        }
        return -1;
    }

    public int getPreferredKeyFrameInterval() {
        return this.preferred;
    }

    protected String getName() {
        return "Key Frames Every";
    }

    public Component getControlComponent() {
        if (this.textComp == null) {
            this.textComp = new TextComp(this.getName(), Integer.toString(this.value), 3, this.settable);
            this.textComp.setActionListener(this);
        }
        return this.textComp;
    }

    public void actionPerformed(ActionEvent ae) {
        int newValue = this.textComp.getIntValue();
        this.setKeyFrameInterval(newValue);
    }
}

