/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.multiplexer.video;

import com.sun.media.BasicPlugIn;
import com.sun.media.multiplexer.BasicMux;
import java.util.Hashtable;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import javax.media.format.YUVFormat;
import javax.media.protocol.ContentDescriptor;

public class QuicktimeMux
extends BasicMux {
    private int removeCount;
    private boolean sourceConnected = false;
    private boolean sinkConnected = false;
    private boolean closed = false;
    private boolean opened = false;
    private int debugCounter;
    private Hashtable streamNumberHash;
    private TrakInfo[] trakInfoArray;
    private int dataSize;
    private Format[] rgbFormats;
    private Format[] yuvFormats;
    private int[] scaleOffsets;
    private boolean[] endOfMediaStatus;
    private int numberOfEoms;
    private int numberOfTracks;
    private int numberOfSupportedTracks;
    private static final String VIDEO = "vide";
    private static final String AUDIO = "soun";
    private long mdatOffset;
    private long moovOffset;
    private long mvhdDurationOffset;
    private static Hashtable audioFourccMapper = new Hashtable();
    private static Hashtable videoFourccMapper = new Hashtable();
    private final int movieTimeScale = 600;
    private final int DEFAULT_FRAME_RATE = 15;
    private final int DEFAULT_FRAME_DURATION = 40;
    private final int TRAK_ENABLED = 1;
    private final int TRAK_IN_MOVIE = 2;
    private static final int DATA_SELF_REFERENCE_FLAG = 1;
    Format bigEndian = new AudioFormat(null, -1.0, -1, -1, 1, -1);

    public QuicktimeMux() {
        this.supportedInputs = new Format[2];
        this.supportedInputs[0] = new AudioFormat(null);
        this.supportedInputs[1] = new VideoFormat(null);
        this.supportedOutputs = new ContentDescriptor[1];
        this.supportedOutputs[0] = new ContentDescriptor("video.quicktime");
        int NS = -1;
        this.rgbFormats = new Format[]{new RGBFormat(null, NS, Format.byteArray, NS, 16, 0, 31744, 992, 31, 2, NS, 0, 0), new RGBFormat(null, NS, Format.byteArray, NS, 24, 0, 1, 2, 3, 3, NS, 0, NS), new RGBFormat(null, NS, Format.byteArray, NS, 32, 0, 2, 3, 4, 4, NS, 0, NS)};
        this.yuvFormats = new Format[]{new YUVFormat(null, NS, Format.byteArray, NS, 96, NS, NS, 0, 1, 3)};
    }

    public String getName() {
        return "Quicktime Multiplexer";
    }

    public Format setInputFormat(Format input, int trackID) {
        if (this.trakInfoArray == null) {
            this.trakInfoArray = new TrakInfo[this.numTracks];
            this.endOfMediaStatus = new boolean[this.numTracks];
        }
        if (!(input instanceof VideoFormat) && !(input instanceof AudioFormat)) {
            this.trakInfoArray[trackID] = new TrakInfo();
            this.trakInfoArray[trackID].format = input;
            this.trakInfoArray[trackID].supported = false;
            return input;
        }
        String encoding = input.getEncoding();
        if (input instanceof VideoFormat) {
            if (videoFourccMapper.get(encoding.toLowerCase()) == null) {
                return null;
            }
            if (encoding.equals("rgb") && BasicPlugIn.matches(input, this.rgbFormats) == null) {
                return null;
            }
            if (encoding.equals("yuv") && BasicPlugIn.matches(input, this.yuvFormats) == null) {
                return null;
            }
            VideoTrakInfo vti = new VideoTrakInfo();
            this.trakInfoArray[trackID] = vti;
            vti.supported = true;
            vti.type = VIDEO;
            vti.encoding = encoding;
            vti.format = input;
            vti.videoFormat = null;
        } else if (input instanceof AudioFormat) {
            if (encoding.equalsIgnoreCase("LINEAR")) {
                AudioFormat af = (AudioFormat)input;
                if (af.getSampleSizeInBits() > 8) {
                    if (af.getSigned() == 0) {
                        return null;
                    }
                    if (af.getEndian() == 0) {
                        return null;
                    }
                    if (af.getEndian() == -1) {
                        input = af.intersects(this.bigEndian);
                    }
                }
            } else if (audioFourccMapper.get(encoding) == null) {
                return null;
            }
            AudioTrakInfo ati = new AudioTrakInfo();
            this.trakInfoArray[trackID] = ati;
            ati.supported = true;
            ati.type = AUDIO;
            ati.encoding = encoding;
            ati.format = input;
            ati.audioFormat = (AudioFormat)input;
            ati.frameSizeInBytes = ati.audioFormat.getFrameSizeInBits() / 8;
            if (ati.frameSizeInBytes <= 0) {
                ati.frameSizeInBytes = ati.audioFormat.getSampleSizeInBits() * ati.audioFormat.getChannels() / 8;
            }
            if (encoding.equals("ima4")) {
                ati.samplesPerBlock = 64;
            } else if (encoding.equals("gsm")) {
                ati.samplesPerBlock = 160;
            } else if (encoding.equals("MAC3")) {
                ati.samplesPerBlock = 6;
            } else if (encoding.equals("MAC6")) {
                ati.samplesPerBlock = 6;
            }
        }
        if (this.trakInfoArray[trackID].supported) {
            ++this.numberOfSupportedTracks;
        }
        this.inputs[trackID] = input;
        return input;
    }

    public synchronized int doProcess(Buffer buffer, int trackID) {
        Object obj;
        if (buffer.isEOM() && !this.endOfMediaStatus[trackID]) {
            this.endOfMediaStatus[trackID] = true;
            ++this.numberOfEoms;
            if (this.numberOfEoms == this.numTracks) {
                return super.doProcess(buffer, trackID);
            }
            return 0;
        }
        if (!this.trakInfoArray[trackID].initFormat) {
            if (this.trakInfoArray[trackID] instanceof VideoTrakInfo) {
                VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[trackID];
                vti.videoFormat = (VideoFormat)buffer.getFormat();
                vti.frameRate = vti.videoFormat.getFrameRate();
                if (vti.frameRate > 0.0f) {
                    vti.frameDuration = (int)(1.0f / vti.frameRate * 600.0f);
                } else {
                    vti.frameRate = 15.0f;
                    vti.frameDuration = 40;
                }
            }
            this.trakInfoArray[trackID].initFormat = true;
        }
        if ((obj = buffer.getData()) == null) {
            return 1;
        }
        byte[] data = (byte[])obj;
        if (data == null) {
            return 1;
        }
        int length = buffer.getLength();
        this.dataSize += length;
        TrakInfo trakInfo = this.trakInfoArray[trackID];
        this.write(data, 0, length);
        int chunkOffset = this.filePointer - length;
        int chunkOffsetsIndex = trakInfo.chunkOffsetsIndex++;
        int numChunkOffsetsArraysUsed = trakInfo.numChunkOffsetsArraysUsed++;
        trakInfo.chunkOffsetsArray[numChunkOffsetsArraysUsed - 1][chunkOffsetsIndex] = chunkOffset;
        if (++chunkOffsetsIndex >= 1000) {
            trakInfo.chunkOffsetsIndex = 0;
            trakInfo.chunkOffsetsArray[numChunkOffsetsArraysUsed] = new int[1000];
            if (++numChunkOffsetsArraysUsed >= 1000) {
                System.err.println("Cannot create quicktime file with more than " + 1000000 + " chunks ");
                return 1;
            }
        }
        String type = trakInfo.type;
        VideoTrakInfo vti = null;
        AudioTrakInfo ati = null;
        if (type.equals(VIDEO)) {
            boolean keyframe;
            vti = (VideoTrakInfo)trakInfo;
            int sampleSizeIndex = vti.sampleSizeIndex++;
            int numSampleSizeArraysUsed = vti.numSampleSizeArraysUsed;
            vti.sampleSize[numSampleSizeArraysUsed - 1][sampleSizeIndex] = length;
            if (vti.constantSampleSize && length != vti.sampleSize[0][0]) {
                vti.constantSampleSize = false;
            }
            if (++sampleSizeIndex >= 2000) {
                vti.sampleSizeIndex = 0;
                vti.sampleSize[numSampleSizeArraysUsed] = new int[2000];
                ++vti.numSampleSizeArraysUsed;
                if (++numSampleSizeArraysUsed >= 1000) {
                    System.err.println("Cannot create quicktime file with more than " + 2000000 + " samples ");
                    return 1;
                }
            }
            boolean bl = keyframe = (buffer.getFlags() & 0x10) > 0;
            if (keyframe) {
                int keyFrameIndex = vti.keyFrameIndex++;
                int numKeyFrameArraysUsed = vti.numKeyFrameArraysUsed++;
                vti.keyFrames[numKeyFrameArraysUsed - 1][keyFrameIndex] = vti.totalFrames + 1;
                if (++keyFrameIndex >= 1000) {
                    vti.keyFrameIndex = 0;
                    vti.keyFrames[numKeyFrameArraysUsed] = new int[1000];
                    if (++numKeyFrameArraysUsed >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000000 + " keyframes ");
                        return 1;
                    }
                }
            }
        } else {
            ati = (AudioTrakInfo)trakInfo;
            int samplesPerChunk = length / ati.frameSizeInBytes * ati.samplesPerBlock;
            ati.numSamples += samplesPerChunk;
            if (ati.previousSamplesPerChunk != samplesPerChunk) {
                int samplesPerChunkIndex = ati.samplesPerChunkIndex;
                int numSamplesPerChunkArraysUsed = ati.numSamplesPerChunkArraysUsed++;
                ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed - 1][samplesPerChunkIndex] = trakInfo.totalFrames + 1;
                ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed - 1][++samplesPerChunkIndex] = samplesPerChunk;
                ++samplesPerChunkIndex;
                ati.samplesPerChunkIndex = samplesPerChunkIndex++;
                ati.previousSamplesPerChunk = samplesPerChunk;
                if (samplesPerChunkIndex >= 1000) {
                    ati.samplesPerChunkIndex = 0;
                    ati.samplesPerChunkArray[numSamplesPerChunkArraysUsed] = new int[1000];
                    if (++numSamplesPerChunkArraysUsed >= 1000) {
                        System.err.println("Cannot create quicktime file with more than " + 1000000 + " chunks ");
                        return 1;
                    }
                }
            }
        }
        ++trakInfo.totalFrames;
        return 0;
    }

    protected void writeHeader() {
        this.mdatOffset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdat");
        this.bufFlush();
        this.dataSize = 0;
    }

    protected void writeFooter() {
        this.moovOffset = this.filePointer;
        this.seek((int)this.mdatOffset);
        this.bufClear();
        this.bufWriteInt(8 + this.dataSize);
        this.bufFlush();
        this.seek((int)this.moovOffset);
        this.writeMOOV();
        int maxTrackDuration = -1;
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.trakInfoArray[i2].supported && this.trakInfoArray[i2].duration > maxTrackDuration) {
                maxTrackDuration = this.trakInfoArray[i2].duration;
            }
            ++i2;
        }
        this.writeSize(this.mvhdDurationOffset, maxTrackDuration);
    }

    private int writeMOOV() {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("moov");
        this.bufFlush();
        int size = 8;
        size += this.writeMVHD();
        int i2 = 0;
        while (i2 < this.numTracks) {
            if (this.trakInfoArray[i2].supported) {
                size += this.writeTRAK(i2, this.trakInfoArray[i2].type);
            }
            ++i2;
        }
        return this.writeSize(offset, size);
    }

    private int writeMVHD() {
        this.bufClear();
        this.bufWriteInt(108);
        this.bufWriteBytes("mvhd");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(600);
        this.mvhdDurationOffset = this.filePointer;
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteShort((short)255);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(this.numberOfSupportedTracks + 1);
        this.bufFlush();
        return 108;
    }

    private int writeSize(long offset, int size) {
        long currentOffset = this.filePointer;
        this.seek((int)offset);
        this.bufClear();
        this.bufWriteInt(size);
        this.bufFlush();
        this.seek((int)currentOffset);
        return size;
    }

    private int writeTRAK(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("trak");
        this.bufFlush();
        int size = 8;
        size += this.writeTKHD(streamNumber, type);
        return this.writeSize(offset, size += this.writeMDIA(streamNumber, type));
    }

    private int writeTKHD(int streamNumber, String type) {
        int width = 0;
        int height = 0;
        int duration = 0;
        int volume = 0;
        if (type.equals(VIDEO)) {
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            width = videoTrakInfo.videoFormat.getSize().width;
            height = videoTrakInfo.videoFormat.getSize().height;
            duration = videoTrakInfo.duration = videoTrakInfo.frameDuration * videoTrakInfo.totalFrames;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            float sampleRate = (int)audioTrakInfo.audioFormat.getSampleRate();
            float epsilon = 0.01f;
            audioTrakInfo.duration = duration = (int)((float)audioTrakInfo.numSamples / sampleRate * 600.0f + epsilon);
            volume = 255;
        }
        this.bufClear();
        this.bufWriteInt(92);
        this.bufWriteBytes("tkhd");
        this.bufWriteInt(3);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(streamNumber + 1);
        this.bufWriteInt(0);
        this.bufWriteInt(duration);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)volume);
        this.bufWriteShort((short)0);
        this.bufFlush();
        this.writeMatrix();
        this.bufClear();
        this.bufWriteInt(width * 65536);
        this.bufWriteInt(height * 65536);
        this.bufFlush();
        return 92;
    }

    private int writeMDIA(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("mdia");
        this.bufFlush();
        int size = 8;
        size += this.writeMDHD(streamNumber, type);
        size += this.writeMhlrHdlr(streamNumber, type);
        return this.writeSize(offset, size += this.writeMINF(streamNumber, type));
    }

    private void writeMatrix() {
        this.bufClear();
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(65536);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(0x40000000);
        this.bufFlush();
    }

    private int writeMDHD(int streamNumber, String type) {
        int timeScale = 0;
        int duration = 0;
        if (type.equals(VIDEO)) {
            timeScale = 600;
            VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            duration = videoTrakInfo.duration;
        } else {
            AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            timeScale = (int)audioTrakInfo.audioFormat.getSampleRate();
            duration = audioTrakInfo.numSamples;
        }
        this.bufClear();
        this.bufWriteInt(32);
        this.bufWriteBytes("mdhd");
        this.bufWriteInt(1);
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteInt(timeScale);
        this.bufWriteInt(duration);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 32;
    }

    private int writeMINF(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("minf");
        this.bufFlush();
        int size = 8;
        size = type.equals(VIDEO) ? (size += this.writeVMHD(streamNumber, type)) : (size += this.writeSMHD(streamNumber, type));
        size += this.writeDHlrHdlr(streamNumber, type);
        size += this.writeDINF(streamNumber, type);
        return this.writeSize(offset, size += this.writeSTBL(streamNumber, type));
    }

    private int writeVMHD(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(20);
        this.bufWriteBytes("vmhd");
        this.bufWriteInt(1);
        this.bufWriteShort((short)64);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufWriteShort((short)Short.MIN_VALUE);
        this.bufFlush();
        return 20;
    }

    private int writeSMHD(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(16);
        this.bufWriteBytes("smhd");
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufFlush();
        return 16;
    }

    private int writeMhlrHdlr(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("mhlr");
        this.bufWriteBytes(type);
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDHlrHdlr(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("hdlr");
        this.bufWriteInt(0);
        this.bufWriteBytes("dhlr");
        this.bufWriteBytes("alis");
        this.bufWriteBytes("    ");
        this.bufWriteInt(0);
        this.bufWriteInt(0);
        this.bufWriteBytes("    ");
        this.bufFlush();
        return 36;
    }

    private int writeDINF(int streamNumber, String type) {
        this.bufClear();
        this.bufWriteInt(36);
        this.bufWriteBytes("dinf");
        this.bufWriteInt(28);
        this.bufWriteBytes("dref");
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufWriteInt(12);
        this.bufWriteBytes("alis");
        this.bufWriteInt(1);
        this.bufFlush();
        return 36;
    }

    private int writeSTBL(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stbl");
        this.bufFlush();
        int size = 8;
        size += this.writeSTSD(streamNumber, type);
        size += this.writeSTTS(streamNumber, type);
        size += this.writeSTSS(streamNumber, type);
        size += this.writeSTSC(streamNumber, type);
        size += this.writeSTSZ(streamNumber, type);
        return this.writeSize(offset, size += this.writeSTCO(streamNumber, type));
    }

    private int writeSTSD(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsd");
        int size = 8;
        this.bufWriteInt(0);
        this.bufWriteInt(1);
        this.bufFlush();
        size += 8;
        size = type.equals(VIDEO) ? (size += this.writeVideoSampleDescription(streamNumber, type)) : (size += this.writeAudioSampleDescription(streamNumber, type));
        return this.writeSize(offset, size);
    }

    private int writeVideoSampleDescription(int streamNumber, String type) {
        int bitsPerPixel;
        VideoTrakInfo videoTrakInfo = (VideoTrakInfo)this.trakInfoArray[streamNumber];
        int width = videoTrakInfo.videoFormat.getSize().width;
        int height = videoTrakInfo.videoFormat.getSize().height;
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int size = 4;
        String encoding = videoTrakInfo.encoding;
        String fourcc = null;
        if (encoding.equals("rgb")) {
            RGBFormat rgbFormat = (RGBFormat)videoTrakInfo.format;
            bitsPerPixel = rgbFormat.getBitsPerPixel();
            fourcc = "raw ";
        } else {
            fourcc = (String)videoFourccMapper.get(encoding.toLowerCase());
            bitsPerPixel = 24;
        }
        this.bufWriteBytes(fourcc);
        size += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        size += 6;
        this.bufWriteShort((short)1);
        size += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteBytes("appl");
        this.bufWriteInt(1023);
        this.bufWriteInt(1023);
        this.bufWriteShort((short)width);
        this.bufWriteShort((short)height);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0x480000);
        this.bufWriteInt(0);
        this.bufWriteShort((short)1);
        this.bufWriteBytes(fourcc);
        this.bufWriteBytes("                            ");
        this.bufWriteShort((short)bitsPerPixel);
        this.bufWriteShort((short)-1);
        this.bufFlush();
        return this.writeSize(offset, size += 70);
    }

    private int writeAudioSampleDescription(int streamNumber, String type) {
        AudioTrakInfo audioTrakInfo = (AudioTrakInfo)this.trakInfoArray[streamNumber];
        AudioFormat audioFormat = audioTrakInfo.audioFormat;
        int channels = audioFormat.getChannels();
        int sampleSizeInBits = audioFormat.getSampleSizeInBits();
        int sampleRate = (int)audioFormat.getSampleRate();
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        int size = 4;
        String encoding = audioTrakInfo.encoding;
        String fourcc = encoding.equals("LINEAR") ? (sampleSizeInBits == 8 && audioFormat.getSigned() == 0 ? "raw " : "twos") : (String)audioFourccMapper.get(encoding);
        this.bufWriteBytes(fourcc);
        size += 4;
        this.bufWriteInt(0);
        this.bufWriteShort((short)0);
        size += 6;
        this.bufWriteShort((short)1);
        size += 2;
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(0);
        this.bufWriteShort((short)channels);
        this.bufWriteShort((short)sampleSizeInBits);
        this.bufWriteShort((short)0);
        this.bufWriteShort((short)0);
        this.bufWriteInt(sampleRate * 65536);
        this.bufFlush();
        return this.writeSize(offset, size += 20);
    }

    private int writeSTTS(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stts");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        if (type.equals(VIDEO)) {
            VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            this.bufWriteInt(1);
            size += 4;
            this.bufWriteInt(vti.totalFrames);
            this.bufWriteInt(vti.frameDuration);
            size += 8;
        } else {
            AudioTrakInfo ati = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            this.bufWriteInt(1);
            size += 4;
            this.bufWriteInt(ati.numSamples);
            this.bufWriteInt(1);
            size += 8;
        }
        this.bufFlush();
        return this.writeSize(offset, size);
    }

    private int writeSTSS(int streamNumber, String type) {
        if (!type.equals(VIDEO)) {
            return 0;
        }
        VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
        int numKeyFrameArraysUsed = vti.numKeyFrameArraysUsed;
        int numKeyFrames = (numKeyFrameArraysUsed - 1) * 1000 + vti.keyFrameIndex;
        if (numKeyFrames == vti.totalFrames) {
            int i2 = 0;
            while (i2 < numKeyFrameArraysUsed) {
                vti.keyFrames[i2] = null;
                ++i2;
            }
            return 0;
        }
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stss");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        int[][] keyFrames = vti.keyFrames;
        this.bufWriteInt(numKeyFrames);
        size += 4;
        int indexi = 0;
        int indexj = 0;
        int i3 = 0;
        while (i3 < numKeyFrames) {
            this.bufWriteInt(keyFrames[indexi][indexj++]);
            if (indexj >= 1000) {
                ++indexi;
                indexj = 0;
            }
            ++i3;
        }
        this.bufFlush();
        return this.writeSize(offset, size += numKeyFrames * 4);
    }

    private int writeSTSC(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsc");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        if (type.equals(VIDEO)) {
            VideoTrakInfo vti = (VideoTrakInfo)this.trakInfoArray[streamNumber];
            this.bufWriteInt(1);
            size += 4;
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            this.bufWriteInt(1);
            size += 12;
        } else {
            AudioTrakInfo ati = (AudioTrakInfo)this.trakInfoArray[streamNumber];
            int numberOfEntries = ((ati.numSamplesPerChunkArraysUsed - 1) * 1000 + ati.samplesPerChunkIndex) / 2;
            this.bufWriteInt(numberOfEntries);
            size += 4;
            int indexi = 0;
            int indexj = 0;
            int[][] samplesPerChunkArray = ati.samplesPerChunkArray;
            int i2 = 0;
            while (i2 < numberOfEntries) {
                this.bufWriteInt(samplesPerChunkArray[indexi][indexj++]);
                this.bufWriteInt(samplesPerChunkArray[indexi][indexj++]);
                this.bufWriteInt(1);
                if (indexj >= 1000) {
                    ++indexi;
                    indexj = 0;
                }
                ++i2;
            }
            size += numberOfEntries * 12;
        }
        this.bufFlush();
        return this.writeSize(offset, size);
    }

    /*
     * WARNING - void declaration
     */
    private int writeSTSZ(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stsz");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        TrakInfo trakInfo = this.trakInfoArray[streamNumber];
        if (type.equals(AUDIO)) {
            this.bufWriteInt(1);
            this.bufWriteInt(((AudioTrakInfo)trakInfo).numSamples);
            size += 8;
        } else if (type.equals(VIDEO)) {
            void var10_9;
            VideoTrakInfo vti = (VideoTrakInfo)trakInfo;
            int numSampleSizeArraysUsed = vti.numSampleSizeArraysUsed;
            int numberOfEntries = trakInfo.totalFrames;
            if (trakInfo.constantSampleSize) {
                int sampleSize = vti.sampleSize[0][0];
                this.bufWriteInt(sampleSize);
                this.bufWriteInt(numberOfEntries);
                size += 8;
            } else {
                int[][] sampleSize = vti.sampleSize;
                this.bufWriteInt(0);
                this.bufWriteInt(numberOfEntries);
                size += 8;
                int indexi = 0;
                int indexj = 0;
                int i2 = 0;
                while (i2 < numberOfEntries) {
                    this.bufWriteInt(sampleSize[indexi][indexj++]);
                    if (indexj >= 2000) {
                        ++indexi;
                        indexj = 0;
                    }
                    ++i2;
                }
                size += numberOfEntries * 4;
            }
            boolean i3 = false;
            while (var10_9 < numSampleSizeArraysUsed) {
                vti.sampleSize[var10_9] = null;
                ++var10_9;
            }
        }
        this.bufFlush();
        return this.writeSize(offset, size);
    }

    private int writeSTCO(int streamNumber, String type) {
        long offset = this.filePointer;
        this.bufClear();
        this.bufWriteInt(0);
        this.bufWriteBytes("stco");
        int size = 8;
        this.bufWriteInt(0);
        size += 4;
        TrakInfo trakInfo = this.trakInfoArray[streamNumber];
        int numChunkOffsetsArraysUsed = trakInfo.numChunkOffsetsArraysUsed;
        int[][] chunkOffsetsArray = trakInfo.chunkOffsetsArray;
        this.bufWriteInt(trakInfo.totalFrames);
        size += 4;
        int indexi = 0;
        int indexj = 0;
        int i2 = 0;
        while (i2 < trakInfo.totalFrames) {
            this.bufWriteInt((int)((long)chunkOffsetsArray[indexi][indexj++] - this.mdatOffset));
            if (indexj >= 1000) {
                ++indexi;
                indexj = 0;
            }
            ++i2;
        }
        this.bufFlush();
        return this.writeSize(offset, size += trakInfo.totalFrames * 4);
    }

    static {
        audioFourccMapper.put("alaw", "alaw");
        audioFourccMapper.put("ULAW", "ULAW");
        audioFourccMapper.put("ima4", "ima4");
        audioFourccMapper.put("gsm", "agsm");
        audioFourccMapper.put("MAC3", "MAC3");
        audioFourccMapper.put("MAC6", "MAC6");
        videoFourccMapper.put("rgb", "rgb");
        videoFourccMapper.put("cvid", "cvid");
        videoFourccMapper.put("jpeg", "jpeg");
        videoFourccMapper.put("h261", "h261");
        videoFourccMapper.put("h263", "h263");
        videoFourccMapper.put("iv32", "iv32");
        videoFourccMapper.put("iv41", "iv41");
        videoFourccMapper.put("iv50", "iv50");
        videoFourccMapper.put("mjpg", "mjpg");
        videoFourccMapper.put("mjpa", "mjpa");
        videoFourccMapper.put("mjpb", "mjpb");
        videoFourccMapper.put("mpeg", "mpeg");
        videoFourccMapper.put("rpza", "rpza");
        videoFourccMapper.put("yuv", "yuv2");
    }

    private class TrakInfo {
        boolean initFormat = false;
        boolean supported = false;
        String type;
        String encoding;
        Format format;
        int totalFrames;
        int duration;
        boolean constantSampleSize = true;
        final int MAX_CHUNKOFFSETS_NUMARRAYS = 1000;
        final int MAX_CHUNKOFFSETS_ARRAYSIZE = 1000;
        int numChunkOffsetsArraysUsed = 1;
        int chunkOffsetsIndex;
        int[][] chunkOffsetsArray = new int[1000][];

        public TrakInfo() {
            QuicktimeMux.this = QuicktimeMux.this;
            this.chunkOffsetsArray[0] = new int[1000];
        }

        public String toString() {
            if (!this.supported) {
                System.out.println("No support for format " + this.format);
            }
            return String.valueOf(this.type) + ": " + this.encoding + " : totalFrames " + this.totalFrames;
        }
    }

    private class VideoTrakInfo
    extends TrakInfo {
        VideoFormat videoFormat;
        float frameRate;
        int frameDuration;
        final int MAX_SAMPLE_SIZE_NUMARRAYS = 1000;
        final int MAX_SAMPLE_SIZE_ARRAYSIZE = 2000;
        int numSampleSizeArraysUsed = 1;
        int sampleSizeIndex;
        int[][] sampleSize = new int[1000][];
        final int MAX_KEYFRAME_NUMARRAYS = 1000;
        final int MAX_KEYFRAME_ARRAYSIZE = 1000;
        int numKeyFrameArraysUsed = 1;
        int keyFrameIndex;
        int[][] keyFrames;

        public VideoTrakInfo() {
            QuicktimeMux.this = QuicktimeMux.this;
            this.sampleSize[0] = new int[2000];
            this.keyFrames = new int[1000][];
            this.keyFrames[0] = new int[1000];
        }

        public String toString() {
            return String.valueOf(super.toString()) + " \n frameRate " + this.frameRate + " : frameDuration " + this.frameDuration;
        }
    }

    private class AudioTrakInfo
    extends TrakInfo {
        AudioFormat audioFormat;
        final int IMA4_SAMPLES_PER_BLOCK = 64;
        final int GSM_SAMPLES_PER_BLOCK = 160;
        final int MAC3_SAMPLES_PER_BLOCK = 6;
        final int MAC6_SAMPLES_PER_BLOCK = 6;
        int samplesPerBlock = 1;
        int numSamples;
        int frameSizeInBytes;
        final int MAX_SAMPLESPERCHUNK_NUMARRAYS = 1000;
        final int MAX_SAMPLESPERCHUNK_ARRAYSIZE = 1000;
        int numSamplesPerChunkArraysUsed = 1;
        int samplesPerChunkIndex;
        int[][] samplesPerChunkArray = new int[1000][];
        int previousSamplesPerChunk = -1;

        public AudioTrakInfo() {
            QuicktimeMux.this = QuicktimeMux.this;
            this.samplesPerChunkArray[0] = new int[1000];
            this.samplesPerChunkArray[0][0] = 1;
            this.samplesPerChunkArray[0][1] = -1;
        }
    }
}

