/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.format.AudioFormat;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class AiffParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private Format format;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize = -1;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private PullSourceStream stream;
    private int maxFrame;
    private int blockSize;
    private double sampleRate = -1.0;
    private long minLocation;
    private long maxLocation;
    private String encodingString;
    private int samplesPerBlock = 1;
    private double timePerBlockNano = -1.0;
    private double locationToMediaTime = -1.0;
    public static final String FormID = "FORM";
    public static final String FormatVersionID = "FVER";
    public static final String CommonID = "COMM";
    public static final String SoundDataID = "SSND";
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_aiff")};
    public static final int CommonIDSize = 18;
    private boolean isAIFC = false;
    private boolean commonChunkSeen = false;
    private boolean soundDataChunkSeen = false;
    private boolean formatVersionChunkSeen = false;

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.tracks[0] = new AiffTrack((AudioFormat)this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        boolean signed = true;
        String magic = this.readString(this.stream);
        if (!magic.equals(FormID)) {
            throw new BadHeaderException("AIFF Parser: expected string FORM, got " + magic);
        }
        int fileLength = this.readInt(this.stream) + 8;
        String formType = this.readString(this.stream);
        if (formType.equals("AIFC")) {
            this.isAIFC = true;
        } else {
            this.encodingString = "LINEAR";
        }
        int remainingLength = fileLength - 12;
        String compressionType = null;
        int offset = 0;
        int channels = -1;
        int sampleSizeInBits = -1;
        while (remainingLength >= 8) {
            String type = this.readString(this.stream);
            int size = this.readInt(this.stream);
            remainingLength -= 8;
            if (type.equals(FormatVersionID)) {
                int timestamp = this.readInt(this.stream);
                if (size != 4) {
                    throw new BadHeaderException("Illegal FormatVersionID: chunk size is not 4 but " + size);
                }
                this.formatVersionChunkSeen = true;
            } else if (type.equals(CommonID)) {
                if (size < 18) {
                    throw new BadHeaderException("Size of COMM chunk should be atleast " + 18);
                }
                channels = this.readShort(this.stream);
                if (channels < 1) {
                    throw new BadHeaderException("Number of channels is " + channels);
                }
                this.maxFrame = this.readInt(this.stream);
                sampleSizeInBits = this.readShort(this.stream);
                if (sampleSizeInBits <= 0) {
                    throw new BadHeaderException("Illegal sampleSize " + sampleSizeInBits);
                }
                this.sampleRate = this.readIeeeExtended(this.stream);
                if (this.sampleRate < 0.0) {
                    throw new BadHeaderException("Negative Sample Rate " + this.sampleRate);
                }
                int remainingCommSize = size - 18;
                if (this.isAIFC) {
                    if (remainingCommSize < 4) {
                        throw new BadHeaderException("COMM chunk in AIFC doesn't have compressionType info");
                    }
                    compressionType = this.readString(this.stream);
                    if (compressionType == null) {
                        throw new BadHeaderException("Compression type for AIFC is null");
                    }
                    this.skip(this.stream, remainingCommSize - 4);
                }
                this.commonChunkSeen = true;
            } else if (type.equals(SoundDataID)) {
                if (this.soundDataChunkSeen) {
                    throw new BadHeaderException("Cannot have more than 1 Sound Data Chunk");
                }
                offset = this.readInt(this.stream);
                this.blockSize = this.readInt(this.stream);
                this.minLocation = this.getLocation(this.stream);
                this.dataSize = size - 8;
                this.maxLocation = this.minLocation + (long)this.dataSize;
                this.soundDataChunkSeen = true;
                if (this.commonChunkSeen) {
                    remainingLength -= 8;
                    break;
                }
                this.skip(this.stream, size - 8);
            } else {
                this.skip(this.stream, size);
            }
            remainingLength -= size;
        }
        if (!this.commonChunkSeen) {
            throw new BadHeaderException("Mandatory chunk COMM missing");
        }
        if (!this.soundDataChunkSeen) {
            throw new BadHeaderException("Mandatory chunk SSND missing");
        }
        double durationSeconds = -1.0;
        if (this.isAIFC) {
            String c2 = compressionType;
            if (c2.equalsIgnoreCase("NONE")) {
                this.encodingString = "LINEAR";
            } else if (c2.equalsIgnoreCase("twos")) {
                this.encodingString = "LINEAR";
            } else if (c2.equalsIgnoreCase("raw")) {
                this.encodingString = "LINEAR";
                signed = false;
            } else if (c2.equalsIgnoreCase("ULAW")) {
                this.encodingString = "ULAW";
                sampleSizeInBits = 8;
                signed = false;
            } else if (c2.equalsIgnoreCase("ALAW")) {
                this.encodingString = "alaw";
                sampleSizeInBits = 8;
                signed = false;
            } else if (c2.equalsIgnoreCase("G723")) {
                this.encodingString = "g723";
            } else if (c2.equalsIgnoreCase("MAC3")) {
                this.encodingString = "MAC3";
                this.blockSize = 2;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (c2.equalsIgnoreCase("MAC6")) {
                this.encodingString = "MAC6";
                this.blockSize = 1;
                this.samplesPerBlock = 6;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else if (c2.equalsIgnoreCase("IMA4")) {
                this.encodingString = "ima4";
                this.blockSize = 34 * channels;
                this.samplesPerBlock = 64;
                this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / this.sampleRate;
            } else {
                throw new BadHeaderException("Unsupported encoding" + c2);
            }
        }
        if (this.blockSize == 0) {
            this.blockSize = channels * sampleSizeInBits / 8;
        }
        this.bufferSize = this.blockSize * (int)(this.sampleRate / (double)this.samplesPerBlock);
        durationSeconds = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
        if (durationSeconds > 0.0) {
            this.duration = new Time(durationSeconds);
        }
        this.locationToMediaTime = (double)this.samplesPerBlock / (this.sampleRate * (double)this.blockSize);
        this.format = new AudioFormat(this.encodingString, this.sampleRate, sampleSizeInBits, channels, 1, signed ? 1 : 0, this.blockSize * 8, -1.0, Format.byteArray);
    }

    /*
     * Unable to fully structure code
     */
    public Time setPosition(Time where, int rounding) {
        block21: {
            block20: {
                if (!this.seekable) {
                    return this.getMediaTime();
                }
                time = where.getNanoseconds();
                if (time < 0L) {
                    time = 0L;
                }
                if (this.timePerBlockNano != -1.0) break block20;
                bytesPerSecond = (int)this.sampleRate * this.blockSize;
                newPosd = (double)time * this.sampleRate * (double)this.blockSize / 1.0E9;
                remainder = newPosd % (double)this.blockSize;
                newPos = (long)(newPosd - remainder);
                if (!(remainder > 0.0)) ** GOTO lbl36
                switch (rounding) {
                    case 1: {
                        newPos += (long)this.blockSize;
                        ** GOTO lbl36
                    }
                    case 3: {
                        if (remainder > (double)this.blockSize / 2.0) {
                            newPos += (long)this.blockSize;
                        }
                        ** GOTO lbl36
                    }
                    default: {
                        if (newPos <= this.maxLocation) break block21;
                    }
                }
            }
            blockNum = (double)time / this.timePerBlockNano;
            blockNumInt = (int)blockNum;
            remainder = blockNum - (double)blockNumInt;
            if (remainder > 0.0) {
                switch (rounding) {
                    case 1: {
                        ++blockNumInt;
                        break;
                    }
                    case 3: {
                        if (!(remainder > 0.5)) break;
                        ++blockNumInt;
                        break;
                    }
                }
            }
            newPos = blockNumInt * this.blockSize;
lbl36:
            // 4 sources

            if (newPos <= this.maxLocation) break block21;
            newPos = this.maxLocation;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(newPos += this.minLocation);
        if (this.cacheStream != null) {
            blockNum = this;
            synchronized (blockNum) {
                this.cacheStream.abortRead();
            }
        }
        return where;
    }

    public Time getMediaTime() {
        long seekLocation = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long location = seekLocation != -1L ? seekLocation - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)location * this.locationToMediaTime);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        long mediaSizeAtEOM;
        if (this.maxFrame <= 0 && this.tracks[0] != null && (mediaSizeAtEOM = ((BasicTrack)this.tracks[0]).getMediaSizeAtEOM()) > 0L) {
            this.maxFrame = (int)(mediaSizeAtEOM / (long)this.blockSize);
            double durationSeconds = (double)(this.maxFrame * this.samplesPerBlock) / this.sampleRate;
            if (durationSeconds > 0.0) {
                this.duration = new Time(durationSeconds);
            }
        }
        return this.duration;
    }

    public String getName() {
        return "Parser for AIFF file format";
    }

    private double readIeeeExtended(PullSourceStream stream) throws IOException {
        double f2 = 0.0;
        int expon = 0;
        long hiMant = 0L;
        long loMant = 0L;
        double huge = 3.4028234663852886E38;
        expon = this.readShort(stream);
        hiMant = this.readInt(stream);
        if (hiMant < 0L) {
            hiMant += 0x100000000L;
        }
        if ((loMant = (long)this.readInt(stream)) < 0L) {
            loMant += 0x100000000L;
        }
        if (expon == 0 && hiMant == 0L && loMant == 0L) {
            f2 = 0.0;
        } else if (expon == Short.MAX_VALUE) {
            f2 = huge;
        } else {
            expon -= 16383;
            f2 = (double)hiMant * Math.pow(2.0, expon -= 31);
            f2 += (double)loMant * Math.pow(2.0, expon -= 32);
        }
        return f2;
    }

    class AiffTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        AiffTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize, long minLocation, long maxLocation) {
            super(AiffParser.this, format, enabled, AiffParser.this.duration, startTime, numBuffers, bufferSize, AiffParser.this.stream, minLocation, maxLocation);
            AiffParser.this = AiffParser.this;
            double sampleRate = format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            if (AiffParser.this.timePerBlockNano == -1.0) {
                float bytesPerSecond = (float)(sampleRate * (double)AiffParser.this.blockSize);
                this.timePerFrame = (float)bufferSize / bytesPerSecond;
            } else {
                float blocksPerFrame = (float)bufferSize / (float)AiffParser.this.blockSize;
                float samplesPerFrame = blocksPerFrame * (float)AiffParser.this.samplesPerBlock;
                this.timePerFrame = (float)((double)samplesPerFrame / sampleRate);
            }
        }

        AiffTrack(AudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize) {
            this(format, enabled, startTime, numBuffers, bufferSize, 0L, Long.MAX_VALUE);
        }
    }
}

