/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.ms.security.PermissionID;
import com.ms.security.PolicyEngine;
import com.sun.media.JMFSecurity;
import com.sun.media.JMFSecurityManager;
import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class UDPPacketReceiver
implements PacketSource {
    DatagramSocket sock;
    int maxsize;
    String sessaddress;
    private static JMFSecurity jmfSecurity = null;
    private static boolean securityPrivelege;
    private Method[] m = new Method[1];
    private Class[] cl = new Class[1];
    private Object[][] args = new Object[1][0];

    public UDPPacketReceiver(DatagramSocket sock, int maxsize) {
        this.sock = sock;
        this.maxsize = maxsize;
        try {
            sock.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public UDPPacketReceiver(int remoteport, String remoteaddress, int maxsize) throws SocketException, UnknownHostException, IOException {
        InetAddress inetaddr = InetAddress.getByName(remoteaddress);
        if (inetaddr.isMulticastAddress()) {
            MulticastSocket sock = new MulticastSocket(remoteport);
            if (jmfSecurity != null) {
                try {
                    if (jmfSecurity.getName().startsWith("jmf-security")) {
                        jmfSecurity.requestPermission(this.m, this.cl, this.args, 512);
                        this.m[0].invoke((Object)this.cl[0], this.args[0]);
                    } else if (jmfSecurity.getName().startsWith("internet")) {
                        PolicyEngine.checkPermission((PermissionID)PermissionID.NETIO);
                        PolicyEngine.assertPermission((PermissionID)PermissionID.NETIO);
                    }
                }
                catch (Throwable e2) {
                    jmfSecurity.permissionFailureNotification(512);
                }
            }
            sock.joinGroup(InetAddress.getByName(remoteaddress));
            this.sessaddress = remoteaddress;
            this.sock = sock;
            this.maxsize = maxsize;
        } else {
            DatagramSocket dsock = new DatagramSocket(remoteport, InetAddress.getByName(remoteaddress));
            this.sessaddress = remoteaddress;
            this.sock = dsock;
            this.maxsize = maxsize;
        }
        try {
            this.sock.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            System.out.println("could not set timeout on socket");
        }
    }

    public Packet receiveFrom() throws IOException {
        DatagramPacket dp;
        int len;
        do {
            dp = new DatagramPacket(new byte[this.maxsize], this.maxsize);
            this.sock.receive(dp);
            len = dp.getLength();
            if (len <= this.maxsize >> 1) continue;
            this.maxsize = len << 1;
        } while (len >= dp.getData().length);
        UDPPacket p2 = new UDPPacket();
        p2.receiptTime = System.currentTimeMillis();
        p2.data = dp.getData();
        p2.offset = 0;
        p2.length = len;
        p2.datagrampacket = dp;
        p2.localPort = this.sock.getLocalPort();
        p2.remotePort = dp.getPort();
        p2.remoteAddress = dp.getAddress();
        return p2;
    }

    public void closeSource() {
        if (this.sock != null) {
            this.sock.close();
            this.sock = null;
        }
    }

    public String sourceString() {
        String s = "UDP Datagram Packet Receiver on port " + this.sock.getLocalPort() + "on local address " + this.sock.getLocalAddress();
        return s;
    }

    static {
        try {
            jmfSecurity = JMFSecurityManager.getJMFSecurity();
            securityPrivelege = true;
        }
        catch (SecurityException securityException) {}
    }
}

