/*
 * Decompiled with CFR 0.152.
 */
package javax.media.protocol;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import javax.media.Duration;
import javax.media.MediaLocator;
import javax.media.Time;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.InputSourceStream;
import javax.media.protocol.PullDataSource;
import javax.media.protocol.PullSourceStream;

public class URLDataSource
extends PullDataSource {
    protected URLConnection conn;
    protected ContentDescriptor contentType;
    protected URLSourceStream[] sources;
    protected boolean connected;

    protected URLDataSource() {
    }

    public URLDataSource(URL url) throws IOException {
        this.setLocator(new MediaLocator(url));
        this.connected = false;
    }

    public PullSourceStream[] getStreams() {
        if (!this.connected) {
            throw new Error("Unconnected source.");
        }
        return this.sources;
    }

    public void connect() throws IOException {
        this.conn = this.getLocator().getURL().openConnection();
        this.conn.connect();
        this.connected = true;
        String mimeType = this.conn.getContentType();
        if (mimeType == null) {
            mimeType = "UnknownContent";
        }
        this.contentType = new ContentDescriptor(ContentDescriptor.mimeTypeToPackageName(mimeType));
        this.sources = new URLSourceStream[1];
        this.sources[0] = new URLSourceStream(this.conn, this.contentType);
    }

    public String getContentType() {
        if (!this.connected) {
            throw new Error("Source is unconnected.");
        }
        return this.contentType.getContentType();
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.sources[0].close();
            }
            catch (IOException iOException) {}
            this.connected = false;
        }
    }

    public void start() throws IOException {
    }

    public void stop() throws IOException {
    }

    public Time getDuration() {
        return Duration.DURATION_UNKNOWN;
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String controlName) {
        return null;
    }

    class URLSourceStream
    extends InputSourceStream {
        protected URLConnection conn;

        public URLSourceStream(URLConnection conn, ContentDescriptor type) throws IOException {
            super(conn.getInputStream(), type);
            URLDataSource.this = URLDataSource.this;
            this.conn = conn;
        }

        public long getContentLength() {
            long len = this.conn.getContentLength();
            len = len == -1L ? -1L : len;
            return len;
        }
    }
}

