/*
 * Decompiled with CFR 0.152.
 */
package javax.media.rtp;

import java.net.InetAddress;

public class SessionAddress {
    private InetAddress m_dataAddress;
    private InetAddress m_controlAddress;
    private int m_dataPort;
    private int m_controlPort;
    public static final int ANY_PORT = -1;

    public SessionAddress(InetAddress dataAddress, int dataPort, InetAddress controlAddress, int controlPort) {
        this.m_dataAddress = dataAddress;
        this.m_controlAddress = controlAddress;
        this.m_dataPort = dataPort;
        this.m_controlPort = controlPort;
    }

    public SessionAddress() {
        this(null, -1, null, -1);
    }

    public InetAddress getDataAddress() {
        return this.m_dataAddress;
    }

    public int getDataPort() {
        return this.m_dataPort;
    }

    public InetAddress getControlAddress() {
        return this.m_controlAddress;
    }

    public int getControlPort() {
        return this.m_controlPort;
    }

    public boolean equals(Object obj) {
        if (obj instanceof SessionAddress) {
            SessionAddress otheraddr = (SessionAddress)obj;
            InetAddress otherdest = otheraddr.getDataAddress();
            InetAddress othercontl = otheraddr.getControlAddress();
            int dport = otheraddr.getDataPort();
            int cport = otheraddr.getControlPort();
            if (otherdest.equals(this.m_dataAddress) && othercontl.equals(this.m_controlAddress) && dport == this.m_dataPort && cport == this.m_controlPort) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return 1;
    }

    public String toString() {
        String s = "DataAddress " + this.m_dataAddress.toString() + "\n\tControlAddress " + this.m_controlAddress.toString() + "\n\tDataPort " + this.m_dataPort + "\n\tControlPort " + this.m_controlPort;
        return s;
    }
}

