/*
 * Decompiled with CFR 0.152.
 */
package javax.media.util;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.RGBFormat;

public class ImageToBuffer {
    private static ImageObserver iobs = null;

    public static Buffer createBuffer(Image image, float frameRate) {
        int blueMask;
        int greenMask;
        if (image == null) {
            return null;
        }
        if (iobs == null) {
            iobs = new 1();
        }
        int width = image.getWidth(iobs);
        int height = image.getHeight(iobs);
        if (width < 1 || height < 1) {
            return null;
        }
        int scan = width + 3 & 0xFFFFFFFC;
        Dimension size = new Dimension(width, height);
        int[] data = new int[scan * height];
        PixelGrabber pg = new PixelGrabber(image, 0, 0, width, height, data, 0, scan);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        ColorModel cm = pg.getColorModel();
        if (!(cm instanceof DirectColorModel)) {
            return null;
        }
        DirectColorModel dcm = (DirectColorModel)cm;
        int redMask = dcm.getRedMask();
        if ((redMask | (greenMask = dcm.getGreenMask()) | (blueMask = dcm.getBlueMask())) != 0xFFFFFF) {
            return null;
        }
        RGBFormat rgb = new RGBFormat(size, scan * height, Format.intArray, frameRate, 32, 1, redMask, greenMask, blueMask, 1, scan, 0, -1);
        Buffer buffer = new Buffer();
        buffer.setOffset(0);
        buffer.setLength(scan * height);
        buffer.setHeader(null);
        buffer.setFlags(0);
        buffer.setData(data);
        buffer.setFormat(rgb);
        buffer.setTimeStamp(-1L);
        buffer.setSequenceNumber(0L);
        return buffer;
    }

    private final class 1
    implements ImageObserver {
        public boolean imageUpdate(Image im, int info, int x, int y, int w, int h2) {
            return false;
        }

        /* synthetic */ 1() {
        }
    }
}

