/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.control.BufferControl;
import javax.media.rtp.SessionManager;
import rtp.ParticipantListWindow;
import rtp.RTPUtil;

public class RTPDialog
extends Dialog
implements ActionListener,
TextListener {
    public static final String ACTION_OPEN = "Open";
    public static final String ACTION_CANCEL = "Cancel";
    private TextField fieldAddress1;
    private TextField fieldAddress2;
    private TextField fieldAddress3;
    private TextField fieldAddress4;
    private TextField fieldPort;
    private Choice choiceTtl;
    private Button buttonOpen;
    private Button buttonCancel;
    private JMStudio parent;
    private RTPUtil rtpUtil;
    private SessionManager manager;
    private Integer closeLock = new Integer(0);
    Button monitorb;
    Button closeb;
    Button bufferb;
    Panel mypanel;

    public RTPDialog(Frame frame) {
        super(frame, false);
        this.parent = (JMStudio)frame;
        this.addWindowListener(new 1());
        this.init();
    }

    private void init() {
        this.setTitle("Open RTP Session");
        this.setLayout(new BorderLayout());
        BorderedPanel panelContent = new BorderedPanel(new BorderLayout(6, 6));
        panelContent.setEmptyBorder(6, 6, 6, 6);
        this.add((Component)panelContent, "Center");
        panelContent.setBackground(Color.lightGray);
        Panel panel = this.createPanelSource();
        panelContent.add((Component)panel, "Center");
        panel = this.createPanelButtons();
        panelContent.add((Component)panel, "South");
        this.pack();
        this.setResizable(false);
        this.show();
    }

    private Panel createPanelSource() {
        Panel panelSource = new Panel(new BorderLayout(6, 6));
        Panel panelLabels = new Panel(new GridLayout(0, 1, 6, 6));
        panelSource.add((Component)panelLabels, "West");
        Panel panelParams = new Panel(new GridLayout(0, 1, 6, 6));
        panelSource.add((Component)panelParams, "Center");
        Label label = new Label("Address:");
        panelLabels.add(label);
        Panel panelAddress = new Panel(new GridLayout(1, 0, 2, 2));
        panelParams.add(panelAddress);
        this.fieldAddress1 = new TextField(3);
        this.fieldAddress1.addTextListener(this);
        panelAddress.add(this.fieldAddress1);
        this.fieldAddress2 = new TextField(3);
        this.fieldAddress2.addTextListener(this);
        panelAddress.add(this.fieldAddress2);
        this.fieldAddress3 = new TextField(3);
        this.fieldAddress3.addTextListener(this);
        panelAddress.add(this.fieldAddress3);
        this.fieldAddress4 = new TextField(3);
        this.fieldAddress4.addTextListener(this);
        panelAddress.add(this.fieldAddress4);
        label = new Label("Port:");
        panelLabels.add(label);
        this.fieldPort = new TextField(5);
        panelParams.add(this.fieldPort);
        label = new Label("TTL:");
        panelLabels.add(label);
        this.choiceTtl = new Choice();
        panelParams.add(this.choiceTtl);
        this.choiceTtl.addItem("1");
        this.choiceTtl.addItem("2");
        this.choiceTtl.addItem("3");
        this.choiceTtl.addItem("4");
        this.choiceTtl.addItem("8");
        this.choiceTtl.addItem("16");
        this.choiceTtl.addItem("32");
        this.choiceTtl.addItem("64");
        this.choiceTtl.addItem("128");
        this.choiceTtl.addItem("255");
        return panelSource;
    }

    private Panel createPanelButtons() {
        Panel panelButtons = new Panel(new FlowLayout(1));
        Panel panel = new Panel(new GridLayout(1, 0, 6, 6));
        panelButtons.add(panel);
        this.buttonOpen = new Button(ACTION_OPEN);
        this.buttonOpen.addActionListener(this);
        panel.add(this.buttonOpen);
        this.buttonCancel = new Button(ACTION_CANCEL);
        this.buttonCancel.addActionListener(this);
        panel.add(this.buttonCancel);
        return panelButtons;
    }

    public void setVisible(boolean show) {
        super.setVisible(show);
        this.fieldAddress1.requestFocus();
    }

    public void open() {
        if (this.openSession()) {
            this.setVisible(false);
            this.parent.killThePlayer();
            while (this.parent.player != null) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.mypanel = new Panel(new BorderLayout());
            this.parent.add((Component)this.mypanel, "North");
            this.monitorb = new Button("Participant List for " + this.getRtpSessionString());
            this.mypanel.add((Component)this.monitorb, "North");
            this.bufferb = new Button("Buffer Control for RTP Session");
            this.mypanel.add((Component)this.bufferb, "South");
            this.closeb = new Button("Close RTP Session ");
            this.mypanel.add((Component)this.closeb, "Center");
            this.closeb.addActionListener(new 2());
            this.monitorb.addActionListener(new 3());
            this.bufferb.addActionListener(new 4());
            this.parent.pack();
            this.parent.show();
            this.parent.checkMenu();
        }
    }

    public void close() {
        Integer n2 = this.closeLock;
        synchronized (n2) {
            if (this.closeb == null) {
                Object var2_2 = null;
                return;
            }
            if (this.manager != null) {
                this.rtpUtil.closeManager();
                this.manager = null;
            }
            this.mypanel.remove(this.monitorb);
            this.mypanel.remove(this.closeb);
            this.mypanel.remove(this.bufferb);
            this.parent.remove(this.mypanel);
            this.parent.rtpd = null;
            this.parent.checkMenu();
            this.parent.setBlankSize();
            this.monitorb = null;
            this.closeb = null;
            this.bufferb = null;
            this.mypanel = null;
            this.parent = null;
        }
    }

    public void cancel() {
        this.setVisible(false);
        this.parent.rtpd = null;
        this.parent.checkMenu();
    }

    public boolean openSession() {
        int nValue;
        String strValue = this.fieldAddress1.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog((Frame)this.parent, "Invalid session address.");
            return false;
        }
        String strAddress = new String(strValue);
        strValue = this.fieldAddress2.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog((Frame)this.parent, "Invalid session address.");
            return false;
        }
        strAddress = String.valueOf(strAddress) + "." + strValue;
        strValue = this.fieldAddress3.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog((Frame)this.parent, "Invalid session address.");
            return false;
        }
        strAddress = String.valueOf(strAddress) + "." + strValue;
        strValue = this.fieldAddress4.getText();
        try {
            nValue = Integer.valueOf(strValue);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || nValue > 255) {
            MessageDialog.createErrorDialog((Frame)this.parent, "Invalid session address.");
            return false;
        }
        strAddress = String.valueOf(strAddress) + "." + strValue;
        String strPort = this.fieldPort.getText();
        try {
            nValue = Integer.valueOf(strPort);
        }
        catch (Exception exception) {
            nValue = -1;
        }
        if (nValue < 0 || (nValue & 1) == 1) {
            MessageDialog.createErrorDialog((Frame)this.parent, "Invalid port number. Value shoud be even.");
            return false;
        }
        String strTtl = this.choiceTtl.getSelectedItem();
        try {
            this.rtpUtil = new RTPUtil();
            this.manager = this.rtpUtil.createManager(strAddress, strPort, strTtl, true, false);
        }
        catch (Exception exception) {
            MessageDialog.createErrorDialog(this.parent, "Failed to create Session Manager.", exception);
            return false;
        }
        return true;
    }

    public void monitor() {
        if (this.manager != null) {
            new ParticipantListWindow(this.manager);
        }
    }

    public void buffercontrol() {
        if (this.manager != null) {
            BufferControl b2 = (BufferControl)this.manager.getControl("javax.media.control.BufferControl");
            Component c2 = null;
            if (b2 != null) {
                c2 = b2.getControlComponent();
            }
            this.mypanel.remove(this.bufferb);
            this.mypanel.add(c2, "South");
            this.parent.pack();
            this.parent.show();
        }
    }

    public void actionPerformed(ActionEvent event) {
        String strCmd = event.getActionCommand();
        if (strCmd.equals(ACTION_OPEN)) {
            this.open();
        } else if (strCmd.equals(ACTION_CANCEL)) {
            this.cancel();
        }
    }

    public void textValueChanged(TextEvent event) {
        TextField textField;
        String strValue;
        Object objectSource = event.getSource();
        if (objectSource instanceof TextField && (strValue = (textField = (TextField)objectSource).getText()).length() > 2) {
            textField.transferFocus();
        }
    }

    private String getRtpSessionString() {
        String strAddress = "rtp://";
        String strValue = this.fieldAddress1.getText();
        strAddress = String.valueOf(strAddress) + strValue;
        strValue = this.fieldAddress2.getText();
        strAddress = String.valueOf(strAddress) + "." + strValue;
        strValue = this.fieldAddress3.getText();
        strAddress = String.valueOf(strAddress) + "." + strValue;
        strValue = this.fieldAddress4.getText();
        strAddress = String.valueOf(strAddress) + "." + strValue;
        String strPort = this.fieldPort.getText();
        strAddress = String.valueOf(strAddress) + ":" + strPort;
        String strTtl = this.choiceTtl.getSelectedItem();
        strAddress = String.valueOf(strAddress) + "/" + strTtl;
        return strAddress;
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            RTPDialog.this.cancel();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            RTPDialog.this.close();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            RTPDialog.this.monitor();
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent e2) {
            RTPDialog.this.buffercontrol();
        }

        /* synthetic */ 4() {
        }
    }
}

