/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicToolTipUI
extends ToolTipUI {
    static BasicToolTipUI sharedInstance = new BasicToolTipUI();
    private PropertyChangeListener propertyChangeListener;

    private PropertyChangeListener createPropertyChangeListener(JComponent jComponent) {
        return new PropertyChangeHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return sharedInstance;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        System.out.println("Max Size = " + dimension);
        return dimension;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        View view = (View)jComponent.getClientProperty("html");
        if (view != null) {
            dimension.width = (int)((float)dimension.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        System.out.println("Min Size = " + dimension);
        return dimension;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Insets insets = jComponent.getInsets();
        Dimension dimension = new Dimension(insets.left + insets.right, insets.top + insets.bottom);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null || string.equals("")) {
            string = "";
        } else {
            View view;
            View view2 = view = jComponent != null ? (View)jComponent.getClientProperty("html") : null;
            if (view != null) {
                dimension.width += (int)view.getPreferredSpan(0);
                dimension.height += (int)view.getPreferredSpan(1);
            } else {
                dimension.width += SwingUtilities.computeStringWidth(fontMetrics, string);
                dimension.height += fontMetrics.getHeight();
            }
        }
        return dimension;
    }

    private void installComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, ((JToolTip)jComponent).getTipText());
    }

    protected void installDefaults(JComponent jComponent) {
        LookAndFeel.installColorsAndFont(jComponent, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(jComponent, "ToolTip.border");
    }

    protected void installListeners(JComponent jComponent) {
        this.propertyChangeListener = this.createPropertyChangeListener(jComponent);
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    public void installUI(JComponent jComponent) {
        this.installDefaults(jComponent);
        this.installComponents(jComponent);
        this.installListeners(jComponent);
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        Dimension dimension = jComponent.getSize();
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        graphics.setFont(font);
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null) {
            string = "";
        }
        if (string != null) {
            View view = (View)jComponent.getClientProperty("html");
            if (view != null) {
                Rectangle rectangle = jComponent.getBounds();
                Insets insets = jComponent.getInsets();
                rectangle.x += insets.left;
                rectangle.y += insets.top;
                rectangle.width -= insets.left + insets.right;
                rectangle.height -= insets.top + insets.bottom;
                view.paint(graphics, rectangle);
            } else {
                graphics.drawString(((JToolTip)jComponent).getTipText(), 3, 2 + fontMetrics.getAscent());
            }
        }
    }

    private void uninstallComponents(JComponent jComponent) {
        BasicHTML.updateRenderer(jComponent, "");
    }

    protected void uninstallDefaults(JComponent jComponent) {
        LookAndFeel.uninstallBorder(jComponent);
    }

    protected void uninstallListeners(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults(jComponent);
        this.uninstallComponents(jComponent);
        this.uninstallListeners(jComponent);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("tiptext")) {
                JToolTip jToolTip = (JToolTip)propertyChangeEvent.getSource();
                String string2 = jToolTip.getTipText();
                BasicHTML.updateRenderer(jToolTip, string2);
            }
        }
    }
}

