/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.rtp.util;

import com.sun.media.rtp.util.Packet;
import com.sun.media.rtp.util.PacketConsumer;
import com.sun.media.rtp.util.PacketSource;
import com.sun.media.rtp.util.UDPPacket;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Vector;
import javax.media.rtp.SessionAddress;

public abstract class PacketFilter
implements PacketSource,
PacketConsumer {
    PacketSource source;
    PacketConsumer consumer;
    public Vector destaddresslist;
    public Vector peerlist;
    public boolean control = false;

    public abstract Packet handlePacket(Packet var1);

    public abstract Packet handlePacket(Packet var1, int var2);

    public Packet receiveFrom() throws IOException {
        Packet p2 = null;
        Packet rawp = this.source.receiveFrom();
        if (rawp != null) {
            p2 = this.handlePacket(rawp);
        }
        return p2;
    }

    public void sendTo(Packet p2) throws IOException {
        Packet origpacket = p2;
        if (this.peerlist != null) {
            p2 = this.handlePacket(origpacket);
            int i2 = 0;
            while (i2 < this.peerlist.size()) {
                SessionAddress a2 = (SessionAddress)this.peerlist.elementAt(i2);
                if (!this.control) {
                    ((UDPPacket)p2).remoteAddress = a2.getDataAddress();
                    ((UDPPacket)p2).remotePort = a2.getDataPort();
                } else {
                    ((UDPPacket)p2).remoteAddress = a2.getControlAddress();
                    ((UDPPacket)p2).remotePort = a2.getControlPort();
                }
                if (p2 != null && this.consumer != null) {
                    this.consumer.sendTo(p2);
                }
                ++i2;
            }
        } else if (this.destaddresslist != null) {
            int i3 = 0;
            while (i3 < this.destaddresslist.size()) {
                InetAddress remoteAddr = (InetAddress)this.destaddresslist.elementAt(i3);
                p2 = this.handlePacket(origpacket, i3);
                if (p2 != null && this.consumer != null) {
                    this.consumer.sendTo(p2);
                }
                ++i3;
            }
        } else if (this.destaddresslist == null && (p2 = this.handlePacket(p2)) != null && this.consumer != null) {
            this.consumer.sendTo(p2);
        }
    }

    public void close() {
    }

    public void closeSource() {
        this.close();
        if (this.source != null) {
            this.source.closeSource();
        }
    }

    public void closeConsumer() {
        this.close();
        if (this.consumer != null) {
            this.consumer.closeConsumer();
        }
    }

    public PacketConsumer getConsumer() {
        return this.consumer;
    }

    public PacketSource getSource() {
        return this.source;
    }

    public Vector getDestList() {
        return null;
    }

    public void setConsumer(PacketConsumer c2) {
        this.consumer = c2;
    }

    public void setSource(PacketSource s) {
        this.source = s;
    }

    public String filtername() {
        return this.getClass().getName();
    }

    public String consumerString() {
        if (this.consumer == null) {
            return this.filtername();
        }
        return String.valueOf(this.filtername()) + " connected to " + this.consumer.consumerString();
    }

    public String sourceString() {
        if (this.source == null) {
            return this.filtername();
        }
        return String.valueOf(this.filtername()) + " attached to " + this.source.sourceString();
    }
}

