/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.media.CachingControl;
import javax.media.CachingControlEvent;
import javax.media.Control;
import javax.media.ControllerClosedEvent;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Player;
import javax.media.PrefetchCompleteEvent;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.Time;
import javax.media.format.FormatChangeEvent;

public class PlayerWindow
extends Frame
implements ControllerListener {
    Player player;
    Panel framePanel;
    ComponentListener cl;
    ComponentListener fcl;
    WindowListener wl;
    MouseListener ml;
    Component controlComp;
    Component visualComp;
    Insets insets;
    PopupMenu zoomMenu;
    boolean windowCreated = false;
    boolean newVideo = true;
    boolean panelResized = false;
    boolean autoStart = true;
    boolean autoLoop = true;
    Component progressBar;
    private Integer playerLock = new Integer(1);

    public PlayerWindow(Player player) {
        this(player, "Java Media Player", true, true);
    }

    public PlayerWindow(Player player, String title) {
        this(player, title, true, true);
    }

    public PlayerWindow(Player player, String title, boolean autoStart) {
        this(player, title, autoStart, true);
    }

    public PlayerWindow(Player player, String title, boolean autoStart, boolean autoLoop) {
        super(title);
        this.autoStart = autoStart;
        this.autoLoop = autoLoop;
        this.player = player;
        this.setLayout(new BorderLayout());
        this.framePanel = new Panel();
        this.framePanel.setLayout(null);
        this.add((Component)this.framePanel, "Center");
        this.insets = this.getInsets();
        ((Component)this).setSize(this.insets.left + this.insets.right + 320, this.insets.top + this.insets.bottom + 30);
        ((Component)this).setVisible(true);
        this.wl = new 1();
        this.addWindowListener(this.wl);
        this.fcl = new 2();
        this.framePanel.addComponentListener(this.fcl);
        this.fcl = new 3();
        this.addComponentListener(this.fcl);
        player.addControllerListener(this);
        player.realize();
    }

    void sleep(long time) {
        try {
            Thread.currentThread();
            Thread.sleep(time);
        }
        catch (Exception exception) {}
    }

    public void addNotify() {
        super.addNotify();
        this.windowCreated = true;
        this.invalidate();
    }

    public void doResize() {
        Dimension d2 = this.framePanel.getSize();
        int videoHeight = d2.height;
        if (this.controlComp != null) {
            if ((videoHeight -= this.controlComp.getPreferredSize().height) < 2) {
                videoHeight = 2;
            }
            if (d2.width < 80) {
                d2.width = 80;
            }
            this.controlComp.setBounds(0, videoHeight, d2.width, this.controlComp.getPreferredSize().height);
            this.controlComp.invalidate();
        }
        if (this.visualComp != null) {
            this.visualComp.setBounds(0, 0, d2.width, videoHeight);
        }
        this.framePanel.validate();
    }

    public void killThePlayer() {
        Integer n2 = this.playerLock;
        synchronized (n2) {
            if (this.visualComp != null) {
                this.framePanel.remove(this.visualComp);
                this.visualComp = null;
            }
            if (this.controlComp != null) {
                this.framePanel.remove(this.controlComp);
                this.controlComp = null;
            }
            if (this.player != null) {
                this.player.close();
            }
        }
    }

    public void controllerUpdate(ControllerEvent ce) {
        Integer n2 = this.playerLock;
        synchronized (n2) {
            CachingControl cc;
            if (ce instanceof RealizeCompleteEvent) {
                int width = 320;
                int height = 0;
                this.insets = this.getInsets();
                if (this.progressBar != null) {
                    this.framePanel.remove(this.progressBar);
                }
                if ((this.visualComp = this.player.getVisualComponent()) != null) {
                    width = this.visualComp.getPreferredSize().width;
                    height = this.visualComp.getPreferredSize().height;
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, width, height);
                    this.addPopupMenu(this.visualComp);
                } else {
                    Control mc = this.player.getControl("javax.media.control.MonitorControl");
                    if (mc != null) {
                        this.visualComp = mc.getControlComponent();
                        width = this.visualComp.getPreferredSize().width;
                        height = this.visualComp.getPreferredSize().height;
                        this.framePanel.add(this.visualComp);
                        this.visualComp.setBounds(0, 0, width, height);
                    }
                }
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null) {
                    int prefHeight = this.controlComp.getPreferredSize().height;
                    this.framePanel.add(this.controlComp);
                    this.controlComp.setBounds(0, height, width, prefHeight);
                    height += prefHeight;
                }
                ((Component)this).setSize(width + this.insets.left + this.insets.right, height + this.insets.top + this.insets.bottom);
                if (this.autoStart) {
                    this.player.prefetch();
                }
            } else if (ce instanceof PrefetchCompleteEvent) {
                if (this.visualComp != null) {
                    Dimension vSize = this.visualComp.getPreferredSize();
                    if (this.controlComp != null) {
                        vSize.height += this.controlComp.getPreferredSize().height;
                    }
                    this.panelResized = false;
                    ((Component)this).setSize(vSize.width + this.insets.left + this.insets.right, vSize.height + this.insets.top + this.insets.bottom);
                    int waited = 0;
                    while (!this.panelResized && waited < 2000) {
                        try {
                            waited += 50;
                            Thread.currentThread();
                            Thread.sleep(50L);
                            Thread.currentThread();
                            Thread.yield();
                        }
                        catch (Exception exception) {}
                    }
                } else {
                    int height = 1;
                    if (this.controlComp != null) {
                        height = this.controlComp.getPreferredSize().height;
                    }
                    ((Component)this).setSize(320 + this.insets.left + this.insets.right, height + this.insets.top + this.insets.bottom);
                }
                if (this.autoStart && this.player.getTargetState() != 600) {
                    this.player.start();
                }
            } else if (ce instanceof EndOfMediaEvent) {
                if (this.autoLoop) {
                    this.player.setMediaTime(new Time(0L));
                    this.player.start();
                }
            } else if (ce instanceof ControllerErrorEvent) {
                System.err.println("Received controller error");
                this.killThePlayer();
                this.dispose();
            } else if (ce instanceof SizeChangeEvent) {
                if (this.framePanel != null) {
                    SizeChangeEvent sce = (SizeChangeEvent)ce;
                    int nooWidth = sce.getWidth();
                    int nooHeight = sce.getHeight();
                    if (this.controlComp != null) {
                        nooHeight += this.controlComp.getPreferredSize().height;
                    }
                    if (this.framePanel.getSize().width != nooWidth || this.framePanel.getSize().height != nooHeight) {
                        ((Component)this).setSize(nooWidth + this.insets.left + this.insets.right, nooHeight + this.insets.top + this.insets.bottom);
                    } else {
                        this.doResize();
                    }
                    if (this.controlComp != null) {
                        this.controlComp.invalidate();
                    }
                }
            } else if (ce instanceof FormatChangeEvent) {
                Dimension vSize = new Dimension(320, 0);
                Component oldVisualComp = this.visualComp;
                this.visualComp = this.player.getVisualComponent();
                if (this.visualComp != null && oldVisualComp != this.visualComp) {
                    if (oldVisualComp != null && this.zoomMenu != null) {
                        oldVisualComp.remove(this.zoomMenu);
                    }
                    this.framePanel.remove(oldVisualComp);
                    vSize = this.visualComp.getPreferredSize();
                    this.framePanel.add(this.visualComp);
                    this.visualComp.setBounds(0, 0, vSize.width, vSize.height);
                    this.addPopupMenu(this.visualComp);
                }
                Component oldComp = this.controlComp;
                this.controlComp = this.player.getControlPanelComponent();
                if (this.controlComp != null && oldComp != this.controlComp) {
                    this.framePanel.remove(oldComp);
                    this.framePanel.add(this.controlComp);
                    if (this.controlComp != null) {
                        int prefHeight = this.controlComp.getPreferredSize().height;
                        this.controlComp.setBounds(0, vSize.height, vSize.width, prefHeight);
                    }
                }
            } else if (ce instanceof ControllerClosedEvent) {
                if (this.visualComp != null) {
                    if (this.zoomMenu != null) {
                        this.visualComp.remove(this.zoomMenu);
                    }
                    this.visualComp.removeMouseListener(this.ml);
                }
                this.removeWindowListener(this.wl);
                this.removeComponentListener(this.cl);
                if (this.framePanel != null) {
                    this.framePanel.removeAll();
                }
                this.player = null;
                this.visualComp = null;
                this.controlComp = null;
                this.sleep(200L);
                this.dispose();
            } else if (ce instanceof CachingControlEvent && (cc = ((CachingControlEvent)ce).getCachingControl()) != null && this.progressBar == null) {
                this.progressBar = cc.getControlComponent();
                if (this.progressBar == null) {
                    this.progressBar = cc.getProgressBarComponent();
                }
                if (this.progressBar != null) {
                    this.framePanel.add(this.progressBar);
                    Dimension prefSize = this.progressBar.getPreferredSize();
                    this.progressBar.setBounds(0, 0, prefSize.width, prefSize.height);
                    this.insets = this.getInsets();
                    this.framePanel.setSize(prefSize.width, prefSize.height);
                    ((Component)this).setSize(this.insets.left + this.insets.right + prefSize.width, this.insets.top + this.insets.bottom + prefSize.height);
                }
            }
        }
    }

    public void zoomTo(float z) {
        if (this.visualComp != null) {
            this.insets = this.getInsets();
            Dimension d2 = this.visualComp.getPreferredSize();
            d2.width = (int)((float)d2.width * z);
            d2.height = (int)((float)d2.height * z);
            if (this.controlComp != null) {
                d2.height += this.controlComp.getPreferredSize().height;
            }
            ((Component)this).setSize(d2.width + this.insets.left + this.insets.right, d2.height + this.insets.top + this.insets.bottom);
        }
    }

    private void addPopupMenu(Component visual) {
        this.zoomMenu = new PopupMenu("Zoom");
        4 zoomSelect = new 4();
        visual.add(this.zoomMenu);
        MenuItem mi = new MenuItem("Scale 1:2");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 1:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 2:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        mi = new MenuItem("Scale 4:1");
        this.zoomMenu.add(mi);
        mi.addActionListener(zoomSelect);
        this.ml = new 5();
        visual.addMouseListener(this.ml);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent we) {
            PlayerWindow.this.killThePlayer();
        }

        /* synthetic */ 1() {
        }
    }

    private final class 2
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            PlayerWindow.this.panelResized = true;
            PlayerWindow.this.doResize();
        }

        /* synthetic */ 2() {
        }
    }

    private final class 3
    extends ComponentAdapter {
        public void componentResized(ComponentEvent ce) {
            PlayerWindow.this.insets = PlayerWindow.this.getInsets();
            Dimension dim = PlayerWindow.this.getSize();
            PlayerWindow.this.framePanel.setSize(dim.width - PlayerWindow.this.insets.left - PlayerWindow.this.insets.right, dim.height - PlayerWindow.this.insets.top - PlayerWindow.this.insets.bottom);
        }

        /* synthetic */ 3() {
        }
    }

    private final class 4
    implements ActionListener {
        public void actionPerformed(ActionEvent ae) {
            String action = ae.getActionCommand();
            if (action.indexOf("1:2") >= 0) {
                PlayerWindow.this.zoomTo(0.5f);
            } else if (action.indexOf("1:1") >= 0) {
                PlayerWindow.this.zoomTo(1.0f);
            } else if (action.indexOf("2:1") >= 0) {
                PlayerWindow.this.zoomTo(2.0f);
            } else if (action.indexOf("4:1") >= 0) {
                PlayerWindow.this.zoomTo(4.0f);
            }
        }

        /* synthetic */ 4() {
        }
    }

    private final class 5
    extends MouseAdapter {
        public void mousePressed(MouseEvent me) {
            if (me.isPopupTrigger()) {
                PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
            }
        }

        public void mouseReleased(MouseEvent me) {
            if (me.isPopupTrigger()) {
                PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
            }
        }

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                PlayerWindow.this.zoomMenu.show(PlayerWindow.this.visualComp, me.getX(), me.getY());
            }
        }

        /* synthetic */ 5() {
        }
    }
}

