/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.util;

public class ByteBuffer {
    public byte[] buffer;
    public int offset;
    public int length;
    public int size;

    public ByteBuffer(int size) {
        this.size = size;
        this.buffer = new byte[size];
    }

    public final void clear() {
        this.offset = 0;
        this.length = 0;
    }

    public final void writeBytes(String s) {
        byte[] bytes = s.getBytes();
        this.writeBytes(bytes);
    }

    public final void writeBytes(byte[] bytes) {
        System.arraycopy(bytes, 0, this.buffer, this.offset, bytes.length);
        this.offset += bytes.length;
        this.length += bytes.length;
    }

    public final void writeInt(int value) {
        this.buffer[this.offset] = (byte)(value >> 24 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(value >> 16 & 0xFF);
        this.buffer[this.offset + 2] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.offset + 3] = (byte)(value & 0xFF);
        this.offset += 4;
        this.length += 4;
    }

    public final void writeIntLittleEndian(int value) {
        this.buffer[this.offset + 3] = (byte)(value >>> 24 & 0xFF);
        this.buffer[this.offset + 2] = (byte)(value >>> 16 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(value >>> 8 & 0xFF);
        this.buffer[this.offset] = (byte)(value & 0xFF);
        this.offset += 4;
        this.length += 4;
    }

    public final void writeShort(short value) {
        this.buffer[this.offset] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.offset + 1] = (byte)(value & 0xFF);
        this.offset += 2;
        this.length += 2;
    }

    public final void writeShortLittleEndian(short value) {
        this.buffer[this.offset + 1] = (byte)(value >> 8 & 0xFF);
        this.buffer[this.offset] = (byte)(value & 0xFF);
        this.offset += 2;
        this.length += 2;
    }

    public final void writeByte(byte value) {
        this.buffer[this.offset] = value;
        ++this.offset;
        ++this.length;
    }
}

