/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.media.rtp.SendStream;
import javax.media.rtp.SendStreamListener;
import javax.media.rtp.SessionManager;
import javax.media.rtp.event.NewSendStreamEvent;
import javax.media.rtp.event.SendStreamEvent;
import javax.media.rtp.event.StreamClosedEvent;
import rtp.OverallTransStatsWindow;

public class RTPSendStreamWindow
extends Frame
implements SendStreamListener,
ActionListener {
    SessionManager manager;
    Button closeb;
    Button stopb;
    Button transstats;
    Button startb;
    SendStream sendstream;
    RTPStreamBar sb;

    public RTPSendStreamWindow(SessionManager mgr) {
        super("RTP Transmission");
        this.setLayout(new FlowLayout());
        this.manager = mgr;
        this.manager.addSendStreamListener(this);
        this.transstats = new Button("Global Transmission Statistics");
        this.transstats.addActionListener(this);
        this.add(this.transstats);
        ((Component)this).setVisible(true);
        this.addWindowListener(new 1());
    }

    public void update(SendStreamEvent evt) {
        if (evt instanceof NewSendStreamEvent) {
            this.sendstream = ((NewSendStreamEvent)evt).getSendStream();
            this.sb = new RTPStreamBar(evt.getSendStream(), this);
            this.add(this.sb);
            this.pack();
            ((Component)this).setVisible(true);
        }
        if (evt instanceof StreamClosedEvent) {
            this.closeSendStream(evt.getSendStream());
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Button source = (Button)evt.getSource();
        if (source.getLabel().equals("Global Transmission Statistics")) {
            new OverallTransStatsWindow(this.manager);
        }
        if (source.getLabel().equals("Close")) {
            this.sendstream.close();
        }
        if (source.getLabel().equals("Stop")) {
            try {
                this.sendstream.stop();
                this.sb.remove(this.stopb);
                this.sb.add(this.startb);
                this.sb.setVisible(true);
            }
            catch (IOException e2) {
                e2.getMessage();
            }
        }
        if (source.getLabel().equals("Start")) {
            try {
                this.sendstream.start();
                this.sb.remove(this.startb);
                this.sb.add(this.stopb);
                this.sb.setVisible(true);
            }
            catch (IOException e3) {
                e3.getMessage();
            }
        }
        ((Component)this).setVisible(true);
    }

    private void close() {
        this.dispose();
    }

    public void closeSendStream(SendStream s) {
        this.remove(this.sb);
        this.remove(this.transstats);
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            RTPSendStreamWindow.this.close();
        }

        /* synthetic */ 1() {
        }
    }

    public class RTPStreamBar
    extends Panel {
        public RTPStreamBar(SendStream s, ActionListener a2) {
            RTPSendStreamWindow.this = RTPSendStreamWindow.this;
            RTPSendStreamWindow.this.closeb = new Button("Close");
            this.add(RTPSendStreamWindow.this.closeb);
            RTPSendStreamWindow.this.closeb.addActionListener(a2);
            RTPSendStreamWindow.this.stopb = new Button("Stop");
            this.add(RTPSendStreamWindow.this.stopb);
            RTPSendStreamWindow.this.stopb.addActionListener(a2);
            RTPSendStreamWindow.this.startb = new Button("Start");
            RTPSendStreamWindow.this.startb.addActionListener(a2);
            this.setVisible(true);
        }
    }
}

