/*
 * Decompiled with CFR 0.152.
 */
package rtp;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceptionStats;

public class RTPStatsWindow
extends Frame
implements Runnable {
    ReceiveStream stream;
    Thread thread;
    TextField pdulost;
    TextField pduproc;
    TextField pdumisord;
    TextField pduinvalid;
    TextField pdudup;
    GridBagLayout gridbag;
    GridBagConstraints c;

    public RTPStatsWindow(ReceiveStream stream) {
        super("Source RTP Statistics");
        ((Component)this).setSize(220, 500);
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.c.fill = 2;
        this.c.anchor = 18;
        this.c.weightx = 1.0;
        this.c.weighty = 1.0;
        this.setLayout(this.gridbag);
        this.show();
        this.stream = stream;
        Label lpdu = new Label("Lost PDU");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(lpdu, this.c);
        this.add(lpdu);
        this.pdulost = new TextField(10);
        this.pdulost.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.pdulost, this.c);
        this.add(this.pdulost);
        Label ppdu = new Label("Processed PDU");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(ppdu, this.c);
        this.add(ppdu);
        this.pduproc = new TextField(10);
        this.pduproc.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.pduproc, this.c);
        this.add(this.pduproc);
        Label mispdu = new Label("Misordered PDU");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(mispdu, this.c);
        this.add(mispdu);
        this.pdumisord = new TextField(10);
        this.pdumisord.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.pdumisord, this.c);
        this.add(this.pdumisord);
        Label invalid = new Label("Invalid PDU");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(invalid, this.c);
        this.add(invalid);
        this.pduinvalid = new TextField(10);
        this.pduinvalid.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.pduinvalid, this.c);
        this.add(this.pduinvalid);
        Label dup = new Label("Duplicate PDU");
        this.c.gridwidth = -1;
        this.gridbag.setConstraints(dup, this.c);
        this.add(dup);
        this.pdudup = new TextField(10);
        this.pdudup.setEditable(false);
        this.c.gridwidth = 0;
        this.gridbag.setConstraints(this.pdudup, this.c);
        this.add(this.pdudup);
        this.show();
        this.addWindowListener(new 1());
        this.thread = new Thread((Runnable)this, "RTPStream Stats Thread");
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public void close() {
        this.thread.stop();
        this.dispose();
    }

    public void run() {
        while (true) {
            ReceptionStats stats = this.stream.getSourceReceptionStats();
            ((TextComponent)this.pdulost).setText(new Integer(stats.getPDUlost()).toString());
            ((TextComponent)this.pduproc).setText(new Integer(stats.getPDUProcessed()).toString());
            ((TextComponent)this.pdumisord).setText(new Integer(stats.getPDUMisOrd()).toString());
            ((TextComponent)this.pduinvalid).setText(new Integer(stats.getPDUInvalid()).toString());
            ((TextComponent)this.pdudup).setText(new Integer(stats.getPDUDuplicate()).toString());
            if (this.isShowing()) {
                this.show();
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private final class 1
    extends WindowAdapter {
        public void windowClosing(WindowEvent e2) {
            RTPStatsWindow.this.close();
        }

        /* synthetic */ 1() {
        }
    }
}

