/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminComputers {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayComputerEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("computer_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("type");
        if (object == null) {
            object = "host_name";
        }
        if (((String)object).equalsIgnoreCase("host_name")) {
            string = DString.replace(string, "%type_host_name%", "CHECKED");
            string = DString.replace(string, "%type_ip_address%", "");
            string = DString.replace(string, "%type_ip_range%", "");
        } else if (((String)object).equalsIgnoreCase("ip_address")) {
            string = DString.replace(string, "%type_host_name%", "");
            string = DString.replace(string, "%type_ip_address%", "CHECKED");
            string = DString.replace(string, "%type_ip_range%", "");
        } else if (((String)object).equalsIgnoreCase("ip_range")) {
            string = DString.replace(string, "%type_host_name%", "");
            string = DString.replace(string, "%type_ip_address%", "");
            string = DString.replace(string, "%type_ip_range%", "CHECKED");
        } else {
            string = DString.replace(string, "%type_host_name%", "CHECKED");
            string = DString.replace(string, "%type_ip_address%", "");
            string = DString.replace(string, "%type_ip_range%", "");
        }
        object = hashtable.get("computer");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%computer%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayComputers(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("computers");
        AdminUtils.displayList(adminContext);
    }

    protected static void doComputerEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("computer_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminComputers.verifyComputerEntry(adminContext)) {
                AdminComputers.updateComputerEntry(adminContext);
                adminContext.setForm("computers");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "computers", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminComputers.verifyComputerEntry(adminContext)) {
                    AdminComputers.updateComputerEntry(adminContext);
                    adminContext.setForm("computers");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("computers");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminComputers.displayComputerEntry(adminContext);
    }

    protected static void doComputers(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("computers");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminComputers.displayComputerEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminComputers.parseComputerEntry(adminContext);
                AdminComputers.displayComputerEntry(adminContext);
                return;
            }
        } else {
            if (adminContext.action.equals("change")) {
                AdminUtils.changeRealm(adminContext);
                AdminUtils.displayList(adminContext);
                return;
            }
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getComputerEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("computer", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("type", string2);
        return hashtable;
    }

    protected static void parseComputerEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminComputers.getComputerEntry(adminContext, hashtable);
    }

    protected static void updateComputerEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("computer");
        String string2 = "";
        Object v = hashtable.get("type");
        if (v != null) {
            string2 = (String)v;
        }
        hashtable = AdminUtils.getSessionData(adminContext, "computers");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "computers", hashtable);
    }

    protected static boolean verifyComputerEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminComputers.getComputerEntry(adminContext, AdminUtils.getFormData(adminContext, "computers"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("type")) == null) {
            adminContext.error_message.append("Type is required.<br>");
            string3 = hashtable.get("type");
            if (string3 != null) {
                hashtable2.put("type", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Type is required.<br>");
                string3 = hashtable.get("type");
                if (string3 != null) {
                    hashtable2.put("type", string3);
                }
            } else {
                hashtable2.put("type", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("computer")) == null) {
            adminContext.error_message.append("Computer is required.<br>");
            string3 = hashtable.get("computer");
            if (string3 != null) {
                hashtable2.put("computer", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Computer is required.<br>");
                string3 = hashtable.get("computer");
                if (string3 != null) {
                    hashtable2.put("computer", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("computer", string);
            } else if (AdminUtils.getFormEntry(adminContext, "computers", string) != null) {
                adminContext.error_message.append("Computer already exists.<br>");
                string3 = hashtable.get("computer");
                if (string3 != null) {
                    hashtable2.put("computer", string3);
                }
            } else {
                hashtable2.put("computer", string);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

