/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminPools {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayPoolEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("pool_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("pool");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%pool%", (String)object);
        object = hashtable.get("driver");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%driver%", (String)object);
        object = hashtable.get("url");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%url%", (String)object);
        object = hashtable.get("username");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%username%", (String)object);
        object = hashtable.get("password");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%password%", (String)object);
        string = DString.replace(string, "%vpassword%", (String)object);
        object = hashtable.get("init_size");
        if (object == null) {
            object = String.valueOf(10);
        }
        string = DString.replace(string, "%init_size%", (String)object);
        Object object2 = object;
        object = hashtable.get("max_size");
        if (object == null) {
            object = object2;
        }
        string = DString.replace(string, "%max_size%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayPools(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("pools");
        AdminUtils.displayList(adminContext);
    }

    protected static void doPoolEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("pool_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminPools.verifyPoolEntry(adminContext)) {
                AdminPools.updatePoolEntry(adminContext);
                adminContext.setForm("pools");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "pools", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminPools.verifyPoolEntry(adminContext)) {
                    AdminPools.updatePoolEntry(adminContext);
                    adminContext.setForm("pools");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("pools");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminPools.displayPoolEntry(adminContext);
    }

    protected static void doPools(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("pools");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminPools.displayPoolEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminPools.parsePoolEntry(adminContext);
                AdminPools.displayPoolEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getPoolEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("pool", string);
        String string2 = (String)hashtable.get("entry");
        Hashtable hashtable2 = Utils.decodeParameters(string2);
        v = hashtable2.get("driver");
        if (v != null) {
            hashtable.put("driver", ((String[])v)[0]);
        }
        if ((v = hashtable2.get("url")) != null) {
            hashtable.put("url", ((String[])v)[0]);
        }
        if ((v = hashtable2.get("username")) != null) {
            hashtable.put("username", ((String[])v)[0]);
        }
        if ((v = hashtable2.get("password")) != null) {
            hashtable.put("password", ((String[])v)[0]);
        }
        if ((v = hashtable2.get("init_size")) != null) {
            hashtable.put("init_size", ((String[])v)[0]);
        }
        if ((v = hashtable2.get("max_size")) != null) {
            hashtable.put("max_size", ((String[])v)[0]);
        }
        return hashtable;
    }

    protected static void parsePoolEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminPools.getPoolEntry(adminContext, hashtable);
    }

    protected static void updatePoolEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("pool");
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("driver=");
        stringBuffer.append((String)hashtable.get("driver"));
        stringBuffer.append("&url=");
        stringBuffer.append((String)hashtable.get("url"));
        Object v = hashtable.get("username");
        if (v != null) {
            stringBuffer.append("&username=");
            stringBuffer.append((String)v);
        }
        if ((v = hashtable.get("password")) != null) {
            stringBuffer.append("&password=");
            stringBuffer.append((String)v);
        }
        if ((v = hashtable.get("init_size")) != null) {
            stringBuffer.append("&init_size=");
            stringBuffer.append((String)v);
        }
        if ((v = hashtable.get("max_size")) != null) {
            stringBuffer.append("&max_size=");
            stringBuffer.append((String)v);
        }
        hashtable = AdminUtils.getSessionData(adminContext, "pools");
        hashtable.put(string, stringBuffer.toString());
        AdminUtils.putSessionData(adminContext, "pools", hashtable);
    }

    protected static boolean verifyPoolEntry(AdminContext adminContext) throws IOException, ServletException {
        block50: {
            int n;
            String string;
            Hashtable hashtable;
            Hashtable hashtable2;
            block49: {
                String string2;
                hashtable2 = AdminPools.getPoolEntry(adminContext, AdminUtils.getFormData(adminContext, "pools"));
                adminContext.error_message.setLength(0);
                hashtable = adminContext.data;
                String string3 = "";
                string = adminContext.request.getParameter("key");
                if (string != null) {
                    string3 = string;
                    hashtable.put("key", string3);
                }
                if ((string = adminContext.request.getParameter("pool")) == null) {
                    adminContext.error_message.append("Connection Pool is required.<br>");
                    string = hashtable2.get("pool");
                    if (string != null) {
                        hashtable.put("pool", string);
                    }
                } else {
                    string2 = DString.trim(string);
                    if (string2.length() == 0) {
                        adminContext.error_message.append("Connection Pool is required.<br>");
                        string = hashtable2.get("pool");
                        if (string != null) {
                            hashtable.put("pool", string);
                        }
                    } else if (string3.equals(string2)) {
                        hashtable.put("pool", string2);
                    } else if (AdminUtils.getFormEntry(adminContext, "pools", string2) != null) {
                        adminContext.error_message.append("Connection Pool already exists.<br>");
                        string = hashtable2.get("pool");
                        if (string != null) {
                            hashtable.put("pool", string);
                        }
                    } else {
                        hashtable.put("pool", string2);
                    }
                }
                if ((string = adminContext.request.getParameter("driver")) == null) {
                    adminContext.error_message.append("Driver is required.<br>");
                    string = hashtable2.get("driver");
                    if (string != null) {
                        hashtable.put("driver", string);
                    }
                } else {
                    string2 = DString.trim(string);
                    if (string2.length() == 0) {
                        adminContext.error_message.append("Driver is required.<br>");
                        string = hashtable2.get("driver");
                        if (string != null) {
                            hashtable.put("driver", string);
                        }
                    } else {
                        hashtable.put("driver", string);
                    }
                }
                if ((string = adminContext.request.getParameter("url")) == null) {
                    adminContext.error_message.append("URL is required.<br>");
                    string = hashtable2.get("url");
                    if (string != null) {
                        hashtable.put("url", string);
                    }
                } else {
                    string2 = DString.trim(string);
                    if (string2.length() == 0) {
                        adminContext.error_message.append("URL is required.<br>");
                        string = hashtable2.get("url");
                        if (string != null) {
                            hashtable.put("url", string);
                        }
                    } else {
                        hashtable.put("url", string);
                    }
                }
                if ((string = adminContext.request.getParameter("username")) != null) {
                    hashtable.put("username", string);
                }
                String string4 = null;
                string = adminContext.request.getParameter("password");
                if (string != null) {
                    string4 = string;
                }
                string = adminContext.request.getParameter("vpassword");
                if (string4 != null || string != null) {
                    if (string4 == null || string == null) {
                        adminContext.error_message.append("Password mismatch.<br>");
                        string = hashtable2.get("password");
                        if (string != null) {
                            hashtable.put("password", string);
                        }
                    } else if (string4.equals(string)) {
                        hashtable.put("password", string4);
                        hashtable.put("vpassword", string);
                    } else {
                        adminContext.error_message.append("Password mismatch.<br>");
                        string = hashtable2.get("password");
                        if (string != null) {
                            hashtable.put("password", string);
                        }
                    }
                }
                n = 10;
                string = adminContext.request.getParameter("init_size");
                if (string == null) {
                    adminContext.error_message.append("Initial Size is required.<br>");
                    string = hashtable2.get("init_size");
                    if (string != null) {
                        hashtable.put("init_size", string);
                    }
                } else {
                    try {
                        n = Integer.parseInt(string);
                        if (n < 1) {
                            adminContext.error_message.append("Initial Size is not valid.<br>");
                            string = hashtable2.get("init_size");
                            if (string != null) {
                                hashtable.put("init_size", string);
                            }
                        } else {
                            hashtable.put("init_size", string);
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        adminContext.error_message.append("Initial Size requires a numeric value.<br>");
                        string = hashtable2.get("init_size");
                        if (string == null) break block49;
                        hashtable.put("init_size", string);
                    }
                }
            }
            int n2 = n;
            string = adminContext.request.getParameter("max_size");
            if (string == null) {
                adminContext.error_message.append("Maximum Size is required.<br>");
                string = hashtable2.get("max_size");
                if (string != null) {
                    hashtable.put("max_size", string);
                }
            } else {
                try {
                    n = Integer.parseInt(string);
                    if (n < n2) {
                        adminContext.error_message.append("Maximum Size is not valid.<br>");
                        string = hashtable2.get("max_size");
                        if (string != null) {
                            hashtable.put("max_size", string);
                        }
                    } else {
                        hashtable.put("max_size", string);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    adminContext.error_message.append("Maximum Size requires a numeric value.<br>");
                    string = hashtable2.get("max_size");
                    if (string == null) break block50;
                    hashtable.put("max_size", string);
                }
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

