/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.IOException;
import java.util.Hashtable;
import javax.servlet.ServletException;
import stec.iws.AdminContext;
import stec.iws.AdminUtils;
import stec.iws.IOManager;
import stec.iws.Utils;
import stec.iws.iws;
import stec.lang.DString;

public class AdminTemplates {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    protected static void displayTemplateEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("template_entry");
        Hashtable hashtable = adminContext.data;
        String string = adminContext.template;
        string = Utils.getItem(IOManager.getHandler(iws.basedir, string));
        string = DString.replace(string, "%error_message%", adminContext.error_message.toString());
        Object object = hashtable.get("name");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%name%", (String)object);
        object = hashtable.get("template");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%template%", (String)object);
        object = hashtable.get("key");
        if (object == null) {
            object = "";
        }
        string = DString.replace(string, "%key%", (String)object);
        AdminUtils.sendItem(adminContext.response, string);
    }

    protected static void displayTemplates(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("templates");
        AdminUtils.displayList(adminContext);
    }

    protected static void doTemplateEntry(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("template_entry");
        String string = AdminUtils.getAction(adminContext);
        if (string == null) {
            if (AdminTemplates.verifyTemplateEntry(adminContext)) {
                AdminTemplates.updateTemplateEntry(adminContext);
                adminContext.setForm("templates");
                AdminUtils.displayList(adminContext);
                return;
            }
        } else {
            if (string.equals("help")) {
                AdminUtils.help(adminContext, "templates", "#entry");
                return;
            }
            if (string.equals("ok")) {
                if (AdminTemplates.verifyTemplateEntry(adminContext)) {
                    AdminTemplates.updateTemplateEntry(adminContext);
                    adminContext.setForm("templates");
                    AdminUtils.displayList(adminContext);
                    return;
                }
            } else if (string.equals("cancel")) {
                adminContext.setForm("templates");
                AdminUtils.displayList(adminContext);
                return;
            }
        }
        AdminTemplates.displayTemplateEntry(adminContext);
    }

    protected static void doTemplates(AdminContext adminContext) throws IOException, ServletException {
        adminContext.setForm("templates");
        if (AdminUtils.doListAction(adminContext)) {
            return;
        }
        if (adminContext.action.equals("add")) {
            AdminTemplates.displayTemplateEntry(adminContext);
            return;
        }
        if (adminContext.action.equals("edit")) {
            if (AdminUtils.doEdit(adminContext)) {
                AdminTemplates.parseTemplateEntry(adminContext);
                AdminTemplates.displayTemplateEntry(adminContext);
                return;
            }
        } else {
            AdminUtils.displayList(adminContext);
        }
    }

    protected static Hashtable getTemplateEntry(AdminContext adminContext, Hashtable hashtable) {
        Object v = hashtable.get("key");
        if (v == null) {
            return hashtable;
        }
        String string = (String)v;
        hashtable.put("key", string);
        hashtable.put("name", string);
        String string2 = (String)hashtable.get("entry");
        hashtable.put("template", string2);
        return hashtable;
    }

    protected static void parseTemplateEntry(AdminContext adminContext) {
        Hashtable hashtable = adminContext.data;
        AdminTemplates.getTemplateEntry(adminContext, hashtable);
    }

    protected static void updateTemplateEntry(AdminContext adminContext) throws IOException, ServletException {
        Hashtable hashtable = adminContext.data;
        String string = (String)hashtable.get("name");
        String string2 = (String)hashtable.get("template");
        if ((string2 = DString.trim(string2)).length() > 0) {
            string2 = DString.replace(string2, "\n", " ");
            string2 = DString.replace(string2, "\r", "");
        }
        hashtable = AdminUtils.getSessionData(adminContext, "templates");
        hashtable.put(string, string2);
        AdminUtils.putSessionData(adminContext, "templates", hashtable);
    }

    protected static boolean verifyTemplateEntry(AdminContext adminContext) throws IOException, ServletException {
        String string;
        Hashtable hashtable = AdminTemplates.getTemplateEntry(adminContext, AdminUtils.getFormData(adminContext, "templates"));
        adminContext.error_message.setLength(0);
        Hashtable hashtable2 = adminContext.data;
        String string2 = "";
        String string3 = adminContext.request.getParameter("key");
        if (string3 != null) {
            string2 = string3;
            hashtable2.put("key", string2);
        }
        if ((string3 = adminContext.request.getParameter("name")) == null) {
            adminContext.error_message.append("Name is required.<br>");
            string3 = hashtable.get("name");
            if (string3 != null) {
                hashtable2.put("name", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Name is required.<br>");
                string3 = hashtable.get("name");
                if (string3 != null) {
                    hashtable2.put("name", string3);
                }
            } else if (string2.equals(string)) {
                hashtable2.put("name", string);
            } else if (AdminUtils.getFormEntry(adminContext, "templates", string) != null) {
                adminContext.error_message.append("Access Log Template already exists.<br>");
                string3 = hashtable.get("name");
                if (string3 != null) {
                    hashtable2.put("name", string3);
                }
            } else {
                hashtable2.put("name", string);
            }
        }
        if ((string3 = adminContext.request.getParameter("template")) == null) {
            adminContext.error_message.append("Template is required.<br>");
            string3 = hashtable.get("template");
            if (string3 != null) {
                hashtable2.put("template", string3);
            }
        } else {
            string = DString.trim(string3);
            if (string.length() == 0) {
                adminContext.error_message.append("Template is required.<br>");
                string3 = hashtable.get("template");
                if (string3 != null) {
                    hashtable2.put("template", string3);
                }
            } else {
                hashtable2.put("template", string3);
            }
        }
        return adminContext.error_message.length() <= 0;
    }
}

