/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.OutputStreamLogger;

public class ConsoleLogger
extends OutputStreamLogger {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";

    public void destroy() {
        super.destroy();
    }

    public void init(Hashtable hashtable) throws Exception {
        super.init(hashtable);
        this.accesslog = System.out;
        this.eventslog = System.out;
        this.errorslog = System.err;
    }

    public void output(AccessLogEntry accessLogEntry) throws Exception {
        this.accesslog.println(this.convertToString(accessLogEntry));
        this.accesslog.flush();
    }

    public void output(ErrorLogEntry errorLogEntry) throws Exception {
        this.errorslog.print("[");
        this.errorslog.print(new Date(errorLogEntry.timestamp).toString());
        this.errorslog.print("] ");
        this.errorslog.print(errorLogEntry.message);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        errorLogEntry.error.printStackTrace(printWriter);
        this.errorslog.println(charArrayWriter.toString());
        this.errorslog.flush();
    }

    public void output(EventLogEntry eventLogEntry) throws Exception {
        this.eventslog.print("[");
        this.eventslog.print(new Date(eventLogEntry.timestamp).toString());
        this.eventslog.print("] ");
        this.eventslog.println(eventLogEntry.message);
        this.eventslog.flush();
    }
}

