/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.Logger;

public class DatabaseLogger
extends Logger {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private static String NONE = "";
    private Connection connection;
    private PreparedStatement insertErrorStatement;
    private PreparedStatement insertEventStatement;
    private PreparedStatement insertAccessStatement;

    private void _destroy() {
        if (this.insertEventStatement != null) {
            try {
                this.insertEventStatement.close();
            }
            catch (Exception exception) {}
            this.insertEventStatement = null;
        }
        if (this.insertErrorStatement != null) {
            try {
                this.insertErrorStatement.close();
            }
            catch (Exception exception) {}
            this.insertErrorStatement = null;
        }
        if (this.insertAccessStatement != null) {
            try {
                this.insertAccessStatement.close();
            }
            catch (Exception exception) {}
            this.insertAccessStatement = null;
        }
        if (this.connection != null) {
            try {
                this.connection.close();
            }
            catch (Exception exception) {}
            this.connection = null;
        }
    }

    public synchronized void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._destroy();
            throw throwable;
        }
        Object var2_1 = null;
        this._destroy();
    }

    public void init(Hashtable hashtable) throws Exception {
        super.init(hashtable);
        Object v = hashtable.get("driver");
        if (v == null) {
            throw new Exception("Driver was not specified.");
        }
        String string = ((String[])v)[0];
        Class.forName(string);
        v = hashtable.get("url");
        if (v == null) {
            throw new Exception("URL was not specified.");
        }
        String string2 = ((String[])v)[0];
        v = hashtable.get("username");
        String string3 = v == null ? "" : ((String[])v)[0];
        v = hashtable.get("password");
        String string4 = v == null ? "" : ((String[])v)[0];
        try {
            this.connection = DriverManager.getConnection(string2, string3, string4);
            this.connection.setAutoCommit(true);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("INSERT INTO AccessLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Remote_Address");
            stringBuffer.append(", Remote_Host");
            stringBuffer.append(", Remote_User");
            stringBuffer.append(", Host");
            stringBuffer.append(", Port");
            stringBuffer.append(", Local_Address");
            stringBuffer.append(", Content_Length");
            stringBuffer.append(", Request_Length");
            stringBuffer.append(", Response_Time");
            stringBuffer.append(", Status_Code");
            stringBuffer.append(", Error_Code");
            stringBuffer.append(", Request_Method");
            stringBuffer.append(", Request_URI");
            stringBuffer.append(", User_Agent");
            stringBuffer.append(", Referer");
            stringBuffer.append(", Protocol");
            stringBuffer.append(", Server_Service");
            stringBuffer.append(") VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)");
            this.insertAccessStatement = this.connection.prepareStatement(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO EventLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Message");
            stringBuffer.append(") VALUES (?,?)");
            this.insertEventStatement = this.connection.prepareStatement(stringBuffer.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("INSERT INTO ErrorLog (");
            stringBuffer.append("Date_Time");
            stringBuffer.append(", Exception");
            stringBuffer.append(", Message");
            stringBuffer.append(") VALUES (?,?,?)");
            this.insertErrorStatement = this.connection.prepareStatement(stringBuffer.toString());
            return;
        }
        catch (Exception exception) {
            this._destroy();
            throw exception;
        }
    }

    public void output(AccessLogEntry accessLogEntry) throws SQLException {
        this.insertAccessStatement.setTimestamp(1, new Timestamp(accessLogEntry.timestamp));
        this.insertAccessStatement.setString(2, accessLogEntry.remoteAddress == null ? NONE : accessLogEntry.remoteAddress);
        this.insertAccessStatement.setString(3, accessLogEntry.remoteHost == null ? NONE : accessLogEntry.remoteHost);
        this.insertAccessStatement.setString(4, accessLogEntry.remoteUser == null ? NONE : accessLogEntry.remoteUser);
        this.insertAccessStatement.setString(5, accessLogEntry.host == null ? NONE : accessLogEntry.host);
        this.insertAccessStatement.setInt(6, accessLogEntry.port == -1 ? 80 : accessLogEntry.port);
        this.insertAccessStatement.setString(7, accessLogEntry.localAddress == null ? NONE : accessLogEntry.localAddress);
        this.insertAccessStatement.setInt(8, accessLogEntry.contentLength == -1L ? 0 : (int)accessLogEntry.contentLength);
        this.insertAccessStatement.setInt(9, (int)accessLogEntry.requestLength);
        this.insertAccessStatement.setInt(10, (int)accessLogEntry.responseTime);
        this.insertAccessStatement.setInt(11, accessLogEntry.statusCode);
        this.insertAccessStatement.setInt(12, accessLogEntry.errorCode);
        this.insertAccessStatement.setString(13, accessLogEntry.requestMethod == null ? NONE : accessLogEntry.requestMethod);
        this.insertAccessStatement.setString(14, accessLogEntry.requestURI == null ? NONE : accessLogEntry.requestURI);
        this.insertAccessStatement.setString(15, accessLogEntry.userAgent == null ? NONE : accessLogEntry.userAgent);
        this.insertAccessStatement.setString(16, accessLogEntry.referer == null ? NONE : accessLogEntry.referer);
        this.insertAccessStatement.setString(17, accessLogEntry.protocol == null ? NONE : accessLogEntry.protocol);
        this.insertAccessStatement.setString(18, accessLogEntry.serverService == null ? NONE : accessLogEntry.serverService);
        this.insertAccessStatement.executeUpdate();
    }

    public void output(ErrorLogEntry errorLogEntry) throws SQLException {
        System.err.print(errorLogEntry.message);
        errorLogEntry.error.printStackTrace(System.err);
        this.insertErrorStatement.setTimestamp(1, new Timestamp(errorLogEntry.timestamp));
        this.insertErrorStatement.setString(2, errorLogEntry.error == null ? NONE : errorLogEntry.error.toString());
        this.insertErrorStatement.setString(3, errorLogEntry.message == null ? NONE : errorLogEntry.message);
        this.insertErrorStatement.executeUpdate();
    }

    public void output(EventLogEntry eventLogEntry) throws SQLException {
        this.insertEventStatement.setTimestamp(1, new Timestamp(eventLogEntry.timestamp));
        this.insertEventStatement.setString(2, eventLogEntry.message == null ? NONE : eventLogEntry.message);
        this.insertEventStatement.executeUpdate();
    }
}

