/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.BufferedOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.ErrorLogEntry;
import stec.iws.EventLogEntry;
import stec.iws.OutputStreamLogger;
import stec.iws.Utils;
import stec.iws.iws;

public class FileLogger
extends OutputStreamLogger {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private Date accessLogDate;
    private Date errorsLogDate;
    private Date eventsLogDate;
    private int rolloverInterval;
    private String basedir;

    public void _destroy() {
        if (this.accesslog != null) {
            try {
                this.accesslog.close();
            }
            catch (Exception exception) {}
            this.accesslog = null;
        }
        if (this.errorslog != null) {
            try {
                this.errorslog.close();
            }
            catch (Exception exception) {}
            this.errorslog = null;
        }
        if (this.eventslog != null) {
            try {
                this.eventslog.close();
            }
            catch (Exception exception) {}
            this.eventslog = null;
        }
    }

    public synchronized void destroy() {
        try {
            super.destroy();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this._destroy();
            throw throwable;
        }
        Object var2_1 = null;
        this._destroy();
    }

    private String getBaseFileName(Date date) {
        String string;
        if (this.rolloverInterval == 0) {
            string = "";
        } else {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
            string = String.valueOf(simpleDateFormat.format(date)) + "_";
        }
        return string;
    }

    private Date getDate() {
        if (this.rolloverInterval == 1) {
            return new Date();
        }
        if (this.rolloverInterval == 2) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.get(1), calendar.get(2), calendar.get(5) - calendar.get(7) + 1);
            return calendar.getTime();
        }
        if (this.rolloverInterval == 3) {
            Calendar calendar = Calendar.getInstance();
            calendar.set(calendar.get(1), calendar.get(2), 1);
            return calendar.getTime();
        }
        return null;
    }

    public void init(Hashtable hashtable) throws Exception {
        try {
            Object object;
            super.init(hashtable);
            Object v = hashtable.get("log_rollover_interval");
            if (v == null) {
                this.rolloverInterval = 2;
            } else {
                object = ((String[])v)[0].toLowerCase();
                if (((String)object).equals("daily") || ((String)object).equals("d")) {
                    this.rolloverInterval = 1;
                } else if (((String)object).equals("weekly") || ((String)object).equals("w")) {
                    this.rolloverInterval = 2;
                } else if (((String)object).equals("monthly") || ((String)object).equals("m")) {
                    this.rolloverInterval = 3;
                } else if (((String)object).equals("none") || ((String)object).equals("n")) {
                    this.rolloverInterval = 0;
                } else {
                    throw new Exception("Invalid log rollover interval: " + (String)object);
                }
            }
            v = hashtable.get("basedir");
            this.basedir = v == null ? "./logs" : ((String[])v)[0];
            object = new File(this.basedir);
            if (!((File)object).isAbsolute()) {
                this.basedir = Utils.concatPaths(iws.basedir, this.basedir);
            }
            this.openAccessLog();
            this.openErrorsLog();
            this.openEventsLog();
            return;
        }
        catch (Exception exception) {
            this._destroy();
            throw exception;
        }
    }

    private void openAccessLog() throws IOException {
        if (iws.logAccess) {
            Date date;
            this.accessLogDate = date = this.getDate();
            String string = this.getBaseFileName(date);
            if (this.accesslog != null) {
                this.accesslog.close();
            }
            this.accesslog = new PrintStream(new BufferedOutputStream(new FileOutputStream(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(string) + "access.log")), true)));
        }
    }

    private void openErrorsLog() throws IOException {
        if (iws.logErrors) {
            Date date;
            this.errorsLogDate = date = this.getDate();
            String string = this.getBaseFileName(date);
            if (this.errorslog != null) {
                this.errorslog.close();
            }
            this.errorslog = new PrintStream(new BufferedOutputStream(new FileOutputStream(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(string) + "errors.log")), true)));
        }
    }

    private void openEventsLog() throws IOException {
        if (iws.logEvents) {
            Date date;
            this.eventsLogDate = date = this.getDate();
            String string = this.getBaseFileName(date);
            if (this.eventslog != null) {
                this.eventslog.close();
            }
            this.eventslog = new PrintStream(new BufferedOutputStream(new FileOutputStream(Utils.getCanonicalPath(Utils.concatPaths(this.basedir, String.valueOf(string) + "events.log")), true)));
        }
    }

    public void output(AccessLogEntry accessLogEntry) throws Exception {
        if (this.accessLogDate != this.getDate()) {
            this.openAccessLog();
        }
        this.accesslog.println(this.convertToString(accessLogEntry));
        this.accesslog.flush();
    }

    public void output(ErrorLogEntry errorLogEntry) throws Exception {
        System.err.print(errorLogEntry.message);
        errorLogEntry.error.printStackTrace(System.err);
        if (this.errorsLogDate != this.getDate()) {
            this.openErrorsLog();
        }
        this.errorslog.print("[");
        this.errorslog.print(new Date(errorLogEntry.timestamp).toString());
        this.errorslog.print("] ");
        this.errorslog.print(errorLogEntry.message);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        PrintWriter printWriter = new PrintWriter(charArrayWriter);
        errorLogEntry.error.printStackTrace(printWriter);
        this.errorslog.println(charArrayWriter.toString());
        this.errorslog.flush();
    }

    public void output(EventLogEntry eventLogEntry) throws Exception {
        if (this.eventsLogDate != this.getDate()) {
            this.openEventsLog();
        }
        this.eventslog.print("[");
        this.eventslog.print(new Date(eventLogEntry.timestamp).toString());
        this.eventslog.print("] ");
        this.eventslog.println(eventLogEntry.message);
        this.eventslog.flush();
    }
}

