/*
 * Decompiled with CFR 0.152.
 */
package stec.iws;

import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import stec.iws.AccessLogEntry;
import stec.iws.Logger;
import stec.iws.Utils;
import stec.lang.DString;

public abstract class OutputStreamLogger
extends Logger {
    private static final String _ = "Copyright (c) 1998-2000 Servertec. All rights reserved.";
    private static final String NONE = "-";
    private static final String DELIMITER = ", ";
    public PrintStream accesslog;
    public PrintStream errorslog;
    public PrintStream eventslog;
    public String accessLogTemplate;

    public String convertToString(AccessLogEntry accessLogEntry) {
        Date date = new Date(accessLogEntry.timestamp);
        if (this.accessLogTemplate == null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(accessLogEntry.remoteAddress == null ? NONE : accessLogEntry.remoteAddress);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.remoteHost == null ? NONE : accessLogEntry.remoteHost);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(OutputStreamLogger.formatDate(date));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(OutputStreamLogger.formatTime(date));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.remoteUser == null ? NONE : accessLogEntry.remoteUser);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.host == null ? NONE : accessLogEntry.host);
            stringBuffer.append(':');
            stringBuffer.append(String.valueOf(accessLogEntry.port == -1 ? 80 : accessLogEntry.port));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.localAddress == null ? NONE : accessLogEntry.localAddress);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(String.valueOf(accessLogEntry.contentLength == -1L ? 0L : accessLogEntry.contentLength));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(String.valueOf(accessLogEntry.requestLength));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(String.valueOf(accessLogEntry.responseTime));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(String.valueOf(accessLogEntry.statusCode));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(String.valueOf(accessLogEntry.errorCode));
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.requestMethod == null ? NONE : accessLogEntry.requestMethod);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.requestURI == null ? NONE : accessLogEntry.requestURI);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.userAgent == null ? NONE : accessLogEntry.userAgent);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.referer == null ? NONE : accessLogEntry.referer);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.protocol == null ? NONE : accessLogEntry.protocol);
            stringBuffer.append(DELIMITER);
            stringBuffer.append(accessLogEntry.serverService == null ? NONE : accessLogEntry.serverService);
            return stringBuffer.toString();
        }
        String string = this.accessLogTemplate;
        string = DString.replace(string, "%remote_address%", accessLogEntry.remoteAddress == null ? NONE : accessLogEntry.remoteAddress);
        string = DString.replace(string, "%remote_host%", accessLogEntry.remoteHost == null ? NONE : accessLogEntry.remoteHost);
        string = DString.replace(string, "%date%", OutputStreamLogger.formatDate(date));
        string = DString.replace(string, "%ldate%", OutputStreamLogger.formatLDate(date));
        string = DString.replace(string, "%edate%", OutputStreamLogger.formatEDate(date));
        string = DString.replace(string, "%time%", OutputStreamLogger.formatTime(date));
        string = DString.replace(string, "%timestamp%", OutputStreamLogger.formatTimestamp(date));
        string = DString.replace(string, "%remote_user%", accessLogEntry.remoteUser == null ? NONE : accessLogEntry.remoteUser);
        string = DString.replace(string, "%host%", accessLogEntry.host == null ? NONE : accessLogEntry.host);
        string = DString.replace(string, "%port%", String.valueOf(accessLogEntry.port == -1 ? 80 : accessLogEntry.port));
        string = DString.replace(string, "%local_address%", accessLogEntry.localAddress == null ? NONE : accessLogEntry.localAddress);
        string = DString.replace(string, "%content_length%", String.valueOf(accessLogEntry.contentLength == -1L ? 0L : accessLogEntry.contentLength));
        string = DString.replace(string, "%request_length%", String.valueOf(accessLogEntry.requestLength));
        string = DString.replace(string, "%response_time%", String.valueOf(accessLogEntry.responseTime));
        string = DString.replace(string, "%status_code%", String.valueOf(accessLogEntry.statusCode));
        string = DString.replace(string, "%error_code%", String.valueOf(accessLogEntry.errorCode));
        string = DString.replace(string, "%request_method%", accessLogEntry.requestMethod == null ? NONE : accessLogEntry.requestMethod);
        string = DString.replace(string, "%request_uri%", accessLogEntry.requestURI == null ? NONE : accessLogEntry.requestURI);
        string = DString.replace(string, "%base_uri%", accessLogEntry.baseURI == null ? NONE : accessLogEntry.baseURI);
        string = DString.replace(string, "%query_string%", accessLogEntry.queryString == null ? NONE : accessLogEntry.queryString);
        string = DString.replace(string, "%user_agent%", accessLogEntry.userAgent == null ? NONE : accessLogEntry.userAgent);
        string = DString.replace(string, "%referer%", accessLogEntry.referer == null ? NONE : accessLogEntry.referer);
        string = DString.replace(string, "%protocol%", accessLogEntry.protocol == null ? NONE : accessLogEntry.protocol);
        string = DString.replace(string, "%server_service%", accessLogEntry.serverService == null ? NONE : accessLogEntry.serverService);
        return string;
    }

    public static String formatDate(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("MM/dd/yy");
        return simpleDateFormat.format(date);
    }

    public static String formatEDate(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("yyyy/MM/dd");
        return simpleDateFormat.format(date);
    }

    public static String formatLDate(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("MM/dd/yyyy");
        return simpleDateFormat.format(date);
    }

    public static String formatTime(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public static String formatTimestamp(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        simpleDateFormat.applyPattern("MM/dd/yyyy:HH:mm:ss zzz");
        return simpleDateFormat.format(date);
    }

    public void init(Hashtable hashtable) throws Exception {
        super.init(hashtable);
        Object v = hashtable.get("access_log_template");
        String string = v == null ? "default" : ((String[])v)[0];
        if (string.equalsIgnoreCase("none")) {
            this.accessLogTemplate = null;
            return;
        }
        Hashtable hashtable2 = Utils.load("./config/templates.ini", false);
        v = hashtable2.get(string);
        if (v == null) {
            v = hashtable2.get("default");
        }
        if (v == null) {
            throw new Exception("Access log template was not found: " + string);
        }
        this.accessLogTemplate = (String)v;
    }
}

