/*
 * @(#)CookieManagerServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import java.io.IOException;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;

import stec.net.Codecs;

public class CookieTesterServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        String key = _request.getParameter("key");
        if(key == null)
        {
            key = "";
        }

        String value = _request.getParameter("value");
        if(value == null)
        {
            value = "";
        }

        if(key.length() != 0)
        {
            _response.addCookie(new Cookie(key, value));
        }

        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Cookie Manager</title></head>");
        out.println("<body>");
        out.println("<h1>Cookie Manager</h1>");
        
        out.println("<hr>");
        
        out.println("Cookies received from browser:<br>");

        Cookie cookies[] = _request.getCookies();

        if(cookies.length == 0)
        {
            out.println("None<br>");
        }
        else
        {
            for(int i = 0; i < cookies.length; i++)
            {
                out.println(cookies[i].getName() + " = " + cookies[i].getValue() + "<br>");
            }
        }

        out.println("<p>");
        out.println("Cookies added:<br>");

        if(key.length() == 0)
        {
            out.println("None<br>");
        }
        else
        {
            out.println(key + " = " + value + "<br>");
        }
        
        out.println("<hr>");
        
        out.println("<form action=\"./cookietester.html\" method=\"get\">");
        out.println("Key: ");
        out.println("<input type=\"text\" name=\"key\" value=\"\">");
        out.println("<br>");
        out.println("Value: ");
        out.println("<input type=\"text\" name=\"value\" value=\"\">");
        out.println("<p>");
        out.println("<input type=\"submit\" value=\"Submit\">");
        out.println("<input type=\"reset\" value=\"Reset\">");
        out.println("</form>");

        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    public String getServletInfo()
    {
        return "SimpleFormServlet";
    }
}
