/*
 * @(#)SimpleFormServlet.java
 *
 * Copyright (c) 1998-1999 Servertec. All Rights Reserved.
 *
 * This software is the proprietary and confidential property of Servertec.
 * Use only in accordance with the terms of the license agreement.
 *
 * SERVERTEC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY
 * OF THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE, OR NON-INFRINGEMENT. SERVERTEC SHALL NOT BE LIABLE FOR ANY
 * DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 *
 * THIS NOTICE MUST NOT BE ALTERED NOR REMOVED.
 *
 * CopyrightVersion 1.0
 */

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletException;
import java.io.IOException;

public class SimpleFormServlet extends HttpServlet
{
    public void service(HttpServletRequest _request, HttpServletResponse _response) throws ServletException, IOException
    {
        _response.setContentType("text/html");

        ServletOutputStream out = _response.getOutputStream();

        out.println("<html>");
        out.println("<head><title>Simple Entry Form</title></head>");
        out.println("<body>");
        
        String name = _request.getParameter("name");
        if(name == null)
        {
            String oldvalue = _request.getParameter("oldvalue");
            if(oldvalue == null)
            {
                oldvalue = "";
            }    

            out.println("Please enter your name");
            out.println("<br>");
            out.println("<form action=\"./simpleform.html\" method=\"get\">");
            out.println("<input type=\"text\" name=\"name\" value=\"" + oldvalue + "\">");
            out.println("<br>");
            out.println("<input type=\"submit\" value=\"Submit\">");
            out.println("<input type=\"reset\" value=\"Reset\">");
            out.println("</form>");
        }
        else if(name.length() == 0)
        {
            out.println("<h1>Please enter your name</h1>");
            out.println("<br>");
            out.println("[ <a href=\"./simpleform.html?oldvalue=" + name + "\">try again</a> ]");
        }
        else
        {
            out.println("<h1>Hello " + name + "</h1>");
            out.println("<br>");
            out.println("[ <a href=\"./simpleform.html?oldvalue=" + name + "\">try again</a> ]");
        }    
    
        out.println("</body>");
        out.println("</html>");
        out.close();
    }

    public String getServletInfo()
    {
        return "SimpleFormServlet";
    }
}
