package org.phoenix.util;

/*

 *  This is a DNS client javabean.  It is used to resolve host names and do

 *  reverse dns lookups as well as MX record lookups.

 *

 *  Written from scratch based on RFC 1035

 *

 *  Version 1.0 basic lookup and reverse lookup functionality  (set recursion available to true so that dns server does nonauthoritative lookups)

 *  -version 1.1
 *   fixed problem with return vectors not being added equally
 *  -version 1.2
 *   fixed problem with cname records not being handled
 *   added error message for unsupported types
 *  -version 1.3
 *   enabled datagram socket timeout
 *   set packet to be resent if first attempt fails
 *  -version 1.4
 *   an IOException is thrown for server errors
 */



import java.net.*;

import java.io.*;

import java.util.*;



public class dnsBean {

	String server = "dns";  //name of dns server

	String qname = "domain";  //question name, name of host the question is about

	byte send[] = new byte[512];

	int sendLength = 0;

	byte receive[] = new byte[512];

	int recieveLength = 0;



	private Random rand = new Random(System.currentTimeMillis());



	static final int port = 53;



	//type, 1 - A, 2 - NS, 5 - CNAME, 6 - SOA, 11 - WKS, 12 - PTR, 13 - HINFO, 14 - MINFO, 15 - MX, 16 - TXT

	public static final char A = 0x0001; // A (address)

	public static final char NS = 0x0002; // NS (nameserver)

	public static final char CNAME = 0x0005; // CNAME (cononical name)

	public static final char SOA = 0x0006; // SOA (start of authority)

	public static final char PTR = 0x000C; // PTR (pointer or reverse dns lookup)

	public static final char HINFO = 0x000D; // HINFO (host info)

	public static final char MX = 0x000F; // MX (mail exchange)

	public static final char AXFR = 0x00FC; // AXFR (transfer an entire zone)

	public static final char ALL = 0x00FF; // ALL (returns all domain records)



	public static final int UDP = 0x0001; // UDP connection

	public static final int TCP = 0x0002; // TCP connection



	int connection = UDP;

	

	//class, 1 - IN (internet)

	char IN = 0x0001; // IN (internet)



	char qtype = A;

	char qclass = IN;

	

	int count = 0;



	int headerOffset = 12;

	int timeout = 1000;



	boolean response = false; // true - response, false - query

	int opcode = 0; // 0 - standard query, 1 - inverse query, 2 - server request status, 3-15 - reserved

	boolean AA = false; // true - authoritative, false - nonauthoritative

	boolean TC = false; // truncation, usually due to large messages

	boolean RD = false; // recursion desired

	boolean RA = true; // recursion available

	int z = 0; //reserved for future use

	int RCODE = 0; // responce code 0 - no error, 1 - format error, 2 - server failure, 3 - name error, 4 - not implemented, 5 - refused, 6-15 reserved



	Vector answers = new Vector();

	Vector types = new Vector();

	Vector rname = new Vector();

	

	boolean debug = false;

	public static void main(String args[]) throws SocketException, IOException, UnknownHostException {

		dnsBean dns = new dnsBean();

		dns.setServer(args[1]);

		dns.setName(args[0]);

		dns.setType(dnsBean.A);

		dns.setDataConnection(dns.UDP);

		dns.setRA(true);

		dns.setRD(false);

		dns.send();

		dns.getReply();

		Vector c1 = dns.getRNames();

		Vector c2 = dns.getTypes();

		Vector c3 = dns.getAnswers();

		System.out.println("c1 is " + c1.size());

		System.out.println("c2 is " + c2.size());

		System.out.println("c3 is " + c3.size());

		System.out.println("------------------------------");

		for (int i = 0; i < c1.size(); i++) {

			System.out.println(c1.elementAt(i) + "	" + c2.elementAt(i) + "	" + c3.elementAt(i));

		}

		System.out.println("------------------------------");

	}



	public Vector getAnswers() {

		return answers;

	}



	public Vector getTypes() {

		return types;

	}



	public Vector getRNames() {

		return rname;

	}



	public void dnsBean() {

		setType(A);

		setRA(true);

		setRD(false);

	}



	public void setServer(String server) {

		this.server = server;

	}

	

	public void setName(String name) {

		qname = name;

	}



	public void setType(char type) {

		qtype = type;

	}



	public void setClass(char qclass) {

		this.qclass = qclass;

	}



	public void setRD(boolean flag) {

		RD = flag;

	}



	public void setRA(boolean flag) {

		RA = flag;

	}



	public void setDataConnection(int con) {

		connection = con;

	}



	public void send() throws SocketException, IOException, UnknownHostException {

		int queryID = rand.nextInt(); // id of the query/response generated by the querier





		int QDCOUNT = 1; // question count

		int ANCOUNT = 0; // answer count

		int NSCOUNT = 0; // name server count

		int ARCOUNT = 0; // additional section count

		char header[] = new char[6];

		header[0] = (char) queryID;

		header[1] = 0;

		if (response) {

			header[1] = (char) (header[1] | (1 << 0));

		}

		header[1] = (char) (header[1] | (opcode << 1));

		if (AA) {

			header[1] = (char) (header[1] | (1 << 5));

		}

		if (TC) {

			header[1] = (char) (header[1] | (1 << 6));

		}

		if (RD) {

			header[1] = (char) (header[1] | (1 << 7));

		}

		if (RA) {

			header[1] = (char) (header[1] | (1 << 8));

		}

		header[1] = (char) (header[1] | (z << 9));

		header[1] = (char) (header[1] | (RCODE << 12));



		header[2] = (char) QDCOUNT;

		header[3] = (char) ANCOUNT;

		header[4] = (char) NSCOUNT;

		header[5] = (char) ARCOUNT;



		int t = 0;

		

		for (int i = 0; i < header.length; i++) {

			send[t++] = (byte) ((header[i] >> 8) & 0xFF);

			send[t++] =  (byte) (header[i] & 0xFF);

		}

		byte name[] = encode(qname);

		for (int i = 0; i < name.length; i++) {

			send[t++] = name[i];

		}

	

		send[t++] = (byte) ((qtype >> 8) & 0xFF);

		send[t++] =  (byte) (qtype & 0xFF);

		send[t++] = (byte) ((qclass >> 8) & 0xFF);

		send[t++] =  (byte) (qclass & 0xFF);

		sendLength = t;
		connect();

	}



	void connect() throws SocketException, IOException, UnknownHostException {

		answers = new Vector();

		types = new Vector();

		rname = new Vector();

		if (connection == UDP) {

			InetAddress DNSServer = InetAddress.getByName(server);

			DatagramPacket question = new DatagramPacket(send, sendLength, DNSServer, port);

			DatagramPacket reply = new DatagramPacket(receive, receive.length);

			DatagramSocket sock = new DatagramSocket();

			sock.setSoTimeout(timeout);

			try {
				sock.send(question);

				sock.receive(reply);
			} catch (IOException e) {
				sock.send(question);

				sock.receive(reply);
			}

			receive = reply.getData();

		} else if (connection == TCP) {

			Socket s = new Socket(server, port);

			InputStream in = s.getInputStream();

			OutputStream out = s.getOutputStream();

			out.write((send.length >> 8) & 0xFF);

			out.write(send.length & 0xFF);

			for (int i = 0; i < send.length; i++) {

				out.write(send[i]);

			}

			if (qtype == AXFR) {

				while (true) {

					int alength = ((in.read() << 8) & 0xFF) | (in.read() & 0xFF);

					if (alength < 3) {

						System.err.println("invalid alength - no data");

						break;

					}

					for (int i = 0; i < alength; i++) {

						receive[i] = (byte) in.read();

					}

					getReply();

					if (types.size() > 1 && ((String) types.elementAt(types.size() - 1)).equals("SOA")) {

						break;

					}

				}

			}

		} else {

			System.err.println("Invalid Connection Type");

		}

	}



	public String getReply() throws UnknownHostException, IOException {

		count = 0;

		int id = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		int flags = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		

		int response = (flags >> 15) & 0x01;



		int aa = (flags >> 10) & 0x01;

		int tc = (flags >> 9) & 0x01;

		int rd = (flags >> 8) & 0x01;

		int ra = (flags >> 7) & 0x01;

		int z = (flags >> 4) & 0x07;



		int opcode = (flags >> 11) & 0x0F;

		int rcode = (flags >> 0) & 0x0F;

		if (rcode == 1)	{

			if (debug) {
				System.err.println("A Format Error has occurred, the nameserver was unable to interpret the query.");
			}

			throw new IOException("Error in nameserver query");
		}

		if (rcode == 2)	{

			if (debug) {
				System.err.println("A Server Failure has occured, The nameserver was unable to process this query due to an internal problem");

			}

			throw new IOException("Internal nameserver server error");
		}

		if (rcode == 3)	{

			if (debug) {
				System.err.println("A Name Error has occured, the domain does not exist");
			}

			throw new UnknownHostException(qname);
		}

		if (rcode == 4)	{

			if (debug) {
				System.err.println("A Not Implemented Error has occured, this service is not implemented");
			}

			throw new IOException("Not implemented by nameserver");
		}

		if (rcode == 5)	{

			if (debug) {
				System.err.println("A Refued Error has occured, the nameserver refused to perform the action");
			}

			throw new IOException("Refused by nameserver");
		}



		int qdcount = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		int ancount = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		int nscount = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		int arcount = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

		if (debug) {
			System.out.println("qd is " + qdcount);

			System.out.println("an is " + ancount);

			System.out.println("ns is " + nscount);

			System.out.println("ar is " + arcount);
		}

		if (debug) {
			System.out.println("-Questions-");
		}

		while(qdcount-- > 0) {

			if (debug) {
				System.out.println("Question:" + (qdcount + 1));
			}

			String qname = decode(receive, count);

			count += length(receive, count);

			int qtype = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			int qclass = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			if (debug) {
				System.out.println("qname is " + qname);

				System.out.println("qtype is " + qtype);

				System.out.println("qclass is " + qclass);
			}

		}

		if (debug) {
			System.out.println("-Answers-");
		}

		while(ancount-- > 0) {

			if (debug) {
				System.out.println("Answer:" + (ancount + 1));
			}

			String rname = decode(receive, count);

			count += length(receive, count);

			int atype = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			int aclass = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			long ttl = get32Bit(receive);

			int rlength = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			if (debug) {
				System.out.println("rname is " + rname);

				System.out.println("atype2 is " + atype);

				System.out.println("aclass is " + aclass);

				System.out.println("rlength is " + rlength);
			}

			processData(rname, atype, rlength);

		}

		if (debug) {
			System.out.println("-Nameservers-");
		}

		while(nscount-- > 0) {

			if (debug) {
				System.out.println("Nameserver:" + (nscount + 1));
			}

			String rname = decode(receive, count);

			count += length(receive, count);

			int nstype = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			int nsclass = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			long ttl = get32Bit(receive);

			int rlength = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			if (debug) {
				System.out.println("rname is " + rname);

				System.out.println("nstype2 is " + nstype);

				System.out.println("nsclass is " + nsclass);

				System.out.println("rlength is " + rlength);
			}

			processData(rname, nstype, rlength);

		}

		if (debug) {
			System.out.println("-Additional-");
		}

		while(arcount-- > 0) {

			if (debug) {
				System.out.println("Additional:" + (arcount + 1));
			}

			String rname = decode(receive, count);

			count += length(receive, count);

			int artype = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			int arclass = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			long ttl = get32Bit(receive);

			int rlength = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

			if (debug) {
				System.out.println("rname is " + rname);

				System.out.println("nstype2 is " + artype);

				System.out.println("nsclass is " + arclass);

				System.out.println("rlength is " + rlength);
			}

			processData(rname, artype, rlength);

		}

		for (int i = 0; i < types.size(); i++) {
			if (qtype == A) {
				if (((String) types.elementAt(i)).equals("A")) {
					return answers.elementAt(i).toString();
				}
			} else if (qtype == PTR) {
				if (((String) types.elementAt(i)).equals("PTR")) {
					return answers.elementAt(i).toString();
				}
			}
		}
		return "";

	}

	/*

	 *	Process rdata section

	 */

	String processData(String rname, int type, int rlength) {

			if (type == A) {

				this.rname.addElement(rname);

				types.addElement("A");

				if (debug) {
					System.out.println("Processing address info");
				}

				int n1 = (int) receive[count++];

				if (n1 < 0) {

					n1 += 256;

				}

				int n2 = (int) receive[count++];

				if (n2 < 0) {

					n2 += 256;

				}

				int n3 = (int) receive[count++];

				if (n3 < 0) {

					n3 += 256;

				}

				int n4 = (int) receive[count++];

				if (n4 < 0) {

					n4 += 256;

				}

				answers.addElement(n1 + "." + n2 + "." + n3 + "." + n4);

				if (debug) {
					System.out.println(n1 + "." + n2 + "." + n3 + "." + n4);
				}

			} else if (type == PTR) {

				this.rname.addElement(rname);

				types.addElement("PTR");

				if (debug) {
					System.out.println("Processing ptr info");
				}

				String temp = decode(receive, count);

				answers.addElement(temp);

				if (debug) {
					System.out.println("PTR answer is " + temp);
				}

				count += rlength;

			} else if (type == NS) {

				this.rname.addElement(rname);

				types.addElement("NS");

				if (debug) {
					System.out.println("Processing Nameserver info");
				}

				String temp = decode(receive, count);

				answers.addElement(temp);

				if (debug) {
					System.out.println("Names server is " + temp);
				}

				count += rlength;

			} else if (type == SOA) {

				this.rname.addElement(rname);

				types.addElement("SOA");

				String MName = decode(receive, count); //primary source

				count += length(receive, count);

				String RName = decode(receive, count); //mailbox of responsible person

				count += length(receive, count);

				long serial = get32Bit(receive);

				long refresh = get32Bit(receive);

				long retry = get32Bit(receive);

				long expire = get32Bit(receive);

				long ttl = get32Bit(receive);

				answers.addElement(MName + ", " + RName + ", serial = " + serial + ", refresh = " + refresh +", retry = " + retry + ", expire = " + expire + ", min ttl = " + ttl);

				if (debug) {
					System.out.println("MName is " + MName);

					System.out.println("RName is " + RName);

					System.out.println("serial is " + serial);

					System.out.println("refresh is " + refresh);

					System.out.println("retry is " + retry);

					System.out.println("expire is " + expire);

					System.out.println("ttl is " + ttl);
				}

			} else if (type == HINFO) {

				this.rname.addElement(rname);

				types.addElement("HINFO");

				String CPU = getString(receive);

				String OS = getString(receive);

				answers.addElement("CPU = " + CPU + ", OS = " + OS);

				if (debug) {
					System.out.println("CPU is " + CPU);

					System.out.println("OS is " + OS);
				}

			} else if (type == MX) {

				this.rname.addElement(rname);

				types.addElement("MX");

				if (debug) {
					System.out.println("Processing MX info");
				}

				int pref = (((receive[count++] << 8) & 0xFF00)) | (receive[count++] & 0xFF);

				String mxserver = decode(receive, count);

				if (debug) {
					System.out.println("preference is " + pref);

					System.out.println("mx server is " + mxserver);
				}

				answers.addElement(mxserver + ", preference = " + pref);

				count += rlength - 2;

			} else if (type == CNAME) {
				this.rname.addElement(rname);

				types.addElement("CNAME");

				if (debug) {
					System.out.println("Processing Cononical Name info");
				}

				String temp = decode(receive, count);

				answers.addElement(temp);

				if (debug) {
					System.out.println("Cononical name is " + temp);
				}

				count += rlength;

			} else {
				System.err.println("Unsupported TYPE found: Error");
			}

		return "";

	}

	/*

	 *  Returns a long from a 32 bit value in the stream

	 */

	long get32Bit(byte[] input) {

			return ((input[count++] << 24) & 0xFF000000) | ((receive[count++] << 16) & 0xFF0000) | ((receive[count++] << 8) & 0xFF00) | (receive[count++] & 0xFF);

	}

	/*

	 *  Return string data from a stream

	 */

	String getString(byte[] input) {

		int size = input[count++];

		String temp = "";

		while (size-- > 0) {

			temp += (char) input[count++];

		}

		return temp;

	}

	/*

       	 *  DNS encodes the specified string.  DNS encoding breaks the name based

	 *  on periods.

       	 */

	byte[] encode(String name) {

		byte data[] = new byte[name.length() + 2];

		int t = 0;

		int start = 0;

		int end = name.indexOf(".", start);

		while (true) {

			if (end == -1) {

				end = name.length();

			}

			data[t++] = (byte) (end - start);

			for (int i = start; i < end; i++) {

				data[t++] = (byte) name.charAt(i);

			}

			start = end + 1;

			end = name.indexOf(".", start);

			if (start == (name.length() + 1) && end == -1) {

				break;

			}

		}

		data[t++] = (byte) 0;

		return data;

	}

	String decode(byte[] input, int offset) {

		String host = "";

		int t = offset;

		byte b = input[t++];

		if ((b & 0xC0) == 0xC0) {

			byte b2 = input[t++];

			int pointer = ((b << 8) & 0x3F00) | (b2 & 0xFF);

			return host + decode(input, pointer);

		}

		while (b != 0 && (b & 0xC0) != 0xC0){

			int end = t + b;

			for (int i = t; i < end; i++) {

				host += (char) input[t++];

			}

			b = input[t++];

			if (b != 0 && (b & 0xC0) != 0xC0) {

				host += ".";

			}

		}

		if ((b & 0xC0) == 0xC0) {

			byte b2 = input[t++];

			int pointer = ((b << 8) & 0x3F00) | (b2 & 0xFF);

			return host + "." + decode(input, pointer);

		}

		return host;

	}

	int length(byte[] input, int offset) {

		int t = offset;

		byte b = input[t++];

		if ((b & 0xC0) == 0xC0) {

			byte b2 = input[t++];

			int pointer = ((b << 8) & 0x3F00) | (b2 & 0xFF);

			return t - offset;

		}

		while (b != 0 && (b & 0xC0) != 0xC0){

			int end = t + b;

			for (int i = t; i < end; i++) {

			}

			b = input[t++];

			if (b != 0 && (b & 0xC0) != 0xC0) {

			}

		}

		if ((b & 0xC0) == 0xC0) {

			byte b2 = input[t++];

			int pointer = ((b << 8) & 0x3F00) | (b2 & 0xFF);

			return t - offset;

		}

		return t - offset;

	}

	public String reverse(String ip) {

		try {
			int d1 = ip.indexOf(".", 0);

			int d2 = ip.indexOf(".", d1 + 1);

			int d3 = ip.indexOf(".", d2 + 1);

			return ip.substring(d3 + 1, ip.length()) + "." + ip.substring(d2 + 1, d3) + "." + ip.substring(d1 + 1, d2) + "." + ip.substring(0, d1) + ".in-addr.arpa";
		} catch (Exception e) {
		}

		return "0.0.0.0.in-addr.arpa";
	}

}