// ForkServerTask.h: interface for the ForkServerTask class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FORKSERVERTASK_H__F4C71FB8_D144_4D55_90CA_6F25654B2E01__INCLUDED_)
#define AFX_FORKSERVERTASK_H__F4C71FB8_D144_4D55_90CA_6F25654B2E01__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <atask\Task.h>
#include <atask\Synchronization.h>
#include "TableTop.h"

#define N_FORKS N_PHILOSOPHERS

typedef int ForkId;	// range 0 .. N_FORKS - 1

class ForkServerTask : public Task  
{
public:
	Entry0 request_and_wait[N_PHILOSOPHERS];
	Entry1<PhilosopherId> release;

	ForkServerTask();
	~ForkServerTask();

protected:
	virtual void body();
	virtual Priority priority();
	virtual size_t virtual_sizeof();

private:
	bool available[N_FORKS];

	bool can_grab_both(PhilosopherId philo_id);
};

#endif // !defined(AFX_FORKSERVERTASK_H__F4C71FB8_D144_4D55_90CA_6F25654B2E01__INCLUDED_)
