# Makefile for Calendar Example program (Windows 95 / NT version)

TARGETOS=BOTH
APPVER=4.0
!include <win32.mak>

##### Module Macros ####
NAME    = example
SRCS	= $(NAME).c
OBJS    = $(SRCS:.c=.obj)

##### Library Macros #####
LIBS    = $(guilibs) calend32.lib

##### Resource Macro #####
RCFILES = $(NAME).rc

##### DEBUG Macro Defined #####
DEBUG	= 1

##### Tool Macros #####
CC      = $(cc) $(cdebug) $(cflags) $(cvars)
RC      = rc

##### Inference Rules #####
.c.obj:
    $(CC) $*.c

.rc.res:
    $(RC) -r $*.rc

##### Main (default) Target #####
goal: $(NAME).exe

##### Dependents For Goal and Command Line #####
$(NAME).exe: $(OBJS) $(NAME).def $(NAME).res
    $(link) @<<$*.lnk
    $(OBJS)
    -out:$(NAME).exe
    -map:$(NAME).map
    $(guilflags) $(linkdebug)
    $(LIBS)
    $(NAME).res
<<KEEP

##### Dependents #####
$(NAME).res: $(RCFILES)

clean:
    -del *.obj
    -del *.res
    -del *.exe
    -del *.map
    -del *.sym
    -del *.bak
    -del *.pdb
    -del *.exp
    -del *.lnk
