#include <windows.h>
#include <stdio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include "calendar.h"
#include "example.h"

#if defined(WIN32)
#define _Export                 __declspec(dllexport)
#else
#define _Export                 _export
#endif

int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int);
BOOL _Export CALLBACK ExampleDlgProc(HWND, unsigned, WPARAM, LPARAM);

int PASCAL WinMain(
    HINSTANCE  hInst,          // current instance
    HINSTANCE  hPrev,          // previous instance
    LPSTR   lpszCmdLine,       // command line
    int     iCmdShow )         // display mode
{
    FARPROC  fpfn;

    fpfn = MakeProcInstance((FARPROC)ExampleDlgProc, (HINSTANCE) hInst);
    DialogBox((HINSTANCE) hInst, MAKEINTRESOURCE(EXAMPLEBOX), NULL, (DLGPROC)fpfn);
    FreeProcInstance(fpfn);

    return TRUE;
}


BOOL FAR PASCAL ExampleDlgProc(HWND hDlg, unsigned wMsg, WPARAM wParam, LPARAM lParam)
{
    static CALENDAR Info;
    char Date[9];

    switch (wMsg)
    {
        case WM_INITDIALOG:
            // Calendar initialization
            calInit("EVALUATE");
            // Calendar customization
            calGetParams(&Info);
            Info.DayColor = RGB(0,0,255);
            Info.SelectedDayColor = RGB(255,0,0);
            Info.SelectedBkgColor = RGB(0, 128, 255);
            Info.FirstDayOfWeek = MONDAY;
            Info.xPos = GetSystemMetrics(SM_CXSCREEN)/4;
            Info.yPos = GetSystemMetrics(SM_CYSCREEN)/4;
            strcpy(Info.FontName, "Times New Roman");
            calSetParams(&Info);

            return TRUE;

        case WM_COMMAND:
            switch (wParam)
            {
                case IDOK:
                    if(Calendar(hDlg, Date, NULL))
                        SetDlgItemText(hDlg, IDT_REPORT, Date);
                    else
                        SetDlgItemText(hDlg, IDT_REPORT, "No selection");
                    break;

                case IDCANCEL:
                    EndDialog(hDlg, FALSE);
                    break;

                case IDP_DEFAULT:
                    calSetDefaults();
                    break;
            }
            break;
    }
    return FALSE;
}
