#include "chartdir.h"

int main(int argc, char *argv[])
{
	//The data for the area chart
	double data[] = {25, 18, 9, 4, 5, 8, 14, 20, 40, 92, 75, 88, 75, 
		58, 90, 95, 83, 75, 70, 66, 46, 38, 28, 15, 22};

	//The labels for the area chart
	const char *labels[] = {"0", "", "", "3", "", "", "6", "", "", "9", "", "", 
		"12", "", "", "15", "", "", "18", "", "", "21", "", "", "24"};
	
	//First, create a XYChart of size 300 pixels x 280 pixels
	XYChart *c = XYChart::create(300, 280);

	//Set the plotarea at (50, 25) and of 200 pixel (w) x 200 pixels (h)
	c->setPlotArea(50, 25, 200, 200);

	//Add a title to the chart
	c->addTitle("Daily Server Load");
		
	//Add a title to the y axis
	c->yAxis()->setTitle("MBytes");

	//Add a title to the x axis
	c->xAxis()->setTitle("June 12, 2001");
	
	//Set the x axis labels using the supplied labels
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add an area layer to the chart
	AreaLayer *layer = c->addAreaLayer();

	//Add a data set to the area layer, and set the data color to 
	//light blue (0xa8a8ff) and the line color to blue (0x0000ff)
	layer->addDataSet(sizeof(data) / sizeof(data[0]), data)
		->setDataColor(0xa8a8ff, 0x0000ff);

	//Set the line width to 3 pixels to highlight the line
	layer->setLineWidth(3);

	//output the chart as a PNG file
	c->makeChart("linearea.png");

	//destroy the chart to free up resources
	c->destroy();

	return 0;
}