#include "chartdir.h"

void logaxis(bool logaxis, const char *filename)
{
	//data for the chart
	double data[] = {100, 125, 260, 147, 67};
	const char *labels[] = {"Mon", "Tue", "Wed", "Thur", "Fri"};

	//create a XYChart object of size 200 x 180
	XYChart *c = XYChart::create(200, 180);
	
	//set the plot area to start at (30, 10) and of size 140 x 130
	c->setPlotArea(30, 10, 140, 130);

	//use log scale axis if required
	if (logaxis)
		c->yAxis()->setLogScale();

	//Set the labels on the x axis
	c->xAxis()->setLabels(sizeof(labels) / sizeof(labels[0]), labels);

	//Add a bar layer using the supplied data
	c->addBarLayer(sizeof(data) / sizeof(data[0]), data);
	
	//output the chart as a PNG file
	c->makeChart(filename);

	//destroy the chart to free up resources
	c->destroy();
}

int main(int argc, char *argv[])
{
	logaxis(false, "linearaxis.png");
	logaxis(true, "logaxis.png");
	return 0;
}