------------------------------------------------------------------------------
---------------------- PMODE Para Watcom C/C++ - v1.33 -----------------------
------------------------------------------------------------------------------

  Esta es la documentacin del PMODE para Watcom C/C++ - v1.33, al cual nos
referiremos a partir de ahora como PMODE/W. PMODE/W tiene Copyright (c)
1994-1997 por Charles Scheffold y Thomas Pytel. Todos los derechos reservados.

Contenidos:
-----------

1 - Vista preliminar
    1.0 - Disposicin legal
    1.1 - Descripcin
    1.2 - Uso
    1.3 - Funcionamiento y compatibilidad
    1.4 - Modo protegido PMODE/W
    1.5 - Ejecucin de PMODE/W
    1.6 - Condiciones para el uso no comercial
    1.7 - Licencia de PMODE/W para uso comercial
    1.8 - Informacin para contactar

2 - Funciones de la INT 31h soportadas por DPMI
    2.0  - Funcin 0000h - Asignar Descriptores
    2.1  - Funcin 0001h - Liberar Descriptor
    2.2  - Funcin 0002h - Segmento a Descriptor
    2.3  - Funcin 0003h - Toma el Valor de Incremento del Selector
    2.4  - Funcin 0006h - Toma la Direccin Base del Segmento
    2.5  - Funcin 0007h - Establecer la Direccin Base del Segmento
    2.6  - Funcin 0008h - Establecer el Lmite del Segmento
    2.7  - Funcin 0009h - Establecer los Derechos de Acceso del Descriptor
    2.8  - Funcin 000Ah - Crea un Descriptor de Alias
    2.9  - Funcin 000Bh - Tomar Descriptor
    2.10 - Funcin 000Ch - Establecer Descriptor
    2.11 - Funcin 0100h - Asignar Bloque de Memoria de DOS
    2.12 - Funcin 0101h - Liberar Bloque de Memoria de DOS
    2.13 - Funcin 0102h - Dar Nuevo Tamao al Bloque de Memoria de DOS
    2.14 - Funcin 0200h - Toma el Vector de Interrupcin en Modo Real
    2.15 - Funcin 0201h - Establecer el Vector de Interrupcin en Modo Real
    2.16 - Funcin 0202h - Toma el Vector del Manejador de Excepciones del
                           Procesador
    2.17 - Funcin 0203h - Establecer el Vector del Manejador de Excepciones del
                           Procesador
    2.18 - Funcin 0204h - Toma el Vector de Interrupcin en Modo Protegido
    2.19 - Funcin 0205h - Establecer el Vector de Interrupcin en Modo
			   Protegido
    2.20 - Funcin 0300h - Simular Interrupcin en Modo Real
    2.21 - Funcin 0301h - Llamar al Procedimiento en Modo Real con Marco de
			   Retorno Lejano
    2.22 - Funcin 0302h - Llamar al Procedimiento en Modo Real con Marco IRET
    2.23 - Funcin 0303h - Asignar la Direccin de la Llamada de Retorno en Modo
                           Real
    2.24 - Funcin 0304h - Liberar la Direccin de la Llamada de Retorno en Modo
                           Real
    2.25 - Funcin 0305h - Muestra el Estado de las Direcciones para
                           Grabar/Restaurar
    2.26 - Funcin 0306h - Toma Direcciones de Enlace en Modo Raw
    2.27 - Funcin 0400h - Muestra la Versin
    2.28 - Funcin 0500h - Muestra la Informacin sobre la Memoria Libre
    2.29 - Funcin 0501h - Asignar Bloque de Memoria
    2.30 - Funcin 0502h - Liberar Bloque de Memoria
    2.31 - Funcin 0503h - Dar Nuevo Tamao al Bloque de Memoria
    2.32 - Funcin 0800h - Mapeado de Direccin Fsica
    2.33 - Funcin 0801h - Liberar el Mapeado de Direccin Fsica
    2.34 - Funcin 0900h - Da y Desactiva el Estado de la Interrupcin Virtual
    2.35 - Funcin 0901h - Da y Habilita el Estado de la Interrupcin Virtual
    2.36 - Funcin 0902h - Da el Estado de la Interrupcin Virtual
    2.37 - Funcin EEFFh - Da la Informacin del Extensor de DOS

3 - Funciones extendidas de la INT 21h soportadas por el DOS
    3.0  - Funcin 09h - Escribir Cadena a una Salida Estndar
    3.1  - Funcin 1Ah - Establecer el Area de Transferencia del Disco
    3.2  - Funcin 1Bh - Toma Informacin de Asignacin para la Unidad por
			 Defecto
    3.3  - Funcin 1Ch - Toma Informacin de Asignacin para una Unidad
			 Especfica
    3.4  - Funcin 1Fh - Toma el Bloque del Parmetro de la Unidad para la
                         Unidad por Defecto
    3.5  - Funcin 25h - Establecer el Vector de Interrupcin
    3.6  - Funcin 2Fh - Toma el Area de Transferencia del Disco
    3.7  - Funcin 32h - Toma el Bloque del Parmetro de la Unidad para una
			 Unidad Especfica
    3.8  - Funcin 34h - Toma la Direccin de un Flag InDOS
    3.9  - Funcin 35h - Toma el Vector de Interrupcin
    3.10 - Funcin 39h - Crear Subdirectorio
    3.11 - Funcin 3Ah - Eliminar Subdirectorio
    3.12 - Funcin 3Bh - Establecer Subdirectorio
    3.13 - Funcin 3Ch - Crear Fichero
    3.14 - Funcin 3Dh - Abrir Fichero
    3.15 - Funcin 3Fh - Leer del Fichero
    3.16 - Funcin 40h - Escribir a Fichero
    3.17 - Funcin 41h - Borrar Fichero
    3.18 - Funcin 43h - Muestra/Establece los Atributos del Fichero
    3.19 - Funcin 47h - Toma el Path del Directorio
    3.20 - Funcin 48h - Asignar Bloque de Memoria
    3.21 - Funcin 49h - Liberar Bloque de Memoria
    3.22 - Funcin 4Ah - Dar Nuevo Tamao al Bloque de Memoria
    3.23 - Funcin 4Bh - Sub-Funcin 00h - Carga y Ejecuta el Programa
    3.24 - Funcin 4Eh - Busca la Primera Coincidencia en el Nombre del Fichero
    3.25 - Funcin 4Fh - Busca la Siguiente Coincidencia en el Nombre del
			 Fichero
    3.26 - Funcin 56h - Renombrar Fichero
    3.27 - Funcin 62h - Toma la Direccin PSP

4 - Funciones extendidas de la INT 33h soportadas por el ratn
    4.0  - Funcin 0009h - Definir el Cursor Grfico
    4.1  - Funcin 000Ch - Definir los Parmetros de la Subrutina de la
                           Interrupcin
    4.2  - Funcin 0016h - Grabar el Estado del Controlador
    4.3  - Funcin 0017h - Restablecer el Estado del Controlador

------------------------------------------------------------------------------
-------------------------- 1 - Vista Preliminar ------------------------------
------------------------------------------------------------------------------

  Esta seccin te dar toda la informacin que necesitars para conectar
PMODE/W a tus programas en modo protegido Watcom C/C++. Todas las dems cosas
que necesitas saber sobre cmo usar PMODE/W comercialmente y no comercialmente
se encuentran tambin en esta seccin. Informacin especfica sobre las
INT 31h y INT 21h de los servicios del DOS extendido soportados por PMODE/W se
encuentra en las siguientes secciones. Por favor, ten en cuenta que hemos
probado este modo extendido con las versiones 9.5, 10.0, 10.5 y 10.6 de
Watcom C/C++.

1.0 - Disposicin legal:
------------------------

  Declinamos todas y cada una de las garantas implcitas, incluyendo
garantas de comerciabilidad y ajuste a un prposito particular. No
garantizamos ni representamos, ni expresa ni implcitamente, con respecto a
PMODE/W, su calidad, funcionamiento, comerciabilidad o ajuste a un prposito
particular. No tendremos ninguna responsabilidad por daos especiales,
incidentales o consiguientes derivados o como resultado del uso, mal uso o
modificacin de PMODE/W.

  Todas las marcas comerciales usadas en esta documentacin son propiedad de sus
respectivos dueos.

1.1 Descripcin:
----------------

  PMODE/W es un extensor de DOS para el paquete Watcom C/C++. Permite que los
programas del DOS corran en modo protegido de 32 bit, con acceso a toda la
memoria disponible en el sistema. PMODE/W bsicamente extiende el entorno DOS
al modo protegido y suministra un sencillo interfaz a los servicios de sistema
del modo real DOS para tu cdigo. PMODE/W tiene cuidado de todos los aspectos a
la hora de hacer funcionar el sistema en modo protegido y de mantener la
compatibilidad con el software del modo real que est por debajo. PMODE/W se
ocupa de necesidades a bajo nivel tales como tablas del descriptor,
administracin de memoria, redireccionamiento de IRQ e interrupciones,
funciones de conversin de modo real/protegido, manejo de excepciones y otra
serie de aspectos de la ejecucin en modo protegido. Tu cdigo no necesita
manejar aspectos especficos de diferentes sistemas tales como disponibilidad
XMS/EMS/VCPI/DPMI. PMODE/W funcionar sobre casi cualquier sistema y
proporciona los servicios comunes de modo protegido a tu programa a travs de
la especificacin de interfaz DPMI, as como la mayora de las funciones
estndar de DOS extendido para el uso del modo protegido.

  PMODE/W sustituye el extensor DOS/4GW en el paquete Watcom C/C++. Mientras
que DOS/4GW requiere una cabecera y un gran extensor externo, PMODE/W es
cabecera y el extensor en uno solo. El ejecutable generado contiene el extensor
PMODE/W dentro de l as como la cabecera. Cuando se ejecuta, PMODE/W tendr
cuidado de configurar el sistema y ejecutar la parte de modo protegido del
programa. PMODE/W tiene la ventaja aadida de permitirte comprimir tus programas
en modo protegido. PMODE/W adems es completamente intercambiable con DOS/4GW.
Puedes conectar PMODE/W en casi todos los programs Watcom C/C++ sin preocuparte.
Mientras el programa no use funciones especficas de DOS/4GW, el cdigo
funcionar correctamente. Esto te permite conectar directamente de nuevo con
DOS/4GW si por cualquier razn no ests satisfecho con PMODE/W. Esto tambin
te permite depurar los programas PMODE/W usando el debugger de Watcom, ya que
cualquier ejecutable descomprimido de PMODE/W puede ejecutarse con DOS/4GW
slo con ejecutarlo con DOS4GW.EXE.

  El desarrollo de PMODE/W ha llevado varios aos. Ahora es un extensor de DOS
bastante maduro y ha pasado por su justa dosis de bugs e incompatibilidades. Es
en este momento un sistema de modo protegido bastante estable. Grandes
sufrimientos han llevado la optimacin y la prueba de PMODE/W. Nuestros mayores
objetivos han sido la velocidad, el tamao y la estabilidad. Creemos que ahora
hemos logrado una buena parte de estas cosas. Pero no aceptes nuestra palabra,
prubalo por ti mismo ya que puedes hacerlo muy fcilmente antes de realmente
decidirte a comprar PMODE/W. Simplemente conecta PMODE/W a cualquier programa
de moda que use DOS/4GW.

  En resumen, si ests buscando un buen extensor, slido, estable y rpido,
PMODE/W puede ser lo que necesitas.

Aqu tienes las ventajas de PMODE/W:

) No se necesita un extensor externo (todo lo que se necesita ejecutar est en
  el EXE).
) Tamao reducido (menos de 12k para todo el programa extensor).
) Compresin de los ejecutables del modo protegido.
) Poco gasto de memoria extendida
) No necesita NADA de memoria extendida para cargar O ejecutar.
) Ejecucin rpida.
) Gratis para uso no comercial.

1.2 - Uso:
----------

  Los siguientes ficheros principales deberan estar presentes en tu archivo
PMODE/W:

) FILE_ID.DIZ   - Fichero de descripcin de BBS.
) UPDATES.DOC   - Informacin sobre actualizaciones/correcin de bugs.
) PMODEW.DOC    - La documentacin que ests leyendo en este momento.
) PMODEW.EXE    - El extensor PMODE/W de DOS en s.
) PMODEW.FAQ    - Las preguntas hechas con ms frecuencia.
) PMODEW.LNK    - Ejemplo de fichero de inicializacin del enlazador para
                  PMODE/W.
) PMWSETUP.EXE  - Utilidad de configuracin de parmetros para PMODE/W.
) PMWBIND.EXE   - Utilidad para enlazar de PMODE/W.
) PMWLITE.EXE   - Utilidad de compresin de ejecutables en modo protegido de
		  PMODE/W.
) PMWVER.COM    - Utilidad para comprobar la versin de PMODE/W.
) UTILS.DOC     - Documentacin sobre PMWSETUP, PMWBIND, PMWLITE, y PMWVER.
) EXAMPLES.ZIP  - Ficheros de ejemplo.

  Probablemente querrs aadir un nuevo sistema, PMODE/W, a tu fichero
WLSYSTEM.LNK. Todo lo que necesitas hacer en ese caso es aadir los contenidos
de PMODEW.LNK a tu fichero WLSYSTEM.LNK; esto aadir el sistema 'pmodew' a tu
configuracin de Watcom C/C++. Tambin puedes simplemente compilar a un sistema
'dos4gw' pero sustituye el <stub> con el PMODEW.EXE.

1.3 - Funcionamiento y compatibilidad:
--------------------------------------

  Nuestras mayores preocupaciones a la hora de desarrollar PMODE/W fueron la
velocidad, el tamao y la estabilidad. El propio PMODE/W fue escrito
enteramente en ensamblador. Cuando ests ejecutando bajo PMODE/W, tu cdigo
estar siendo ejecutado a un nivel de privilegio de cero, el mayor y el ms
rpido. PMODE/W no virtualiza ya que lo que hace no lo necesita y no invoca
ningn mecanismo de modo protegido que sea lento. Por ejemplo, si el sistema
est corriendo limpio o bajo XMS, PMODE/W no pone en marcha la paginacin.
Bajo un gestionador de memoria que proporciona los servicios tanto de VCPI como
de DPMI, PMODE/W optar por el modo protegido VCPI que es significativamente
ms rpido que el DPMI. Cuando PMODE/W hace llamadas al modo real, cambia el
sistema al verdadero modo real antes que al modo ms lento V86 (cuando puede,
bajo VCPI esto no es posible, el control debe ser devuelto al servidor VCPI).
En trminos de velocidad, cuando tu cdigo est siendo ejecutado bajo PMODE/W,
est siendo ejecutado tan rpido como lo permite el sistema.

  En trminos de tamao de disco, no necesitamos decirte nada ms que mires el
tamao del ejecutable de PMODE/W y lo compares con otros extensores. En
trminos de tamao de memoria, puedes hacer pruebas por ti mismo para confirmar
que PMODE/W de hecho absorbe mucha menos memoria durante el tiempo de ejecucin
que la competencia. De hecho, PMODE/W funcionar incluso si no hay
absolutamente nada de memoria extendida en el sistema (asumiendo, por supuesto,
que hay suficiente memoria baja para el programa). Para ser justos, debemos
decir que redujimos el ejecutable de PMODE/W con nuestro propio programa de
compresin escrito expresamente para este fin, esto, sin embargo, demuestra
para qu usamos la mayor parte de nuestras optimizaciones.

  En cuanto a la compatibilidad, PMODE/W es casi totalmente compatible con
DOS/4GW en lo que se refiere a Watcom C/C++. PMODE/W extiende slo aquellas
fundiones de DOS que necesitan las libreras de Watcom C/CC++, aunque esto es
una buena cantidad de ellas. La excepcin son las funciones de la INT 13h de la
BIOS, las cuales PMODE/W no extiende. PMODE/W tambin proporciona un grupo de
funciones de la INT 31h de DPMI 0.9 en modo protegido. Sin embargo, no emulamos
DOS/4GW ya que ninguna de sus funciones API es duplicada por PMODE/W. PMODE/W
correr bajo un sistema limpio, XMS, VCPI o DPMI. Aunque debes saber que, bajo
un sistema DPMI, PMODE/W no estar proporcionando las funciones DPMI sino que
lo har el host DPMI real en el sistema. Tambin debes saber que PMODE/W dejar
la lnea A20 disponible cuando llame al modo real. Desactivar la A20 para el
modo real no es realmente necesario, es un gran retardo durante el intercambio
de modos el tener que activar/desactivar la A20 por lo que PMODE/W lo evita.

1.4 - Modo protegido PMODE/W:
-----------------------------

  Cuando lo ejecutas en un sistema limpio, XMS o VCPI, PMODE/W tiene el
control del modo protegido. En este caso, puede configurar el sistema para que
vaya tan rpido como sea posible segn las diferentes condiciones. Bajo DPMI,
el host DPMI del sistema tendr un control total del modo protegido y PMODE/W
instalar sus extensiones de DOS encima de todo. Si el sistema proporciona los
servicios tanto de VCPI como de DPMI, PMODE/W usar los servicios de VCPI para
una ejecucin ms rpida, a no ser que se le diga que no lo haga mediante la
configuracin del programa. Cuando PMODE/W tiene el control del modo protegido
bajo sistema limpio/XMS/VCPI, ejecuta todos los cdigos en el nivel de
privilegio de cero. Adems, bajo un sistema limpio o XMS, la paginacin no
estar disponible. Esto es slo un pequeo aumento de la velocidad pero no hay
realmente necesidad de manejar la paginacin.

  PMODE/W proporciona un grupo de llamadas de funcin de DPMI 0.9 y una
funcionalidad general cuando no hay un host DPMI. PMODE/W pasar todas las
interrupciones de software del modo protegido a sus manejadores por defecto del
modo real, supuesto que no se hayan instalado manejadores en modo protegido
para ellos, tal como hara DPMI. Los registros generales se traspasarn al
manejador en modo real pero los registros de segmento no pueden ser traspasados
ya que tienen sentidos diferentes en el modo real y en el modo protegido. Los
flags se devolvern desde el manejador del modo protegido. Esto proporciona un
sencillo interfaz a todas las rutinas de interrupcin en modo real las cuales
no toman parmetros en los registros de segmento, por ejemplo, funcin 00h de
la INT 16h.

  Todas las IRQs que tienen lugar en el modo protegido y no han sido
enganchadas por un manejador en modo protegido sern enviadas a sus manejadores
en modo real. Si una IRQ tiene lugar en el modo real y un manejador en modo
protegido ha enganchado esa IRQ, ser enviada en primer lugar al manejador en
modo protegido. El manejador en modo protegido puede enlazar con el manejador
en modo real para esa IRQ llamando al anterior manejador en modo protegido para
esa IRQ. Este procedimiento se corresponde con el estndar del DPMI. Si
enganchas una IRQ en modo protegido (funcin 0205h de la INT 31h) y luego
enganchas la misma IRQ en modo real (funcin 0201h de la INT 31h), el manejador
en modo protegido ser llamado si la IRQ tiene lugar en modo protegido y el
manejador en modo real se ocupar de las IRQs si stas tienen lugar en modo
real. Configurando dos manejadores de esta forma se asegura un mnimo tiempo de
espera. Esto quiere decir que un manejador tomar el control, cuando la IRQ
tenga lugar, tan pronto como fsicamente sea posible. Sin embargo, PMODE/W
tiene que intervenir en el proceso de las IRQs cuando las 8 IRQs bajas son
asignadas a las INTs 08h-15h para diferenciar las IRQs de las excepciones de
CPU.

  De acuerdo con las especificaciones DPMI, PMODE/W traspasar las
interrupciones de software 1ch (BIOS timer tick), 23h (DOS CTRL+C) y 24h
(Error crtico de DOS) del modo real al modo protegido. Esto significa que esas
interrupciones pueden ser enganchadas directamente en modo protegido sin que
hayas tenido que configurar un mecanismo de llamada de retorno por tu cuenta.
PMODE/W tambin pasar la interrupcin 1bh (BIOS CTRL+BREAK) del modo real al
modo protegido. Este no es un requerimiento del DPMI pero es necesario por el
bien de la compatibilidad con el DOS/4GW.

  Otro desmarque de PMODE/W respecto a las especificaciones oficiales de DPMI
se da en la asignacin de la memoria extendida. La documentacin de DPMI
establece que el bloque de memoria extendida asignado por medio de la funcin
0501h est garantizado al menos el alineamiento de prrafo. La implementacin
de DPMI por el PMODE/W obligar slo el alineamiento de las DWORD.

1.5 - Ejecucin de PMODE/W:
---------------------------

  Cuando se hace correr un ejecutable de PMODE/W, PMODE/W intentar conectar el
sistema al modo protegido y cargar la parte de modo protegido del propio
ejecutable. Si hay algn error, no hay suficiente memoria o incompatibilidad
del sistema, PMODE/W saldr con un mensaje de error. Si la carga tuvo xito,
PMODE/W traspasar el control de la ejecucin al programa. PMODE/W cargar
cualquier cdigo y datos de 16 bit en la memoria baja, pero los cdigos y datos
de 32 bit pueden ser cargados en la memoria baja o en la memoria extendida
dependiendo de su disponibilidad.

  Hay un nmero de parmetros modificables en el extensor ejecutable de PMODE/W
que afectan a la ejecucin en modo protegido. En su mayor parte, estos
parmetros tienen que ver con la memoria. PMODE/W asigna un bloque grande de
memoria extendida de la cual suministra memoria a su programa cliente.
Hay un valor mximo para la memoria extendida que puede ser asignada.
Por defecto, el mximo es toda la memoria extendida del sistema. El valor
mximo refleja el tamao del bloque que quieres que PMODE/W tome del sistema y
no necesariamente el tamao del bloque ms grande disponible para las funciones
malloc por defecto de C/C++. Puedes establecer el mximo en cero para indicar
que no quieres que PMODE/W asigne NADA de memoria extendida. La cantidad de
memoria del sistema que le permites asignar a PMODE/W determina qu cantidad
de memoria extendida quedar disponible para otro programa si sales con un
shell de tu programa PMODE/W.

  Otra variable especifica la cantidad de memoria baja que el PMODE/W INTENTARA
dejar libre. Si el PMODE/W puede, compondr este valor cargando cdigo y datos
de 32 bit en la memoria extendida. Si no hay suficiente memoria extendida
disponible para esto, el cdigo y los datos de 32 bit se cargarn de todos
modos en la memoria baja. Si el PMODE/W no puede mantener libre la cantidad de
memoria baja indicada, no saldr con un mensaje de error. Estableciendo este
parmetro en un valor elevado, en realidad duplicar el comportamiento del
DOS/4GW de cargar todo el cdigo y los datos de 32 bit en la memoria extendida.
Si realmente no necesitas ninguna cantidad extra de memoria baja libre durante
la ejecucin de tu programa, puedes poner este valor en cero.

  Hay un grupo de parmetros que especifican el nmero y el tamao de las pilas
anidadas del enlace de modos. Cada vez que haces una llamada al modo real o una
llamada de retorno o una IRQ es pasada del modo real a su rutina en modo
protegido, se usa una pila anidada. Estos parmetros slo tienen sentido si el
programa no se ejecuta bajo un sistema DPMI. Si un host DPMI est cuando se
ejecuta el programa, proporciona sus propias pilas anidadas para el intercambio
de modos. El nmero de pilas anidadas afecta directamente al nmero de los
enlaces de modos anidados que tu programa puede hacer usando los diversos
mtodos de enlace de modos. El tamao de las pilas anidadas tanto en modo real
como en modo protegido tambin puede ser especificado. Por defecto, estos
valores son suficientemente grandes para las operaciones normales. Sin embargo,
si pretendes usar un montn de variables de pila en un manejador IRQ en modo
protegido o un montn de llamadas recursivas, es posible que necesites
incrementar el tamao de las pilas anidadas en modo protegido. Cuantas ms
pilas anidadas especifiques y cuanto ms grandes sean ms memoria baja necesita
el PMODE/W durante la ejecucin.

  Otro grupo de variables que slo tienen sentido bajo ejecucin en sistemas
limpio/XMS/VCPI especifica el nmero de selectores y llamadas de retorno de
DPMI que quieres que el PMODE/W convierta en disponibles. Cuantos ms
selectores y llamadas de retorno pidas ms memoria baja es usada por PMODE/W,
aunque la cantidad de memoria baja usada por cada una es bastante pequea por
lo que se pueden especificar grandes cantidades de cada una. Normalmente habr
disponibles un poco menos del nmero de selectores y llamadas de retorno del
que t solicites para tu programa debido a que el sistema en modo protegido y
el cdigo C/C++ usan algunas de ellas. Por esta razn deberas pedir 20h-40h
selectores ms y 2-4 llamadas de retorno ms de las que necesitars en tu
programa.

  Hay otros cuatro diversos parmetros que se pueden configurar. Hay un nmero
mximo de tablas de pginas para usar bajo un sistema VCPI. Cada tabla de
pgina asignada requiere 4k de memoria baja para ser usada por PMODE/W y
mapea 4M de memoria. Esto afecta directamente a la mxima cantidad de memoria
extendida disponible bajo un sistema VCPI. Este parmetro es slo el nmero
mximo de tablas de pginas permitidas. Durante la ejecucin, slo se asignarn
tantas tablas de pginas como sean necesarias. Bajo un sistema limpio/XMS no
se necesitan tablas de pginas, por lo que este parmetro no tiene sentido.
Pero bajo VCPI, puede que desees restringir el nmero de tablas de pginas para
ahorrar memoria baja si no necesitas ms que una determinada cantidad de
memoria extendida. Esto coloca un tope mximo de memoria extendida bajo VCPI
que puede ser menor que el mximo realmente especificado en la otra variable.
El segundo parmetro especifica el orden de deteccin de DPMI y VCPI. Por
defecto, se comprobar VCPI antes que DPMI, pero puedes establecer que DPMI sea
comprobado antes que VCPI de tal manera que en un sistema que soporte tanto
VCPI como DPMI, se usar DPMI. La tercera variable especifica cuntas pginas
habr que reservar para llamadas de mapeado de direcciones fsicas (funcin
0800h de la INT 31h) bajo VCPI. Bajo XMS o un sistema limpio, la paginacin no
est disponible y PMODE/W no necesita pginas para el mapeado de direcciones
fsicas. Cada pgina te permitir mapear hasta 4M de espacio de direcciones y
necesita 4k de memoria extendida. As, por ejemplo, si intentas mapear un
buffer de marco de 2M de una tarjeta de vdeo, slo necesitars una pgina.
Puedes dejar este parmetro en cero si no piensas mapear ninguna direccin
fsica. El cuarto parmetro especifica si PMODE/W muestra su emblema al
arrancar. Esto puede ser deseable para indicar que el programa realmente se
est ejecutando, y no se ha colgado, ya que la asignacin de memoria desde
algunos servidores VCPI puede ser un proceso lento.

1.6 - Condiciones para el uso no comercial:
-------------------------------------------

  Por la presente, se te permite usar este extensor de DOS en todos los
programas no comerciales y no shareware libre de cualquier obligacin monetaria
para con nosotros, siempre que, si el programa es distribuido, sea distribuido
para el pblico, libre de todo coste debido al programa en s. No hay
restriccin sobre el tipo de reventa que se haga del programa arriba mencionado
(casas shareware, CD-ROMs, etc...), siempre que el programa est disponible
para el pblico sin obligacin monetaria para con el autor/es. Lo nico que te
pedimos en este caso es que nos acredites en tu produccin para el extensor de
DOS. Tambin sera de agradecer, aunque no es necesario, que nos dejaras una
nota informndonos de tu uso del PMODE/W en alguna produccin.

1.7 - Licencia de PMODE/W para uso comercial:
---------------------------------------------

  Si deseas usar PMODE/W en un programa comercial, shareware o cualquier
programa que vaya a ser vendido o que tenga asociada a l alguna obligacin de
comprar algo, DEBES comprar una licencia de distribucin comercial. Esta
licencia te permitir la distribucin libre de derechos de autor de todas y
cada una de las aplicaciones que usando PMODE/W se realicen y pertenezcan al
dueo de la licencia. NO se necesita una licencia diferente para cada
aplicacin en que se use PMODE/W. Esta licencia no es transferible (no puedes
vender, dar, prestar o de cualquier otra forma transferirla a otra persona).

  La cuota de la licencia es de $500 U.S. para programas comerciales o
shareware. Una vez comprada, esta licencia es vlida para todos y cada uno de
los programas creados y que pertenezcan a la personan o compaa que ha
comprado la licencia hasta el fin de los tiempos. La licencia es de una sola
cuota, sin limitaciones sobre en cuntos programas el PMODE/W pueda ser usado.
Hay un descuento especial para el PMODE/W disponible para estudiantes. La
licencia puede ser comprada por estudiantes universitarios por $100 U.S.

1.8 - Informacin para contactar:
---------------------------------

  Si ests interesado en licenciar PMODE/W para un programa comercial o
shareware, puedes contactar con nosotros de la siguiente manera:

) Escribe una carta a:

    Ryan Cramer
    8300 Riding Ridge Place
    McLean, VA 22102
    USA

) Enva un e-mail a:

    rcramer1@osf1.gmu.edu

) En la World Wide Web:

    http://www.di.net/pmw (Pgina oficial)
    http://www.dorsai.org/~daredevi/pmw (Ultima versin, slo download)

) Djale una nota al SysOp de la Data Connection BBS en:

    +1-703-506-8598
    +1-703-847-0861

) Para preguntas tcnicas, deja una nota en la siguiente direccin:

    daredevi@dorsai.org

------------------------------------------------------------------------------
-------------- 2 - Funciones de la INT 31h soportadas por DPMI ---------------
------------------------------------------------------------------------------

  PMODE/W duplica un grupo de funciones del modo protegido DPMI. Estas
funciones estn disponibles SOLO en modo protegido a travs de la INT 31h.
Proporcionan servicios de descriptor, servicios de memoria extendida, servicios
de interrupcin, servicios de conversin y algunas otras cosas. Para llamar a
una funcin se configura AX para el cdigo de la funcin, fijando cualquier
otro registro para la funcin y ejecuntando la INT 31h. Cuando retorna, el flag
de acarreo estar limpio si la funcin tuvo xito. Si el flag de acarreo est
activado, la funcin fall. Todos los dems registros se conservan a menos que
se indique otra cosa. Adems de las funciones enumeradas aqu, las funciones
0600h, 0601h, 0702h y 0703h retornarn con el flag de acarreo limpio para
seguir siendo compatibles con el cdigo que usa esas funciones particulares de
DPMI.


2.0 - Funcin 0000h - Asignar Descriptores:
-------------------------------------------

  Asigna uno o ms descriptores en la tabla de descripcin del cliente. Los
descriptores asignados deben ser inicializados mediante otras llamadas de
funcin.

In:
  AX     = 0000h
  CX     = nmero de descriptores a asignar

Out:
  si tiene xito:
    flag de acarreo limpio
    AX     = selector base

  si falla:
    flag de acarreo activado

Notas:
) Si se solicit ms de un descriptor, la funcin devuelve un selector base
  referenciando el primero de una matriz contigua de descriptores. Los valores
  del selector para los posteriores descriptores en la matriz pueden ser
  calculados aadiendo el valor devuelto por la funcin 0003h de la INT 31h.

) Los descriptores asignados se configurarn para expandir los datos
  escribibles, con el bit actual activado y una base y un lmite de cero. El
  nivel de privilegio de los descriptores coincidir con el nivel de privilegio
  del segmento de cdigo del cliente.

2.1 - Funcin 0001h - Liberar Descriptor:
-----------------------------------------

  Libera un descriptor.

In:
  AX     = 0001h
  BX     = selector para el descriptor a liberar

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) Cada descriptor asignado con la funcin 0000h de la INT 31h debe ser liberado
  de forma individual con la funcin. Incluso si fue previamente asignado como
  parte de una matriz contigua de descriptores.
  
) Bajo DPMI 1.0/VCPI/XMS/raw, todos los registros de segmento que contengan
  el selector que est siendo liberado son puestos a cero por esta funcin.
  
2.2 - Funcin 0002h - Segmento para Descriptor:
-----------------------------------------------

  Convierte un segmento en modo real en un descriptor en modo protegido.
  
In:
  AX     = 0002h
  BX     = segmento en modo real

Out:
  si tiene xito:
    flag de acarreo limpio
    AX     = selector

  si falla:
    flag de acarreo activado

Notas:
) Llamadas mltiples para el mismo segmento en modo real devuelven el mismo
  selector.
  
) El descriptor devuelto no debera ser modificado o liberado jams.

2.3 - Funcin 0003h - Toma el Valor de Incremento del Selector:
---------------------------------------------------------------

  La funcin para Asignar Descriptores (0000h) puede asignar una matriz de
descriptores contiguos, pero slo devuelve un selector para el primer
descriptor. El valor devuelto por esta funcin se puede usar para calcular los
selectores para los posteriores descriptores en la matriz.

In:
  AX     = 0003h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AX     = valor de incremento del selector

Notas:
) El valor de incremento es siempre potencia de dos.

2.4 - Funcin 0006h - Toma la Direccin Base del Segmento:
----------------------------------------------------------

  Devuelve la direccin base lineal de 32bit de la tabla del descriptor para el
segmento especificado.

In:
  AX     = 0006h
  BX     = selector

Out:
  si tiene xito:
    flag de acarreo limpio
    CX:DX  = direccin base lineal de 32bit del segmento

  si falla:
    flag de acarreo activado

Notas:
) Los programas cliente deben usar la instruccin LSL para preguntar el lmite
  para un descriptor.

2.5 - Funcin 0007h - Establecer la Direccin Base del Segmento:
----------------------------------------------------------------

  Establece el campo de la direccin base lineal de 32bit en el descriptor
para el segmento especificado.

In:
  AX     = 0007h
  BX     = selector
  CX:DX  = direccin base lineal de 32bit del segmento

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no se garantiza que salga bien.
  
) Confiamos que tengas el suficiente sentido como para no tratar de modificar
  los actuales descriptores CS o SS.
  
2.6 - Funcin 0008h - Establecer el Lmite del Segmento:
--------------------------------------------------------

  Establece el campo lmite en el descriptor para el segmento especificado.
  
In:
  AX     = 0008h
  BX     = selector
  CX:DX  = lmite del segmento de 32bit

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) El valor suministrado a la funcin en CX:DX es la longitud del byte del
  segmento-1.
  
) Lmites de segmento iguales o mayores que 1M deben ser alineados en pgina.
  Es decir, deben tener los 12 bits bajos activados.
  
) Esta funcin tiene un efecto implcito sobre el bit "G" en el descriptor
  del segmento.
  
) Los programas clientes deben usar la instruccin LSL para preguntar el lmite
  para un descriptor.
  
) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto pero no se garantiza que salga bien.
  
) Confiamos que tengas el suficiente sentido como para no tratar de modificar
  los actuales descriptores CS o SS.
  
2.7 - Funcin 0009h - Establecer los Derechos de Acceso del Descriptor:
-----------------------------------------------------------------------

  Modifica el campo de los derechos de acceso en el descriptor para el segmento
especificado.

In:
  AX     = 0009h
  BX     = selector
  CX     = palabra derechos de acceso/tipo

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) La palabras derechos de acceso/tipo pasados a la funcin en CX tienen el
  siguiente formato:
  
    Bit: 15  14  13  12  11  10   9   8   7   6   5   4   3   2   1   0
       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+
       | G |B/D| 0 | ? |       ?       | 1 |  DPL  | 1 |C/D|E/C|W/R| A |
       +---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+---+

    G   - 0=byte granular, 1=pgina granular
    B/D - 0=por defecto 16bit, 1=por defecto 32bit
    DPL - debe ser igual al CPL del que llama
    C/D - 0=datos, 1=cdigo
    E/C - datos: 0=expand-up, 1=expand-down
	  cdigo: debe ser 0 (no conforme)
    W/R - datos: 0=lectura, 1=lectura/escritura
	  cdigo: debe ser 1 (leble)
    A   - 0=no accedido, 1=accedido
    0   - debe ser 0
    1   - debe ser 1
    ?   - ignorado

) Los programas clientes deberan usar la instruccin LAR para examinar los
  derechos de acceso de un descriptor.
  
) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no se garantiza que salga bien.

) Confiamos que tengas el suficiente sentido como para no tratar de modificar
  los actuales descriptores CS o SS.
  
2.8 - Funcin 000Ah - Crea un Descriptor de Alias:
--------------------------------------------------

  Crea un nuevo descriptor de datos que tiene la misma base y lmite que el
descriptor especificado.

In:
  AX     = 000ah
  BX     = selector

Out:
  si tiene xito:
    flag de acarreo limpio
    AX     = selector de datos (alias)

  si falla:
    flag de acarreo activado

Notas:
) El selector proporcionado a la funcin puede ser tanto un descriptor de datos
  como un descritor de cdigo. El descriptor de alias creado es siempre un
  segmento expandido de datos escribibles.

) El descriptor de alias devuelto por esta funcin no dejar signos de cambios
  en el descriptor original.
  
2.9 - Funcin 000Bh - Toma Descriptor:
--------------------------------------

  Copia la entrada de la tabla de descriptor para el selector especificado en
un buffer de 8 byte.

In:
  AX     = 000bh
  BX     = selector
  ES:EDI = selector:offset de un buffer de 8 byte

Out:
  si tiene xito:
    flag de acarreo limpio
    el buffer al que se seal por medio de ES:EDI contiene un descriptor

  si falla:
    flag de acarreo activado

2.10 - Funcin 000Ch - Establecer Descriptor:
---------------------------------------------

  Copia los contenidos de un buffer de 8 byte en el descriptor para el selector
especificado.

In:
  AX     = 000ch
  BX     = selector
  ES:EDI = selector:offset de un buffer de 8 byte que contiene el descriptor

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

) La palabra de derechos de acceso/tipo de los descriptores con un offset de 5
  dentro del descriptor siguen el mismo formato y las mismas restricciones que
  el parmetro CX de derechos de acceso/tipo to the Set Descriptor Access Rights
  function (0009h).

) Bajo DPMI 1.0/VCPI/XMS/raw, se volver a cargar cualquier registro de
  segmento que contenga el selector especificado en el registro BX. DPMI 0.9
  puede hacer esto, pero no se garantiza que salga bien.

) Confiamos que tengas el suficiente sentido como para no tratar de modificar
  los actuales descriptores CS o SS o el descriptor del buffer.

2.11 - Funcin 0100h - Asignar Bloque de Memoria de DOS:
--------------------------------------------------------

  Asigna memoria baja a travs de la funcin 48h de DOS y la asigna a un
descriptor.

In:
  AX     = 0100h
  BX     = prrafos a asignar

Out:
  si tiene xito:
    flag de acarreo limpio
    AX     = direccin de segmento en modo real
    DX     = selector en modo protegido para el bloque de memoria

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS
    BX     = tamao del mayor bloque disponible

2.12 - Funcin 0101h - Liberar Bloque de Memoria de DOS:
--------------------------------------------------------

  Libera un bloque de memoria baja previamente asignado por la funcin 0100h.


In:
  AX     = 0101h
  DX     = selector en modo protegido para el bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS

2.13 - Funcin 0102h - Dar Nuevo Tamao al Bloque de Memoria de DOS:
--------------------------------------------------------------------

  Da un nuevo tamao a un bloque de memoria baja previamente asignado por la
funcin 0100h.

In:
  AX     = 0102h
  BX     = nuevo tamao del bloque en prrafos
  DX     = selector en modo protegido para el bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    AX     = cdigo de error de DOS
    BX     = tamao del mayor bloque disponible

2.14 - Funcin 0200h - Toma el Vector de Interrupcin en Modo Real:
-------------------------------------------------------------------

  Devuelve el segmento:offset en modo real para el vector de interrupcin
especificado.

In:
  AX     = 0200h
  BL     = nmero de interrupcin

Out:
  siempre tiene xito:
    flag de acarreo limpio
    CX:DX  = segmento:offset del manejador de interrupcin en modo real

Notas:
) El valor devuelto en CX es una direccin de segmento en modo real y no un
  selector en modo protegido.
  
2.15 - Funcin 0201h - Establecer el Vector de Interrupcin en Modo Real:
-------------------------------------------------------------------------

  Establece el segmento:offset en modo real para el vector de interrupcin
especificado.

In:
  AX     = 0201h
  BL     = nmero de interrupcin
  CX:DX  = segmento:offset del manejador de interrupcin en modo real

Out:
  siempre tiene xito:
    flag de acarreo limpio

Notas:
) El valor pasado a CX debe ser una direccin de segmento en modo real y no un
  selector en modo protegido. Consecuentemente, el manejador de interrupcin
  debe residir o en la memoria del DOS (por debajo del lmite de 1M) o el
  cliente debe asignar una direccin de llamada de retorno en modo real.
  
2.16 - Funcin 0202h - Toma el Vector del Manejador de Excepciones del
----------------------------------------------------------------------
       Procesador:
       -----------

  Devuelve la direccin del actual manejador de excepcin en modo protegido
para el nmero de excepcin especificado.

In:
  AX     = 0202h
  BL     = nmero de excepcin (00h-1fh)

Out:
  si tiene xito:
    flag de acarreo limpio
    CX:EDX = selector:offset del manejador de excepcin

  si falla:
    flag de acarreo activado

Notas:
) PMODE/W maneja las excepciones bajo entornos limpios/XMS/VCPI. Bajo un
  entorno DPMI, el manejo de excepciones lo proporciona el host DPMI.
  
) PMODE/W slo captura las excepciones de la 0 a la 14. El comportamiento por
  defecto es terminar la ejecucin y hacer un volcado de depuracin. PMODE/W
  terminar con las excepciones 0, 1, 2, 3, 4, 5 y 7 en vez de pasarlas a los
  manejadores en modo real como las especificaciones DPMI establecen.

2.17 - Funcin 0203h - Establecer el Vector del Manejador de Excepciones del
----------------------------------------------------------------------------
       Procesador:
       -----------

  Establece la direccin de un manejador para una excepcin o un fallo de la
CPU, permitiendo a una aplicacin del modo protegido interceptar las
excepciones del procesador.

In:
  AX     = 0203h
  BL     = nmero de excepcin (00h-1fh)
  CX:EDX = selector:offset del manejador de la excepcin

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) PMODE/W maneja las excepciones bajo entornos limpio/XMS/VCPI. Bajo un entorno
  DPMI, el manejo de las excepciones lo proporciona el host de DPMI.
  
) PMODE/W slo capturas las excepciones de la 0 a la 14. El comportamiento por
  defecto es terminar la ejecucin y hacer un volcado de depuracin. PMODE/W
  terminar con las excepciones 0, 1, 2, 3, 4, 5 y 7 en vez de pasarlas a los
  manejadores en modo real como las especificaciones DPMI establecen.

) Si deseas enganchar una de las 8 interrupciones bajas, debes engancharla como
  a una excepcin. No se la llamar si la enganchas con la funcin 0205h.

2.18 - Funcin 0204h - Toma el Vector de Interrupcin en Modo Protegido:
------------------------------------------------------------------------

  Devuelve la direccin del actual manejador de interrupcin en modo protegido
para la interrupcin especificada.

In:
  AX     = 0204h
  BL     = nmero de la interrupcin

Out:
  siempre tiene xito:
    flag de acarreo limpio
    CX:EDX = selector:offset del manejador de interrupcin en modo protegido

Notes:
) El valor devuelto en CX es un selector vlido en modo protegido y no una
  direccin de segmento en modo real.
  
2.19 - Funcin 0205h - Establecer el Vector de Interrupcin en Modo Protegido:
------------------------------------------------------------------------------

  Establece la direccin del manejador de interrupcin en modo protegido para
la interrupcin especificada.

In:
  AX     = 0205h
  BL     = nmero de interrupcin
  CX:EDX = selector:offset del manejador de interrupcin en modo protegido

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) El valor pasado a CX debe ser un selector en modo protegido vlido y no una
  direccin de segmento en modo real.
  
) Si deseas enganchar una de las 8 interrupciones bajas, debes engancharla como
  a una excepcin. No se la llamar si la enganchas con la funcin 0205h.

2.20 - Funcin 0300h - Simular Interrupcin en Modo Real:
---------------------------------------------------------

  Simula una interupcin en modo real. La funcin transfiere el control a la
direccin especificada por el vector de interrupcin en modo real. El manejador
en modo real debe volver mediante la ejecucin de un IRET.

In:
  AX     = 0300h
  BL     = nmero de interrupcin
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
	   en modo real
  ES:EDI = selector:offset de la estructura de datos de los registros en modo
	   real con el siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservada, ignorada
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP (reservada, ignorada)
           2ch     2       CS (reserveda, ignorada)
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
    flag de acarreo limpio
    ES:EDI = selector:offset de la estructura modificada de datos de los
             registros en modo real

  si falla:
    flag de acarreo activado

Notas:
) Esta funcin ignora el CS:IP en la estructura de datos de los registros en
  modo real. Se llamar al manejador de interrupcin adecuado basndose en el
  valor pasado en BL.
  
) Si los campos SS:SP en la estructura de datos de los registros en modo real
  son cero, el host suministrar una pila en modo real. Si no, el SS:SP en modo
  real se fijar con los valores especificados antes de que se llamara al
  manejador de interrupcin.
  
) Los flags especificados en la estructura de datos de los registros en modo
  real sern puestos en el marco IRET del manejador de interrupcin en modo
  real. Se llamar al manejador de interrupcin con la interrupcin y los flags
  de seguimiento limpios.

) Los valores situados en las posiciones del registro de segmento de la
  estructura de datos deben ser vlidos para el modo real. Es decir, los
  valores deben ser direcciones de prrafo, no selectores en modo protegido.
  
) El manejador de destino en modo real debe volver con la pila en el mismo
  estado que cuando fue llamado. Esto significa que el cdigo en modo real
  puede conectar pilas cuando est siendo ejecutado pero debe volver a la misma
  pila desde la que fue llamado y debe volver con un IRET.

) Cuando esta funcin retorna, la estructura de datos de los registros en modo
  real contendr los valores que fueron devueltos por el manejador de
  interrupcin en modo real. Los valores de CS:IP y SS:SP permanecern
  inalterados en la estructura de datos.
  
) Es responsabilidad del que hace la llamada el quitar cualquier parmetro que
  fuera puesto en la pila de modo protegido.
  
2.21 - Funcin 0301h - Llamar al Procedimiento en Modo Real con Marco de Retorno
--------------------------------------------------------------------------------
       Lejano:
       -------

  Simula una FAR CALL (LLAMADA LEJANA) a un procedimiento en modo real. El
procedimiento llamado debe retornar mediante la ejecucin de una instruccin
RETF.

In:
  AX     = 0301h
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
	   en modo real
  ES:EDI = selector:offset de la estructura de datos de los registros en modo
	   real con el siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservada, ignorada
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP
           2ch     2       CS
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
    flag de acarreo limpio
    ES:EDI = selector:offset de la estructura modificada de datos de los
             registros en modo real

  si falla:
    flag de acarreo activado

Notas:
) El CS:IP en la estructura de datos de los registros en modo real especifica
  la direccin del procedimiento en modo real a llamar.
  
) Si los campos SS:SP en la estructura de datos de los registros en modo real
  son cero, el host suministrar una pila en modo real. Si no, el SS:SP en modo
  real se fijar con los valores especificados antes de que se llamara a dicho
  procedimiento.

) Los valores situados en las posiciones del registro de segmento de la
  estructura de datos deben ser vlidos para el modo real. Es decir, los
  valores deben ser direcciones de prrafo, no selectores en modo protegido.
  
) El procedimiento de destino en modo real debe volver con la pila en el mismo
  estado que cuando fue llamado. Esto significa que el cdigo en modo real
  puede conectar pilas cuando est siendo ejecutado pero debe volver a la misma
  pila desde la que fue llamado y debe volver con un IRET y no debera limpiar
  la pila de ningn parmetro que le fuera pasado al cdigo por la pila.

) Cuando esta funcin retorna, la estructura de datos de los registros en modo
  real contendr los valores que fueron devueltos por el procedimiento en modo
  real. Los valores de CS:IP y SS:SP permanecern inalterados en la estructura
  de datos.
  
) Es responsabilidad del que hace la llamada el quitar cualquier parmetro que
  fuera puesto en la pila en modo protegido.
  
2.22 - Funcin 0302h - Llamar al Procedimiento en Modo Real con Marco IRET:
---------------------------------------------------------------------------

  Simula una FAR CALL (LLAMADA LEJANA) con los flags puestos en la pila a una
rutina en modo real. El procedimiento en modo real debe retornar mediante una
instruccin IRET o un RETF 2.

In:
  AX     = 0302h
  BH     = debe ser 0
  CX     = nmero de palabras a copiar de la pila en modo protegido a la pila
	   en modo real
  ES:EDI = selector:offset de la estructura de datos de los registros en modo
	   real con el siguiente formato:

           Offset Longitud Contenidos
           00h     4       EDI
           04h     4       ESI
           08h     4       EBP
           0ch     4       reservada, ignorada
           10h     4       EBX
           14h     4       EDX
           18h     4       ECX
           1ch     4       EAX
           20h     2       flags de estado de la CPU
           22h     2       ES
           24h     2       DS
           26h     2       FS
           28h     2       GS
           2ah     2       IP
           2ch     2       CS
           2eh     2       SP
           30h     2       SS

Out:
  si tiene xito:
    flag de acarreo limpio
    ES:EDI = selector offset de la estructura modificada de datos de los
             registros en modo real

  si falla:
    flag de acarreo activado

Notas:
) El CS:IP en la estructura de datos de los registros en modo real especifica
  la direccin del procedimiento en modo real a llamar.
  
) Si los campos SS:SP en la estructura de datos de los registros en modo real
  son cero, el host suministrar una pila en modo real. Si no, el SS:SP en modo
  real se fijar con los valores especificados antes de que se llame a dicho
  procedimiento.

) Los flags especificados en la estructura de datos de los registros en modo
  real sern puestos en el marco IRET del procedimiento en modo real. El
  procedimiento ser llamado con los flags de interrupcin y de seguimiento
  limpios.
  
) Los valores situados en las posiciones del registro de segmento de la
  estructura de datos deben ser vlidos para el modo real. Es decir, los
  valores deben ser direcciones de prrafo, no selectores en modo protegido.
  
) El procedimiento de destino en modo real debe volver con la pila en el mismo
  estado que cuando fue llamado. Esto significa que el cdigo en modo real
  puede conectar pilas cuando est siendo ejecutado pero debe volver a la misma
  pila desde la que fue llamado y debe volver con un IRET o deshacerse de los
  flags de la pila con un RETF 2 y no debera limpiar la pila de ningn
  parmetro que le fuera pasado al cdigo por la pila.

) Cuando esta funcin retorna, la estructura de datos de los registros en modo
  real contendr los valores que fueron devueltos por el procedimiento en modo
  real. Los valores de CS:IP y SS:SP permanecern inalterados en la estructura
  de datos.
  
) Es responsabilidad del que hace la llamada el quitar cualquier parmetro que
  fuera puesto en la pila de modo protegido.
  
2.23 - Funcin 0303h - Asignar la Direccin de la Llamada de Retorno en Modo
----------------------------------------------------------------------------
       Real:
       -----

  Devuelve un nico segmento:offset en modo real, conocido como "llamada de
retorno en modo real", que transferir el control del procedimiento en modo
real al del modo protegido. Las direcciones de las llamadas de retorno
obtenidas con esta funcin pueden ser pasadas por un programa en modo protegido
a una aplicacin en modo real, a un manejador de interrupcin, a un dispositivo
controlador, a un TSR, etc... de tal manera que el programa en modo real pueda
llamar a los procedimientos dentro del programa en modo protegido.

In:
  AX     = 0303h
  DS:ESI = selector:offset del procedimiento en modo protegido a llamar
  ES:EDI = selector:offset del buffer del byte 32h para la estructura de datos
           de los registros en modo real a usar cuando se llame a la rutina de
	   llamada de retorno.

Out:
  si tiene xito:
    flag de acarreo limpio
    CX:DX  = segment:offset de la llamada de retorno en modo real

  si falla:
    flag de acarreo activado

Notas:
) Se puede asignar un descriptor para cada llamada de retorno para mantener el
  SS en modo real. Las llamadas de retorno en modo real son un recurso limitado
  del sistema. Un cliente debera liberar una llamada de retorno que ya no est
  usando.
  
2.24 - Funcin 0304h - Liberar la Direccin de la Llamada de Retorno en Modo
----------------------------------------------------------------------------
       Real:
       -----

  Libera la direccin de la llamada de retorno en modo real que fue previamente
asignada con la funcin de Asignar la Direccin de Llamada de Retorno en Modo
Real (0303h).

In:
  AX     = 0304h
  CX:DX  = segment:offset de la llamada de retorno en modo real a liberar
  
Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) Las llamadas de retorno en modo real son un recurso limitado del sistema. Un
  cliente debera liberar cualquier llamada de retorno que ya no est usando.
  
2.25 - Funcin 0305h - Toma el Estado de las Direcciones para Grabar/Restaurar:
-------------------------------------------------------------------------------

  Devuelve la direccin de dos procedimientos usados para grabar y restaurar el
estado de los actuales registros de tarea en el modo (protegido o real) que no
se est ejecutando en ese momento.

In:
  AX     = 0305h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AX     = tamao necesario del buffer en bytes para grabar el estado
    BX:CX  = segmento:offset de la rutina en modo real usada para
	     grabar/restaurar el estado
    SI:EDI = selector:offset de la rutina en modo protegido usada para
	     grabar/restaurar el estado

Notas:
) El segmento:offset en modo real devuelto por esta funcin debera ser llamado
  slo en modo real para grabar/restaurar el estado de los registros del modo
  protegido. El selector:offset en modo protegido devuelto por esta funcin
  debera ser llamado slo en modo protegido para grabar/restaurar el estado
  de los registros del modo real.
  
) Los dos procedimientos de grabar/restaurar el estado son introducidos por una
  FAR CALL (LLAMADA LEJANA) con los siguientes parmetros:
  
  AL       = 0 para grabar el estado
	   = 1 para restaurar el estado
  ES:(E)DI = (selector o segmento):offset del buffer de estado

  El buffer de estado debe ser al menos tan grande como el valor devuelto en
  AX por la funcin 0305h de la INT 31h. El estado de los procedimientos para
  grabar/restaurar no modifica ningn registro. Se debe usar DI por el offset
  del buffer en modo real, se debe usar EDI en modo protegido.
  
) Algunos hosts de DPMI y VCPI/XMS/raw no necesitarn que se grabe el estado,
  y esto se indicar mediante la devolucin de un tamao de buffer de cero en
  AX. En tales casos, todava se podr llamar a las direcciones devueltas por
  esta funcin, aunque simplemente volvern sin realizar ninguna funcin de
  utilidad.
  
) Los clientes no necesitan llamar a los procedimientos de grabar/restaurar
  el estado antes de usar las funciones 0300h, 0301h o 0302h de la
  INT 31h. Los procedimientos para grabar/restaurar el estado se proporcionan
  para los clientes que usan slo los servicios de enlace del modo raw.
  
2.26 - Funcin 0306h - Toma las Direcciones de Enlace del Modo Raw:
-------------------------------------------------------------------

  Devuelve direcciones que pueden ser llamadas para el nivel bajo de enlace de
modos.

In:
  AX     = 0306h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    BX:CX  = segmento:offset del procedimiento de cambio del modo real al modo
	     protegido
    SI:EDI = selector:offset del procedimiento de cambio del modo protegido al
	     modo real

Notas:
) El segmento:offset en modo real devuelto por esta funcin debera ser llamado
  slo en modo real para conectar con el modo protegido. El selector:offset en
  modo protegido devuelto por esta funcin debera ser llamado slo en modo
  protegido para conectar con el modo real.
  
) Los procedimientos de enlace de modos son introducidos por un FAR JMP en la
  direccin apropiada con los siguientes parmetros:
  
  AX    = nuevo DS
  CX    = nuevo ES
  DX    = nuevo SS
  (E)BX = nuevo (E)SP
  SI    = nuevo CS
  (E)DI = nuevo (E)IP

  El procesador es colocado en el modo deseado y los registros DS, ES, SS,
  (E)SP, CS y (E)IP son actualizados con los valores especficos. En otras
  palabras, la ejecucin del cliente contina en el modo solicitado en la
  direccin suministrada en los registros SI:(E)DI. Los valores especificados
  para ser situados en los registros de segmento deben ser los apropiados para
  el modo de destino. Es decir, direcciones de segmento para el modo real y
  selectores para el modo protegido.
  
  Los valores en EAX, EBX, ECX, EDX, ESI y EDI tras el enlace de modos no estn
  definidos. EBP ser conservado a lo largo de la llamada de enlace de modos
  para que pueda ser usado como un puntero. FS y GS contendrn cero tras el
  enlace de modos.
  
  Si las interrupciones estn desactivadas cuando se llama al procedimiento de
  enlace de modos, estas no volvern a ser activadas por el host (ni siquiera
  temporalmente).
  
) Depende del cliente el grabar y restaurar el estado de una tarea cuando se
  usa esta funcin para enlazar modos. Esto requiere los procedimientos de
  grabar/restaurar el estado cuyas direcciones se pueden obtener con la funcin
  0305h de la INT 31h.
  
2.27 - Funcin 0400h - Muestra la Versin:
------------------------------------------

  Devuelve la versin de la Especificacin DPMI implementada por el host DPMI.
El cliente puede usar esta informacin para determinar qu funciones estn
disponibles.

In:
  AX     = 0400h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AH     = la versin mayor de DPMI como un nmero binario (VCPI/XMS/raw
	     devuelve 00h)
    AL     = la versin menor de DPMI como un nmero binario (VCPI/XMS/raw
	     devuelve 5ah)
    BX     = flags:
             Bits    Significado
	     0       0 = el host es de 16bit (PMODE/W nunca funciona bajo uno
			 de estos)
		     1 = el host es de 32bit
	     1       0 = CPU devuelta al modo V86 para las interrupciones
			 reflejadas
		     1 = CPU devuelta al modo real para las interrupciones
			 reflejadas
	     2       0 = no soporta memoria virtual
		     1 = soporta memoria virtual
	     3-15    reservada
    CL     = tipo de procesador:
	     03h = 80386
	     04h = 80486
	     05h = 80586
	     06h-ffh = reservada
    DH     = valor actual de la interrupcin base del PIC maestro (las 8 IRQs
             bajas)
    DL     = valor actual de la interrupcin base del PIC esclavo (las 8 IRQs
             altas)

Notas:
) Los nmeros de versin mayor y menor son binarios, no BCD. Por ello
  una implementacin de DPMI 0.9 devolver AH como 0 y AL como 5ah (90).
  
2.28 - Funcin 0500h - Toma la Informacin de la Memoria Libre:
---------------------------------------------------------------

  Devuelve informacin sobre la cantidad de memoria disponible. Puesto que los
clientes de DPMI se pueden hacer correr en un entorno de multitarea, la
informacin devuelta por esta funcin debera ser considerada consultiva.

In:
  AX     = 0500h
  ES:EDI = selector:offset del buffer de 48 byte

Out:
  si tiene xito:
    flag de acarreo limpio
    el buffer se llena con la siguiente informacin:

      Offset Longitud Contenidos
      00h     4       El mayor bloque libre disponible en bytes
      04h     2ch     Otros campos slo suministrados por DPMI

  si falla:
    flag de acarreo activado

Notas:
) Slo se garantiza que el primer campo de la estructura contenga un valor
  vlido. Cualquier campo que no sea soportado por el host ser puesto a -1
  (0ffffffffh) para indicar que la informacin no est disponible.
  
2.29 - Funcin 0501h - Asignar Bloque de Memoria:
-------------------------------------------------

  Asigna un bloque de memoria extendida.
  
In:
  AX     = 0501h
  BX:CX  = tamao del bloque en bytes (debe ser distinto de cero)

Out:
  si tiene xito:
    flag de acarreo limpio
    BX:CX  = direccin lineal del bloque de memoria asignado
    SI:DI  = maneja el bloque de memoria (usado para dar un nuevo tamao al
	     bloque y liberarlo)

  si falla:
    flag de acarreo activado

Notas:
) Se garantiza que el bloque asignado tenga al menos alineacin de palabra.

) Esta funcin no asigna ningn descriptor para el bloque de memoria. Es
  responsabilidad del cliente el asignar e inicializar cualquier descriptor
  que se necesite para acceder a la memoria con llamadas de funcin
  adicionales.
  
2.30 - Funcin 0502h - Liberar Bloque de Memoria:
-------------------------------------------------

  Libera un bloque de memoria previamente asignado con la funcin Asignar
Bloque de Memoria (0501h).

In:
  AX     = 0502h
  SI:DI  = maneja bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) Esta llamada no libera ningn descriptor. Es responsabilidad del cliente el
  liberar cualquier descriptor que previamente asignara para mapear el bloque
  de memoria. Los descriptores deberan ser liberados antes que los bloques de
  memoria.
  
2.31 - Funcin 0503h - Dar Nuevo Tamao al Bloque de Memoria:
-------------------------------------------------------------

  Cambia el tamao de un bloque de memoria previamente asignado con la funcin
Asignar Bloque de Memoria (0501h).

In:
  AX     = 0503h
  BX:CX  = nuevo tamao del bloque en bytes (debe ser distinto de cero)
  SI:DI  = maneja bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio
    BX:CX  = nueva direccin lineal del bloque de memoria
    SI:DI  = maneja nuevo bloque de memoria

  si falla:
    flag de acarreo activado

Notas:
) Una vez la funcin retorna con xito, el manejador previo para este bloque
  de memoria no es vlido y no se debera volver a usar.
  
) Es responsabilidad del cliente el actualizar cualquier descriptor que mapease
  el bloque de memoria con la nueva direccin lineal tras darle un nuevo tamao
  al bloque.
  
2.32 - Funcin 0800h - Mapeado de Direccin Fsica:
---------------------------------------------------

  Convierte una direccin fsica en una direccin lineal. Esta funcin permite
al cliente acceder a dispositivos mapeados en una direccin de memoria fsica
especfica. Ejemplos de esto son los buffers de marcos de ciertas tarjetas de
vdeo en memoria extendida.

In:
  AX     = 0800h
  BX:CX  = direccin fsica de la memoria
  SI:DI  = tamao de la regin a mapear en bytes

Out:
  si tiene xito:
    flag de acarreo limpio
    BX:CX  = direccin lineal que puede ser usada para acceder a la memoria
	     fsica

  si falla:
    flag de acarreo activado

Notas:
) Es responsabilidad del que llama el asignar e inicializar un descriptor para
  el acceso a la memoria.
  
) Los clientes no deberan usar esta funcin para acceder a la memoria por
  debajo del lmite de 1 MB.
  
2.33 - Funcin 0801h - Liberar el Mapeado de Direccin Fsica:
--------------------------------------------------------------

  Realiza un mapeado de direcciones de fsica a lineal que fueron obtenidas
previamente con la funcin 0800h.

In:
  AX     = 0801h
  BX:CX  = direccin lineal devuelta por la llamada de mapeado de direccin
           fsica

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) El cliente debera llamar a esta funcin cuando haya acabado de usar un
  dispositivo previamente mapeado a direcciones lineales con la funcin 0801h.
  
2.34 - Funcin 0900h - Da y Desactiva el Estado de la Interrupcin Virtual:
---------------------------------------------------------------------------

  Desactiva el flag de interrupcin virtual y devuelve su estado previo.
  
In:
  AX     = 0900h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AL     = 0 si las interrupciones virtuales fueron previamente desactivadas
    AL     = 1 si las interrupciones virtuales fueron previamente activadas

Notas:
) Esta funcin no cambia AH. Por lo tanto el estado previo puede ser restaurado
  simplemente ejecutando otra INT 31h.
  
) Un cliente que no necesite saber el estado anterior de la interrupcin puede
  ejecutar la instruccin CLI en vez de llamar a esta funcin. La instruccin
  puede ser atrapada por un host DPMI y debera ser asumida como muy lenta.
  
2.35 - Funcin 0901h - Da y Habilita el Estado de la Interrupcin Virtual:
--------------------------------------------------------------------------

  Habilita el flag de la interrupcin virtual y devuelve su estado previo.
  
In:
  AX     = 0901h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AL     = 0 si las interrupciones virtuales fueron previamente desactivadas
    AL     = 1 si las interrupciones virtuales fueron previamente activadas

Notas:
) Esta funcin no cambia AH. Por lo tanto el estado previo puede ser restaurado
  simplemente ejecutando otra INT 31h.
  
) Un cliente que no necesite saber el estado anterior de la interrupcin puede
  ejecutar la instruccin STI en vez de llamar a esta funcin. La instruccin
  puede ser atrapada por un host DPMI y debera ser asumida como muy lenta.

2.36 - Funcin 0902h - Da el Estado de la Interrupcin Virtual:
---------------------------------------------------------------

  Devuelve el estado actual del flag de la interrupcin virtual.
  
In:
  AX     = 0902h

Out:
  siempre tiene xito:
    flag de acarreo limpio
    AL     = 0 si las interrupciones virtuales estn desactivadas
    AL     = 1 si las interrupciones virtuales estn activadas

Notas:
) Se debera usar esta funcin con preferencia sobre la instruccin PUSHF para
  examinar el flag de interrupcin ya que la instruccin PUSHF devuelve el flag
  de la interrupcin fsica en vez del flag virtualizado de la interrupcin.
  En algunos hosts DPMI, el flag de interrupcin fsica siempre estar
  habilitado, incluso cuando las interrupciones del hardware no estn siendo
  pasadas al cliente.
  
2.37 - Funcin EEFFh - Da la Informacin del Extensor de DOS:
-------------------------------------------------------------

  Devuelve informacin acerca del extensor de DOS.
  
In:
  AX     = EEFFh

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX    = 'PMDW' (504D4457h)
    ES:EBX = selector:offset de la cadena de copyright ASCIIZ
    CH     = tipo de sistema en modo protegido (0=raw, 1=XMS, 2=VCPI, 3=DPMI)
    CL     = tipo de procesador (3=386, 4=486, 5=586)
    DH     = versin MAYOR del extensor (binario)
    DL     = versin MENOR del extensor (binario)

  si falla:
    flag de acarreo activado

Notas:
) En la implementacin de esta funcin hecha por PMODE/W, el valor devuelto en
  ES es equivalente al selector de datos 4G devuelto en DS al arrancar.
  
) Esta funcin siempre tiene xito bajo PMODE/W.

------------------------------------------------------------------------------
-------- 3 - Funciones extendidas de la INT 21h soportadas por el DOS --------
------------------------------------------------------------------------------

  En su mayor parte, PMODE/W extiende slo las funciones de DOS ms usadas. El
trmino "extiende" quiere decir que extiende el modo real de punteros 16:16, el
cual tiene un lmite de 1MB, al modo protegido en toda su extensin de punteros
16:32 con una extensin de 4GB. Dado que el DOS slo puede direccionar
memoria por debajo de 1MB, debemos depurar todos los datos que deban ser
pasados al DOS o desde el DOS en memoria baja. Slo necesitan ser extendidas
las funciones de DOS que usan punteros 16:16 o registros de segmentos. Esto
significa que las funciones de DOS que no estn enumeradas aqu se pueden
seguir usando siempre y cuando se tenga certeza de que no usan este tipo de
parmetros. Ejemplos de tales funciones son INT 21h AH=30h, INT 21h AH=2, etc.
La siguiente es una lista detallada de todas las funciones extendidas por
PMODE/W. Todos los registros de segmento usados como parmetros deben ser
selectores en modo protegido que sean vlidos. Cualquier funcin que no est
enumerada aqu ser pasada al manejador INT 21h en modo real sin ninguna
modificacin o depuracin. Esta y las dems secciones sobre interrupciones se
proporcionan como referencia para que se vea cmo PMODE/W trabaja con estas
interrupciones. Se supone que el lector est familiarizado con el modo normal
de operar en modo real de estas funciones.

3.0 - Funcin 09h - Escribir Cadena a una Salida Estndar:
----------------------------------------------------------

In:
  AH     = 09h
  DS:EDX -> '$' cadena terminada para escribir

Out:
  siempre tiene xito

3.1 - Funcin 1Ah - Establecer el Area de Transferencia del Disco:
------------------------------------------------------------------

In:
  AH     = 1Ah
  DS:EDX -> buffer para DTA

Out:
  siempre tiene xito

Notas:
) PMODE/W mantiene un buffer DTA interno en memoria baja que es usado para
  depurar cualquier funcin que use el DTA. Tras llamar a la funcin de DOS en
  modo real, los datos sern transferidos al buffer especificado por DS:EDX.
  
3.2 - Funcin 1Bh - Toma Informacin de Asignacin para la Unidad por Defecto:
------------------------------------------------------------------------------

In:
  AH     = 1Bh

Out:
  siempre tiene xito:
    AL     = sectores por cluster
    ECX    = bytes por sector
    EDX    = nmero total de clusters
    DS:EBX -> Byte de ID del medio

Notas:
) Esta funcin simplemente convierte el segmento:offset en modo real devuelto
  por el DOS en un selector:offset en modo protegido.
  
3.3 - Funcin 1Ch - Toma Informacin de Asignacin para una Unidad Especfica:
------------------------------------------------------------------------------

In:
  AH     = 1Ch
  DL     = nmero de unidad

Out:
  si tiene xito:
    AL     = sectores por cluster
    ECX    = bytes por sector
    EDX    = nmero total de clusters
    DS:EBX -> Byte de ID del medio

  si falla:
    AL     = FFh (unidad no vlida)

Notas:
) Esta funcin simplemente convierte el segmento:offset en modo real devuelto
  por el DOS en un selector:offset en modo protegido.
  
3.4 - Funcin 1Fh - Toma el Bloque del Parmetro de la Unidad para la Unidad
----------------------------------------------------------------------------
      por defecto:
      ------------

In:
  AH     = 1Fh

Out:
  si tiene xito:
    AL     = 0
    DS:EBX -> bloque del parmetro de la unidad

  si falla:
    AL     = FFh (unidad no vlida)

Notas:
) Esta funcin simplemente convierte el segmento:offset en modo real devuelto
  por el DOS en un selector:offset en modo protegido.
  
3.5 - Funcin 25h - Establecer el Vector de Interrupcin:
---------------------------------------------------------

In:
  AH     = 25h
  AL     = nmero de interrupcin
  DS:EDX -> rutina de interrupcin

Out:
  si tiene xito:
    flag de acarreo libre

  si falla:
    flag de acarreo activado

Notas:
) Esta funcin es equivalente a la funcin 0205h de la INT 31h.

3.6 - Funcin 2Fh - Toma el Area de Transferencia del Disco:
------------------------------------------------------------

In:
  AH     = 2Fh

Out:
  siempre tiene xito:
    ES:EBX -> DTA

Notas:
) Esta funcin devolver el valor que fue previamente establecido por la
  funcin 1Ah o el buffer por defecto si no se llam a la funcin 1Ah.
  
3.7 - Funcin 32h - Toma el Bloque del Parmetro de la Unidad para una Unidad
-----------------------------------------------------------------------------
      Especfica:
      -----------

In:
  AH     = 32h
  DL     = nmero de unidad

Out:
  si tiene xito:
    AL     = 0
    DS:EBX -> bloque del parmetro de la unidad

  si falla:
    AL     = FFh (unidad no vlida)

Notas:
) Esta funcin simplemente convierte el segmento:offset en modo real devuelto
  por el DOS en un selector:offset en modo protegido.
  
3.8 - Funcin 34h - Toma la Direccin de un Flag InDOS:
-------------------------------------------------------

In:
  AH = 34h

Out:
  siempre tiene xito:
    ES:EBX -> InDOS flag

Notas:
) Esta funcin simplemente convierte el segmento:offset en modo real devuelto
  por el DOS en un selector:offset en modo protegido.
  
3.9 - Funcin 35h - Toma el Vector de Interrupcin:
---------------------------------------------------

In:
  AH     = 35h
  AL     = nmero de interrupcin

Out:
  siempre tiene xito:
    ES:EBX -> rutina de interrupcin

Notas:
) Esta funcin es equivalente a la funcin 0204h de la INT 31h.

3.10 - Funcin 39h - Crear Subdirectorio:
-----------------------------------------

In:
  AH     = 39h
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.11 - Funcin 3Ah - Eliminar Subdirectorio:
--------------------------------------------

In:
  AH     = 3Ah
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.12 - Funcin 3Bh - Establecer Directorio:
-------------------------------------------

In:
  AH     = 3Bh
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.13 - Funcin 3Ch - Crear Fichero:
-----------------------------------

In:
  AH     = 3Ch
  CX     = atributo
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX = handle

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.14 - Funcin 3Dh - Abrir Fichero:
-----------------------------------

In:
  AH     = 3Dh
  AL     = abre cdigo
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX = handle

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.15 - Funcin 3Fh - Leer del Fichero:
--------------------------------------

In:
  AH     = 3Fh
  BX     = manejador del fichero
  ECX    = nmero de bytes a leer
  DS:EDX -> buffer al que leer

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX = nmero de bytes ledos

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.16 - Funcin 40h - Escribir a Fichero:
----------------------------------------

In:
  AH     = 40h
  BX     = manejador del fichero
  ECX    = nmero de bytes a escribir
  DS:EDX -> buffer desde el que escribir

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX = nmero de bytes escritos

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.17 - Funcin 41h - Borrar Fichero:
------------------------------------

In:
  AH     = 41h
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.18 - Funcin 43h -Muestra/Establece los Atributos del Fichero:
----------------------------------------------------------------

In:
  AH     = 43h
  AL     = cdigo de la funcin
  CX     = atributos deseados
  DS:EDX -> nombre de path en ASCIIZ

Out:
  si tiene xito:
    flag de acarreo limpio
    CX = atributos actuales

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.19 - Funcin 47h - Toma el Path del Directorio:
-------------------------------------------------

In:
  AH     = 47h
  DL     = nmero de unidad
  DS:ESI -> buffer para el path

Out:
  si tiene xito:
    flag de acarreo limpio
    el buffer al que apunt DS:ESI se rellena con el path

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.20 - Funcin 48h - Asignar Bloque de Memoria:
-----------------------------------------------

In:
  AH     = 48h
  BX     = prrafos a asignar

Out:
  si tiene xito:
    flag de acarreo limpio
    EAX = selector para bloque de memoria

  si falla:
    flag de acarreo activado
    EAX = cdigo de error
    EBX = mximos prrafos disponibles

Notas:
) Esta funcin asigna SOLO memoria de DOS por debajo de 1MB.

) Esta funcin es equivalente a la funcin 0100h de la INT 31h.

3.21 - Funcin 49h - Liberar Bloque de Memoria:
-----------------------------------------------

In:
  AH     = 49h
  ES     = selector para bloque de memoria

Out:
  si tiene xito:
    flag de acarreo limpio
    ES = selector NULL (puesto a cero para prevenir la carga de un selector no
	 vlido)

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

Notas:
) Esta funcin es equivalente a la funcin 0101h de la INT 31h.

3.22 - Funcin 4Ah - Dar Nuevo Tamao al Bloque de Memoria:
-----------------------------------------------------------

In:
  AH     = 4Ah
  BX     = prrafos totales a asignar
  ES     = selector

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error
    EBX = mximos prrafos disponibles para el bloque de memoria especificado

Notas:
) Esta funcin es equivalente a la funcin 0102h de la INT 31h.

3.23 - Funcin 4Bh - Sub-Funcin 00h - Carga y Ejecuta el Programa:
-------------------------------------------------------------------

In:
  AH     = 4Bh
  AL     = 00h
  DS:EDX -> nombre del path
  ES:EBX -> bloque de parmetros

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado

Notas:
) Para poder superar la incapacidad del DOS de acceder a los datos por encima
  de 1MB, el entorno especificado en el bloque de parmetros ser copiado en un
  buffer intermedio antes de ser pasado al DOS. El buffer ser asignado a
  travs de la funcin 48h de DOS y ser liberado por medio de la 49h una vez
  el programa ha realizado la ejecucin. Debe haber suficiente memoria baja
  disponible para mantener los datos del entorno o se producir un error. Ten
  esto en cuenta cuando ests pasando un entorno que use spawnle() y funciones
  relacionadas.
  
3.24 - Funcin 4Eh - Busca la Primera Coincidencia en el Nombre del Fichero:
----------------------------------------------------------------------------

In:
  AH     = 4Eh
  CX     = atributo de fichero
  DS:EDX -> nombre de path en ASCIIZ

Out:
   si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

Notas:
) PMODE/W mantiene un buffer DTA interno en memoria baja que es usado para
  depurar todas las funciones que usen el DTA. Tras llamar a la funcin del
  DOS en modo real los datos sern transferidos al buffer especificado por la
  funcin 1Ah o al buffer por defecto si no se llam a la funcin 1Ah.
  
3.25 - Funcin 4Fh - Busca la Siguiente Coincidencia en el Nombre del Fichero:
------------------------------------------------------------------------------

In:
  AH     = 4Fh

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

Notas:
) PMODE/W mantiene un buffer DTA interno en memoria baja que es usado para
  depurar todas las funciones que usen el DTA. Tras llamar a la funcin del
  DOS en modo real los datos sern transferidos al buffer especificado por la
  funcin 1Ah o al buffer por defecto si no se llam a la funcin 1Ah.
 
3.26 - Funcin 56h - Renombrar Fichero:
---------------------------------------

In:
  AH     = 56h
  DS:EDX -> antiguo nombre de fichero
  ES:EDI -> nuevo nombre de fichero

Out:
  si tiene xito:
    flag de acarreo limpio

  si falla:
    flag de acarreo activado
    EAX = cdigo de error

3.27 - Funcin 62h - Toma la Direccin PSP:
-------------------------------------------

In:
  AH     = 62h

Out:
  siempre tiene xito:
    BX = Selector PSP

Notas:
) Esta funcin devuelve el selector PSP en modo protegido. Usa INT 21h/AH=51h
  si necesitas una direccin de segmento en modo real.

------------------------------------------------------------------------------
------- 4 - Funciones extendidas de la INT 33h soportadas por el ratn -------
------------------------------------------------------------------------------

  Las funciones del ratn, tcnicamente, no son parte del soporte de Watcom
C/C++ porque no son usadas por ninguna de las libreras. Pero ofrecemos las
funciones ms frecuentes porque son ampliamente usadas. Las funciones que se
necesita extender son aquellas que requieren que se pasen direcciones a
registros de segmentos. El resto de funciones del ratn no enumeradas aqu
funcionarn si no toman registros de segmentos como parmetros. Esto significa
que adems de las funciones enumeradas aqu, funcionarn funciones como 0000h,
0001h, 0002h, etc... Pero funciones como 0012h y 0018h no funcionarn
directamente desde el modo protegido porque pasan o devuelven registros de
segmentos como parmetros o requieren el depurado de memoria baja. Todava
puedes usar esas funciones, pero debes llamarlas a travs del DPMI y asegurarte
de que todos los datos y cdigos que usen se encuentren en memoria baja y que
el cdigo es cdigo en modo real (como la llamada de retorno de DPMI si deseas
pasar el control al cdigo en modo protegido desde all).

4.0 - Funcin 0009h - Definir el Cursor Grfico:
------------------------------------------------

In:
  AX     = 0009h
  BX     = columna del cursor resaltado en bitmap
  CX     = fila del cursor resaltado en bitmap
  ES:EDX -> enmascara bitmap

Out:
  siempre tiene xito

4.1 - Funcin 000Ch - Definir los Parmetros de la Subrutina de la Interrupcin:
--------------------------------------------------------------------------------

In:
  AX     = 000Ch
  CX     = llama a mask
  ES:EDX -> rutina FAR

Out:
  siempre tiene xito

Notas:
) Esta funcin usar una llamada de retorno en modo real de DPMI para pasar el
  control del modo real a tu subrutina de interrupcin en modo protegido.
  
) Llamar a esta funcin con una rutina FAR de 0000:00000000 es anlogo a llamar
  al driver del mouse en modo real con una direccin de 0000:0000 que dejar
  sin definir la subrutina de la interrupcin.
  
4.2 - Funcin 0016h - Grabar el Estado del Controlador:
-------------------------------------------------------

In:
  AX     = 0016h
  BX     = tamao del buffer
  ES:EDX -> buffer para el estado del controlador

Out:
  siempre tiene xito

4.3 - Funcin 0017h - Restablecer el Estado del Controlador:
------------------------------------------------------------

In:
  AX     = 0017h
  BX     = tamao del buffer
  ES:EDX -> buffer que contiene el estado grabado

Out:
  siempre tiene xito

------------------------------------------------------------------------------
--------------------- Fin de la Documentacin de PMODE/W ---------------------
------------------------------------------------------------------------------

