//
//      simple idc program to automate ida.
//      if ida is started as
//
//              ida -A -Sanalys.idc file
//
//      this idc file will be executed:
//        - the code segment is analysed
//        - the output file is created
//        - IDA exits to OS
//
//      this is unusual usage of IDA though.
//
  
#include <idc.idc>

static main() {
  auto file;

  Message("Waiting for the end of auto analysis...\n");
  Wait();

  Message("\n\n------ Creating output file.... --------\n");
  file = GetInputFile();
  file = substr(file,0,strstr(file,".")) + ".asm";
  WriteTxt(file,0,0xFFFFFFFF);
  Message("All done, exiting...\n");
  Exit(0);                              // exit to OS, error code 0 - success
}
