//
//
//      This example shows how to use cross-reference related functions.
//      You should stand at the start of the program, make several
//      instructions and execute this program.
//

#include "idc.idc"

static main() {
  auto ea,flag,x,ea1,y;
  flag = 1;
  ea = ScreenEA();
  ea1 = NextHead(ea1=ea, BADADDR);
  ea1 = NextHead(ea1, BADADDR);


  setDref(ea,ea1,dr_R);         // set data reference (read)
  Rflow(ea,ea1,fl_CN);          // set 'call near' reference
//  Ruflow(ea,ea1,1);

//
//      Now show all reference relations between ea & ea1.
//
  Message("\n*** Code references from " + atoa(ea) + "\n");
  for ( x=Rfirst(ea); x != BADADDR; x=Rnext(ea,x) )
    Message(atoa(ea) + " refers to " + atoa(x) + xrefchar() + "\n");

  Message("\n*** Code references to " + atoa(ea1) + "\n");
  x = ea1;
  for ( y=RfirstB(x); y != BADADDR; y=RnextB(x,y) )
    Message(atoa(x) + " is referred from " + atoa(y) + xrefchar() + "\n");

  Message("\n*** Code references from " + atoa(ea) + " (only non-trivial refs)\n");
  for ( x=Rfirst0(ea); x != BADADDR; x=Rnext0(ea,x) )
    Message(atoa(ea) + " refers to " + atoa(x) + xrefchar() + "\n");

  Message("\n*** Code references to " + atoa(ea1) + " (only non-trivial refs)\n");
  x = ea1;
  for ( y=RfirstB0(x); y != BADADDR; y=RnextB0(x,y) )
    Message(atoa(x) + " is referred from " + atoa(y) + xrefchar() + "\n");

  Message("\n*** Data references from " + atoa(ea) + "\n");
  for ( x=Dfirst(ea); x != BADADDR; x=Dnext(ea,x) )
    Message(atoa(ea) + " accesses " + atoa(x) + xrefchar() + "\n");

  Message("\n*** Data references to " + atoa(ea1) + "\n");
  x = ea1;
  for ( y=DfirstB(x); y != BADADDR; y=DnextB(x,y) )
    Message(atoa(x) + " is accessed from " + atoa(y) + xrefchar() + "\n");

}

static xrefchar() {
  auto x;
  x = XrefType();

  if ( x == fl_F )  return " (ordinary flow)";
  if ( x == fl_CF ) return " (call far)";
  if ( x == fl_CN ) return " (call near)";
  if ( x == fl_JF ) return " (jump far)";
  if ( x == fl_JN ) return " (jump near)";
  if ( x == fl_US ) return " (user-defined)";
  if ( x == dr_O  ) return " (offset)";
  if ( x == dr_W  ) return " (write)";
  if ( x == dr_R  ) return " (read)";
  if ( x == dr_T  ) return " (textual)";
  return "(?)";
}
