/*************************************************************************
** interpcom-2.3    (command interpreter)                                **
** _mapm.c : expression evaluator with double precision numbers          **
**                                                                       **
** Copyright (C) 2001  Jean-Marc Drezet                                  **
**                                                                       **
**  This library is free software; you can redistribute it and/or        **
**  modify it under the terms of the GNU Library General Public          **
**  License as published by the Free Software Foundation; either         **
**  version 2 of the License, or (at your option) any later version.     **
**                                                                       **
**  This library is distributed in the hope that it will be useful,      **
**  but WITHOUT ANY WARRANTY; without even the implied warranty of       **
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU    **
**  Library General Public License for more details.                     **
**                                                                       **
**  You should have received a copy of the GNU Library General Public    **
**  License along with this library; if not, write to the Free           **
**  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.   **
**                                                                       **
** Please mail any bug reports/fixes/enhancements to me at:              **
**      drezet@math.jussieu.fr                                           **
** or                                                                    **
**      Jean-Marc Drezet                                                 **
**      Institut de Mathematiques                                        **
**      Aile 45-55                                                       **
**      2, place Jussieu                                                 **
**      75251 Paris Cedex 05                                             **
**      France                                                           **
**                                                                       **
 *************************************************************************/

#include "interp.h"

int
_dummy_iszero(void *z)
{
    double         *t;

    t = (double *)z;
    if (*t == 0.0)
        return 1;
    else
        return 0;
}

void
_dummy_Zero(void *z)
{
    double         *t;

    t = (double *)z;
    t[0] = 0.;
}

void
_dummy_clear(void *z)
{
    free(z);
}

void
_dummy_neg(void *z)
{
    double         *t;

    t = (double *)z;
    t[0] = - t[0];
}

void
_dummy_add(void *res, void *a, void *b)
{
    double         *t,
                   *u,
                   *v;

    t = (double *)res;
    u = (double *)a;
    v = (double *)b;
    t[0] = u[0] + v[0];
}

void
_dummy_sub(void *res, void *a, void *b)
{
    double         *t,
                   *u,
                   *v;

    t = (double *)res;
    u = (double *)a;
    v = (double *)b;
    t[0] = u[0] - v[0];
}

void
_dummy_mul(void *res, void *a, void *b)
{
    double         *t,
                   *u,
                   *v;

    t = (double *)res;
    u = (double *)a;
    v = (double *)b;
    t[0] = u[0] * v[0];
}

void
_dummy_pow(void *res, void *a, void *b)
{
    double         *t,
                   *u,
                   *v;

    t = (double *)res;
    u = (double *)a;
    v = (double *)b;
    t[0] = pow(u[0], v[0]);
}

void
_dummy_div(void *res, void *a, void *b)
{
    double         *t,
                   *u,
                   *v;

    t = (double *)res;
    u = (double *)a;
    v = (double *)b;
    t[0] = u[0] / v[0];
}

void
_dummy_set(void *res, char *h)
{
    double         *t;

    t = (double *)res;
    t[0] = atof(h);
}

void
_dummy_Init(void **s)
{
    double          *t;

    t = (double *) malloc((size_t) sizeof(double));
    s[0] = (void *) t;
}

char *
_dummy_print(void *c)
{
    double         *t;

    t = (double *)c;
    return ch_copy_float(t[0]);
}

void *
_dummy_copy(void *c)
{
    double         *t,
                   *u;

    t = (double *)c;
    u = (double *) malloc(sizeof(double));
    u[0] = t[0];
    return (void *) u;
}

int
_dummy_sign(void *c)
{
    double         *t;

    t = (double *)c;
    if (*t < 0.)
        return -1;
    else {
        if (*t > 0.)
            return 1;
    }
    return 0;
}

EXPREVAL_GEN        _dummy_exprev = {
    _dummy_clear,
    _dummy_Zero,
    _dummy_neg,
    _dummy_iszero,
    _dummy_add,
    _dummy_sub,
    _dummy_mul,
    _dummy_pow,
    _dummy_div,
    _dummy_set,
    _dummy_Init,
    _dummy_print,
    _dummy_copy,
    _dummy_sign,
    0,
    NULL,
    NULL,
    1,
    "clone expression evaluator"
};



void
_dummy_sin(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = sin(t[0]);
}

void
_dummy_cos(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = cos(t[0]);
}

void
_dummy_tan(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = tan(t[0]);
}

void
_dummy_asin(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = asin(t[0]);
}

void
_dummy_acos(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = acos(t[0]);
}

void
_dummy_atan(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = atan(t[0]);
}

void
_dummy_sinh(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = sinh(t[0]);
}

void
_dummy_cosh(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = cosh(t[0]);
}

void
_dummy_tanh(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = tanh(t[0]);
}
void

_dummy_exp(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = exp(t[0]);
}

void
_dummy_log(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = log(t[0]);
}

void
_dummy_log10(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = log10(t[0]);
}

void
_dummy_sqrt(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = sqrt(t[0]);
}

void
_dummy_floor(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = floor(t[0]);
}

void
_dummy_ceil(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = ceil(t[0]);
}

void
_dummy_fabs(void **res, void **x)
{
    double         *t,
                   *u;

    t = (double *) x[0];
    u = (double *) res[0];
    u[0] = fabs(t[0]);
}

void
_dummy_hypot(void **res, void **x)
{
    double         *t,
                   *u,
                   *v;

    t = (double *) x[0];
    u = (double *) res[0];
    v = (double *) x[1];
    u[0] = hypot(t[0], v[0]);
}



FUNCTIONGen         Funcs_dummy[] =
{
   /* name, function to call */
   { "sin",     1,    _dummy_sin },            /* 0    */
   { "cos",     1,    _dummy_cos },            /* 1    */
   { "tan",     1,    _dummy_tan },            /* 2    */
   { "asin",    1,    _dummy_asin },           /* 3    */
   { "acos",    1,    _dummy_acos },           /* 4    */
   { "atan",    1,    _dummy_atan },           /* 5    */
   { "sinh",    1,    _dummy_sinh },           /* 6    */
   { "cosh",    1,    _dummy_cosh },           /* 7    */
   { "tanh",    1,    _dummy_tanh },           /* 8    */
   { "exp",     1,    _dummy_exp },            /* 9    */
   { "log",     1,    _dummy_log },            /* 10   */
   { "log10",   1,    _dummy_log10 },          /* 11   */
   { "sqrt",    1,    _dummy_sqrt },           /* 12   */
   { "floor",   1,    _dummy_floor },          /* 13   */
   { "ceil",    1,    _dummy_ceil },           /* 14   */
   { "abs",     1,    _dummy_fabs },           /* 15   */
   { "hypot",   2,    _dummy_hypot },          /* 16   */
   { 0 }                                       /* 17   */
};

int                 _dummy_NBFONC0=17;

