//
//
//
//
//
//
//
//
//
//
// Microsoft Windows 95/98/NT Version 
//
//Copyright (c) 1994-1999 by Dan Higdon, Tim Little, and Chuck Walbourn
//
//
//
// This file and all associated files are subject to the terms of the
// GNU Lesser General Public License version 2 as published by the
// Free Software Foundation (http://www.gnu.org).   They remain the
// property of the authors: Dan Higdon, Tim Little, and Chuck Walbourn.
// See LICENSE.TXT in the distribution for a copy of this license.
//
// THE AUTHORS MAKE NO WARRANTIES, EXPRESS OR IMPLIED, AS TO THE CORRECTNESS
// OF THIS CODE OR ANY DERIVATIVE WORKS WHICH INCORPORATE IT.  THE AUTHORS
// PROVIDE THE CODE ON AN "AS-IS" BASIS AND EXPLICITLY DISCLAIMS ANY
// LIABILITY, INCLUDING CONSEQUENTIAL AND INCIDENTAL DAMAGES FOR ERRORS,
// OMISSIONS, AND OTHER PROBLEMS IN THE CODE.
//
//
//
//                        http://www.mythos-engine.org/
//
//
//
// Created by Tim Little & Chuck Walbourn
//
// esbasic.hpp
//
// Contains some basic draw classes.
//
// EschPointDraw is a single unlit colored point in 3-space.
//
// EschLineDraw is a single unlit colored line in 3-space.
//
// EschPlaneDraw is a colored and optionally textured plane in 3-space.
//
// EschSprite is a 2D bitmap always facing the viewer.
//
//

#ifndef __ESBASIC_HPP
#define __ESBASIC_HPP    1

#ifdef __WATCOMC__
#pragma pack(1);
#endif

#ifdef _MSC_VER
#pragma pack(push,1)
#endif

//
//
//                                Includes
//
//

#include "esdraw.hpp"

//
//
//                                Classes
//
//

//Ŀ
// EschPointDraw -  Single colored point in 3-space.                        
//
class EschPointDraw : public EschDrawable
{
public:
    //Ŀ
    // Public data members                                                  
    //
    EschPoint   pos;                        // Position
    dword       color;                      // Color

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschPointDraw() : EschDrawable(ESCH_DRWT_POINTDRAW) {}

    EschPointDraw(float ix, float iy, float iz, dword c) :
        EschDrawable(ESCH_DRWT_POINTDRAW),
        pos(ix,iy,iz), color(c) {}

    EschPointDraw(const EschPoint *p, dword c) :
        EschDrawable(ESCH_DRWT_POINTDRAW),
        pos(*p), color(c) {}

    virtual ~EschPointDraw() {}

    //Ŀ
    // Operations                                                           
    //
    virtual void draw();

    //Ŀ
    // Utility routines.                                                    
    //
    void set_position(float ix, float iy, float iz)
    {
        pos.x = ix;  pos.y = iy;  pos.z = iz;
    }
    void set_position(const EschPoint *pnt)
    {
        pos.x = pnt->x;  pos.y = pnt->y;  pos.z = pnt->z;
    }

    void set_color(dword c) { color = c; }
};


//Ŀ
// EschLineDraw -  Single colored line in 3-space.                          
//
class EschLineDraw : public EschDrawable
{
public:
    //Ŀ
    // Public data members                                                  
    //
    EschPoint   pos1;                       // End-positions
    EschPoint   pos2;
    dword       color;                      // Color

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschLineDraw() : EschDrawable(ESCH_DRWT_LINEDRAW) {}

    EschLineDraw(float ix1, float iy1, float iz1,
                 float ix2, float iy2, float iz2,
                 dword c) :
        EschDrawable(ESCH_DRWT_LINEDRAW),
        pos1(ix1,iy1,iz1), pos2(ix2,iy2,iz2), color(c) {}

    EschLineDraw(const EschPoint *p1, const EschPoint *p2, dword c) :
        EschDrawable(ESCH_DRWT_LINEDRAW),
        pos1(*p1), pos2(*p2), color(c) {}

    virtual ~EschLineDraw() {}

    //Ŀ
    // Operations                                                           
    //
    virtual void draw();

    //Ŀ
    // Utility routines.                                                    
    //
    void set_position(float ix1, float iy1, float iz1,
                      float ix2, float iy2, float iz2)
    {
        pos1.x = ix1;  pos1.y = iy1;  pos1.z = iz1;
        pos2.x = ix2;  pos2.y = iy2;  pos2.z = iz2;
    }
    void set_position(const EschPoint *pnt1, const EschPoint *pnt2)
    {
        pos1.x = pnt1->x;  pos1.y = pnt1->y;  pos1.z = pnt1->z;
        pos2.x = pnt2->x;  pos2.y = pnt2->y;  pos2.z = pnt2->z;
    }

    void set_color(dword c) { color = c; }
};


//Ŀ
// EschPlaneDraw - Colored plane in 3-space.                                
//
class EschPlaneDraw : public EschDrawable
{
protected:
    long        alpha_level;                // Alpha-level

public:
    //Ŀ
    // Public data members                                                  
    //
    EschPlane   plane;                      // Plane definition
    dword       color;                      // Color
    EschTexture *txt;                       // Texture
    EschVector  uvec;                       // Mapping parameters
    EschVector  vvec;
    EschPoint   uvpos;
    float       ustep;
    float       vstep;

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschPlaneDraw();
    EschPlaneDraw(float ia, float ib, float ic, float id, dword c);
    EschPlaneDraw(float ia, float ib, float ic,
                  float ix, float iy, float iz, dword c);
    EschPlaneDraw(const EschVector &in, float id, dword c);
    EschPlaneDraw(const EschPlane *pl, dword c);
    EschPlaneDraw(const EschVector &v1, const EschVector &v2,
                  const EschPoint &pos, dword c, float us=100, float vs=100);

    virtual ~EschPlaneDraw();

    //Ŀ
    // Operations                                                           
    //
    const EschPlaneDraw &operator = (const EschPlaneDraw &s);

    virtual void draw();

    virtual float ray(const EschPoint *pt, const EschVector *v, int coarse=0) const;
    virtual int hit(const EschPoint *pt, const float r, int coarse=0) const;

    virtual void animate();
    virtual void release();

    //Ŀ
    // Utility routines.                                                    
    //
    void set_plane(const EschPlane &pln);
    void set_plane(float ia, float ib, float ic, float id);
    void set_plane(float ia, float ib, float ic,
                   float ix, float iy, float iz);
    void set_plane(const EschVector &v1, const EschVector &v2, const EschPoint &pos);

    void set_mapping(const EschVector &_uvec,
                     const EschVector &_vvec,
                     const EschPoint &_uvpos,
                     float us, float vs);

    void set_uvstep(float us, float vs) { ustep = us; vstep = vs; }

    void rotatex(const float d)
    {
        plane.normal.rotatex(d);
        uvec.rotatex(d);
        vvec.rotatex(d);
    }
    void rotatey(const float d)
    {
        plane.normal.rotatey(d);
        uvec.rotatey(d);
        vvec.rotatey(d);
    }
    void rotatez(const float d)
    {
        plane.normal.rotatez(d);
        uvec.rotatez(d);
        vvec.rotatez(d);
    }

    void normalize()
    {

        plane.normalize();
        uvec.normalize();
        vvec.normalize();
    }

    void set_color(dword c) { color = c; }

    void set_alpha(long alpha) { alpha_level = alpha; }
    long get_alpha() const { return alpha_level; }

    void set_texture(EschTexture *t);
};


//Ŀ
// EschSprite - 2D bitmap always drawn facing the viewer.                   
//
class EschSprite : public EschDrawable
{
protected:
    EschTexture     *txt;
    long            alpha_level;

public:
    //Ŀ
    // Public data members                                                  
    //
    EschPoint       pos;
    float           width;
    float           height;
    float           rotation;
    float           scale;

    //Ŀ
    // Constructor/Destructors                                              
    //
    EschSprite() :
        EschDrawable(ESCH_DRWT_SPRITE),
        txt(0),
        alpha_level(255),
        rotation(0),
        scale(1) {};
    EschSprite(float ix, float iy, float iz, float w, float h,
               float r=0, float s=1) :
        EschDrawable(ESCH_DRWT_SPRITE),
        txt(0),
        alpha_level(255),
        pos(ix,iy,iz),
        width(w), height(h),
        rotation(r),
        scale(s) {};
    EschSprite(const EschPoint *p, float w, float h,
               float r=0, float s=1) :
        EschDrawable(ESCH_DRWT_SPRITE),
        txt(0),
        alpha_level(255),
        pos(*p),
        width(w), height(h),
        rotation(r),
        scale(s) {};

    virtual ~EschSprite();

    //Ŀ
    // Operations                                                           
    //
    const EschSprite &operator = (const EschSprite &s);

    virtual void draw();
    virtual int get_extents(EschSphereExtents *sp) const;
    virtual void animate();

    virtual void release();

    //Ŀ
    // Utility functions.                                                   
    //
    void set_position(float ix, float iy, float iz)
    {
        pos.x = ix;
        pos.y = iy;
        pos.z = iz;
    }
    void set_position(const EschPoint *pnt)
    {
        pos.x = pnt->x;
        pos.y = pnt->y;
        pos.z = pnt->z;
    }

    void set_size(float w, float h)
    {
        width=w;
        height=h;
    }

    void set_rotation (float r) { rotation = r; }
    void set_scale (float s) { scale = s; }

    void set_alpha(long alpha) { alpha_level = alpha; }
    long get_alpha() const { return alpha_level; }

    void attach(EschTexture *t);

    esch_error_codes create(XFBitmap *bm, float w, float h,
                            int trans=1, VngoPal *pal=0);
};

#ifdef __WATCOMC__
#pragma pack();
#endif

#ifdef _MSC_VER
#pragma pack(pop)
#endif

#endif

// End of header - esbasic.hpp 

